/**
  ******************************************************************************
  * ļ  kf32ls_basic_systick.h
  *     ChipON_AE/FAE_Group
  *     V3.0.0
  *     2021-08-20
  *     ļṩ˽ĶʱĿ⺯غ궨塣
  *********************************************************************
  */

#ifndef _KF32LS_BASIC_SYSTICK_H_
#define _KF32LS_BASIC_SYSTICK_H_

#include "KF32LS_BASIC.h"

/* Ķʱָ붨 */
#define CHECK_SYSTICK_PERIPH(PERIPH)    ((PERIPH) == SYSTICK_SFR)

/**
  *   Ķʱ(SYSTICK)Ϣṹ
  */
typedef struct
{
    uint32_t m_Period;          /* ĶʱؼؼĴֵȡֵ24λݡ */
    uint32_t m_Clock;           /* ĶʱʱԴѡ
                                   ȡֵΪꡰSYSTICKʱʱԴеһ */
    uint32_t m_SysTickINT;      /* ʱSysTickжʹã
                                   ȡֵΪTRUEFALSE */
} SYSTICK_InitTypeDef;


/**
  * SYSTICKʱʱԴ
  */
#define SYSTICK_SYS_CLOCK_DIV_2         ((uint32_t)0x0 << ST_CTL_STCLKS_POS)
#define SYSTICK_SYS_CLOCK_DIV_1         ((uint32_t)0x1 << ST_CTL_STCLKS_POS)
#define CHECK_SYSTICK_CLOCK(SCLK)       (((SCLK) == SYSTICK_SYS_CLOCK_DIV_2) \
                                      || ((SCLK) == SYSTICK_SYS_CLOCK_DIV_1))

/**
  * SYSTICKʱؼؼĴֵ
  */
#define CHECK_SYSTICK_RELOAD(SYS)       (((SYS) >> 24) == 0)

/* Ķʱ(SYSTICK)ʼ************************************/
void SYSTICK_Configuration (uint32_t Clock, uint32_t SysTickINT,
                    uint32_t Reload);
/* Ķʱ(SYSTICK)ú**************************************/
void SYSTICK_Cmd (FunctionalState NewState);
void SYSTICK_Clock_Config (uint32_t SysClock);
void SYSTICK_Systick_INT_Enable (uint32_t SysClock);
FlagStatus SYSTICK_Get_Count_Zero_Flag (void);
void SYSTICK_Reload_Config (uint32_t Reload);
void SYSTICK_Counter_Updata (void);
uint32_t SYSTICK_Get_Reload (void);
uint32_t SYSTICK_Get_Counter (void);

#endif /* _KF32LS_BASIC_SYSTICK_H */
