/**
  ******************************************************************************
  * ļ  kf32ls_basic_cfgl.c
  *     ChipON_AE/FAE_Group
  *     V3.0.0
  *     2021-08-20
  *     ļṩ˿߼(CFLG)صĹܺ
  *            + ߼(CFLG)ʼ
  *            + ߼(CFLG)жϹ
  *
  *********************************************************************
  */

#include "kf32ls_basic_cfgl.h"
#include "kf32ls_basic_rst.h"
#include "kf32ls_basic_pclk.h"

#ifdef KF32LS_Periph_cfgl
/* (CFGL)ģ˽ж -------------------------------------------------*/

/* CFGLx_CTL0Ĵʼ */
#define CFGL_CTL0_INIT_MASK		 		(CFGL_CTL0_EN \
                                       | CFGL_CTL0_OE \
                                       | CFGL_CTL0_INTP \
                                       | CFGL_CTL0_INTN \
                                       | CFGL_CTL0_MD \
                                       | CFGL_CTL0_POL \
                                       | CFGL_CTL0_G4POL \
                                       | CFGL_CTL0_G3POL \
                                       | CFGL_CTL0_G2POL \
                                       | CFGL_CTL0_G1POL \
                                       | CFGL_CTL0_D4S \
                                       | CFGL_CTL0_D3S \
                                       | CFGL_CTL0_D2S \
                                       | CFGL_CTL0_D1S \
                                       | CFGL_CTL0_REGIN \
                                       | CFGL_CTL0_TPSEL)

#define CFGL_CTL1_INIT_MASK	0XFFFFFFFF
/**
  *   ##### CFGLģʼ #####
  */
/**
  *   λCFGL裬ʹʱӡ
  *   CFGLx: ָCFGLڴṹָ룬ȡֵΪCFGL0_SFR~CFGL2_SFR
  *   ޡ
  */
void
CFGL_Reset ()
{

	RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_CFGLRST, TRUE);
	RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_CFGLRST, FALSE);
	PCLK_CTL3_Peripheral_Clock_Enable(PCLK_CTL3_CFGLCLKEN, TRUE);

}
/**
  *   CFGLģʼá
  *   CFGLx: ָCFGLڴṹָ룬ȡֵΪCFGL0_SFR~CFGL2_SFR
  *       CFGLInitStruct: CFGLģϢṹָ롣
  *   ޡ
  */
void
CFGL_Configuration (CFGL_SFRmap* CFGLx, CFGL_InitTypeDef* CFGLInitStruct)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_CFGL_PERIPH(CFGLx));
    CHECK_RESTRICTION(CHECK_CFGL_EN(CFGLInitStruct->m_Module_EN));
    CHECK_RESTRICTION(CHECK_CFGL_OUTPUT(CFGLInitStruct->m_Output_EN));
    CHECK_RESTRICTION(CHECK_CFGL_RISEINT_EN(CFGLInitStruct->m_RaiseINT_EN));
    CHECK_RESTRICTION(CHECK_CFGL_FALLINT_EN(CFGLInitStruct->m_FallINT_EN));
    CHECK_RESTRICTION(CHECK_CFGL_MODE(CFGLInitStruct->m_Mode_Sel));
    CHECK_RESTRICTION(CHECK_CFGL_OUT_POL(CFGLInitStruct->m_Output_Pol));
    CHECK_RESTRICTION(CHECK_G4POL_SEL(CFGLInitStruct->m_G4Output_POL));
    CHECK_RESTRICTION(CHECK_G3POL_SEL(CFGLInitStruct->m_G3Output_POL));
    CHECK_RESTRICTION(CHECK_G2POL_SEL(CFGLInitStruct->m_G2Output_POL));
    CHECK_RESTRICTION(CHECK_G1POL_SEL(CFGLInitStruct->m_G1Output_POL));
    CHECK_RESTRICTION(CHECK_G4INPUT_SEL(CFGLInitStruct->m_G4Input_Sel));
    CHECK_RESTRICTION(CHECK_G3INPUT_SEL(CFGLInitStruct->m_G3Input_Sel));
    CHECK_RESTRICTION(CHECK_G2INPUT_SEL(CFGLInitStruct->m_G2Input_Sel));
    CHECK_RESTRICTION(CHECK_G1INPUT_SEL(CFGLInitStruct->m_G1Input_Sel));
    CHECK_RESTRICTION(CHECK_CH4_INPUT_SEL(CFGLInitStruct->m_CH4Data_Sel));
    CHECK_RESTRICTION(CHECK_CH5CH6_INPUT_SEL(CFGLInitStruct->m_CH5CH6Data_Sel));

    /*---------------- CFGL_CTL0Ĵ ----------------*/
    /* ݽṹԱm_Module_ENENλ */
    /* ݽṹԱm_Output_ENOEλ */
    /* ݽṹԱm_RaiseINT_ENINTPλ */
    /* ݽṹԱm_FallINT_ENINTNλ */
    /* ݽṹԱm_Mode_SelMDλ */
    /* ݽṹԱm_Output_PolPOLλ */
    /* ݽṹԱm_G4Output_POLG4POLλ */
    /* ݽṹԱm_G3Output_POLG3POLλ */
    /* ݽṹԱm_G2Output_POLG2POLλ */
    /* ݽṹԱm_G1Output_POLG1POLλ */
    /* ݽṹԱm_G4Input_SelD4Sλ */
    /* ݽṹԱm_G3Input_SelD3Sλ */
    /* ݽṹԱm_G2Input_SelD2Sλ */
    /* ݽṹԱm_G1Input_SelD1Sλ */
    /* ݽṹԱm_CH4Data_SelREGINλ */
    /* ݽṹԱm_CH5CH6Data_SelTPSELλ */
    tmpreg = (uint32_t)(CFGLInitStruct->m_Module_EN | \
                        CFGLInitStruct->m_Output_EN | \
                        CFGLInitStruct->m_RaiseINT_EN | \
                        CFGLInitStruct->m_FallINT_EN | \
                        CFGLInitStruct->m_Mode_Sel | \
                        CFGLInitStruct->m_Output_Pol | \
                        CFGLInitStruct->m_G4Output_POL | \
                        CFGLInitStruct->m_G3Output_POL | \
                        CFGLInitStruct->m_G2Output_POL | \
                        CFGLInitStruct->m_G1Output_POL | \
                        CFGLInitStruct->m_G4Input_Sel | \
                        CFGLInitStruct->m_G3Input_Sel | \
                        CFGLInitStruct->m_G2Input_Sel | \
                        CFGLInitStruct->m_G1Input_Sel | \
                        CFGLInitStruct->m_CH4Data_Sel | \
                        CFGLInitStruct->m_CH5CH6Data_Sel);
    CFGLx->CTL0 = SFR_Config (CFGLx->CTL0, ~CFGL_CTL0_INIT_MASK, tmpreg);

    /*---------------- CFGL_CTL1Ĵ ----------------*/
    /* ݽṹԱm_G4D4_Inphase_ENG4D4Tλ */
    /* ݽṹԱm_G4D4_Inverse_ENG4D4Nλ */
    /* ݽṹԱm_G4D3_Inphase_ENG4D3Tλ */
    /* ݽṹԱm_G4D3_Inverse_ENG4D3Nλ */
    /* ݽṹԱm_G4D2_Inphase_ENG4D2Tλ */
    /* ݽṹԱm_G4D2_Inverse_ENG4D2Nλ */
    /* ݽṹԱm_G4D1_Inphase_ENG4D1Tλ */
    /* ݽṹԱm_G4D1_Inverse_ENG4D1Nλ */
    /* ݽṹԱm_G3D4_Inphase_ENG3D4Tλ */
    /* ݽṹԱm_G3D4_Inverse_ENG3D4Nλ */
    /* ݽṹԱm_G3D3_Inphase_ENG3D3Tλ */
    /* ݽṹԱm_G3D3_Inverse_ENG3D3Nλ */
    /* ݽṹԱm_G3D2_Inphase_ENG3D2Tλ */
    /* ݽṹԱm_G3D2_Inverse_ENG3D2Nλ */
    /* ݽṹԱm_G3D1_Inphase_ENG3D1Tλ */
    /* ݽṹԱm_G3D1_Inverse_ENG3D1Nλ */
    /* ݽṹԱm_G2D4_Inphase_ENG2D4Tλ */
    /* ݽṹԱm_G2D4_Inverse_ENG2D4Nλ */
    /* ݽṹԱm_G2D3_Inphase_ENG2D3Tλ */
    /* ݽṹԱm_G2D3_Inverse_ENG2D3Nλ */
    /* ݽṹԱm_G2D2_Inphase_ENG2D2Tλ */
    /* ݽṹԱm_G2D2_Inverse_ENG2D2Nλ */
    /* ݽṹԱm_G2D1_Inphase_ENG2D1Tλ */
    /* ݽṹԱm_G2D1_Inverse_ENG2D1Nλ */
    /* ݽṹԱm_G1D4_Inphase_ENG1D4Tλ */
    /* ݽṹԱm_G1D4_Inverse_ENG1D4Nλ */
    /* ݽṹԱm_G1D3_Inphase_ENG1D3Tλ */
    /* ݽṹԱm_G1D3_Inverse_ENG1D3Nλ */
    /* ݽṹԱm_G1D2_Inphase_ENG1D2Tλ */
    /* ݽṹԱm_G1D2_Inverse_ENG1D2Nλ */
    /* ݽṹԱm_G1D1_Inphase_ENG1D1Tλ */
    /* ݽṹԱm_G1D1_Inverse_ENG1D1Nλ */
    tmpreg = (uint32_t)((CFGLInitStruct->m_G4D4_Inphase_EN << CFGL_CTL1_G4D4T_POS) | \
    					(CFGLInitStruct->m_G4D4_Inverse_EN << CFGL_CTL1_G4D4N_POS) | \
    					(CFGLInitStruct->m_G4D3_Inphase_EN << CFGL_CTL1_G4D3T_POS) | \
    					(CFGLInitStruct->m_G4D3_Inverse_EN << CFGL_CTL1_G4D3N_POS) | \
    					(CFGLInitStruct->m_G4D2_Inphase_EN << CFGL_CTL1_G4D2T_POS) | \
    					(CFGLInitStruct->m_G4D2_Inverse_EN << CFGL_CTL1_G4D2N_POS) | \
    					(CFGLInitStruct->m_G4D1_Inphase_EN << CFGL_CTL1_G4D1T_POS) | \
    					(CFGLInitStruct->m_G4D1_Inverse_EN << CFGL_CTL1_G4D1N_POS) | \
    					(CFGLInitStruct->m_G3D4_Inphase_EN << CFGL_CTL1_G3D4T_POS) | \
						(CFGLInitStruct->m_G3D4_Inverse_EN << CFGL_CTL1_G3D4N_POS) | \
						(CFGLInitStruct->m_G3D3_Inphase_EN << CFGL_CTL1_G3D3T_POS) | \
						(CFGLInitStruct->m_G3D3_Inverse_EN << CFGL_CTL1_G3D3N_POS) | \
						(CFGLInitStruct->m_G3D2_Inphase_EN << CFGL_CTL1_G3D2T_POS) | \
						(CFGLInitStruct->m_G3D2_Inverse_EN << CFGL_CTL1_G3D2N_POS) | \
						(CFGLInitStruct->m_G3D1_Inphase_EN << CFGL_CTL1_G3D1T_POS) | \
						(CFGLInitStruct->m_G3D1_Inverse_EN << CFGL_CTL1_G3D1N_POS) | \
    					(CFGLInitStruct->m_G2D4_Inphase_EN << CFGL_CTL1_G2D4T_POS) | \
						(CFGLInitStruct->m_G2D4_Inverse_EN << CFGL_CTL1_G2D4N_POS) | \
						(CFGLInitStruct->m_G2D3_Inphase_EN << CFGL_CTL1_G2D3T_POS) | \
						(CFGLInitStruct->m_G2D3_Inverse_EN << CFGL_CTL1_G2D3N_POS) | \
						(CFGLInitStruct->m_G2D2_Inphase_EN << CFGL_CTL1_G2D2T_POS) | \
						(CFGLInitStruct->m_G2D2_Inverse_EN << CFGL_CTL1_G2D2N_POS) | \
						(CFGLInitStruct->m_G2D1_Inphase_EN << CFGL_CTL1_G2D1T_POS) | \
						(CFGLInitStruct->m_G2D1_Inverse_EN << CFGL_CTL1_G2D1N_POS) | \
    					(CFGLInitStruct->m_G1D4_Inphase_EN << CFGL_CTL1_G1D4T_POS) | \
						(CFGLInitStruct->m_G1D4_Inverse_EN << CFGL_CTL1_G1D4N_POS) | \
						(CFGLInitStruct->m_G1D3_Inphase_EN << CFGL_CTL1_G1D3T_POS) | \
						(CFGLInitStruct->m_G1D3_Inverse_EN << CFGL_CTL1_G1D3N_POS) | \
						(CFGLInitStruct->m_G1D2_Inphase_EN << CFGL_CTL1_G1D2T_POS) | \
						(CFGLInitStruct->m_G1D2_Inverse_EN << CFGL_CTL1_G1D2N_POS) | \
						(CFGLInitStruct->m_G1D1_Inphase_EN << CFGL_CTL1_G1D1T_POS) | \
						(CFGLInitStruct->m_G1D1_Inverse_EN << CFGL_CTL1_G1D1N_POS));
    CFGLx->CTL1 = SFR_Config (CFGLx->CTL1, ~CFGL_CTL1_INIT_MASK, tmpreg);

}

/**
  *   ʼCFGLϢṹ塣
  *   CFGLInitStruct: ָʼĽṹָ롣
  *   ޡ
  */
void
CFGL_Struct_Init (CFGL_InitTypeDef* CFGLInitStruct)
{
    /* ʼCFGL ߼Ԫʹܿλ */
	CFGLInitStruct->m_Module_EN = CFGL_DISABLE;
    /* ʼ CFGL ʹѡλ */
    CFGLInitStruct->m_Output_EN = CFGL_OUTPUT_DISABLE;
    /* ʼ CFGL жѡ */
    CFGLInitStruct->m_RaiseINT_EN = CFGL_RISEINT_DISABLE;
    /* ʼ CFGL ½жѡ */
    CFGLInitStruct->m_FallINT_EN = CFGL_FALLINT_DISABLE;
    /* ʼCFGL ߼Ԫģʽѡ */
    CFGLInitStruct->m_Mode_Sel = CFGL_AND_OR;
    /* ʼ CFGL ѡλ */
    CFGLInitStruct->m_Output_Pol = CFGL_OUT_INPHASE;
    /* ʼCFGL4ѡ */
	CFGLInitStruct->m_G4Output_POL = CFGL_G4POL_INPHASE;
    /* ʼ CFGL3ѡ */
    CFGLInitStruct->m_G3Output_POL = CFGL_G3POL_INPHASE;
    /* ʼ CFGL2ѡ */
    CFGLInitStruct->m_G2Output_POL = CFGL_G2POL_INPHASE;
    /* ʼ CFGL1ѡ */
    CFGLInitStruct->m_G1Output_POL = CFGL_G1POL_INPHASE;
    /* ʼCFGL4ͨѡ */
    CFGLInitStruct->m_G4Input_Sel = CFGL_G4INPUT_CFGL1CH3;
    /* ʼCFGL3ͨѡ */
    CFGLInitStruct->m_G3Input_Sel = CFGL_G3INPUT_CFGL1CH15;
    /* ʼCFGL2ͨѡ */
    CFGLInitStruct->m_G2Input_Sel = CFGL_G2INPUT_CFGL1CH11;
    /* ʼCFGL1ͨѡ */
    CFGLInitStruct->m_G1Input_Sel = CFGL_G1INPUT_CFGL1CH7;
    /* ʼCFGL CH4ͨλѡ */
    CFGLInitStruct->m_CH4Data_Sel = CFGL_CH4_INPUT_0;
    /* ʼCH5\CH6ͨѡ */
    CFGLInitStruct->m_CH5CH6Data_Sel = CFGL_CH5_T21TRGO_CH6_CCP21CH1OUT;

    /* 44ͬͨѡ */
    CFGLInitStruct->m_G4D4_Inphase_EN = FALSE;
    /* 44ͨѡ */
    CFGLInitStruct->m_G4D4_Inverse_EN = FALSE;
    /* 43ͬͨѡ */
    CFGLInitStruct->m_G4D3_Inphase_EN = FALSE;
    /* 43ͨѡ */
    CFGLInitStruct->m_G4D3_Inverse_EN = FALSE;
    /* 42ͬͨѡ */
    CFGLInitStruct->m_G4D2_Inphase_EN = FALSE;
    /* 42ͨѡ */
    CFGLInitStruct->m_G4D2_Inverse_EN = FALSE;
    /* 41ͬͨѡ */
    CFGLInitStruct->m_G4D1_Inphase_EN = FALSE;
    /* 41ͨѡ */
    CFGLInitStruct->m_G4D1_Inverse_EN = FALSE;

    /* 34ͬͨѡ */
    CFGLInitStruct->m_G3D4_Inphase_EN = FALSE;
    /* 34ͨѡ */
    CFGLInitStruct->m_G3D4_Inverse_EN = FALSE;
    /* 33ͬͨѡ */
    CFGLInitStruct->m_G3D3_Inphase_EN = FALSE;
    /* 33ͨѡ */
    CFGLInitStruct->m_G3D3_Inverse_EN = FALSE;
    /* 32ͬͨѡ */
    CFGLInitStruct->m_G3D2_Inphase_EN = FALSE;
    /* 32ͨѡ */
    CFGLInitStruct->m_G3D2_Inverse_EN = FALSE;
    /* 31ͬͨѡ */
    CFGLInitStruct->m_G3D1_Inphase_EN = FALSE;
    /* 31ͨѡ */
    CFGLInitStruct->m_G3D1_Inverse_EN = FALSE;

    /* 24ͬͨѡ */
    CFGLInitStruct->m_G2D4_Inphase_EN = FALSE;
    /* 24ͨѡ */
    CFGLInitStruct->m_G2D4_Inverse_EN = FALSE;
    /* 23ͬͨѡ */
    CFGLInitStruct->m_G2D3_Inphase_EN = FALSE;
    /* 23ͨѡ */
    CFGLInitStruct->m_G2D3_Inverse_EN = FALSE;
    /* 22ͬͨѡ */
    CFGLInitStruct->m_G2D2_Inphase_EN = FALSE;
    /* 22ͨѡ */
    CFGLInitStruct->m_G2D2_Inverse_EN = FALSE;
    /* 21ͬͨѡ */
    CFGLInitStruct->m_G2D1_Inphase_EN = FALSE;
    /* 21ͨѡ */
    CFGLInitStruct->m_G2D1_Inverse_EN = FALSE;

    /* 14ͬͨѡ */
    CFGLInitStruct->m_G1D4_Inphase_EN = FALSE;
    /* 14ͨѡ */
    CFGLInitStruct->m_G1D4_Inverse_EN = FALSE;
    /* 13ͬͨѡ */
    CFGLInitStruct->m_G1D3_Inphase_EN = FALSE;
    /* 13ͨѡ */
    CFGLInitStruct->m_G1D3_Inverse_EN = FALSE;
    /* 12ͬͨѡ */
    CFGLInitStruct->m_G1D2_Inphase_EN = FALSE;
    /* 12ͨѡ */
    CFGLInitStruct->m_G1D2_Inverse_EN = FALSE;
    /* 11ͬͨѡ */
    CFGLInitStruct->m_G1D1_Inphase_EN = FALSE;
    /* 11ͨѡ */
    CFGLInitStruct->m_G1D1_Inverse_EN = FALSE;
}

/**
  *   CFGL2 ͬʹܡ
  * NewState: ʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
CFGL2_OUT_SYNCHRO_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- CFGLIFRĴCFGL2SYNCENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹCFGL2 ͬλ */
    	SFR_SET_BIT_ASM(CFGLIFR_SFR->IFR, CFGL_IFR_CFGL2SYNCEN_POS);

    }
    else
    {
        /* ֹCFGL2 ͬ*/
        SFR_CLR_BIT_ASM(CFGLIFR_SFR->IFR, CFGL_IFR_CFGL2SYNCEN_POS);
    }
}
/**
  *   CFGL1 ͬʹܡ
  * NewState: ʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
CFGL1_OUT_SYNCHRO_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- CFGLIFRĴCFGL1SYNCENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹCFGL1 ͬλ */
    	SFR_SET_BIT_ASM(CFGLIFR_SFR->IFR, CFGL_IFR_CFGL1SYNCEN_POS);

    }
    else
    {
        /* ֹCFGL1 ͬ*/
        SFR_CLR_BIT_ASM(CFGLIFR_SFR->IFR, CFGL_IFR_CFGL1SYNCEN_POS);
    }
}
/**
  *   CFGL2  CFGL2_OUTж½ѡ
  * NewState: ʹ״̬ȡֵΪTRUE  FALSE
  *
  *   ޡ
  */
void
CFGL2_FALLINT_Enable (FunctionalState NewState)
{
    /* У */
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- CFGLIFRĴCFGL2IEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹCFGL2 ½жλ */
    	SFR_SET_BIT_ASM(CFGL2_SFR->CTL0, CFGL_CTL0_INTN_POS);
    	SFR_SET_BIT_ASM(CFGLIFR_SFR->IFR, CFGL_IFR_CFGL2IE_POS);

    }
    else
    {
        /* ֹCFGL2 ½ж*/
    	SFR_CLR_BIT_ASM(CFGL2_SFR->CTL0, CFGL_CTL0_INTN_POS);
        SFR_CLR_BIT_ASM(CFGLIFR_SFR->IFR, CFGL_IFR_CFGL2IE_POS);
    }
}
/**
  *   CFGL2  CFGL2_OUTжѡ
  * NewState: ʹ״̬ȡֵΪTRUE  FALSE
  *
  *   ޡ
  */
void
CFGL2_RISEINT_Enable (FunctionalState NewState)
{
    /* У */
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- CFGLIFRĴCFGL2IEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹCFGL2 жλ */
    	SFR_SET_BIT_ASM(CFGL2_SFR->CTL0, CFGL_CTL0_INTP_POS);
    	SFR_SET_BIT_ASM(CFGLIFR_SFR->IFR, CFGL_IFR_CFGL2IE_POS);

    }
    else
    {
        /* ֹCFGL2 ж*/
    	SFR_CLR_BIT_ASM(CFGL2_SFR->CTL0, CFGL_CTL0_INTP_POS);
        SFR_CLR_BIT_ASM(CFGLIFR_SFR->IFR, CFGL_IFR_CFGL2IE_POS);
    }
}
/**
  *   CFGL1  CFGL1_OUTж½ѡ
  * NewState: ʹ״̬ȡֵΪTRUE  FALSE
  *
  *   ޡ
  */
void
CFGL1_FALLINT_Enable (FunctionalState NewState)
{
    /* У */
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- CFGLIFRĴCFGL2IEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹCFGL1 ½жλ */
    	SFR_SET_BIT_ASM(CFGL1_SFR->CTL0, CFGL_CTL0_INTN_POS);
    	SFR_SET_BIT_ASM(CFGLIFR_SFR->IFR, CFGL_IFR_CFGL1IE_POS);

    }
    else
    {
        /* ֹCFGL1 ½ж*/
    	SFR_CLR_BIT_ASM(CFGL1_SFR->CTL0, CFGL_CTL0_INTN_POS);
        SFR_CLR_BIT_ASM(CFGLIFR_SFR->IFR, CFGL_IFR_CFGL1IE_POS);
    }
}
/**
  *   CFGL1  CFGL1_OUTжѡ
  * NewState: ʹ״̬ȡֵΪTRUE  FALSE
  *
  *   ޡ
  */
void
CFGL1_RISEINT_Enable (FunctionalState NewState)
{
    /* У */
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- CFGLIFRĴCFGL1IEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹCFGL1 жλ */
    	SFR_SET_BIT_ASM(CFGL1_SFR->CTL0, CFGL_CTL0_INTP_POS);
    	SFR_SET_BIT_ASM(CFGLIFR_SFR->IFR, CFGL_IFR_CFGL1IE_POS);

    }
    else
    {
        /* ֹCFGL1 ж*/
    	SFR_CLR_BIT_ASM(CFGL1_SFR->CTL0, CFGL_CTL0_INTP_POS);
        SFR_CLR_BIT_ASM(CFGLIFR_SFR->IFR, CFGL_IFR_CFGL1IE_POS);
    }
}
/**
  *   ȡCFGL1 жϱ־
  * 룺
  *  FlagStatus
  */
FlagStatus
CFGL1_Get_INT_Flag ()
{
    /*---------------- CFGLIFRĴCFGL1IFλ ----------------*/
    if (CFGLIFR_SFR->IFR & CFGL_IFR_CFGL1IF)
    {
        /* ⵽CFGL1ж */
        return SET;
    }
    else
    {
        /* ûм⵽CFGL1ж */
        return RESET;
    }
}
/**
  *   ȡCFGL2 жϱ־
  * 룺
  *  FlagStatus
  */
FlagStatus
CFGL2_Get_INT_Flag ()
{
    /*---------------- CFGLIFRĴCFGL2IFλ ----------------*/
    if (CFGLIFR_SFR->IFR & CFGL_IFR_CFGL2IF)
    {
        /* ⵽CFGL2жϱ־ */
        return SET;
    }
    else
    {
        /* ûм⵽CFGL2ж */
        return RESET;
    }
}
/**
  *   CFGL1 жϱ־
  * 룺
  *    
  */
void
CFGL1_Clear_RISEINT_Flag (void)
{
    /*---------------- CFGLIFRĴCFGL1IFλ ----------------*/
	SFR_CLR_BIT_ASM(CFGL1_SFR->CTL0, CFGL_CTL0_INTP_POS);
	while((CFGLIFR_SFR->IFR & CFGL_IFR_CFGL1IF)>>CFGL_IFR_CFGL1IF_POS);
	SFR_SET_BIT_ASM(CFGL1_SFR->CTL0, CFGL_CTL0_INTP_POS);
}
/**
  *   CFGL1 ½жϱ־
  * 룺
  *    
  */
void
CFGL1_Clear_FALLINT_Flag (void)
{
    /*---------------- CFGLIFRĴCFGL1IFλ ----------------*/
	SFR_CLR_BIT_ASM(CFGL1_SFR->CTL0, CFGL_CTL0_INTN_POS);
	while((CFGLIFR_SFR->IFR & CFGL_IFR_CFGL1IF)>>CFGL_IFR_CFGL1IF_POS);
	SFR_SET_BIT_ASM(CFGL1_SFR->CTL0, CFGL_CTL0_INTN_POS);
}
/**
  *   CFGL غ½жϱ־
  * 룺
  *    
  */
void
CFGL1_Clear_RISEFALLINT_Flag (void)
{
    /*---------------- CFGLIFRĴCFGL2IFλ ----------------*/
	SFR_CLR_BIT_ASM(CFGL1_SFR->CTL0, CFGL_CTL0_INTN_POS);
	SFR_CLR_BIT_ASM(CFGL1_SFR->CTL0, CFGL_CTL0_INTP_POS);
	while((CFGLIFR_SFR->IFR & CFGL_IFR_CFGL1IF)>>CFGL_IFR_CFGL1IF_POS);
	SFR_SET_BIT_ASM(CFGL1_SFR->CTL0, CFGL_CTL0_INTN_POS);
	SFR_SET_BIT_ASM(CFGL1_SFR->CTL0, CFGL_CTL0_INTP_POS);
}
/**
  *   CFGL2 жϱ־
  * 룺
  *    
  */
void
CFGL2_Clear_RISEINT_Flag (void)
{
    /*---------------- CFGLIFRĴCFGL2IFλ ----------------*/
	SFR_CLR_BIT_ASM(CFGL2_SFR->CTL0, CFGL_CTL0_INTP_POS);
	while((CFGLIFR_SFR->IFR & CFGL_IFR_CFGL2IF)>>CFGL_IFR_CFGL2IF_POS);
	SFR_SET_BIT_ASM(CFGL2_SFR->CTL0, CFGL_CTL0_INTP_POS);
}
/**
  *   CFGL غ½жϱ־
  * 룺
  *    
  */
void
CFGL2_Clear_RISEFALLINT_Flag (void)
{
    /*---------------- CFGLIFRĴCFGL2IFλ ----------------*/
	SFR_CLR_BIT_ASM(CFGL2_SFR->CTL0, CFGL_CTL0_INTN_POS);
	SFR_CLR_BIT_ASM(CFGL2_SFR->CTL0, CFGL_CTL0_INTP_POS);
	while((CFGLIFR_SFR->IFR & CFGL_IFR_CFGL2IF)>>CFGL_IFR_CFGL2IF_POS);
	SFR_SET_BIT_ASM(CFGL2_SFR->CTL0, CFGL_CTL0_INTN_POS);
	SFR_SET_BIT_ASM(CFGL2_SFR->CTL0, CFGL_CTL0_INTP_POS);
}
/**
  *   CFGL2 ½жϱ־
  * 룺
  *    
  */
void
CFGL2_Clear_FALLINT_Flag (void)
{
    /*---------------- CFGLIFRĴCFGL2IFλ ----------------*/
	SFR_CLR_BIT_ASM(CFGL2_SFR->CTL0, CFGL_CTL0_INTN_POS);
	while((CFGLIFR_SFR->IFR & CFGL_IFR_CFGL2IF)>>CFGL_IFR_CFGL2IF_POS);
	SFR_SET_BIT_ASM(CFGL2_SFR->CTL0, CFGL_CTL0_INTN_POS);
}
/**
  *   ȡCFGL2 ״̬
  * 룺
  *  FlagStatus
  */
FlagStatus
CFGL2_OUT_STATE ()
{
    /*---------------- CFGLIFRĴCFGL2OUTλ ----------------*/
    if (CFGLIFR_SFR->IFR & CFGL_IFR_CFGL2OUT)
    {
        /* ⵽CFGL2״̬Ϊ1*/
        return SET;
    }
    else
    {
        /* ⵽CFGL2״̬Ϊ0 */
        return RESET;
    }
}
/**
  *   ȡCFGL1 ״̬
  * 룺
  *  FlagStatus
  */
FlagStatus
CFGL1_OUT_STATE ()
{
    /*---------------- CFGLIFRĴCFGL1OUTλ ----------------*/
    if (CFGLIFR_SFR->IFR & CFGL_IFR_CFGL1OUT)
    {
        /* ⵽CFGL1״̬Ϊ1*/
        return SET;
    }
    else
    {
        /* ⵽CFGL1״̬Ϊ0 */
        return RESET;
    }
}
#endif //KF32LS_Periph_cfgl
