/**
  ******************************************************************************
  * ļ  kf32ls_basic_lcd.c
  *     ChipON_AE/FAE_Group
  *     V3.0.0
  *     2021-08-20
  *     ļṩҺʾ(LCD)صĹܺ
  *          + Һʾ(LCD)ʼ
  *          + Һʾ(LCD)ú
  *          + Һʾ(LCD)жϹ
  *
  *********************************************************************
  */

#include "kf32ls_basic_lcd.h"
#include "kf32ls_basic_rst.h"
#include "kf32ls_basic_pclk.h"

#ifdef KF32LS_Periph_lcd
/* ʱ˽ж ----------------------------------------------------*/
/* LCD_CTLĴʼ */
#define LCD_CTL_INIT_MASK               (LCD_CTL_LCDENANALOG \
                                       | LCD_CTL_LMUX \
                                       | LCD_CTL_FR \
                                       | LCD_CTL_VLCDMD \
                                       | LCD_CTL_CS \
                                       | LCD_CTL_LP)

/**
  *   ##### Һʾ(LCD)ʼ #####
  */
/**
  *   λLCD裬ʹʱӡ
  *   ޡ
  *   ޡ
  */
void
LCD_Reset (void)
{
    RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_LCDRST, TRUE);
    RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_LCDRST, FALSE);
    PCLK_CTL1_Peripheral_Clock_Enable(PCLK_CTL1_LCDCLKEN, TRUE);
}

/**
  *   LCDҺʾʼ
  *   lcdInitStruct: LCDҺʾϢṹ塣
  *   ޡ
  */
void
LCD_Configuration(LCD_InitTypeDef* lcdInitStruct)
{
    uint32_t tmpreg = 0;
    uint32_t tmpmask = 0;
    uint32_t tmploc = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_LCD_SEG_PIN(lcdInitStruct->m_SegPin));
    CHECK_RESTRICTION(CHECK_LCD_SEG_FUNCTION(lcdInitStruct->m_SegPinEn));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(lcdInitStruct->m_Analog));
    CHECK_RESTRICTION(CHECK_LCD_SOURCE(lcdInitStruct->m_ClockSource));
    CHECK_RESTRICTION(CHECK_LCD_SOURCE_DIVIDE(lcdInitStruct->m_SourcePrescaler));
    CHECK_RESTRICTION(CHECK_LCD_PRESCALER(lcdInitStruct->m_LCDPrescaler));
    CHECK_RESTRICTION(CHECK_LCD_COMMON_PORT(lcdInitStruct->m_CommonPort));
    CHECK_RESTRICTION(CHECK_LCD_VOLTAGE_SELECT(lcdInitStruct->m_VoltageSelect));

    /*---------------- LCD_CTLĴ ----------------*/
    /* ݽṹԱm_AnalogLCDENANALOGλ */
    /* ݽṹԱm_CommonPortLMUXλ */
    /* ݽṹԱm_SourcePrescalerFRλ */
    /* ݽṹԱm_VoltageSelectVLCDMDλ */
    /* ݽṹԱm_ClockSourceCSλ */
    /* ݽṹԱm_LCDPrescalerLPλ */
    tmpreg = (lcdInitStruct->m_Analog << LCD_CTL_LCDENANALOG_POS) \
           | (lcdInitStruct->m_CommonPort) \
           | (lcdInitStruct->m_SourcePrescaler) \
           | (lcdInitStruct->m_VoltageSelect << LCD_CTL_VLCDMD_POS) \
           | (lcdInitStruct->m_ClockSource) \
           | (lcdInitStruct->m_LCDPrescaler);
    LCD_CTL = SFR_Config (LCD_CTL,
                          ~LCD_CTL_INIT_MASK,
                          tmpreg);

    /*---------------- LCD_SEGxĴ ----------------*/
    /* ݽṹԱm_SegPinm_SegPinEnSEGxλ */
    tmpreg = (uint32_t)lcdInitStruct->m_SegPin;
    if (tmpreg != 0)
    {
        if (lcdInitStruct->m_SegPinEn != LCD_SEG_PIN_IO)
        {
            /* ʹŵĶι */
            LCD_SEG0 |= tmpreg;
        }
        else
        {
            /* ʹŵI/O */
            LCD_SEG0 &= ~tmpreg;
        }
    }
    else
    {
        ;
    }

    tmpreg = (uint32_t)(lcdInitStruct->m_SegPin >> 32);
    if (tmpreg != 0)
    {
        if (lcdInitStruct->m_SegPinEn != LCD_SEG_PIN_IO)
        {
            /* ʹŵĶι */
            LCD_SEG1 |= tmpreg;
        }
        else
        {
            /* ʹŵI/O */
            LCD_SEG1 &= ~tmpreg;
        }
    }
    else
    {
        ;
    }
}

/**
  *   ʼLCDҺʾϢṹ塣
  *   lcdInitStruct: ָʼĽṹָ롣
  *   ޡ
  */
void
LCD_Struct_Init (LCD_InitTypeDef* lcdInitStruct)
{
    /* ʼ SEGűѡ */
    lcdInitStruct->m_SegPin = 0;
    /* ʼ Ź */
    lcdInitStruct->m_SegPinEn = LCD_SEG_PIN_IO;
    /* ʼ LCDģⲿʹ */
    lcdInitStruct->m_Analog = FALSE;
    /* ʼ LCDʱԴ */
    lcdInitStruct->m_ClockSource = LCD_SOURCE_HALF_SCLK;
    /* ʼ LCDʱԴƵ */
    lcdInitStruct->m_SourcePrescaler = LCD_SOURCE_DIVIDE_2;
    /* ʼ LCDԤƵ */
    lcdInitStruct->m_LCDPrescaler = LCD_PRESCALER_1;
    /* ʼ LCDѡ */
    lcdInitStruct->m_CommonPort = LCD_COMMON_PORT_DIV_8;
    /* ʼ LCDڲ/ⲿԴѡ */
    lcdInitStruct->m_VoltageSelect = LCD_VOLTAGE_INTERNAL;
}
/**
  *   ##### Һʾ(LCD)ʼ #####
  */


/**
  *   ##### Һʾ(LCD)ú #####
  */
/**
  *   LCDʹܡ
  *   NewState: LCDʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
LCD_Cmd_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- LCD_CTLĴLCDENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹLCDģ */
        SFR_SET_BIT_ASM(LCD_CTL, LCD_CTL_LCDEN_POS);
    }
    else
    {
        /* ֹLCDģ */
        SFR_CLR_BIT_ASM(LCD_CTL, LCD_CTL_LCDEN_POS);
    }
}

/**
  *   LCDģⲿʹܡ
  *   NewState: LCDģⲿʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
LCD_Analog_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- LCD_CTLĴLCDENANALOGλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹLCDģⲿ */
        SFR_SET_BIT_ASM(LCD_CTL, LCD_CTL_LCDENANALOG_POS);
    }
    else
    {
        /* ֹLCDģⲿ */
        SFR_CLR_BIT_ASM(LCD_CTL, LCD_CTL_LCDENANALOG_POS);
    }
}

/**
  *   ڲƫѹԴѹ
  *   Voltage: ڲƫѹԴѹȡֵΧΪ:
  *                  LCD_BIAS_VOLTAGE_3P04: 3.04V
  *                  LCD_BIAS_VOLTAGE_2P89: 2.89V
  *                  LCD_BIAS_VOLTAGE_2P76: 2.76V
  *                  LCD_BIAS_VOLTAGE_2P62: 2.62V
  *                  LCD_BIAS_VOLTAGE_3P62: 3.62V
  *                  LCD_BIAS_VOLTAGE_3P46: 3.46V
  *                  LCD_BIAS_VOLTAGE_3P32: 3.32V
  *                  LCD_BIAS_VOLTAGE_3P19: 3.19V
  *   ޡ
  */
void
LCD_Internal_Bias_Voltage_Config (uint32_t Voltage)
{
    /* У */
    CHECK_RESTRICTION(CHECK_LCD_BIAS_VOLTAGE(Voltage));

    /*---------------- LCD_CTLĴTRIMCPVOLλ ----------------*/
    LCD_CTL = SFR_Config (LCD_CTL, ~LCD_CTL_TRIMCPVOL, Voltage);
}

/**
  *   ùˡ
  *   CommonPort: ѡȡֵΧΪ:
  *                     LCD_COMMON_PORT_STATIC: ̬COM0
  *                     LCD_COMMON_PORT_DIV_2: 1/2 COM<1:0>
  *                     LCD_COMMON_PORT_DIV_3: 1/3 COM<2:0>
  *                     LCD_COMMON_PORT_DIV_4: 1/4 COM<3:0>
  *                     LCD_COMMON_PORT_DIV_8: 1/8 COM<7:0>
  *   ޡ
  */
void
LCD_Common_Port_Config (uint32_t CommonPort)
{
    /* У */
    CHECK_RESTRICTION(CHECK_LCD_COMMON_PORT(CommonPort));

    /*---------------- LCD_CTLĴLMUXλ ----------------*/
    LCD_CTL = SFR_Config (LCD_CTL, ~LCD_CTL_LMUX, CommonPort);
}

/**
  *   LCDʱԴƵ
  *   ClkDivider: LCDʱԴƵȡֵΧΪ:
  *                     LCD_SOURCE_DIVIDE_2: 1:2
  *                     LCD_SOURCE_DIVIDE_4: 1:4
  *                     LCD_SOURCE_DIVIDE_8: 1:8
  *                     LCD_SOURCE_DIVIDE_16: 1:16
  *                     LCD_SOURCE_DIVIDE_32: 1:32
  *                     LCD_SOURCE_DIVIDE_64: 1:64
  *                     LCD_SOURCE_DIVIDE_128: 1:128
  *                     LCD_SOURCE_DIVIDE_256: 1:256
  *                     LCD_SOURCE_DIVIDE_512: 1:512
  *                     LCD_SOURCE_DIVIDE_1024: 1:1024
  *                     LCD_SOURCE_DIVIDE_2048: 1:2048
  *                     LCD_SOURCE_DIVIDE_4096: 1:4096
  *                     LCD_SOURCE_DIVIDE_8192: 1:8192
  *                     LCD_SOURCE_DIVIDE_16384: 1:16384
  *                     LCD_SOURCE_DIVIDE_32768: 1:32768
  *   ޡ
  */
void
LCD_Source_Clock_Divider_Config (uint32_t ClkDivider)
{
    /* У */
    CHECK_RESTRICTION(CHECK_LCD_SOURCE_DIVIDE(ClkDivider));

    /*---------------- LCD_CTLĴFRλ ----------------*/
    LCD_CTL = SFR_Config (LCD_CTL, ~LCD_CTL_FR, ClkDivider);
}

/**
  *   LCDѹѡ
  *   VoltageSelect: LCDѹѡȡֵΧΪ:
  *                        LCD_VOLTAGE_INTERNAL: ڲѹ·ṩѹ
  *                        LCD_VOLTAGE_EXTERNAL: ⲿṩѹ
  *   ޡ
  */
void
LCD_Voltage_Divider_Config (uint32_t VoltageSelect)
{
    /* У */
    CHECK_RESTRICTION(CHECK_LCD_VOLTAGE_SELECT(VoltageSelect));

    /*---------------- LCD_CTLĴVLCDSλ ----------------*/
    if (VoltageSelect != LCD_VOLTAGE_INTERNAL)
    {
        /* ⲿṩѹ */
        SFR_SET_BIT_ASM(LCD_CTL, LCD_CTL_VLCDS_POS);
    }
    else
    {
        /* ڲѹ·ṩѹ */
        SFR_CLR_BIT_ASM(LCD_CTL, LCD_CTL_VLCDS_POS);
    }
}

/**
  *   LCDƫõѹԴѡ
  *   VoltageSelect: LCDƫõѹԴѡȡֵΧΪ:
  *                        LCD_VOLTAGE_INTERNAL: ڲԴLCD
  *                        LCD_VOLTAGE_EXTERNAL: ⲿԴLCD
  *   ޡ
  */
void
LCD_Bias_Voltage_Source_Config (uint32_t VoltageSelect)
{
    /* У */
    CHECK_RESTRICTION(CHECK_LCD_VOLTAGE_SELECT(VoltageSelect));

    /*---------------- LCD_CTLĴVLCDMDλ ----------------*/
    if (VoltageSelect != LCD_VOLTAGE_INTERNAL)
    {
        /* ⲿԴLCD */
        SFR_SET_BIT_ASM(LCD_CTL, LCD_CTL_VLCDMD_POS);
    }
    else
    {
        /* ڲԴLCD */
        SFR_CLR_BIT_ASM(LCD_CTL, LCD_CTL_VLCDMD_POS);
    }
}

/**
  *   LCD PUMPʹܡ
  *   NewState: LCD PUMPʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
LCD_Pump_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- LCD_CTLĴPUMPENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹPUMP */
        SFR_SET_BIT_ASM(LCD_CTL, LCD_CTL_PUMPEN_POS);
    }
    else
    {
        /* ʹPUMP */
        SFR_CLR_BIT_ASM(LCD_CTL, LCD_CTL_PUMPEN_POS);
    }
}

/**
  *   ʱԴѡ
  *   SourceClock: LCDʱԴѡȡֵΧΪ:
  *                      LCD_SOURCE_HALF_SCLK: SCLK / 2
  *                      LCD_SOURCE_HALF_HFCLK: HFCLK / 2
  *                      LCD_SOURCE_HALF_LFCLK: LFCLK / 2
  *                      LCD_SOURCE_HALF_INTLF: INTLF / 2
  *   ޡ
  */
void
LCD_Source_Clock_Config (uint32_t SourceClock)
{
    /* У */
    CHECK_RESTRICTION(CHECK_LCD_SOURCE(SourceClock));

    /*---------------- LCD_CTLĴCSλ ----------------*/
    LCD_CTL = SFR_Config (LCD_CTL, ~LCD_CTL_CS, SourceClock);
}

/**
  *   LCDѡ
  *   WaveType: LCDѡȡֵΧΪ:
  *                   LCD_WAVE_TYPE_A: A ͲΣÿһڸıλ
  *                   LCD_WAVE_TYPE_B: B ͲΣÿһ߽֡ıλ
  *   ޡ
  */
void
LCD_Wave_Type_Config (uint32_t WaveType)
{
    /* У */
    CHECK_RESTRICTION(CHECK_LCD_WAVE_TYPE(WaveType));

    /*---------------- LCD_CTLĴWFTλ ----------------*/
    if (WaveType != LCD_WAVE_TYPE_A)
    {
        /* B Ͳ */
        SFR_SET_BIT_ASM(LCD_CTL, LCD_CTL_WFT_POS);
    }
    else
    {
        /* A Ͳ */
        SFR_CLR_BIT_ASM(LCD_CTL, LCD_CTL_WFT_POS);
    }
}

/**
  *   LCDƫģʽѡҪLCD_Common_Port_Config
  *   BiasMode: LCDƫģʽѡȡֵΧΪ:
  *                   LCD_BIAS_MODE_STATIC: ̬ƫģʽ
  *                   LCD_BIAS_MODE_1_DIV_3: 1/3 ƫģʽ
  *                   LCD_BIAS_MODE_1_DIV_2: 1/2 ƫģʽ
  *   ޡ
  */
void
LCD_Bias_Mode_Config (uint32_t BiasMode)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_LCD_BIAS_MODE(BiasMode));

    /* ȡLCD_CTLĴLMUXϢ */
    tmpreg = LCD_CTL;
    tmpreg &= LCD_CTL_LMUX;
    switch (tmpreg)
    {
        case LCD_COMMON_PORT_STATIC:
            CHECK_RESTRICTION(LCD_BIAS_MODE_STATIC==BiasMode);
            break;
        case LCD_COMMON_PORT_DIV_4:
        case LCD_COMMON_PORT_DIV_8:
            CHECK_RESTRICTION(LCD_BIAS_MODE_1_DIV_3==BiasMode);
            break;
        default:
            break;
    }

    /*---------------- LCD_CTLĴBIASMDλ ----------------*/
    if (BiasMode != LCD_BIAS_MODE_1_DIV_3)
    {
        /* 1/3 ƫģʽ  ̬ƫģʽ */
        SFR_SET_BIT_ASM(LCD_CTL, LCD_CTL_BIASMD_POS);
    }
    else
    {
        /* 1/2 ƫģʽ */
        SFR_CLR_BIT_ASM(LCD_CTL, LCD_CTL_BIASMD_POS);
    }
}

/**
  *   LCDԤƵȡ
  *   Prescaler: LCDԤƵȣȡֵΧΪ:
  *                    LCD_PRESCALER_1: 1:1
  *                    LCD_PRESCALER_2: 1:2
  *                    LCD_PRESCALER_3: 1:3
  *                    LCD_PRESCALER_4: 1:4
  *                    LCD_PRESCALER_5: 1:5
  *                    LCD_PRESCALER_6: 1:6
  *                    LCD_PRESCALER_7: 1:7
  *                    LCD_PRESCALER_8: 1:8
  *                    LCD_PRESCALER_9: 1:9
  *                    LCD_PRESCALER_10: 1:10
  *                    LCD_PRESCALER_11: 1:11
  *                    LCD_PRESCALER_12: 1:12
  *                    LCD_PRESCALER_13: 1:13
  *                    LCD_PRESCALER_14: 1:14
  *                    LCD_PRESCALER_15: 1:15
  *                    LCD_PRESCALER_16: 1:16
  *   ޡ
  */
void
LCD_Prescaler_Config (uint32_t Prescaler)
{
    /* У */
    CHECK_RESTRICTION(CHECK_LCD_PRESCALER(Prescaler));

    /*---------------- LCD_CTLĴLPλ ----------------*/
    LCD_CTL = SFR_Config (LCD_CTL, ~LCD_CTL_LP, Prescaler);
}

/**
  *   LCD˸ģʽʱ䣬ʱ=(32 * FlickerOn)/֡Ƶʡ
  *   FlickerOn: LCD˸ģʽʱ䣬ȡֵΪ8λЧֵ
  *   ޡ
  */
void
LCD_Flicker_On_Time_Config (uint8_t FlickerOn)
{
	uint32_t tmpreg = 0;
    /*---------------- LCD_PTLĴFONλ ----------------*/
	tmpreg = FlickerOn << LCD_PTL_FON0_POS;
    LCD_PTL = SFR_Config (LCD_PTL, ~LCD_PTL_FON, tmpreg);
}

/**
  *   LCD˸ģʽʱ䣬ʱ=(32 * FlickerOff)/֡Ƶʡ
  *   FlickerOff: LCD˸ģʽʱ䣬ȡֵΪ8λЧֵ
  *   ޡ
  */
void
LCD_Flicker_Off_Time_Config (uint8_t FlickerOff)
{
	uint32_t tmpreg = 0;
    /*---------------- LCD_PTLĴFOFFλ ----------------*/
	tmpreg = FlickerOff << LCD_PTL_FOFF0_POS;
    LCD_PTL = SFR_Config (LCD_PTL, ~LCD_PTL_FOFF, tmpreg);
}

/**
  *   LCD˸ģʽʹܡ
  *   NewState: LCD˸ģʽʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
LCD_Flicker_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- LCD_PTLĴFLKENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹ˸ */
        SFR_SET_BIT_ASM(LCD_PTL, LCD_PTL_FLKEN_POS);
    }
    else
    {
        /* ֹ˸ */
        SFR_CLR_BIT_ASM(LCD_PTL, LCD_PTL_FLKEN_POS);
    }
}

/**
  *   LCDģʽʹܡ
  *   NewState: LCDģʽʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
LCD_Save_Power_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- LCD_PTLĴSPENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹܽģʽ */
        SFR_SET_BIT_ASM(LCD_PTL, LCD_PTL_SPEN_POS);
    }
    else
    {
        /* ֹģʽ */
        SFR_CLR_BIT_ASM(LCD_PTL, LCD_PTL_SPEN_POS);
    }
}

/**
  *   LCDʱ䵥λС
  *   TimeSlice: LCDʱ䵥λСȡֵΧΪ
  *                    LCD_TIME_SLICE_EQU_2_FRAME: ʱ䵥λt2֡
  *                    LCD_TIME_SLICE_EQU_4_FRAME: ʱ䵥λt4֡
  *                    LCD_TIME_SLICE_EQU_8_FRAME: ʱ䵥λt8֡
  *                    LCD_TIME_SLICE_EQU_16_FRAME: ʱ䵥λt16֡
  *                    LCD_TIME_SLICE_EQU_32_FRAME: ʱ䵥λt32֡
  *                    LCD_TIME_SLICE_EQU_64_FRAME: ʱ䵥λt64֡
  *                    LCD_TIME_SLICE_EQU_128_FRAME: ʱ䵥λt128֡
  *                    LCD_TIME_SLICE_EQU_256_FRAME: ʱ䵥λt256֡
  *   ޡ
  */
void
LCD_Time_Slice_Config (uint32_t TimeSlice)
{
    /* У */
    CHECK_RESTRICTION(CHECK_LCD_TIME_SLICE(TimeSlice));

    /*---------------- LCD_PTLĴTSλ ----------------*/
    LCD_PTL = SFR_Config (LCD_PTL, ~LCD_PTL_TS, TimeSlice);
}

/**
  *   ùʱ͹رʱ
  *   WorkTime: ʱ͹رʱȡֵΧΪ
  *                   LCD_WORK_VS_STOP_8_8: LCDʱ͹رʱıΪ8:8
  *                   LCD_WORK_VS_STOP_7_9: LCDʱ͹رʱıΪ7:9
  *                   LCD_WORK_VS_STOP_6_10: LCDʱ͹رʱıΪ6:10
  *                   LCD_WORK_VS_STOP_5_11: LCDʱ͹رʱıΪ5:11
  *                   LCD_WORK_VS_STOP_4_12: LCDʱ͹رʱıΪ4:12
  *                   LCD_WORK_VS_STOP_3_13: LCDʱ͹رʱıΪ3:13
  *                   LCD_WORK_VS_STOP_2_14: LCDʱ͹رʱıΪ2:14
  *                   LCD_WORK_VS_STOP_1_15: LCDʱ͹رʱıΪ1:15
  *   ޡ
  */
void
LCD_Work_Time_Config (uint32_t WorkTime)
{
    /* У */
    CHECK_RESTRICTION(CHECK_LCD_WORK_VS_STOP(WorkTime));

    /*---------------- LCD_PTLĴIFλ ----------------*/
    LCD_PTL = SFR_Config (LCD_PTL, ~LCD_PTL_IF, WorkTime);
}

/**
  *   Aģʽơ
  *   PowerCtl: ģʽƣȡֵΧΪ
  *                   LCD_HIGH_RESISTANCE_NO_BUF: ʹøߵҲBUF
  *                   LCD_LOW_RESISTANCE_NO_BUF: ʹõ͵ҲBUF
  *                   LCD_HIGH_RESISTANCE_WITH_BUF: ʹøߵҲBUF
  *                   LCD_LOW_RESISTANCE_WITH_BUF: ʹõ͵ҲBUF
  *   ޡ
  */
void
LCD_A_Power_Control_Config (uint32_t PowerCtl)
{
	uint32_t tmpreg = 0;
    /* У */
    CHECK_RESTRICTION(CHECK_LCD_POWER_CONTROL(PowerCtl));

    /*---------------- LCD_PTLĴAPCλ ----------------*/
    tmpreg = PowerCtl << LCD_PTL_APC0_POS;
    LCD_PTL = SFR_Config (LCD_PTL, ~LCD_PTL_APC, tmpreg);
}

/**
  *   Bģʽơ
  *   PowerCtl: ģʽƣȡֵΧΪ
  *                   LCD_HIGH_RESISTANCE_NO_BUF: ʹøߵҲBUF
  *                   LCD_LOW_RESISTANCE_NO_BUF: ʹõ͵ҲBUF
  *                   LCD_HIGH_RESISTANCE_WITH_BUF: ʹøߵҲBUF
  *                   LCD_LOW_RESISTANCE_WITH_BUF: ʹõ͵ҲBUF
  *   ޡ
  */
void
LCD_B_Power_Control_Config (uint32_t PowerCtl)
{
	uint32_t tmpreg = 0;
    /* У */
    CHECK_RESTRICTION(CHECK_LCD_POWER_CONTROL(PowerCtl));

    /*---------------- LCD_PTLĴBPCλ ----------------*/
    tmpreg = PowerCtl << LCD_PTL_BPC0_POS;
    LCD_PTL = SFR_Config (LCD_PTL, ~LCD_PTL_BPC, tmpreg);
}

/**
  *   ʱȿơ
  *   PowerMode: ʱȿƣȡֵΧΪ
  *                    LCD_POWER_B_MODE: ģʽΪBģʽ
  *                    LCD_POWER_A_VS_B_IS_1_15: ABʱ䳤ȱֵΪ1:15
  *                    LCD_POWER_A_VS_B_IS_2_14: ABʱ䳤ȱֵΪ2:14
  *                    LCD_POWER_A_VS_B_IS_3_13: ABʱ䳤ȱֵΪ3:13
  *                    LCD_POWER_A_VS_B_IS_4_12: ABʱ䳤ȱֵΪ4:12
  *                    LCD_POWER_A_VS_B_IS_5_11: ABʱ䳤ȱֵΪ5:11
  *                    LCD_POWER_A_VS_B_IS_6_10: ABʱ䳤ȱֵΪ6:10
  *                    LCD_POWER_A_VS_B_IS_7_9: ABʱ䳤ȱֵΪ7:9
  *   ޡ
  */
void
LCD_Power_Mode_Config (uint32_t PowerMode)
{
    /* У */
    CHECK_RESTRICTION(CHECK_LCD_POWER_MODE(PowerMode));

    /*---------------- LCD_PTLĴATICλ ----------------*/
    LCD_PTL = SFR_Config (LCD_PTL, ~LCD_PTL_ATIC, PowerMode);
}

/**
  *   LCDʹܡ
  *   SegPin: ű룬ȡֵΪLCD_SEG_PIN_0~LCD_SEG_PIN_47еһϡ
  *       SegFunction: ŹãȡֵΪ
  *                      LCD_SEG_PIN_IO: ʹŵI/O
  *                      LCD_SEG_PIN_SEG: ʹŵĶι
  *   ޡ
  */
void
LCD_Seg_Pin_Function_Config (uint64_t SegPin, uint32_t SegFunction)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_LCD_SEG_PIN(SegPin));
    CHECK_RESTRICTION(CHECK_LCD_SEG_FUNCTION(SegFunction));

    tmpreg = (uint32_t)SegPin;
    if (tmpreg != 0)
    {
        /*---------------- LCD_SEG0ĴSEGxλ ----------------*/
        if (SegFunction != LCD_SEG_PIN_IO)
        {
            /* ʹŵĶι */
            LCD_SEG0 |= tmpreg;
        }
        else
        {
            /* ʹŵI/O */
            LCD_SEG0 &= ~tmpreg;
        }
    }
    else
    {
        ;
    }

    tmpreg = (uint32_t)(SegPin >> 32);
    if (tmpreg != 0)
    {
        /*---------------- LCD_SEG1ĴSEGxλ ----------------*/
        if (SegFunction != LCD_SEG_PIN_IO)
        {
            /* ʹŵĶι */
            LCD_SEG1 |= tmpreg;
        }
        else
        {
            /* ʹŵI/O */
            LCD_SEG1 &= ~tmpreg;
        }
    }
    else
    {
        ;
    }
}

/**
  *   LCDݡ
  *   ComPin: COMűţȡֵΪLCD_PIN_SOURCE_COM0~LCD_PIN_SOURCE_COM7еһ
  *       SegPin: ȡֵΪLCD_SEG_PIN_0~LCD_SEG_PIN_47еһϡ
  *       Pixel: ص״̬ȡֵΪ
  *                      LCD_PIXEL_TRANSPARENCY: أ͸
  *                      LCD_PIXEL_LIGHT: أ͸
  *   ޡ
  */
void
LCD_Data_Pixel_Config (uint32_t ComPin, uint64_t SegPin, uint32_t Pixel)
{
    uint32_t tmpmask = 0;
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_LCD_PIN_SOURCE_COM(ComPin));
    CHECK_RESTRICTION(CHECK_LCD_SEG_PIN(SegPin));
    CHECK_RESTRICTION(CHECK_LCD_PIXEL(Pixel));

    /* SEG0~SEG31 */
    tmpmask = (uint32_t)SegPin;
    if (tmpmask != 0)
    {
        /*---------------- LCD_DATAxĴCOMxSEGxλ ----------------*/
        if (Pixel != LCD_PIXEL_TRANSPARENCY)
        {
            /* أ͸ */
            LCD_SFR->DATA[ComPin] |= tmpmask;
        }
        else
        {
            /* أ͸ */
            LCD_SFR->DATA[ComPin] &= ~tmpmask;
        }
    }
    else
    {
        ;
    }

    /* SEG32~SEG39 */
    tmpmask = (uint32_t)(SegPin >> 32);
    tmpmask &= 0xFF;
    if (tmpmask != 0)
    {
        /*---------------- LCD_DATAxĴCOMxSEGxλ ----------------*/
        tmpreg = (ComPin & 0x3) * 8;
        if (Pixel != LCD_PIXEL_TRANSPARENCY)
        {
            /* أ͸ */
            LCD_SFR->DATA[(ComPin >> 2) + 8] |= tmpmask << tmpreg;
        }
        else
        {
            /* أ͸ */
            LCD_SFR->DATA[(ComPin >> 2) + 8] &= ~(tmpmask << tmpreg);
        }
    }
    else
    {
        ;
    }

    /* SEG40~SEG47 */
    tmpmask = (uint32_t)(SegPin >> (32 + 8));
    if (tmpmask != 0)
    {
        /*---------------- LCD_DATAxĴCOMxSEGxλ ----------------*/
        tmpreg = (ComPin & 0x3) * 8;
        if (Pixel != LCD_PIXEL_TRANSPARENCY)
        {
            /* أ͸ */
            LCD_SFR->DATA[(ComPin >> 2) + 10] |= tmpmask << tmpreg;
        }
        else
        {
            /* أ͸ */
            LCD_SFR->DATA[(ComPin >> 2) + 10] &= ~(tmpmask << tmpreg);
        }
    }
    else
    {
        ;
    }
}
/**
  *  : LCDдĴDATAx
  *  : LCD_Datax_Sel0-7(COM0-7)
  * 	   LCD_Datax_DataҪĵ
  * 	   LCD_Datax_LocҪдλ
  *  쳣0ȷ޷
  * Ч ûʾLCDݣдָݼĴṩڡ
  */
uint16_t LCD_SET_Datareg (uint8_t LCD_Datax_Sel,uint64_t LCD_Datax_Data,uint64_t LCD_Datax_Loc)
{
	uint32_t masktmp;//
	/*----------------ǷΪData0-7 ----------------*/
	CHECK_RESTRICTION(CHECK_LCD_COM_SEL(LCD_Datax_Sel));
	/*----------------û64λ16λǷΪ0----------------*/
	if(((LCD_Datax_Data>>48) != 0) | ((LCD_Datax_Loc>>48) != 0))
	{
		return 0;
	}
	/*----------------дLCD_DATAĴDATAλ ----------------
	 * com0-7ĵ32λд0-7
	 * com0-3ĵ32-39λдcom8
	 * com4-7ĵ32-39λдcom9
	 * com0-3ĵ40-47λдcom10
	 * com4-7ĵ40-47λдcom11
	 * οLCDݼĴ
	 * */
	if(LCD_Datax_Sel==0)
	{
		LCD_DATA0=(LCD_DATA0 & ~LCD_Datax_Loc) | (LCD_Datax_Data & LCD_Datax_Loc);//00-31
		if(LCD_Datax_Loc & (uint64_t)(0xFF)<<32)//16-23λҪ
		{
			masktmp= LCD_Datax_Loc<<24>>56;
			LCD_DATA8 = (LCD_DATA8 & ~masktmp) | ((LCD_Datax_Data >>32) & masktmp );//80-7
		}
		if(LCD_Datax_Loc & (uint64_t)(0xFF)<<40)//24-31λҪ
		{
			masktmp = LCD_Datax_Loc<<16>>56;
			LCD_DATA10=(LCD_DATA10 & ~masktmp) | ((LCD_Datax_Data >>40) & masktmp );//100-7
		}
	}
	if(LCD_Datax_Sel==1)
	{
		LCD_DATA1=(LCD_DATA1 & ~LCD_Datax_Loc) | (LCD_Datax_Data & LCD_Datax_Loc);//10-31
		if(LCD_Datax_Loc & (uint64_t)(0xFF)<<32)//16-23λҪ
		{
			masktmp= LCD_Datax_Loc<<24>>56;
			LCD_DATA8 = (LCD_DATA8 & ~(masktmp<<8)) | ((LCD_Datax_Data>>32 & masktmp )<<8);//88-15
		}
		if(LCD_Datax_Loc & (uint64_t)(0xFF)<<40)//24-31λҪ
		{
			masktmp = LCD_Datax_Loc<<16>>56;
			LCD_DATA10 = (LCD_DATA10 & ~(masktmp<<8)) | ((LCD_Datax_Data>>40 & masktmp )<<8);//108-15
		}
	}
	if(LCD_Datax_Sel==2)
	{
		LCD_DATA2=(LCD_DATA2 & ~LCD_Datax_Loc) | (LCD_Datax_Data & LCD_Datax_Loc);//20-31
		if(LCD_Datax_Loc & (uint64_t)(0xFF)<<32)//16-23λҪ
		{
			masktmp= LCD_Datax_Loc<<24>>56;
			LCD_DATA8 = (LCD_DATA8 & ~(masktmp<<16)) | ((LCD_Datax_Data>>32 & masktmp )<<16);//816-23
		}
		if(LCD_Datax_Loc & (uint64_t)(0xFF)<<40)//24-31λҪ
		{
			masktmp = LCD_Datax_Loc<<16>>56;
			LCD_DATA10 = (LCD_DATA10 & ~(masktmp<<16)) | ((LCD_Datax_Data>>40 & masktmp )<<16);//1016-23
		}
	}
	if(LCD_Datax_Sel==3)
	{
		LCD_DATA3=(LCD_DATA3 & ~LCD_Datax_Loc) | (LCD_Datax_Data & LCD_Datax_Loc);//30-31
		if(LCD_Datax_Loc & (uint64_t)(0xFF)<<32)//16-23λҪ
		{
			masktmp= LCD_Datax_Loc<<24>>56;
			LCD_DATA8 = (LCD_DATA8 & ~(masktmp<<24)) | ((LCD_Datax_Data>>32 & masktmp )<<24);//816-23//824-31
		}
		if(LCD_Datax_Loc & (uint64_t)(0xFF)<<40)//24-31λҪ
		{
			masktmp = LCD_Datax_Loc<<16>>56;
			LCD_DATA10 = (LCD_DATA10 & ~(masktmp<<24)) | ((LCD_Datax_Data>>40 & masktmp )<<24);//1024-31
		}
	}
	if(LCD_Datax_Sel==4)
	{
		LCD_DATA4=(LCD_DATA4 & ~LCD_Datax_Loc) | (LCD_Datax_Data & LCD_Datax_Loc);//40-31
		if(LCD_Datax_Loc & (uint64_t)(0xFF)<<32)//16-23λҪ
		{
			masktmp= LCD_Datax_Loc<<24>>56;
			LCD_DATA9 = (LCD_DATA9 & ~masktmp) | ((LCD_Datax_Data >>32) & masktmp );//90-7
		}
		if(LCD_Datax_Loc & (uint64_t)(0xFF)<<40)//24-31λҪ
		{
			masktmp = LCD_Datax_Loc<<16>>56;
			LCD_DATA11=(LCD_DATA11 & ~masktmp) | ((LCD_Datax_Data >>40) & masktmp );//110-7
		}
	}
	if(LCD_Datax_Sel==5)
	{
		LCD_DATA5=(LCD_DATA5 & ~LCD_Datax_Loc) | (LCD_Datax_Data & LCD_Datax_Loc);//50-31
		if(LCD_Datax_Loc & (uint64_t)(0xFF)<<32)//16-23λҪ
		{
			masktmp= LCD_Datax_Loc<<24>>56;
			LCD_DATA9 = (LCD_DATA9 & ~(masktmp<<8)) | ((LCD_Datax_Data>>32 & masktmp )<<8);//98-15
		}
	if(LCD_Datax_Loc & (uint64_t)(0xFF)<<40)//24-31λҪ
		{
			masktmp = LCD_Datax_Loc<<16>>56;
			LCD_DATA11 = (LCD_DATA11 & ~(masktmp<<8)) | ((LCD_Datax_Data>>40 & masktmp )<<8);//118-15
		}
	}
	if(LCD_Datax_Sel==6)
	{
		LCD_DATA6=(LCD_DATA6 & ~LCD_Datax_Loc) | (LCD_Datax_Data & LCD_Datax_Loc);//60-31
		if(LCD_Datax_Loc & (uint64_t)(0xFF)<<32)//16-23λҪ
		{
			masktmp= LCD_Datax_Loc<<24>>56;
			LCD_DATA9 = (LCD_DATA9 & ~(masktmp<<16)) | ((LCD_Datax_Data>>32 & masktmp )<<16);//916-23
		}
		if(LCD_Datax_Loc & (uint64_t)(0xFF)<<40)//24-31λҪ
		{
			masktmp = LCD_Datax_Loc<<16>>56;
			LCD_DATA11 = (LCD_DATA11 & ~(masktmp<<16)) | ((LCD_Datax_Data>>40 & masktmp )<<16);//1116-23
		}
	}
	if(LCD_Datax_Sel==7)
	{
		LCD_DATA7=(LCD_DATA7 & ~LCD_Datax_Loc) | (LCD_Datax_Data & LCD_Datax_Loc);//70-31
		if(LCD_Datax_Loc & (uint64_t)(0xFF)<<32)//16-23λҪ
		{
			masktmp= LCD_Datax_Loc<<24>>56;
			LCD_DATA9 = (LCD_DATA9 & ~(masktmp<<24)) | ((LCD_Datax_Data>>32 & masktmp )<<24);//916-23//824-31
		}
		if(LCD_Datax_Loc & (uint64_t)(0xFF)<<40)//24-31λҪ
		{
			masktmp = LCD_Datax_Loc<<16>>56;
			LCD_DATA11 = (LCD_DATA11 & ~(masktmp<<24)) | ((LCD_Datax_Data>>40 & masktmp )<<24);//1124-31
		}
	}
}
/**
  *   LCD SEGͨѡ
  *   SegSel: SEGͨţȡֵΪLCD_SEG_PIN_0~LCD_SEG_PIN_47еһϡ
  *       NewState: SEGͨѡ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
LCD_Seg_Channel_Select_Config (uint64_t SegSel, FunctionalState NewState)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_LCD_SEG_PIN(SegSel));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    tmpreg = (uint32_t)SegSel;
    if (tmpreg != 0)
    {
        /*---------------- LCD_SEL0ĴSEGSELxλ ----------------*/
        if (NewState != FALSE)
        {
            /* ѡӦͨ */
            LCD_SEL0 |= tmpreg;
        }
        else
        {
            /* ѡӦͨ */
            LCD_SEL0 &= ~tmpreg;
        }
    }
    else
    {
        ;
    }

    tmpreg = (uint32_t)(SegSel >> 32);
    if (tmpreg != 0)
    {
        /*---------------- LCD_SEL1ĴSEGSELxλ ----------------*/
        if (NewState != FALSE)
        {
            /* ѡӦͨ */
            LCD_SEL1 |= tmpreg;
        }
        else
        {
            /* ѡӦͨ */
            LCD_SEL1 &= ~tmpreg;
        }
    }
    else
    {
        ;
    }
}

/**
  *   LCD COMͨѡ
  *   ComPin: COMͨţȡֵΪLCD_COM_PIN_0~LCD_COM_PIN_7еһϡ
  *       NewState: COMͨѡ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
LCD_Com_Channel_Select_Config (uint32_t ComPin,FunctionalState NewState)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_LCD_COM_PIN(ComPin));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- LCD_SEL1ĴCOMxSELyλ ----------------*/
    tmpreg = (ComPin<<LCD_SEL_COM0_POS) ;
    if (NewState != FALSE)
    {
        /* ѡӦͨ */
        LCD_SEL1 |= tmpreg;
    }
    else
    {
        /* ѡӦͨ */
        LCD_SEL1 &= ~tmpreg;
    }
}

/**
  *   LCDͨѡ
  *   IOConfig: IOѡȡֵΪ:
  *                   LCD_IO_NONE: ã
  *                   LCD_SEG0_CONFIGURE_PB4
  *                   LCD_SEG0_CONFIGURE_PD13
  *                   LCD_SEG1_CONFIGURE_PB5
  *                   LCD_SEG1_CONFIGURE_PF5
  *                   LCD_SEG2_CONFIGURE_PB6
  *                   LCD_SEG2_CONFIGURE_PC13
  *                   LCD_SEG3_CONFIGURE_PB7
  *                   LCD_SEG3_CONFIGURE_PH15
  *                   LCD_SEG10_CONFIGURE_PC0
  *                   LCD_SEG10_CONFIGURE_PH12
  *                   LCD_SEG11_CONFIGURE_PC1
  *                   LCD_SEG11_CONFIGURE_PH13
  *                   LCD_SEG12_CONFIGURE_PC2
  *                   LCD_SEG12_CONFIGURE_PH11
  *
  *                   LCD_COM0_CONFIGURE_PB0
  *                   LCD_COM0_CONFIGURE_PB14
  *                   LCD_COM1_CONFIGURE_PB1
  *                   LCD_COM1_CONFIGURE_PB15
  *                   LCD_COM2_CONFIGURE_PB2
  *                   LCD_COM2_CONFIGURE_PF0
  *                   LCD_COM4_CONFIGURE_PD13
  *                   LCD_COM4_CONFIGURE_PB4
  *                   LCD_COM5_CONFIGURE_PF5
  *                   LCD_COM5_CONFIGURE_PB5
  *                   LCD_COM6_CONFIGURE_PC13
  *                   LCD_COM6_CONFIGURE_PB6
  *                   LCD_COM7_CONFIGURE_PH15
  *                   LCD_COM7_CONFIGURE_PB7
  *
  *
  *   ޡ
  */
void
LCD_Channel_IO_Config (uint32_t IOConfig)
{
    uint32_t tmpreg = 0;
    uint32_t tmpmask = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_LCD_IO(IOConfig));

    /* IOڣ */
    if (LCD_IO_NONE == IOConfig)
    {
        return;
    }

    /*---------------- LCD_SELxĴ ----------------*/
    tmpreg = IOConfig >> 4;
    if (tmpreg < LCD_PIN_SOURCE_SEG32)
    {
        /* SEG0~SEG31ͨ */
        tmpmask = IOConfig & 0xF;
        tmpmask <<= tmpreg;
        /* SEGSEL0~SEGSEL31 */
        if (0 != tmpmask)
        {
            LCD_SEL0 |= tmpmask;
        }
        else
        {
            LCD_SEL0 &= ~tmpmask;
        }
    }
    else if (tmpreg < LCD_PIN_SOURCE_SEG47)
    {
        /* SEG32~SEG47ͨ */
        tmpreg -= LCD_PIN_SOURCE_SEG32;
        tmpmask = IOConfig & 0xF;
        tmpmask <<= tmpreg;
        /* SEGSEL32~SEGSEL47 */
        if (0 != tmpmask)
        {
            LCD_SEL1 |= tmpmask;
        }
        else
        {
            LCD_SEL1 &= ~tmpmask;
        }
    }
    else
    {
        /* COM0SELy~COM7SELyͨ */
        tmpreg -= LCD_PIN_SOURCE_SEG32;
        tmpmask = IOConfig & 0xF;
        tmpmask <<= tmpreg;
        /* COM0~COM7 */
        if (0 != tmpmask)
        {
            LCD_SEL1 |= tmpmask;
        }
        else
        {
            LCD_SEL1 &= ~tmpmask;
        }
    }
}


/**
  *   ȡLCDǰ״̬
  *   ޡ
  *   1: LCDģ鹤0:LCDģ鲻
  */
FlagStatus
LCD_Get_Work_Status (void)
{
    /*---------------- ȡLCD_CTLĴLCDAλ ----------------*/
    if (LCD_CTL & LCD_CTL_LCDA)
    {
        /* LCDģ鹤 */
        return SET;
    }
    else
    {
        /* LCDģ鲻 */
        return RESET;
    }
}

/**
  *   ȡLCD˸ģʽ״̬
  *   ޡ
  *   1:LCD״̬Ϊ0:LCD״̬Ϊ
  */
FlagStatus
LCD_Get_Flicker_Status (void)
{
    /*---------------- ȡLCD_PTLĴFLKSTUλ ----------------*/
    if (LCD_PTL & LCD_PTL_FLKSTU)
    {
        /* LCD״̬Ϊ */
        return SET;
    }
    else
    {
        /* LCD״̬Ϊ */
        return RESET;
    }
}
/**
  *   ##### Һʾ(LCD)ú #####
  */

/**
  *   ӦDATAĴ
  *   ComPin: COMűţȡֵΪLCD_PIN_SOURCE_COM0~LCD_PIN_SOURCE_COM7еһ
  *   ޡ
  */
void 
LCD_Clear_DATA_Registers(uint32_t ComPin)
{
    /* У */
    CHECK_RESTRICTION(CHECK_LCD_COM_PIN(ComPin));
    /*--------------- 0~31λ ----------------*/
    LCD_SFR->DATA[ComPin] = 0;
    /*--------------- 32~39λ ----------------*/
    if(ComPin < LCD_PIN_SOURCE_COM4)
    {
        LCD_SFR->DATA[8] &= ~((uint32_t)0xff<<(8*ComPin));
    }
    else 
    {
        LCD_SFR->DATA[9] &= ~((uint32_t)0xff<<(8*ComPin));
    }
    /*--------------- 40~47λ ----------------*/
    if(ComPin < LCD_PIN_SOURCE_COM4)
    {
        LCD_SFR->DATA[10] &= ~((uint32_t)0xff<<(8*ComPin));
    }
    else 
    {
        LCD_SFR->DATA[11] &= ~((uint32_t)0xff<<(8*ComPin));
    }
}

/**
  *   DATAĴ
  *   ޡ
  *   ޡ
  */
void 
LCD_Clear_ALLDATA_Registers(void)
{
    uint8_t i;
    for(i=0;i<12;i=0)
    {
        LCD_SFR->DATA[i] = 0;
    }
}

/**
  *   ##### Һʾ(LCD)жϹ #####
  */
/**
  *   ø¼
  *   NewState: ¼״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
LCD_Updata_All_Registers_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- LCD_INTCTLĴUDRλ ----------------*/
    if (NewState != FALSE)
    {
        /* LCD_DATAĴ */
        SFR_SET_BIT_ASM(LCD_INTCTL, LCD_INTCTL_UDR_POS);
    }
    else
    {
        /* ޶ */
        SFR_CLR_BIT_ASM(LCD_INTCTL, LCD_INTCTL_UDR_POS);
    }
}

/**
  *   ֡ʹܡ
  *   NewState: ֡ʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
LCD_Insert_Dead_Time_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- LCD_INTCTLĴLCDDEADλ ----------------*/
    if (NewState != FALSE)
    {
        /* һ֡ʼһ֡ */
        SFR_SET_BIT_ASM(LCD_INTCTL, LCD_INTCTL_LCDDEAD_POS);
    }
    else
    {
        /*  */
        SFR_CLR_BIT_ASM(LCD_INTCTL, LCD_INTCTL_LCDDEAD_POS);
    }
}
/**
  *  LCDIO ӿʹܡ
  *   NewState: LCD  IO ʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
LCD_IO_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- LCD_CTLĴIOENλ ----------------*/
    if (NewState != FALSE)
    {
        /*  LCD  IO  */
        SFR_SET_BIT_ASM(LCD_CTL, LCD_CTL_IOEN_POS);
    }
    else
    {
        /* ֹ LCD  IO  */
        SFR_CLR_BIT_ASM(LCD_CTL, LCD_CTL_IOEN_POS);
    }
}
/**
  *  VLCDPEN ӿʹܡ
  *   NewState: VLCDPEN ӿʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
LCD_VLCDIO_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- LCD_CTLĴVLCDPENλ ----------------*/
    if (NewState != FALSE)
    {
        /*  VLCDIO ӿʹ */
        SFR_SET_BIT_ASM(LCD_CTL, LCD_CTL_VLCDPEN_POS);
    }
    else
    {
        /* ֹ VLCDIO ӿʹ */
        SFR_CLR_BIT_ASM(LCD_CTL, LCD_CTL_VLCDPEN_POS);
    }
}
/**
  *   LCDжʹܡ
  *   InterruptType: LCDж¼ȡֵΪ:
  *                        LCD_INT_FRAME: ֡ж¼
  *                        LCD_INT_FLICKER_OFF: ж¼
  *                        LCD_INT_FLICKER_ON: Ϩж¼
  *                        LCD_INT_UPDATA: ж¼
  *       NewState: ¼жʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
LCD_Set_INT_Enable (uint32_t InterruptType, FunctionalState NewState)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_LCD_INT_EVENT(InterruptType));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- LCD_INTCTLĴӦλ ----------------*/
    tmpreg = InterruptType & 0xF;
    tmpreg = 0x1 << tmpreg;
    if (NewState != FALSE)
    {
        /* ʹж */
        LCD_INTCTL |= tmpreg;
    }
    else
    {
        /* ֹж */
        LCD_INTCTL &= ~tmpreg;
    }
}

/**
  *   LCDжϱ־
  *   InterruptType: LCDж¼ȡֵΪ:
  *                        LCD_INT_FRAME: ֡ж¼
  *                        LCD_INT_FLICKER_OFF: ж¼
  *                        LCD_INT_FLICKER_ON: Ϩж¼
  *                        LCD_INT_UPDATA: ж¼
  *   ޡ
  */
void
LCD_Clear_INT_Flag (uint32_t InterruptType)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_LCD_INT_EVENT(InterruptType));

    /*---------------- LCD_INTCTLĴӦλ ----------------*/
    tmpreg = InterruptType >> 4;
    tmpreg = 0x1 << tmpreg;
    while(LCD_INTCTL & tmpreg)
    {
    	LCD_INTCTL &= ~tmpreg;
    }
}

/**
  *   ȡLCDжϱ־
  *   InterruptType: LCDж¼ȡֵΪ:
  *                        LCD_INT_FRAME: ֡ж¼
  *                        LCD_INT_FLICKER_OFF: ж¼
  *                        LCD_INT_FLICKER_ON: Ϩж¼
  *                        LCD_INT_UPDATA: ж¼
  *   1:Ӧжϱ־0:δӦжϱ־
  */
FlagStatus
LCD_Get_INT_Flag (uint32_t InterruptType)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_LCD_INT_EVENT(InterruptType));

    /*---------------- ȡLCD_INTCTLĴӦλ ----------------*/
    tmpreg = InterruptType >> 4;
    tmpreg = 0x1 << tmpreg;
    if (LCD_INTCTL & tmpreg)
    {
        /* Ӧжϱ־ */
        return SET;
    }
    else
    {
        /* δӦжϱ־ */
        return RESET;
    }
}

/**
  *   ø¼жʹܡ
  *   NewState: ¼жʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
LCD_Updata_INT_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- LCD_INTCTLĴUDDIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹܸ¼ж */
        SFR_SET_BIT_ASM(LCD_INTCTL, LCD_INTCTL_UDDIE_POS);
    }
    else
    {
        /* ֹ¼ж */
        SFR_CLR_BIT_ASM(LCD_INTCTL, LCD_INTCTL_UDDIE_POS);
    }
}

/**
  *   õжʹܡ
  *   NewState: жʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
LCD_Flicker_On_INT_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- LCD_INTCTLĴFCKONIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹܵж */
        SFR_SET_BIT_ASM(LCD_INTCTL, LCD_INTCTL_FCKONIE_POS);
    }
    else
    {
        /* ֹж */
        SFR_CLR_BIT_ASM(LCD_INTCTL, LCD_INTCTL_FCKONIE_POS);
    }
}

/**
  *   Ϩжʹܡ
  *   NewState: Ϩжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
LCD_Flicker_Off_INT_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- LCD_INTCTLĴFCKOFFIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹϨж */
        SFR_SET_BIT_ASM(LCD_INTCTL, LCD_INTCTL_FCKOFFIE_POS);
    }
    else
    {
        /* ֹϨж */
        SFR_CLR_BIT_ASM(LCD_INTCTL, LCD_INTCTL_FCKOFFIE_POS);
    }
}

/**
  *   ֡жʹܡ
  *   NewState: ֡жʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
LCD_Frame_INT_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- LCD_INTCTLĴFRAMIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹ֡ж */
        SFR_SET_BIT_ASM(LCD_INTCTL, LCD_INTCTL_FRAMIE_POS);
    }
    else
    {
        /* ֹ֡ж */
        SFR_CLR_BIT_ASM(LCD_INTCTL, LCD_INTCTL_FRAMIE_POS);
    }
}

/**
  *   ȡ¼жϱ־
  *   ޡ
  *   1:¼0:δ¼
  */
FlagStatus
LCD_Get_Updata_INT_Flag (void)
{
    /*---------------- ȡLCD_INTCTLĴUDDIFλ ----------------*/
    if (LCD_INTCTL & LCD_INTCTL_UDDIF)
    {
        /* ¼ */
        return SET;
    }
    else
    {
        /* δ¼ */
        return RESET;
    }
}

/**
  *   ȡжϱ־
  *   ޡ
  *   1:⵽жϣ0:δ֡жϡ
  */
FlagStatus
LCD_Get_Flicker_On_INT_Flag (void)
{
    /*---------------- ȡLCD_INTCTLĴFCKONIFλ ----------------*/
    if (LCD_INTCTL & LCD_INTCTL_FCKONIF)
    {
        /* ⵽ж */
        return SET;
    }
    else
    {
        /* δ֡ж */
        return RESET;
    }
}

/**
  *   ȡϨжϱ־
  *   ޡ
  *   1:⵽Ϩжϣ0:δϨ֡жϡ
  */
FlagStatus
LCD_Get_Flicker_Off_INT_Flag (void)
{
    /*---------------- ȡLCD_INTCTLĴFCKOFFIFλ ----------------*/
    if (LCD_INTCTL & LCD_INTCTL_FCKOFFIF)
    {
        /* ⵽Ϩж */
        return SET;
    }
    else
    {
        /* δϨ֡ж */
        return RESET;
    }
}

/**
  *   ȡ֡жϱ־
  *   ޡ
  *   1:⵽֡жϣ0:δ⵽֡жϡ
  */
FlagStatus
LCD_Get_Frame_INT_Flag (void)
{
    /*---------------- ȡLCD_INTCTLĴFRAMIFλ ----------------*/
    if (LCD_INTCTL & LCD_INTCTL_FRAMIF)
    {
        /* ⵽֡ж */
        return SET;
    }
    else
    {
        /* δ⵽֡ж */
        return RESET;
    }
}

/**
  *   LCD¼жϱ־
  *   ޡ
  *   ޡ
  */
void
LCD_Clear_Updata_INT_Flag (void)
{
    /*-------------------- LCD_INTCTLĴUDDIFλ --------------------*/
	while((LCD_INTCTL & LCD_INTCTL_UDDIF)>>LCD_INTCTL_UDDIF_POS)
	{
		SFR_CLR_BIT_ASM(LCD_INTCTL, LCD_INTCTL_UDDIF_POS);
	}
}

/**
  *   LCDжϱ־
  *   ޡ
  *   ޡ
  */
void
LCD_Clear_Flicker_On_INT_Flag (void)
{
    /*-------------------- LCD_INTCTLĴFCKONIFλ --------------------*/
	while((LCD_INTCTL & LCD_INTCTL_FCKONIF)>>LCD_INTCTL_FCKONIF_POS)
	{
		SFR_CLR_BIT_ASM(LCD_INTCTL, LCD_INTCTL_FCKONIF_POS);
	}
}

/**
  *   LCDϨжϱ־
  *   ޡ
  *   ޡ
  */
void
LCD_Clear_Flicker_Off_INT_Flag (void)
{
    /*-------------------- LCD_INTCTLĴFCKOFFIFλ --------------------*/
	while((LCD_INTCTL & LCD_INTCTL_FCKOFFIF)>>LCD_INTCTL_FCKOFFIF_POS)
	{
		SFR_CLR_BIT_ASM(LCD_INTCTL, LCD_INTCTL_FCKOFFIF_POS);
	}
}

/**
  *   LCD֡жϱ־
  *   ޡ
  *   ޡ
  */
void
LCD_Clear_Frame_INT_Flag (void)
{
    /*-------------------- LCD_INTCTLĴFRAMIFλ --------------------*/
	while((LCD_INTCTL & LCD_INTCTL_FRAMIF)>>LCD_INTCTL_FRAMIF_POS)
	{
		SFR_CLR_BIT_ASM(LCD_INTCTL, LCD_INTCTL_FRAMIF_POS);
	}
}

#endif  //KF32LS_Periph_lcd
/**
  *   ##### Һʾ(LCD)жϹ #####
  */
