/****************************************************************************************
  *
  * ļ  main.c
  *     ChipON_AE/FAE_Group
  *     2019-11-16
  *     ļṩGPIOӦ̲ο
  *
 ****************************************************************************************/
#include "system_init.h"

#define Demo_LEDON()         GPIO_Set_Output_Data_Bits(GPIOF_SFR,GPIO_PIN_MASK_0,Bit_SET)  //Ϊߵƽ
#define Demo_LEDOff()        GPIO_Set_Output_Data_Bits(GPIOF_SFR,GPIO_PIN_MASK_0,Bit_RESET)//Ϊ͵ƽ
#define Demo_LED_ON_OFF()    GPIO_Toggle_Output_Data_Config (GPIOF_SFR, GPIO_PIN_MASK_0)   //LEDƽȡ

/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
		GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);

	GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_SET);	 //Ϊߵƽ

}




//
void main()
{
	/*ûɲοKF32L530_demoʵGPIOùܡ
	 * ʹGPIO  PF0ΪSTATUS,PF0Ϊ
	 * STATUSƼ500ms ˸
	 */

	//ϵͳʱ120M,Ƶʱ16M
	SystemInit();//ϵͳʱӳʼ
	systick_delay_init();
	GPIO_Reset(GPIOF_SFR);//λGPIOFʹGPIOFʱ
	GPIOInit_Output_Config(GPIOF_SFR,GPIO_PIN_MASK_0);  //PF0ʼߵƽ

	while(1)
	{
		Demo_LEDON(); //STATUSƵ
		systick_delay_ms(250);
		Demo_LEDOff();//STATUSϨ
		systick_delay_ms(250);
	}
}


/**
  *    У鷢ļ
  *    file: ָļƵָ
  *      line У
  *   ޡ
  */
void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}
