/****************************************************************************************
 * ļ: I2C_Master.c
 * Ŀ: I2C_Master_Mode
 *  :  V3.0.0
 *  :  2021-08-23
 *     ChipON_AE/FAE_Group
 *     ļṩI2CͨŹòο̡
 *
 ****************************************************************************************/

#include "system_init.h"
#include "I2C_Master.h"

I2C_SFRmap* I2C_Choose;    //ָI2Cڴṹָ룬ȡֵΪI2C0_SFR~I2C3_SFR
#define I2C_Choose I2C1_SFR //ѡI2C0_SFR I2C1_SFR

#define TIMOUTCUNT 100

#define FUN_WAIT_FLAG(fun,timecunt) { \
		uint32_t time=0;  			\
		while(fun)  				\
		{							\
			if(time++>timecunt)		\
			{						\
				break;				\
			}						\
		}							\
		}

/**
  *    I2C GPIOӳʼ
  *    
  *    
*/
void I2C_GPIO_init(void)
{
	/*I2Cx*/
	/**/
	GPIO_InitTypeDef I2C_GPIO_Init;

	I2C_GPIO_Init.m_Mode = GPIO_MODE_RMP;                           //GPIOӳ书
	I2C_GPIO_Init.m_OpenDrain = GPIO_POD_OD;                        //GPIO©
	I2C_GPIO_Init.m_Speed = GPIO_HIGH_SPEED;						//IOΪ
	I2C_GPIO_Init.m_Pin = GPIO_PIN_MASK_1|GPIO_PIN_MASK_2;          //Px1 Px2
	I2C_GPIO_Init.m_PullUp = GPIO_NOPULL;                           //GPIO
	I2C_GPIO_Init.m_PullDown = GPIO_NOPULL;                         //ʹGPIO
	GPIO_Pin_RMP_Config(GPIOB_SFR,GPIO_Pin_Num_1,GPIO_RMP_AF8_I2C1); //PB1ΪI2C1 SCL
	GPIO_Pin_RMP_Config(GPIOB_SFR,GPIO_Pin_Num_2,GPIO_RMP_AF8_I2C1); //PB2ΪI2C1 SDA
	GPIO_Configuration(GPIOB_SFR,&I2C_GPIO_Init);

}


/**
  *    I2Cx ʼ
  *    I2CxȡֵΧI2C0_SFR~I2C1_SFR   ѡõI2C
  *
  *    
*/
void I2C_init_Master(I2C_SFRmap* I2Cx)
{
	/*I2CxӦò*/
	I2C_Reset(I2Cx);                                      //I2CλʹI2Cʱ
	I2C_InitTypeDef newStruct_I2C;                        //
	newStruct_I2C.m_Mode = I2C_MODE_I2C;                  //ΪI2Cģʽ
	newStruct_I2C.m_ClockSource = I2C_CLK_SCLK;           //ʱԴѡSCLK 120M

	newStruct_I2C.m_BADR10 = I2C_BUFRADDRESS_7BIT;        //7λӻַ

	newStruct_I2C.m_MasterSlave = I2C_MODE_SMBUSHOST;     // SMBusѡģʽ
    //ʱԴΪ120MһμʱΪ1/120=0.0083 us ʵĸߵ͵ƽʱ趨ֵ X0.0083us趨ֵҪֵ С
#ifdef IIC_100K
	newStruct_I2C.m_BaudRateL = 400;                       //I2Cʵ͵ƽʱ   ֵ С3
	newStruct_I2C.m_BaudRateH = 400;                       //I2Cʸߵƽʱ   ֵ С3
#elif defined IIC_400K
	newStruct_I2C.m_BaudRateL = 115;                       //I2Cʵ͵ƽʱ   ֵ С3
	newStruct_I2C.m_BaudRateH = 115;                       //I2Cʸߵƽʱ   ֵ С3
#elif defined IIC_1M
	newStruct_I2C.m_BaudRateL = 20;                       //I2Cʵ͵ƽʱ   ֵ С3
	newStruct_I2C.m_BaudRateH = 20;                       //I2Cʸߵƽʱ   ֵ С3
#endif
	newStruct_I2C.m_AckEn = TRUE;                         //ʹӦ
	newStruct_I2C.m_AckData = I2C_ACKDATA_ACK;            //ѡӦźΪACK
	I2C_Configuration(I2Cx, &newStruct_I2C);

	I2C_Cmd(I2Cx,TRUE);                    //ʹI2Cģ
}



/**
  *    I2C дֽ
  *    Write_i2c_AddrҪдָI2Cַ
  *          p_buffer: дݵַָ
  *          number_of_byteдݸ
  *    
*/
void I2C_Buffer_write(uint16_t Write_i2c_Addr,uint8_t *p_buffer,uint16_t number_of_byte)
{
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);   //I2Cжϱ־λISIFλ
	I2C_Cmd(I2C_Choose,TRUE);               //ʹI2Cģ
	/*ʼλ*/
	I2C_Generate_START(I2C_Choose,TRUE);    //ʹʼź

	FUN_WAIT_FLAG(!I2C_Get_INTERRUPT_Flag(I2C_Choose),TIMOUTCUNT);//ȴʼźȶ

	/*7λӻַ*/
	I2C_SendData8(I2C_Choose,Write_i2c_Addr); //ʹӻַ  I2C_SLAVE_ADDRESS10BH_W
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);        //I2Cжϱ־λISIFλ

	FUN_WAIT_FLAG(!I2C_Get_INTERRUPT_Flag(I2C_Choose),TIMOUTCUNT);//ȴ

	FUN_WAIT_FLAG(I2C_Get_Ack_Fail_Flag(I2C_Choose),TIMOUTCUNT);//жǷACKӦûֹͣ
    /*ѭд */
    while(number_of_byte--){
    	I2C_SendData8(I2C_Choose, *p_buffer);    //
    	I2C_Clear_INTERRUPT_Flag(I2C_Choose);     	//I2Cжϱ־λISIFλ
        /* ָһҪдֽ*/
        p_buffer++;

        FUN_WAIT_FLAG(!I2C_Get_INTERRUPT_Flag(I2C_Choose),TIMOUTCUNT);//ȴȡBuffISIF1

    }

	/*ֹͣλ*/
	I2C_Generate_STOP(I2C_Choose,TRUE);         //ʹֹͣź

	I2C_Clear_INTERRUPT_Flag(I2C_Choose);       //I2Cжϱ־λISIFλ

	FUN_WAIT_FLAG(!I2C_Get_INTERRUPT_Flag(I2C_Choose),TIMOUTCUNT);//ȴֹͣ

	I2C_Clear_INTERRUPT_Flag(I2C_Choose);       //I2Cжϱ־λISIFλ
	I2C_Clear_Stop_Flag(I2C_Choose);            //I2Cֹͣ־λPIFλ
	I2C_Cmd(I2C_Choose,FALSE);                  //رI2Cģ

}


/**
  *    I2C ֽ
  *    Read_I2C_AddrָҪI2Cַ
  *          p_buffer: ݵַָ
  *          number_of_byteȡݸ
  *    
  *
*/
void I2C_Buffer_read(uint16_t Read_I2C_Addr,uint8_t *p_buffer,uint16_t number_of_byte)
{
	static uint8_t I2C_SLAVE_ADDRESS10BH=0;
	static uint8_t I2C_SLAVE_ADDRESS10BL=0;

	I2C_Cmd(I2C_Choose,TRUE);//I2C
	/*ʼλ*/
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);  //־λISIFλ
	I2C_Generate_START(I2C_Choose,TRUE);   //ʼź

	FUN_WAIT_FLAG(!I2C_Get_INTERRUPT_Flag(I2C_Choose),TIMOUTCUNT);//ȴʼλȶ

	/*Ͷָ*/
	I2C_SendData8(I2C_Choose,Read_I2C_Addr|0x01);//ʹӻַ
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);           //־λISIFλ

	FUN_WAIT_FLAG(I2C_Get_Ack_Fail_Flag(I2C_Choose),TIMOUTCUNT);

	FUN_WAIT_FLAG(!I2C_Get_INTERRUPT_Flag(I2C_Choose),TIMOUTCUNT);//ȴISIF1
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);           //Ȼ־λISIFλ

	while(number_of_byte)
	{
		FUN_WAIT_FLAG(!I2C_Get_Receive_Buff_Flag(I2C_Choose),TIMOUTCUNT);
		*p_buffer = I2C_ReceiveData(I2C_Choose);

		FUN_WAIT_FLAG(!I2C_Get_INTERRUPT_Flag(I2C_Choose),TIMOUTCUNT);//ȴȡBuffISIF1

		if(number_of_byte==2)
		{
			I2C_Ack_DATA_Config(I2C_Choose,I2C_ACKDATA_NO_ACK);//һظNACK
		}
		I2C_Clear_INTERRUPT_Flag(I2C_Choose);        //Ȼ־λISIFλ
		p_buffer++;      							//ָһȡֽڽλ

        number_of_byte--;							//ݼȡֽڼ
	}

	/*ֹͣλ*/
	I2C_Generate_STOP(I2C_Choose,TRUE);         //ʹֹͣź
	I2C_Ack_DATA_Config(I2C_Choose,I2C_ACKDATA_ACK);//һδظACK
	I2C_Clear_INTERRUPT_Flag(I2C_Choose);       //I2Cжϱ־λISIFλ

	FUN_WAIT_FLAG(!I2C_Get_INTERRUPT_Flag(I2C_Choose),TIMOUTCUNT);//ȴֹͣ

	I2C_Clear_INTERRUPT_Flag(I2C_Choose);       //I2Cжϱ־λISIFλ
	I2C_Clear_Stop_Flag(I2C_Choose);            //I2Cֹͣ־λPIFλ
	I2C_Cmd(I2C_Choose,FALSE);                  //رI2Cģ

}


