/****************************************************************************************
 * ļ: main.c
 * Ŀ: I2C_Master_Mode
 *  :  V3.0.0
 *  :  2021-08-23
 *     ChipON_AE/FAE_Group
 *     ļṩI2CͨŹòο̡
 *
 ****************************************************************************************/
#include "system_init.h"
#include "I2C_Master.h"
#include "Usart.h"


#define BUFFER_SIZE_Read     10   //ݸ
uint8_t i2c_buffer_read[BUFFER_SIZE_Read]={0};//ȡI2Cݺ洢

#define I2C_SLAVE_ADDR     0xA0  //ҪдI2Cӻ7λַ

#define BUFFER_SIZE_Write        10   //д10
uint8_t i2c_buffer_write[BUFFER_SIZE_Write] = {
	0X01,0X02,0X03,0X04,0X05,0X06,0X07,0X08,0X09,0X0A
	};

uint8_t i2c_Read_buffer[BUFFER_SIZE_Read];


/*ʱ ֲvolatileܻᱻŻ*/
void delay_ms(volatile uint32_t nms)
{
	volatile uint32_t i,j;
	for(i=0;i<nms;i++)
	{
		j=2000;
		while(j--);
	}

}


/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
	GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);

	GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_SET);	  //Ϊߵƽ

}


void GPIOInit_Input_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
		GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_IN;            //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);

}

/**
  *   ԱI2CǷƥ
  *    :
  *    ƥ==SET ,ƥ==RESET
  */
uint8_t I2C_Data_test(void)
{

	volatile uint16_t i;
    for(i = 0;i < BUFFER_SIZE_Read;i++)
    {
        if(i2c_Read_buffer[i] != i2c_buffer_write[i])
        {
           return RESET;
        }
    }
    memset(i2c_Read_buffer,0,BUFFER_SIZE_Read);
    return SET;
}

/*ûɲοʵʹI2Cӹܡ
* ʹI2C1 PB1 PB2 ӻI2CͨšI2C_Master_Slave.h  궨 IIC_MODE ѡģʽӻģʽ
* ܼ:	1.I2C Masterܣÿ200msӻȷ10ֽݣٶȡ10ֽȷӦʱLED0˸LED0Ƴ
*
* Ӳ˵ ʹdemoԽӣPB1PB1ԽӣPB2PB2Խӣ
*           PB13ӦD4
*           Ҫô,Usart.h ں궨Usart_Print  1
*  ע  110λַʱҪעӻַĸλǵڶλ͵λЧ
*
*/
void main()
{

	/*ϵͳʱӳʼ,ϵͳʱ120M,Ƶʱ16M*/
	SystemInit();

	/*ʼPF0Ϊߵƽ*/
	GPIOInit_Output_Config(GPIOF_SFR,GPIO_PIN_MASK_0);

	I2C_GPIO_init(); //I2C GPIOӳSCL:PB1   SDA:PB2
	I2C_init_Master(I2C1_SFR);  //I2C1ʼ

#if Usart_Print
	//USART2ӳ䣬	//USART2_RX	PB15  //USART2_TX0 PB14
	GPIO_USART();
	USART_Async_config(USART2_SFR);//ȫ˫첽8bit 115200
#endif
	while(1)
    {
		delay_ms(200);

		I2C_Buffer_write(I2C_SLAVE_ADDR,i2c_buffer_write,BUFFER_SIZE_Write);//I2C_SLAVE_ADDRд10
		I2C_Buffer_read(I2C_SLAVE_ADDR,i2c_Read_buffer,BUFFER_SIZE_Read);	//ȡI2C_SLAVE_ADDR10ֽ
#if Usart_Print
			//ڴӡյ
			USART_Send(USART2_SFR,i2c_Read_buffer,sizeof(i2c_Read_buffer));
#endif
		if(I2C_OK == I2C_Data_test())										//ȡǷȷ
		{
			GPIO_Toggle_Output_Data_Config(GPIOF_SFR,GPIO_PIN_MASK_0);		//PB13ת
		}

    }

}


/**
  *    У鷢ļ
  *    file: ָļƵָ
  *      line У
  *   ޡ
  */
void check_failed(uint8_t* file, uint32_t line)
{
	/* ûԼĴʵֱļк,
	 : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
	while(1)
	{
	  ;
	}
}

