/****************************************************************************************
 * ļ: main.c
 * Ŀ: I2C_Slave_Mode
 *  :  V3.0.0
 *  :  2021-08-23
 *     ChipON_AE/FAE_Group
 *     ļṩI2CӻͨŹòο̡
 *
 ****************************************************************************************/
#include "system_init.h"
#include "I2C_Slave.h"
#include "Usart.h"


#define BUFFER_SIZE_Read     10   			  //ݸ
uint8_t i2c_buffer_read[BUFFER_SIZE_Read]={0};//ȡI2Cݺ洢

volatile uint8_t I2C_RecNum = 0;                 //յڼݵı

/*ӻģʽںͶI2CַݵԱ,*/
uint8_t i2c_buffer_read_test[BUFFER_SIZE_Read] = {
	0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xA
};

extern volatile uint8_t i2c_stop_flg;  //i2c stop ־˵һ֡ݷ꣩


/*ʱ ֲvolatileܻᱻŻ*/
void delay_ms(volatile uint32_t nms)
{
	volatile uint32_t i,j;
	for(i=0;i<nms;i++)
	{
		j=2000;
		while(j--);
	}

}


/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
	GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);

	GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_SET);	  //Ϊߵƽ
}


/**
  *    I2Cݽյ
  *    Rev_Temp:  8λ
  *    
  */
void I2C_receive_input(uint8_t Rev_Temp)
{
	if(I2C_RecNum < sizeof(i2c_buffer_read))
    {
		i2c_buffer_read[I2C_RecNum] = Rev_Temp;
		I2C_RecNum++;
    }
}


/**
  *   ԱI2CǷƥ
  *    Rev_Temp:  8λ
  *    
  */
uint8_t I2C_Data_test(void)
{

	volatile uint16_t i;
    for(i = 0;i < BUFFER_SIZE_Read;i++)
    {
        if(i2c_buffer_read[i] != i2c_buffer_read_test[i])
        {
           return RESET;
        }
    }
    memset(i2c_buffer_read,0,BUFFER_SIZE_Read);
    return SET;
}


/*
* ûɲοʵʹI2Cӹܡ
* ʹI2C1 PB1 PB2 ڴӻI2Cͨš
* ܼ:	1.I2C Slaveܣ͹10ݶݶԱƥPB8תled0˸
* 			2.I2C SlaveܣԶȡ
* Ӳ˵ ʹdemoԽӣPB1PB1ԽӣPB2PB2Խӣ
*           PF0ӦƵ
*           ҪôڽUSART2_RX PB15 	USART2_TX0	PB14 Usart.h ں궨Usart_Print  1
*
*/
void main()
{
	/*ϵͳʱӳʼ,ϵͳʱ120M,Ƶʱ16M*/
	SystemInit();

	/*ʼPF0Ϊߵƽ*/
	GPIOInit_Output_Config(GPIOF_SFR,GPIO_PIN_MASK_0);

	I2C_GPIO_init(); //I2C GPIOӳSCL:PB1   SDA:PB2
	I2C_init_Slave(I2C1_SFR,I2C_SLAVE_ADDRESS);	  //I2C1 ӻ7λַ0XA0

#if Usart_Print
	//USART2ӳ䣬	//USART2_RX	PB15  //USART2_TX0 PB14
	GPIO_USART();
	USART_Async_config(USART2_SFR);//ȫ˫첽8bit 115200
#endif
	while(1)
    {
		if(i2c_stop_flg)
		{
			i2c_stop_flg = 0; //stop־
#if Usart_Print
			//ڴӡյ
			USART_Send(USART2_SFR,i2c_buffer_read,sizeof(i2c_buffer_read));
#endif
			if(I2C_OK == I2C_Data_test())//ж϶I2CԤǷƥ䡣
			{
				GPIO_Toggle_Output_Data_Config(GPIOF_SFR,GPIO_PIN_MASK_0);//ƥPB8ת
			}
		}

    }

}


/**
  *    У鷢ļ
  *    file: ָļƵָ
  *      line У
  *   ޡ
  */
void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
	  while(1)
	  {
		  ;
	  }
}

