/**
  ******************************************************************************
  * ļ  main.c
  *     ChipON_AE/FAE_Group
  *     V2.1
  *     2019-11-16
  *     RTCļ
  *
  *********************************************************************
  */
#include "system_init.h"
#include "RTC_user.h"
#include "USART_user.h"
/**
  *     RTCʱ
  *    
  *    
  */
void Set_rtc_time()
{
	RTC_InitTypeDef RTC_INIT;//RTCʼϢṹ

	RTC_Reset();	//ʹܱдλRTCģ

	/********************ʼʼ*************/
	/* RTCʱԴ */
	RTC_INIT.m_ClockSource = BKP_RTC_INTLF;//ⲿƵ32.768KHz,ڲƵ32KHz
	/* RTCʱʽ */
	RTC_INIT.m_HourFormat = RTC_HOUR_FORMAT_24;//24Сʱ
	/* ʱ */
	RTC_INIT.m_TimeStruct.m_Hours = 23;
	/* ÷ */
	RTC_INIT.m_TimeStruct.m_Minutes = 59;
	/*  */
	RTC_INIT.m_TimeStruct.m_Seconds = 30;
	/* AMPM */
	//	RTC_INIT.m_TimeStruct.m_AMPM = RTC_TIME_AM; //24СʱƲҪ硢
	/*  */
	RTC_INIT.m_DateStruct.m_WeekDay = RTC_WEEKDAY_WEDNESDAY_DEC;
	/*  */
	RTC_INIT.m_DateStruct.m_Year = 19;
	/*  */
	RTC_INIT.m_DateStruct.m_Month = RTC_MONTH_OCTOBER_DEC;
	/*  */
	RTC_INIT.m_DateStruct.m_Day = 30;
	RTC_Configuration(RTC_TIME_FORMAT_BIN,&RTC_INIT);//BCDʽʱдĴ
	/********************ʼý*************/
}

/**
  *     ȡʱϢ,ͨuart2ӡ
  *    
  *    
  */
void Print_time_to_uart()
{
	char USART_Array_Tansmit[20]={'2','0'};
	char * p;
	RTC_InitTypeDef buf;
	/*	ȡʱ	*/
	RTC_Get_Time_Configuration(RTC_TIME_FORMAT_BCD, &buf.m_TimeStruct);
	RTC_Get_Date_Configuration(RTC_TIME_FORMAT_BCD, &buf.m_DateStruct);
	/*	ʱתַд뷢ͻ	*/
	USART_Array_Tansmit[2] = (buf.m_DateStruct.m_Year>>4) + '0';  //
	USART_Array_Tansmit[3] = (buf.m_DateStruct.m_Year&0x0F) + '0';
	USART_Array_Tansmit[4] = '-';
	USART_Array_Tansmit[5] = (buf.m_DateStruct.m_Month>>4) + '0';  //
	USART_Array_Tansmit[6] = (buf.m_DateStruct.m_Month&0x0F) + '0';
	USART_Array_Tansmit[7] = '-';
	USART_Array_Tansmit[8] = (buf.m_DateStruct.m_Day>>4) + '0';  //
	USART_Array_Tansmit[9] = (buf.m_DateStruct.m_Day&0x0F) + '0';
	USART_Array_Tansmit[10] = ' ';
	USART_Array_Tansmit[11] = (buf.m_TimeStruct.m_Hours>>4) + '0'; //ʱ
	USART_Array_Tansmit[12] = (buf.m_TimeStruct.m_Hours&0x0F) + '0';
	USART_Array_Tansmit[13] = ':';
	USART_Array_Tansmit[14] = (buf.m_TimeStruct.m_Minutes>>4) + '0'; //
	USART_Array_Tansmit[15] = (buf.m_TimeStruct.m_Minutes&0x0F) + '0';
	USART_Array_Tansmit[16] = ':';
	USART_Array_Tansmit[17] = (buf.m_TimeStruct.m_Seconds>>4) + '0'; //
	USART_Array_Tansmit[18] = (buf.m_TimeStruct.m_Seconds&0x0F) + '0';
	USART_Array_Tansmit[19] = ' ';

	USART_Send(USART2_SFR, USART_Array_Tansmit, sizeof(USART_Array_Tansmit)); //ʱ

	switch(buf.m_DateStruct.m_WeekDay)
	{
		case 1:
			p = "Mon";
		break;
		case 2:
			p = "Tue";
		break;
		case 3:
			p = "Wed";
		break;
		case 4:
			p = "Thu";
		break;
		case 5:
			p = "Fri";
		break;
		case 6:
			p = "Sat";
		break;
		case 7:
			p = "Sun";
		break;
		default:
			p = "error";
		break;
	}
	USART_Send(USART2_SFR, p, 3); //

	p ="\n";
	USART_Send(USART2_SFR, p, 1); //Ϣ󣬻
}

/***************************************************************************
 *RTC
 **************************************************************************/
void Set_rtc_Alarm()
{
	RTC_AlarmTypeDef RTC_AlarmA;
	RTC_Config_Mode_Enable (TRUE);//ģʽ

	RTC_AlarmA.m_WeekDay=RTC_WEEKDAY_MONDAY_DEC;
	RTC_AlarmA.m_Hours=17;
	RTC_AlarmA.m_Minutes=48;
	RTC_AlarmA.m_Seconds=10;
	RTC_AlarmA.m_AMPM=RTC_TIME_AM;
	RTC_AlarmA.m_WeekDayEnable=FALSE;
	RTC_AlarmA.m_HoursEnable=TRUE;
	RTC_AlarmA.m_MinutesEnable=TRUE;
	RTC_AlarmA.m_SecondsEnable=TRUE;
	RTC_Alarm_Configuration (RTC_ALARM_A_ADDR_OFFSET,RTC_TIME_FORMAT_BIN,&RTC_AlarmA);
	RTC_Alarm_A_Enable(TRUE);//Aʹ
	RTC_Alarm_A_INT_Enable (TRUE);//RTCAжʹܡ

	RTC_Config_Mode_Enable (FALSE);//˳ģʽ,ִи
}

/***************************************************************************
 *RTCжϣ
 *ע RTCжԴֱӴںжϡRTCжϱⲿжEint17-19ΪźŴܴͨں˵жϡ
 *		ԣʹRTCжϱҪͬʱEint17-19жϡ
 **************************************************************************/
void Set_rtc_int()
{
	RTC_Config_Mode_Enable (TRUE);//RTCģʽ
	//********ⲿж(EINT)Ϣṹ,ⲿint17-19ж
	EINT_InitTypeDef EINT_17to19;

	//********ⲿж(EINT)Ϣṹ
	EINT_17to19.m_Mask=TRUE; //Ӧⲿжʹ
	EINT_17to19.m_Rise=TRUE; //ش
	EINT_17to19.m_Line=INT_EXTERNAL_INTERRUPT_17; //ⲿжѡһֻдһжԴ
	EINT_17to19.m_Fall=FALSE;  //½ز
	INT_External_Configuration (&EINT_17to19);  //джԴϢʹܻʧ

	RTC_Clock_Calibration_Config((int8_t)0x0);//RTCʱУֵʹУ׼ܣд0ֵ
	RTC_Time_Tick_Config(RTC_TIME_TICK_DIV_1);//ʱ1
	RTC_Time_Tick_INT_Enable (TRUE);//RTCʱжʹܡ

	RTC_Seconds_INT_Enable(TRUE);//RTCжʹ
	RTC_Enable(TRUE);//RTCʹ

	RTC_Config_Mode_Enable (FALSE);//ģʽ

	INT_Interrupt_Enable(INT_EINT19TO17,TRUE);//EIERTSж
	INT_All_Enable (TRUE);//ϵͳж
}


