/****************************************************************************************
 *
 * ļ: main.c
 * Ŀ: LowPower_Time0
 *  :  V2.1
 *  :  20191116
 *  :  ChipON_AE/FAE_Group
 *
 ****************************************************************************************/
#include "system_init.h"



/**
  *  ͹ĶʱT0ʱʱá
  *   Periodµֵȡֵ16λ
  *     PrescalerINTLFԤƵֵ
  *   ޡ
  */
void LPTIMER_T0_Config(uint32_t Period,uint32_t Prescaler)
{

	OSC_SCK_Source_Config(SCLK_SOURCE_INTHF);                 //ѡINTHFΪϵͳʱ

	OSC_Backup_Write_Read_Enable(TRUE);                       //ʹܱд

	PM_CCP0CLKLPEN_Enable(TRUE);                              //CCP0͹ʱʹ

	TIM_Reset(T0_SFR);										  //ʱ踴λʹʱ
	GPTIM_Updata_Immediately_Config(T0_SFR,TRUE);			  //¿
	GPTIM_Updata_Enable(T0_SFR,TRUE);						  //øʹ
	GPTIM_Work_Mode_Config(T0_SFR,GPTIM_TIMER_MODE);		  //ʱģʽѡ
	GPTIM_Set_Counter(T0_SFR,0);							  //ʱֵ
	GPTIM_Set_Period(T0_SFR,Period);						  //ʱֵ
	GPTIM_Set_Prescaler(T0_SFR,Prescaler);				      //ʱԤƵֵ
	GPTIM_Counter_Mode_Config(T0_SFR,GPTIM_COUNT_UP_DOWN_OUF);//-¼,жϱ־
	GPTIM_Clock_Config(T0_SFR,GPTIM_LFCLK);					  //ѡLFCLKʱ

	INT_Interrupt_Priority_Config(INT_T0,4,0);				  //ռȼ4,ȼ0
	GPTIM_Overflow_INT_Enable(T0_SFR,TRUE);					  //жʹ
	INT_Interrupt_Enable(INT_T0,TRUE);						  //жʹ
	INT_Clear_Interrupt_Flag(INT_T0);						  //жϱ־
	GPTIM_Cmd(T0_SFR,TRUE);									  //ʱʹ
	INT_Stack_Align_Config(INT_STACK_SINGLE_ALIGN);			  //жԶջʹõֶ
	INT_All_Enable (TRUE);									  //ȫֿжʹ,жʹܿƲλ/NMI/Ӳж

	OSC_Backup_Write_Read_Enable(FALSE);                      //ֹд

	OSC_SCK_Source_Config(SCLK_SOURCE_PLL);                   //ѡPLLΪϵͳʱ
	while(OSC_Get_INTHF_INT_Flag() != SET);                   //PLLʱȶ

}





/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
		/*ʼλGPIOx裬ʹGPIOxʱ*/
			GPIO_Reset(GPIOx);

		/*  PxyΪģʽ */
		GPIO_InitTypeDef GPIO_InitStructure;
		GPIO_Struct_Init(&GPIO_InitStructure);
		GPIO_InitStructure.m_Pin = GpioPin;
		GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
		GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
		GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
		GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
		GPIO_Configuration(GPIOx,&GPIO_InitStructure);

		GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_SET);					//Ϊߵƽ
}



//
void main()
{
	/*ûɲοKF32L530_demoʵʹõ͹ĶʱT0ʱܡ
	 * жʱT0ʱԴΪڲƵ32KHZ 164Ƶ500Σ1һжϣPF0жϺзתSTATUS˸
	 *
	 *ע⣺ʹܵ͹ĶʱT0֮ǰҪʹܱĶдлڵƵʱлɸƵʱ
     */
	//ϵͳʱ120M,Ƶʱ16M
	SystemInit();   //ʱӳʼ

	//PF0ΪΪߵƽ
	GPIOInit_Output_Config(GPIOF_SFR,GPIO_PIN_MASK_0);

	//͹Ķʱֵ ԤƵ
    LPTIMER_T0_Config(500,63); //ʱԴ32KHZ, ԤƵֵ1:64   500HZ500Σ1һж
    while(1)
    {
    }

}



/**
  *    У鷢ļ
  *    file: ָļƵָ
  *      line У
  *   ޡ
  */
void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}

