/*-----------------------------------------------------------------------*/
/* Low level disk I/O module skeleton for FatFs     (C)ChaN, 2014        */
/*-----------------------------------------------------------------------*/
/* If a working storage control module is available, it should be        */
/* attached to the FatFs via a glue function rather than modifying it.   */
/* This is an example of glue functions to attach various exsisting      */
/* storage control modules to the FatFs module with a defined API.       */
/*-----------------------------------------------------------------------*/
#include "diskio.h"			/* FatFs lower layer API */
#include "malloc.h"	
#include "usb.h"
#include "flash.h"

#define IN_FLASH	 0  //




//ô״̬
DSTATUS disk_status (
	BYTE pdrv		/* Physical drive nmuber to identify the drive */
)
{ 
	return RES_OK;
}  
//ʼ
DSTATUS disk_initialize (
	BYTE pdrv				/* Physical drive nmuber to identify the drive */
)
{
	 return 0; //ʼɹ
} 
//
//pdrv:̱0~9
//*buff:ݽջ׵ַ
//sector:ַ
//count:Ҫȡ
DRESULT disk_read (
	BYTE pdrv,		/* Physical drive nmuber to identify the drive */
	BYTE *buff,		/* Data buffer to store read data */
	DWORD sector,	/* Sector address in LBA */
	UINT count		/* Number of sectors to read */
)
{
	WORD j,i;
	BYTE *read_adr;
	read_adr=(BYTE *)(U_DISK_FLASH_BASE+sector*FLASH_SECTOR_SIZE);
	for(j=0;j<count;j++)
	{
		for(i=0;i<FLASH_SECTOR_SIZE;i++)
		{
			*(buff++)=*(read_adr++);
		}
	}
   return RES_OK;
}
//д
//pdrv:̱0~9
//*buff:׵ַ
//sector:ַ
//count:Ҫд
#if _USE_WRITE
DRESULT disk_write (
	BYTE pdrv,			/* Physical drive nmuber to identify the drive */
	const BYTE *buff,	/* Data to be written */
	DWORD sector,		/* Sector address in LBA */
	UINT count			/* Number of sectors to write */
)
{
	WORD i=0;
	for(i=0;i<count;i++)
	{
		FLASH_PageWrite_fun(U_DISK_FLASH_BASE+(sector+i)*FLASH_SECTOR_SIZE,(uint32_t *)buff,128);
	}

    return RES_OK;
}
#endif
//Ļ
//pdrv:̱0~9
//ctrl:ƴ
//*buff:/ջָ
#if _USE_IOCTL
DRESULT disk_ioctl (
	BYTE pdrv,		/* Physical drive nmuber (0..) */
	BYTE cmd,		/* Control code */
	void *buff		/* Buffer to send/receive control data */
)
{
	DRESULT res;
	    switch(cmd)
	    {
		    case CTRL_SYNC:
				res = RES_OK; 
		        break;	 
		    case GET_SECTOR_SIZE:
				*(DWORD*)buff = 0x400;
		        res = RES_OK;
		        break;	 
		    case GET_BLOCK_SIZE:
				*(WORD*)buff = 1;
		        res = RES_OK;
		        break;	 
		    case GET_SECTOR_COUNT:
		        *(DWORD*)buff = 0x12c;
		        res = RES_OK;
		        break;
		    default:
		        res = RES_PARERR;
		        break;
	    }

    return res;
}
#endif
//ʱ
//User defined function to give a current time to fatfs module      */
//31-25: Year(0-127 org.1980), 24-21: Month(1-12), 20-16: Day(1-31) */                                                                                                                                                                                                                                          
//15-11: Hour(0-23), 10-5: Minute(0-59), 4-0: Second(0-29 *2) */                                                                                                                                                                                                                                                
DWORD get_fattime (void)
{				 
	return 0;
}			 
//̬ڴ
//void *ff_memalloc (UINT size)
//{
//	return (void*)malloc(size);
//}
////ͷڴ
//void ff_memfree (void* mf)
//{
//	free(mf);
//}

















