/**
  ********************************************************************
  * ļ  flash.c
  *      ChipON_AE/FAE_Group
  *     V2.1
  *     2019-11-16
  *     ļṩflashӦöд
  *
  *********************************************************************
*/
#include"flash.h"
#include "system_init.h"
#include "usb_conf.h"
FLASH_ProgramTypeDef flash_write;


/*
*
* ҳдݵFLASHֻΪ128 ַΪҳ׵ַ ʮ½β000 400 800 C00
* 			ַҳ׵ַȷΪ0xFFFFǰдʹҳֵ0xFFFFд쳣
* address дַ
*          p_FlashBuffer дַָ
*          length        дݳ(ֻΪ128)
*           
* дflashע˵ҳַָڵһҳ128˫ֵַݶҳֻ64˫ֽдҳдҪΰҳд
*/
void FLASH_PageWrite_fun(uint32_t address,uint32_t *p_FlashBuffer,uint8_t length)
{
	volatile uint8_t i;
	static uint32_t Flash_Buff1[128];
	static uint32_t Flash_Buff2[128];
	INT_All_Enable(FALSE);
	//	//--------------------------------------------------------------------------------------------
	FLASH_Wipe_Configuration_RAM(FLASH_WIPE_CODE_PAGE,address);//ҳ

	//--------------------------------------------------------------------------------------------
	for (i = 0; i < length; i++)
	{
		Flash_Buff1[i] =*p_FlashBuffer;
		p_FlashBuffer ++;
	}

	flash_write.m_Mode=FLASH_PROGRAM_HALF_PAGE;//FLASH_PROGRAM_HALF_PAGE //FLASH_PROGRAM_WORD
	flash_write.m_Zone=FLASH_PROGRAM_CODE;//FLASH_PROGRAM_CFG  FLASH_PROGRAM_CODE
	flash_write.m_Addr=address;
	flash_write.m_WriteSize=63;//ҳ̲Ϊ0д1+1ʵд2˫ ֱӰ
	flash_write.m_Data=Flash_Buff1;
	FLASH_Program_Configuration_RAM(&flash_write);


	for (i = 0; i < length; i++)
	{
		Flash_Buff2[i] = *p_FlashBuffer;
		p_FlashBuffer ++;
	}

	flash_write.m_Mode=FLASH_PROGRAM_HALF_PAGE;//FLASH_PROGRAM_HALF_PAGE //FLASH_PROGRAM_WORD
	flash_write.m_Zone=FLASH_PROGRAM_CODE;//FLASH_PROGRAM_CFG  FLASH_PROGRAM_CODE
	flash_write.m_Addr=address+0x200;
	flash_write.m_WriteSize=63;//ҳ̲Ϊ0д1+1ʵд2˫ ֱӰ
	flash_write.m_Data=Flash_Buff2;
	FLASH_Program_Configuration_RAM(&flash_write);

	INT_All_Enable(TRUE);

}


/**
  *   flash д
  *   address ָflashַ
  *  p_FlashBuffer: дݵָ
  *
  *   ޡ
  * עдǰҪȲַڵҳ
  */
void FLASH_WriteWord(uint32_t address,uint32_t p_FlashBuffer)
{
	    uint32_t num32[2];
	    uint32_t *flash_write_num;
	    num32[0]=p_FlashBuffer;
	    num32[1]=0;
		flash_write_num=num32;
		//--------------------------------------------------------------------------------------------

	    flash_write.m_Mode=FLASH_PROGRAM_WORD;//FLASH_PROGRAM_HALF_PAGE //FLASH_PROGRAM_WORD
		flash_write.m_Zone=FLASH_PROGRAM_CODE;//FLASH_PROGRAM_CFG  FLASH_PROGRAM_CODE
		flash_write.m_Addr=address;
		flash_write.m_WriteSize=1;//ҳ̲Ϊ0д1+1ʵд2˫ ֱӰ
		flash_write.m_Data=flash_write_num;
		FLASH_Program_Configuration_RAM(&flash_write);
}


/*
*
* ֽڶȡ̵
* address дַ
*           õַ洢
*/
uint8_t FLASH_ReadByte(uint32_t  address)
{
	uint8_t temp=0;
	temp=*(uint8_t *)(address+U_DISK_FLASH_BASE);
	return temp;
}

/*
*
* д
* address дַ
* 			*p_FlashBuffer д
*           õַ洢
*/
void FLASH_PageWrite(uint32_t address,uint8_t *p_FlashBuffer)
{
	FLASH_PageWrite_fun(address+U_DISK_FLASH_BASE,p_FlashBuffer,128);
}
