/*
 * uart.c
 *
 *  Created on: 2020-1-6
 *      Author: liuhao
 */
#include "stdio.h"
#include "uart.h"
#include "kf32l_basic_gpio.h"
#include "kf32l_basic_pclk.h"
#include "kf32l_basic_int.h"




/**
  *   ڳʼ,Ĭʹʱ16M
  *   ޡ
  *   ޡ
*/
void User_USART_Init(void)
{
	UARTInit();
}

/*
 * UART0 ʼ
 *
 * */
void UARTInit()
{
	GPIO_Write_Mode_Bits(GPIOB_SFR, GPIO_PIN_MASK_1, GPIO_MODE_RMP);		  //ӳIOڹģʽ
	GPIO_Pin_RMP_Config(GPIOB_SFR, GPIO_Pin_Num_1, GPIO_RMP_AF5_USART1); //ӳΪUSART
	GPIO_Write_Mode_Bits(GPIOB_SFR, GPIO_PIN_MASK_0, GPIO_MODE_RMP);		  //ӳIOڹģʽ
	GPIO_Pin_RMP_Config(GPIOB_SFR, GPIO_Pin_Num_0, GPIO_RMP_AF5_USART1); //ӳΪUSART

	//ȫ˫첽8bit 115200
	USART_Async_config(USART1_SFR);
	USART_Passageway_Select_Config(USART1_SFR, USART_U7816R_PASSAGEWAY_TX0); //UASRT0ѡTX0ͨ
}



/**
  *   ڳʼ,Ĭʹʱ16M
  *   ڲ,ǰСڵ1M
  *   ޡ
*/
void BLE_USART_Init(void)
{

	/* ˿ӳAF5 */	
	//USART2_RX		PH13
	//USART2_TX0	PH15
	
	GPIO_Write_Mode_Bits(GPIOH_SFR ,GPIO_PIN_MASK_13, GPIO_MODE_RMP);          //ӳIOڹģʽ	
	GPIO_Write_Mode_Bits(GPIOH_SFR ,GPIO_PIN_MASK_15, GPIO_MODE_RMP);          //ӳIOڹģʽ	
	GPIO_Pin_RMP_Config (GPIOH_SFR ,GPIO_Pin_Num_13, GPIO_RMP_AF5_USART2);	  //ӳΪUSART1	
	GPIO_Pin_RMP_Config (GPIOH_SFR ,GPIO_Pin_Num_15, GPIO_RMP_AF5_USART2);     //ӳΪUSART1	
	GPIO_Pin_Lock_Config (GPIOH_SFR ,GPIO_PIN_MASK_13, TRUE);                  //
	GPIO_Pin_Lock_Config (GPIOH_SFR ,GPIO_PIN_MASK_15, TRUE);                  //

	USART_Async_config(USART2_SFR);
	//ڽжʹ	
	USART_ReceiveInt_config(USART2_SFR,INT_USART2,TRUE);
	
}


void BLE_SET_GPIO_LOW(void)
{
	GPIO_Write_Mode_Bits(GPIOH_SFR ,GPIO_PIN_MASK_13, GPIO_MODE_OUT);          //ӳIOڹģʽ	
	GPIO_Write_Mode_Bits(GPIOH_SFR ,GPIO_PIN_MASK_15, GPIO_MODE_OUT);          //ӳIOڹģʽ
	GPIO_Pin_Lock_Config (GPIOH_SFR ,GPIO_PIN_MASK_13, FALSE);                  //	
	GPIO_Pin_Lock_Config (GPIOH_SFR ,GPIO_PIN_MASK_15, FALSE);                  //

	GPIO_Set_Output_Data_Bits(GPIOH_SFR,GPIO_PIN_MASK_13,Bit_RESET);
	GPIO_Set_Output_Data_Bits(GPIOH_SFR,GPIO_PIN_MASK_15,Bit_RESET);
}


/**
  *   첽ȫ˫(Ĭ8bitշʹ  ȫ˫ 115200)
  *    ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *    
  */
void USART_Async_config(USART_SFRmap *USARTx)
{
	USART_InitTypeDef USART_InitStructure;

	USART_Struct_Init(&USART_InitStructure);
	USART_InitStructure.m_Mode = USART_MODE_FULLDUPLEXASY;			 //ȫ˫
	USART_InitStructure.m_TransferDir = USART_DIRECTION_FULL_DUPLEX; //䷽
	USART_InitStructure.m_WordLength = USART_WORDLENGTH_8B;			 //8λ
	USART_InitStructure.m_StopBits = USART_STOPBITS_1;				 //1λֹͣλ
	USART_InitStructure.m_BaudRateBRCKS = USART_CLK_HFCLK;			 //ڲƵʱΪ USARTʷʱ

	/*  =Fck/(16*z1+x/y)) ʱڲƵ16M*/
	//4800    z:208    x:0    y:0
	//9600    z:104    x:0    y:0
	//19200   z:52     x:0    y:0
	//115200  z:8      x:1    y:15
	//HFCLK 16M 115200
	USART_InitStructure.m_BaudRateInteger = 8;		//USARTzȡֵΪ0~65535
	USART_InitStructure.m_BaudRateNumerator = 1;	//USARTСӲxȡֵΪ0~0xF
	USART_InitStructure.m_BaudRateDenominator = 13; //USARTСĸyȡֵΪ0~0xF

	USART_Reset(USARTx);							   //USARTxλ
	USART_Configuration(USARTx, &USART_InitStructure); //USARTx
	USART_Clear_Transmit_BUFR_INT_Flag(USARTx);		   //USARTxBUF
	USART_RESHD_Enable(USARTx, TRUE);				   //ʹRESHDλ
	USART_Cmd(USARTx, TRUE);						   //USARTxʹ
}

/**
  *    ڽж
  *    USARTx:ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *      Peripheral:ںжţȡֵΧΪ
  *                 öInterruptIndexеж
  *    
  */
void USART_ReceiveInt_config(USART_SFRmap *USARTx, InterruptIndex Peripheral, FunctionalState stat)
{
	USART_ReceiveData(USARTx); //ձ־λ
	USART_RDR_INT_Enable(USARTx, stat);
	INT_Interrupt_Enable(Peripheral, stat);
}



/**
  *    ڷ
  *    USARTx:   ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *      Databuf   ָݵָ
  *      length      ͵ĳ
  *    
  */
void USART_Send(USART_SFRmap *USARTx, uint8_t *Databuf, uint32_t length)
{
	uint32_t i;
	for (i = 0; i < length; i++)
	{
		//ɱ־
		while(!USART_Get_Transmitter_Empty_Flag(USARTx));
		//ڷ
		USART_SendData(USARTx, Databuf[i]);
		//ɱ־
		while (!USART_Get_Transmitter_Empty_Flag(USARTx))
			;
	}
}

