/****************************************************************************************
 *
 * ļ: main.c
 * Ŀ: IWDG
 *  :  V2.1
 *  :  20191116
 *  :  ChipON_AE/FAE_Group
 *
 ****************************************************************************************/
#include "system_init.h"

#define    UserKEY    GPIO_Read_Input_Data_Bit(GPIOH_SFR,GPIO_PIN_MASK_14)  //ȡPB0ƽ

//ʱ ֲvolatileܻᱻŻ
//Ƶʱ120M 1msʱ
void delay_ms(volatile uint32_t nms)
{
	volatile uint32_t i,j;
	for(i=0;i<nms;i++)
	{
		j=700;
		while(j--);
	}

}

/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
		GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);

	GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_SET);	  //Ϊߵƽ

}

/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Input_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
		GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;                   //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_IN;                      //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;                     //ʼ GPIOǷ 
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;                   //ʼ GPIOǷ 
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);
}



/**
  *  Ź趨ʱá
  *   OverflowȡֵΪ0~0xFFF Źֵ
  *     PrescalerINTLFԤƵֵ
  *   ޡ
  */
void IWDT_Config(uint32_t Overflow,uint32_t Prescaler)
{

	OSC_SCK_Source_Config(SCLK_SOURCE_INTHF);                       //ѡINTHFΪϵͳʱӽƵ

	BKP_Write_And_Read_Enable(TRUE);                                //дʹ
	PM_Independent_Watchdog_Reset_Config(PERIPHERAL_OUTRST_STATUS); //ʹܶŹ˳λ״̬
	PM_Internal_Low_Frequency_Enable(TRUE);                         //ڲƵʹ
	IWDT_Overflow_Config (Overflow);                                //ŹֵȡֵΪ500//1ӿŹ
	IWDT_Prescaler_Config(Prescaler);                               //ŹINTLF164ԤƵֵ
	IWDT_Enable(TRUE);                                              //ʹܶŹ

	OSC_SCK_Source_Config(SCLK_SOURCE_PLL);                         //ѡpllΪϵͳʱ
}




//
void main()
{
	/*ûɲοKF32L530_demoʵʹöŹܡ
	 * жŹʱԴΪڲ32KHZ 164Ƶ1000ΣλʱΪ1
	 * ûUSRKEYʱϵͳ1븴λһSTATUS˸USER KEYϵͳSTATUSƳ
	 *
	 *ע⣺öŹ֮ǰҪлƵ򿪱öŹ
     */
	//ϵͳʱ120M,Ƶʱ16M
	SystemInit(); //ϵͳʱӳʼ
	delay_ms(200);
	//GPIOʼ
	GPIOInit_Input_Config(GPIOH_SFR,GPIO_PIN_MASK_14);//P14Ϊģʽ
	GPIOInit_Output_Config(GPIOF_SFR,GPIO_PIN_MASK_0);//PF0ΪΪߵƽ
	//Ź
	IWDT_Config(500,IWDT_PRESCALER_64);//32KHZ 164Ƶ1000Σ 1Ӻϵͳλ
	GPIO_Set_Output_Data_Bits(GPIOF_SFR,GPIO_PIN_MASK_0,Bit_SET);//PF0
	while(1)
    {
		if(UserKEY)
		{
			IWDT_Feed_The_Dog();//ºιϵͳûιʱ1ϵͳλ

		}

    }

}



/**
  *    У鷢ļ
  *    file: ָļƵָ
  *      line У
  *   ޡ
  */
void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}

