/**
  ******************************************************************************
  * ļ  kf32l_basic_atim.c
  *     ChipON_AE/FAE_Group
  *     V3.0.0
  *     2021-08-20
  *     ļṩ˸߼ʱ蹦ܺ
  *          + ߼ʱ(ATIM)ʼú
  *          + ߼ʱ(ATIM)жϼ־
  *          + ǿͲ׽/Ƚ/PWM(ECCP)׽ܺ
  *          + ǿͲ׽/Ƚ/PWM(ECCP)жϼ־
  *
  *********************************************************************
  */

#include "kf32l_basic_tim.h"
#include "kf32l_basic_rst.h"
#include "kf32l_basic_pclk.h"


/* ʱ˽ж ----------------------------------------------------*/
/* ATIMx_TXCTLĴ */
#define ATIM_TXCTL_INIT_MASK            (ATIM_TXCTL_TXCS \
                                       | ATIM_TXCTL_TXSY \
                                       | ATIM_TXCTL_TXCKBS \
                                       | ATIM_TXCTL_TXCLK \
                                       | ATIM_TXCTL_TXCMS)

/* ATIMx_TZCTLĴ */
#define ATIM_TZCTL_INIT_MASK            (ATIM_TZCTL_TZCS \
                                       | ATIM_TZCTL_TZSY \
                                       | ATIM_TZCTL_TZCKBS \
                                       | ATIM_TZCTL_TZCLK \
                                       | ATIM_TZCTL_TZCMS)

/* ATIMx_PXUDCTLTxΪʱļĴ */
#define ATIM_X_PXUDCTL_INIT_MASK  (ECCP_PXUDCTL_PXUDEVT0 \
                                  | ECCP_PXUDCTL_PXUDEVT1)

/* ATIMx_PXUDCTLTzΪʱļĴ */
#define ATIM_Z_PXUDCTL_INIT_MASK  (ECCP_PXUDCTL_PXUDEVT2 \
                                  | ECCP_PXUDCTL_PXUDEVT3)

/* ECCPX_CTL2Ĵʼ */
#define ECCP_CTL2_INIT_MASK             (ECCP_CTL2_PXPWMI \
                                       | ECCP_CTL2_PXXORM)

/* ECCPXRYĴƫƵַ */
#define ECCP_RY_OFFSET                   ((uint32_t)0x84)

/* ECCPXCYĴƫƵַ */
#define ECCP_CY_OFFSET                   ((uint32_t)0xD0)


/**
  *   ##### ߼ʱ(ATIM)ʼú #####
  */
/**
  *   ߼ʱ(ATIM)ãTx
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *       atimInitStruct: ߼ʱϢṹָ롣
  *   
  */
void ATIM_X_Configuration(ATIM_SFRmap* ATIMx,
                    ATIM_InitTypeDef* atimInitStruct)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_ATIM_POSTSCALER(atimInitStruct->m_Postscaler));
    CHECK_RESTRICTION(CHECK_ATIM_COUNTER_MODE(atimInitStruct->m_CounterMode));
    CHECK_RESTRICTION(CHECK_ATIM_CLOCK_CONFIG(atimInitStruct->m_Clock));
    CHECK_RESTRICTION(CHECK_ATIM_WORK_MODE(atimInitStruct->m_WorkMode));
    CHECK_RESTRICTION(CHECK_ATIM_SYNC_MODE(atimInitStruct->m_EXPulseSync));

    /*---------------- TxCNTĴ ----------------*/
    ATIMx->TXCNT = (uint32_t)atimInitStruct->m_Counter;

    /*--------------- PPxڼĴ ---------------*/
    ATIMx->TXPPX = (uint32_t)atimInitStruct->m_Period;

    /*-------------- TxԤƵĴ ---------------*/
    ATIMx->TXPRSC = (uint32_t)atimInitStruct->m_Prescaler;

    /*------------------ TXCTLĴ -----------------*/
    /* ݽṹԱm_PostscalerTXCKBSλ */
    /* ݽṹԱm_CounterModeTXCMSλ */
    /* ݽṹԱm_ClockTXCLKλ */
    /* ݽṹԱm_WorkModeTXCSλ */
    /* ݽṹԱm_EXPulseSyncTXSYλ */
    tmpreg = ((uint32_t)atimInitStruct->m_Postscaler << ATIM_TXCTL_TXCKBS0_POS) \
             | (atimInitStruct->m_CounterMode) \
             | ((uint32_t)atimInitStruct->m_Clock) \
             | ((uint32_t)atimInitStruct->m_WorkMode) \
             | ((uint32_t)atimInitStruct->m_EXPulseSync);
    ATIMx->TXCTL = SFR_Config (ATIMx->TXCTL,
                          ~ATIM_TXCTL_INIT_MASK,
                          tmpreg);
}

/**
  *   ߼ʱ(ATIM)ãTz
  *   ATIMx: ָʱڴṹָ룬ȡֵT6_SFR/T10_SFR
  *       atimInitStruct: ߼ʱϢṹָ롣
  *   
  */
void ATIM_Z_Configuration(ATIM_SFRmap* ATIMx,
                    ATIM_InitTypeDef* atimInitStruct)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_ATIM_POSTSCALER(atimInitStruct->m_Postscaler));
    CHECK_RESTRICTION(CHECK_ATIM_COUNTER_MODE(atimInitStruct->m_CounterMode));
    CHECK_RESTRICTION(CHECK_ATIM_CLOCK_CONFIG(atimInitStruct->m_Clock));
    CHECK_RESTRICTION(CHECK_ATIM_WORK_MODE(atimInitStruct->m_WorkMode));
    CHECK_RESTRICTION(CHECK_ATIM_SYNC_MODE(atimInitStruct->m_EXPulseSync));

    /*---------------- TxCNTĴ ----------------*/
    ATIMx->TZCNT = (uint32_t)atimInitStruct->m_Counter;

    /*--------------- PPxڼĴ ---------------*/
    ATIMx->TZPPZ = (uint32_t)atimInitStruct->m_Period;

    /*-------------- TxԤƵĴ ---------------*/
    ATIMx->TZPRSC = (uint32_t)atimInitStruct->m_Prescaler;

    /*------------------ TXCTLĴ -----------------*/
    /* ݽṹԱm_PostscalerTXCKBSλ */
    /* ݽṹԱm_CounterModeTXCMSλ */
    /* ݽṹԱm_ClockTXCLKλ */
    /* ݽṹԱm_WorkModeTXCSλ */
    /* ݽṹԱm_EXPulseSyncTXSYλ */
    tmpreg = ((uint32_t)atimInitStruct->m_Postscaler << ATIM_TZCTL_TZCKBS0_POS) \
             | (atimInitStruct->m_CounterMode) \
             | ((uint32_t)atimInitStruct->m_Clock) \
             | ((uint32_t)atimInitStruct->m_WorkMode) \
             | ((uint32_t)atimInitStruct->m_EXPulseSync);
    ATIMx->TZCTL = SFR_Config (ATIMx->TZCTL,
                          ~ATIM_TZCTL_INIT_MASK,
                          tmpreg);
}

/**
  *   ʼ߼ʱϢṹ塣
  *   atimInitStruct: ָʼĽṹָ롣
  *   
  */
void
ATIM_Struct_Init (ATIM_InitTypeDef* atimInitStruct)
{
    /* Txֵ */
    atimInitStruct->m_Counter = 0x00000000;
    /* Txֵ */
    atimInitStruct->m_Period = 0x0000FFFF;
    /* TxԤƵֵ */
    atimInitStruct->m_Prescaler = 0x00000000;
    /* TxƵֵ */
    atimInitStruct->m_Postscaler = 0x0;
    /* Txģʽ */
    atimInitStruct->m_CounterMode = ATIM_COUNT_UP_OF;
    /* Txʱ */
    atimInitStruct->m_Clock = ATIM_SCLK;
    /* öʱ/ģʽѡ */
    atimInitStruct->m_WorkMode = ATIM_TIMER_MODE;
    /* Txģʽⲿͬ */
    atimInitStruct->m_EXPulseSync = ATIM_EX_SYNC_MODE;
}

/**
  *   ʱTxʹܡ
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *       NewState: ʱʹܿƣ
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ATIM_X_Cmd (ATIM_SFRmap* ATIMx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- TXCTLĴTXENλ --------------------*/
    if (NewState != FALSE)
    {
        /* ʹTxʱ */
        SFR_SET_BIT_ASM(ATIMx->TXCTL, ATIM_TXCTL_TXEN_POS);
    }
    else
    {
        /* ֹTxʱ */
        SFR_CLR_BIT_ASM(ATIMx->TXCTL, ATIM_TXCTL_TXEN_POS);
    }
}

/**
  *   ʱTzʹܡ
  *   ATIMx: ָʱڴṹָ룬ȡֵT6_SFR/T10_SFR
  *       NewState: ʱʹܿƣ
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ATIM_Z_Cmd (ATIM_SFRmap* ATIMx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- TZCTLĴTZENλ --------------------*/
    if (NewState != FALSE)
    {
        /* ʹTzʱ */
        SFR_SET_BIT_ASM(ATIMx->TZCTL, ATIM_TZCTL_TZEN_POS);
    }
    else
    {
        /* ֹTzʱ */
        SFR_CLR_BIT_ASM(ATIMx->TZCTL, ATIM_TZCTL_TZEN_POS);
    }
}

/**
  *   ߼ʱ(ATIM)ãTx
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *       UpdataCounter: ߼ʱ¼ֵȡֵ8λݡ
  *       UpdataOutput: ƼĴʹܿƣ
  *                       ȡֵΪTRUEFALSE
  *       UpdataImmediately: ¶ʱʹܿƣ
  *                            ȡֵΪTRUEFALSE
  *   
  */
void
ATIM_X_Updata_Configuration (ATIM_SFRmap* ATIMx,
                    uint8_t UpdataCounter,
                    uint32_t UpdataOutput,
                    uint32_t UpdataImmediately)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(UpdataOutput));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(UpdataImmediately));

    /*-------------- TXUDTIM¼Ĵ ---------------*/
    ATIMx->TXUDTIM = UpdataCounter;

    /*------------------ PXUDCTLĴ -----------------*/
    /* ݽṹԱUpdataOutputPXUDEVT0λ */
    /* ݽṹԱUpdataImmediatelyPXUDEVT1λ */
    tmpreg = (UpdataOutput << ECCP_PXUDCTL_PXUDEVT0_POS) \
             | (UpdataImmediately << ECCP_PXUDCTL_PXUDEVT1_POS);
    ATIMx->PXUDCTL = SFR_Config (ATIMx->PXUDCTL,
                          ~ATIM_X_PXUDCTL_INIT_MASK,
                          tmpreg);
}

/**
  *   ߼ʱ(ATIM)ãTz
  *   ATIMx: ָʱڴṹָ룬ȡֵT6_SFR/T10_SFR
  *       UpdataCounter: ߼ʱ¼ֵȡֵ8λݡ
  *       UpdataOutput: ƼĴʹܿƣ
  *                       ȡֵΪTRUEFALSE
  *       UpdataImmediately: ¶ʱʹܿƣ
  *                            ȡֵΪTRUEFALSE
  *   
  */
void
ATIM_Z_Updata_Configuration (ATIM_SFRmap* ATIMx,
                    uint8_t UpdataCounter,
                    uint32_t UpdataOutput,
                    uint32_t UpdataImmediately)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(UpdataOutput));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(UpdataImmediately));

    /*-------------- TXUDTIM¼Ĵ ---------------*/
    ATIMx->TZUDTIM = UpdataCounter;

    /*------------------ PXUDCTLĴ -----------------*/
    /* ݽṹԱUpdataOutputPXUDEVT2λ */
    /* ݽṹԱUpdataImmediatelyPXUDEVT3λ */
    tmpreg = (UpdataOutput << ECCP_PXUDCTL_PXUDEVT2_POS) \
             | (UpdataImmediately << ECCP_PXUDCTL_PXUDEVT3_POS);
    ATIMx->PXUDCTL = SFR_Config (ATIMx->PXUDCTL,
                          ~ATIM_Z_PXUDCTL_INIT_MASK,
                          tmpreg);
}

/**
  *   ʱTxʹܿơ
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *       NewState: ʱTxʹܿƣ
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ATIM_X_Updata_Cmd (ATIM_SFRmap* ATIMx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCP_PXUDCTLĴPXUDEN0λ --------------------*/
    if (NewState != FALSE)
    {
        /* ʹTxʱ */
        SFR_SET_BIT_ASM(ATIMx->PXUDCTL, ECCP_PXUDCTL_PXUDEN0_POS);
    }
    else
    {
        /* ֹTxʱ */
        SFR_CLR_BIT_ASM(ATIMx->PXUDCTL, ECCP_PXUDCTL_PXUDEN0_POS);
    }
}

/**
  *   ʱTzʹܿơ
  *   ATIMx: ָʱڴṹָ룬ȡֵT6_SFR/T10_SFR
  *       NewState: ʱTzʹܿƣ
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ATIM_Z_Updata_Cmd (ATIM_SFRmap* ATIMx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCP_PXUDCTLĴPXUDEN1λ --------------------*/
    if (NewState != FALSE)
    {
        /* ʹTzʱ */
        SFR_SET_BIT_ASM(ATIMx->PXUDCTL, ECCP_PXUDCTL_PXUDEN1_POS);
    }
    else
    {
        /* ֹTzʱ */
        SFR_CLR_BIT_ASM(ATIMx->PXUDCTL, ECCP_PXUDCTL_PXUDEN1_POS);
    }
}

/**
  *   öʱTxֵ
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *       Counter: ֵȡֵ16λݡ
  *   
  */
void
ATIM_X_Set_Counter (ATIM_SFRmap* ATIMx, uint16_t Counter)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*---------------- TXCNTĴ ----------------*/
    ATIMx->TXCNT = Counter;
}

/**
  *   öʱTzֵ
  *   ATIMx: ָʱڴṹָ룬ȡֵT6_SFR/T10_SFR
  *       Counter: ֵȡֵ16λݡ
  *   
  */
void
ATIM_Z_Set_Counter (ATIM_SFRmap* ATIMx, uint16_t Counter)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*---------------- TZCNTĴ ----------------*/
    ATIMx->TZCNT = Counter;
}

/**
  *   öʱTxֵ
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *       Period: ֵȡֵ16λݡ
  *   
  */
void
ATIM_X_Set_Period (ATIM_SFRmap* ATIMx, uint16_t Period)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*---------------- TXPPXĴ ----------------*/
    ATIMx->TXPPX = Period;
}

/**
  *   öʱTzֵ
  *   ATIMx: ָʱڴṹָ룬ȡֵT6_SFR/T10_SFR
  *       Period: ֵȡֵ16λݡ
  *   
  */
void
ATIM_Z_Set_Period (ATIM_SFRmap* ATIMx, uint16_t Period)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*---------------- TZPPZĴ ----------------*/
    ATIMx->TZPPZ = Period;
}

/**
  *   öʱTxԤƵֵ
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *       Prescaler: ԤƵȡֵ16λݡ
  *   
  */
void
ATIM_X_Set_Prescaler (ATIM_SFRmap* ATIMx, uint16_t Prescaler)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*---------------- TXPRSCĴ ----------------*/
    ATIMx->TXPRSC = Prescaler;
}

/**
  *   öʱTzԤƵֵ
  *   ATIMx: ָʱڴṹָ룬ȡֵT6_SFR/T10_SFR
  *       Prescaler: ԤƵȡֵ16λݡ
  *   
  */
void
ATIM_Z_Set_Prescaler (ATIM_SFRmap* ATIMx, uint16_t Prescaler)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*---------------- TZPRSCĴ ----------------*/
    ATIMx->TZPRSC = Prescaler;
}

/**
  *   öʱTxģʽ
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *       CounterMode: µļģʽ
  *                    ȡֵΧΪ
  *                      ATIM_COUNT_DOWN_UF: ¼,жϱ־
  *                      ATIM_COUNT_UP_OF: ϼ,жϱ־
  *                      ATIM_COUNT_UP_DOWN_OF: -¼,жϱ־
  *                      ATIM_COUNT_UP_DOWN_UF: -¼,жϱ־
  *                      ATIM_COUNT_UP_DOWN_OUF: -¼,жϱ־
  *   
  */
void
ATIM_X_Counter_Mode_Config (ATIM_SFRmap* ATIMx, uint32_t CounterMode)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_ATIM_COUNTER_MODE(CounterMode));

    /*-------------------- TXCTLĴTXCMSλ --------------------*/
    ATIMx->TXCTL = SFR_Config (ATIMx->TXCTL,
                          ~ATIM_TXCTL_TXCMS,
                          CounterMode);
}

/**
  *   öʱTzģʽ
  *   ATIMx: ָʱڴṹָ룬ȡֵT6_SFR/T10_SFR
  *       CounterMode: µļģʽ
  *                    ȡֵΧΪ
  *                      ATIM_COUNT_DOWN_UF: ¼,жϱ־
  *                      ATIM_COUNT_UP_OF: ϼ,жϱ־
  *                      ATIM_COUNT_UP_DOWN_OF: -¼,жϱ־
  *                      ATIM_COUNT_UP_DOWN_UF: -¼,жϱ־
  *                      ATIM_COUNT_UP_DOWN_OUF: -¼,жϱ־
  *   
  */
void
ATIM_Z_Counter_Mode_Config (ATIM_SFRmap* ATIMx, uint32_t CounterMode)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_ATIM_COUNTER_MODE(CounterMode));

    /*-------------------- TZCTLĴTZCMSλ --------------------*/
    ATIMx->TZCTL = SFR_Config (ATIMx->TZCTL,
                          ~ATIM_TZCTL_TZCMS,
                          CounterMode);
}

/**
  *   öʱTxʱӡ
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *       NewClock: ʱTxʱӣ
  *                 ȡֵΧΪ
  *                   ATIM_SCLK: ѡSCLKʱ
  *                   ATIM_HFCLK: ѡHFCLKʱ
  *                   ATIM_LFCLK: ѡLFCLKʱ
  *   
  */
void
ATIM_X_Clock_Config (ATIM_SFRmap* ATIMx, uint32_t NewClock)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_ATIM_CLOCK_CONFIG(NewClock));

    /*-------------------- TXCTLĴTXCLKλ --------------------*/
    ATIMx->TXCTL = SFR_Config (ATIMx->TXCTL,
                          ~ATIM_TXCTL_TXCLK,
                          NewClock);
}

/**
  *   öʱTzʱӡ
  *   ATIMx: ָʱڴṹָ룬ȡֵT6_SFR/T10_SFR
  *       NewClock: ʱTzʱӣ
  *                 ȡֵΧΪ
  *                   ATIM_SCLK: ѡSCLKʱ
  *                   ATIM_HFCLK: ѡHFCLKʱ
  *                   ATIM_LFCLK: ѡLFCLKʱ
  *   
  */
void
ATIM_Z_Clock_Config (ATIM_SFRmap* ATIMx, uint32_t NewClock)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_ATIM_CLOCK_CONFIG(NewClock));

    /*-------------------- TZCTLĴTZCLKλ --------------------*/
    ATIMx->TZCTL = SFR_Config (ATIMx->TZCTL,
                          ~ATIM_TZCTL_TZCLK,
                          NewClock);
}

/**
  *   öʱTxĺƵ
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *       NewPostscaler: ʱTxĺƵȡֵΪ4λݣΧ£
  *                   ATIM_POSTSCALER_DIV_1: ƵΪ1:1
  *                   ATIM_POSTSCALER_DIV_2: ƵΪ1:2
  *                   ATIM_POSTSCALER_DIV_3: ƵΪ1:3
  *                   ATIM_POSTSCALER_DIV_4: ƵΪ1:4
  *                   ATIM_POSTSCALER_DIV_5: ƵΪ1:5
  *                   ATIM_POSTSCALER_DIV_6: ƵΪ1:6
  *                   ATIM_POSTSCALER_DIV_7: ƵΪ1:7
  *                   ATIM_POSTSCALER_DIV_8: ƵΪ1:8
  *                   ATIM_POSTSCALER_DIV_9: ƵΪ1:9
  *                   ATIM_POSTSCALER_DIV_10: ƵΪ1:10
  *                   ATIM_POSTSCALER_DIV_11: ƵΪ1:11
  *                   ATIM_POSTSCALER_DIV_12: ƵΪ1:12
  *                   ATIM_POSTSCALER_DIV_13: ƵΪ1:13
  *                   ATIM_POSTSCALER_DIV_14: ƵΪ1:14
  *                   ATIM_POSTSCALER_DIV_15: ƵΪ1:15
  *                   ATIM_POSTSCALER_DIV_16: ƵΪ1:16
  *   
  */
void
ATIM_X_Postscaler_Config (ATIM_SFRmap* ATIMx, uint32_t NewPostscaler)
{
	uint32_t tmpreg = 0;
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_ATIM_POSTSCALER(NewPostscaler));

    /*-------------------- TXCTLĴTXCKBSλ --------------------*/
    tmpreg = NewPostscaler << ATIM_TXCTL_TXCKBS0_POS;
    ATIMx->TXCTL = SFR_Config (ATIMx->TXCTL,
                          ~ATIM_TXCTL_TXCKBS,
                          tmpreg);
}

/**
  *   öʱTzĺƵ
  *   ATIMx: ָʱڴṹָ룬ȡֵT6_SFR/T10_SFR
  *       NewPostscaler: ʱTzĺƵȡֵΪ4λݣΧ£
  *                   ATIM_POSTSCALER_DIV_1: ƵΪ1:1
  *                   ATIM_POSTSCALER_DIV_2: ƵΪ1:2
  *                   ATIM_POSTSCALER_DIV_3: ƵΪ1:3
  *                   ATIM_POSTSCALER_DIV_4: ƵΪ1:4
  *                   ATIM_POSTSCALER_DIV_5: ƵΪ1:5
  *                   ATIM_POSTSCALER_DIV_6: ƵΪ1:6
  *                   ATIM_POSTSCALER_DIV_7: ƵΪ1:7
  *                   ATIM_POSTSCALER_DIV_8: ƵΪ1:8
  *                   ATIM_POSTSCALER_DIV_9: ƵΪ1:9
  *                   ATIM_POSTSCALER_DIV_10: ƵΪ1:10
  *                   ATIM_POSTSCALER_DIV_11: ƵΪ1:11
  *                   ATIM_POSTSCALER_DIV_12: ƵΪ1:12
  *                   ATIM_POSTSCALER_DIV_13: ƵΪ1:13
  *                   ATIM_POSTSCALER_DIV_14: ƵΪ1:14
  *                   ATIM_POSTSCALER_DIV_15: ƵΪ1:15
  *                   ATIM_POSTSCALER_DIV_16: ƵΪ1:16
  *   
  */
void
ATIM_Z_Postscaler_Config (ATIM_SFRmap* ATIMx, uint32_t NewPostscaler)
{
	uint32_t tmpreg = 0;
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_ATIM_POSTSCALER(NewPostscaler));

    /*-------------------- TZCTLĴTZCKBSλ --------------------*/
    tmpreg = NewPostscaler << ATIM_TZCTL_TZCKBS0_POS;
    ATIMx->TZCTL = SFR_Config (ATIMx->TZCTL,
                          ~ATIM_TZCTL_TZCKBS,
                          tmpreg);
}

/**
  *   öʱTxģʽⲿͬλ
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *       NewClock: ʱTxģʽⲿͬλʹ״̬
  *                 ȡֵΧΪ
  *                   ATIM_EX_SYNC_MODE: ⲿͬ
  *                   ATIM_NO_SYNC_MODE: ⲿͬ
  *   
  */
void
ATIM_X_External_Pulse_Sync_Config (ATIM_SFRmap* ATIMx, uint32_t PulseSync)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_ATIM_SYNC_MODE(PulseSync));

    /*-------------------- TXCTLĴTXSYλ --------------------*/
    if (PulseSync != ATIM_EX_SYNC_MODE)
    {
        /* ⲿͬ */
        SFR_SET_BIT_ASM(ATIMx->TXCTL, ATIM_TXCTL_TXSY_POS);
    }
    else
    {
        /* ⲿͬ */
        SFR_CLR_BIT_ASM(ATIMx->TXCTL, ATIM_TXCTL_TXSY_POS);
    }
}

/**
  *   öʱTzģʽⲿͬλ
  *   ATIMx: ָʱڴṹָ룬ȡֵT6_SFR/T10_SFR
  *       NewClock: ʱTzģʽⲿͬλʹ״̬
  *                 ȡֵΧΪ
  *                   ATIM_EX_SYNC_MODE: ⲿͬ
  *                   ATIM_NO_SYNC_MODE: ⲿͬ
  *   
  */
void
ATIM_Z_External_Pulse_Sync_Config (ATIM_SFRmap* ATIMx, uint32_t PulseSync)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_ATIM_SYNC_MODE(PulseSync));

    /*-------------------- TZCTLĴTZSYλ --------------------*/
    if (PulseSync != ATIM_EX_SYNC_MODE)
    {
        /* ⲿͬ */
        SFR_SET_BIT_ASM(ATIMx->TZCTL, ATIM_TZCTL_TZSY_POS);
    }
    else
    {
        /* ⲿͬ */
        SFR_CLR_BIT_ASM(ATIMx->TZCTL, ATIM_TZCTL_TZSY_POS);
    }
}

/**
  *   Txʱ/ģʽѡ
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *       NewState: Txʱ/ģʽѡ
  *                 ȡֵΧΪ
  *                   ATIM_TIMER_MODE: ʱģʽ
  *                   ATIM_COUNTER_MODE: ģʽ
  *   
  */
void
ATIM_X_Work_Mode_Config (ATIM_SFRmap* ATIMx, uint32_t NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_ATIM_WORK_MODE(NewState));

    /*-------------------- TXCTLĴTXCSλ --------------------*/
    if (NewState != ATIM_TIMER_MODE)
    {
        /* ģʽ */
        SFR_SET_BIT_ASM(ATIMx->TXCTL, ATIM_TXCTL_TXCS_POS);
    }
    else
    {
        /* ʱģʽ */
        SFR_CLR_BIT_ASM(ATIMx->TXCTL, ATIM_TXCTL_TXCS_POS);
    }
}

/**
  *   Tzʱ/ģʽѡ
  *   ATIMx: ָʱڴṹָ룬ȡֵT6_SFR/T10_SFR
  *       NewState: Tzʱ/ģʽѡ
  *                 ȡֵΧΪ
  *                   ATIM_TIMER_MODE: ʱģʽ
  *                   ATIM_COUNTER_MODE: ģʽ
  *   
  */
void
ATIM_Z_Work_Mode_Config (ATIM_SFRmap* ATIMx, uint32_t NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_ATIM_WORK_MODE(NewState));

    /*-------------------- TZCTLĴTZCSλ --------------------*/
    if (NewState != ATIM_TIMER_MODE)
    {
        /* ģʽ */
        SFR_SET_BIT_ASM(ATIMx->TZCTL, ATIM_TZCTL_TZCS_POS);
    }
    else
    {
        /* ʱģʽ */
        SFR_CLR_BIT_ASM(ATIMx->TZCTL, ATIM_TZCTL_TZCS_POS);
    }
}

/**
  *   Tx
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *   Tx0£1ϡ
  */
DIRStatus
ATIM_X_Get_Direction (ATIM_SFRmap* ATIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*-------------------- ȡTXCTLĴTXDIRλ --------------------*/
    if (ATIMx->TXCTL & ATIM_TXCTL_TXDIR)
    {
        /* ǰΪϼ */
        return DIR_UP;
    }
    else
    {
        /* ǰΪ¼ */
        return DIR_DOWN;
    }
}

/**
  *   Tz
  *   ATIMx: ָʱڴṹָ룬ȡֵT6_SFR/T10_SFR
  *   Tz0£1ϡ
  */
DIRStatus
ATIM_Z_Get_Direction (ATIM_SFRmap* ATIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*-------------------- ȡTZCTLĴTZDIRλ --------------------*/
    if (ATIMx->TZCTL & ATIM_TZCTL_TZDIR)
    {
        /* ǰΪϼ */
        return DIR_UP;
    }
    else
    {
        /* ǰΪ¼ */
        return DIR_DOWN;
    }
}

/**
  *   TxжϴADʹλ
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *       NewState: TxжϴADʹλ
  *                 ȡֵΪTRUEFALSE
  *   
  */
void
ATIM_X_Overflow_AD_Enable (ATIM_SFRmap* ATIMx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- TXCTLĴTXOFS1λ --------------------*/
    if (NewState != FALSE)
    {
    	/* жʹ */
        SFR_SET_BIT_ASM(ATIMx->TXCTL, ATIM_TXCTL_TXOFS1_POS);
    }
    else
    {
        /* жϽֹ */
        SFR_CLR_BIT_ASM(ATIMx->TXCTL, ATIM_TXCTL_TXOFS1_POS);
    }
}

/**
  *   TzжϴADʹλ
  *   ATIMx: ָʱڴṹָ룬ȡֵT6_SFR/T10_SFR
  *       NewState: TzжϴADʹλ
  *                 ȡֵΪTRUEFALSE
  *   
  */
void
ATIM_Z_Overflow_AD_Enable (ATIM_SFRmap* ATIMx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- TZCTLĴTZOFS1λ --------------------*/
    if (NewState != FALSE)
    {
        /* ģʽ */
        SFR_SET_BIT_ASM(ATIMx->TZCTL, ATIM_TZCTL_TZOFS1_POS);
    }
    else
    {
        /* ʱģʽ */
        SFR_CLR_BIT_ASM(ATIMx->TZCTL, ATIM_TZCTL_TZOFS1_POS);
    }
}

/**
  *   TxжϴADʹλ
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *       NewState: TxжϴADʹλ
  *                 ȡֵΪTRUEFALSE
  *   
  */
void
ATIM_X_Underflow_AD_Enable (ATIM_SFRmap* ATIMx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- TXCTLĴTXOFS0λ --------------------*/
    if (NewState != FALSE)
    {
        /* ģʽ */
        SFR_SET_BIT_ASM(ATIMx->TXCTL, ATIM_TXCTL_TXOFS0_POS);
    }
    else
    {
        /* ʱģʽ */
        SFR_CLR_BIT_ASM(ATIMx->TXCTL, ATIM_TXCTL_TXOFS0_POS);
    }
}

/**
  *   TzжϴADʹλ
  *   ATIMx: ָʱڴṹָ룬ȡֵT6_SFR/T10_SFR
  *       NewState: TzжϴADʹλ
  *                 ȡֵΪTRUEFALSE
  *   
  */
void
ATIM_Z_Underflow_AD_Enable (ATIM_SFRmap* ATIMx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- TZCTLĴTZOFS0λ --------------------*/
    if (NewState != FALSE)
    {
        /* ģʽ */
        SFR_SET_BIT_ASM(ATIMx->TZCTL, ATIM_TZCTL_TZOFS0_POS);
    }
    else
    {
        /* ʱģʽ */
        SFR_CLR_BIT_ASM(ATIMx->TZCTL, ATIM_TZCTL_TZOFS0_POS);
    }
}

/**
  *   TxжԶADλ
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *       NewState: TxжԶADλ
  *                 ȡֵΪTRUEFALSE
  *   
  */
void
ATIM_X_TriggerAD_Config (ATIM_SFRmap* ATIMx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- TXCTLĴTXADAUTOλ --------------------*/
    if (NewState != FALSE)
    {
        /* ģʽ */
        SFR_SET_BIT_ASM(ATIMx->TXCTL, ATIM_TXCTL_TXADAUTO_POS);
    }
    else
    {
        /* ʱģʽ */
        SFR_CLR_BIT_ASM(ATIMx->TXCTL, ATIM_TXCTL_TXADAUTO_POS);
    }
}

/**
  *   TzжԶADλ
  *   ATIMx: ָʱڴṹָ룬ȡֵT6_SFR/T10_SFR
  *       NewState: TzжԶADλ
  *                 ȡֵΪTRUEFALSE
  *   
  */
void
ATIM_Z_TriggerAD_Config (ATIM_SFRmap* ATIMx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- TZCTLĴTZADAUTOλ --------------------*/
    if (NewState != FALSE)
    {
        /* ģʽ */
        SFR_SET_BIT_ASM(ATIMx->TZCTL, ATIM_TZCTL_TZADAUTO_POS);
    }
    else
    {
        /* ʱģʽ */
        SFR_CLR_BIT_ASM(ATIMx->TZCTL, ATIM_TZCTL_TZADAUTO_POS);
    }
}

/**
  *   öʱTxADĴֵ
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *       CompareAD0: TxADĴ0ֵȡֵ16λݡ
  *       CompareAD1: TxADĴ1ֵȡֵ16λݡ
  *   
  */
void
ATIM_X_Set_TriggerAD_Signal (ATIM_SFRmap* ATIMx,
                    uint16_t CompareAD0, uint16_t CompareAD1)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*---------------- TXCCR0/TXCCR1Ĵ ----------------*/
    ATIMx->TXCCR0 = CompareAD0;
    ATIMx->TXCCR1 = CompareAD1;
}

/**
  *   öʱTzADĴֵ
  *   ATIMx: ָʱڴṹָ룬ȡֵT6_SFR/T10_SFR
  *       CompareAD: TzADĴ0ֵȡֵ16λݡ
  *   
  */
void
ATIM_Z_Set_TriggerAD_Signal (ATIM_SFRmap* ATIMx,
                    uint16_t CompareAD)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*---------------- TZCCR0Ĵ ----------------*/
    ATIMx->TZCCR0 = CompareAD;
}

/**
  *   Tx¿λ
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *       NewState: ʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ATIM_X_Updata_Immediately_Config (ATIM_SFRmap* ATIMx,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCP_PXUDCTLĴPXUDEVT1λ --------------------*/
    if (NewState != FALSE)
    {
        /* ¼ */
        SFR_SET_BIT_ASM(ATIMx->PXUDCTL, ECCP_PXUDCTL_PXUDEVT1_POS);
    }
    else
    {
    	  /* ʱ UDTIMX Ϊ 0 ʱ Tx ΪʱռձȡڡԤƵ¼Ĵ */
        SFR_CLR_BIT_ASM(ATIMx->PXUDCTL, ECCP_PXUDCTL_PXUDEVT1_POS);
    }
}

/**
  *   Tz¿λ
  *   ATIMx: ָʱڴṹָ룬ȡֵT6_SFR/T10_SFR
  *       NewState: ʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ATIM_Z_Updata_Immediately_Config (ATIM_SFRmap* ATIMx,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCP_PXUDCTLĴPXUDEVT3λ --------------------*/
    if (NewState != FALSE)
    {
        /* ¼ */
        SFR_SET_BIT_ASM(ATIMx->PXUDCTL, ECCP_PXUDCTL_PXUDEVT3_POS);
    }
    else
    {
        /* ʱUDTIMzΪ0ʱ */
        SFR_CLR_BIT_ASM(ATIMx->PXUDCTL, ECCP_PXUDCTL_PXUDEVT3_POS);
    }
}

/**
  *   TxƼĴ¿λ
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *       NewState: ʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ATIM_X_Updata_Output_Ctl (ATIM_SFRmap* ATIMx,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCP_PXUDCTLĴPXUDEVT0λ --------------------*/
    if (NewState != FALSE)
    {
        /* TxΪʱƼĴ */
        SFR_SET_BIT_ASM(ATIMx->PXUDCTL, ECCP_PXUDCTL_PXUDEVT0_POS);
    }
    else
    {
        /* ʱUDTIMxΪ0ʱ */
        SFR_CLR_BIT_ASM(ATIMx->PXUDCTL, ECCP_PXUDCTL_PXUDEVT0_POS);
    }
}

/**
  *   TzƼĴ¿λ
  *   ATIMx: ָʱڴṹָ룬ȡֵT6_SFR/T10_SFR
  *       NewState: ʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   
  *
  */
void
ATIM_Z_Updata_Output_Ctl (ATIM_SFRmap* ATIMx,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCP_PXUDCTLĴPXUDEVT2λ --------------------*/
    if (NewState != FALSE)
    {
        /* TzΪʱƼĴ */
        SFR_SET_BIT_ASM(ATIMx->PXUDCTL, ECCP_PXUDCTL_PXUDEVT2_POS);
    }
    else
    {
        /* ʱUDTIMzΪ0ʱ */
        SFR_CLR_BIT_ASM(ATIMx->PXUDCTL, ECCP_PXUDCTL_PXUDEVT2_POS);
    }
}

/**
  *   Txʹܡ
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *       NewState: ʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ATIM_X_Updata_Enable (ATIM_SFRmap* ATIMx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCP_PXUDCTLĴPXUDEN0λ --------------------*/
    if (NewState != FALSE)
    {
        /* ʹܸ */
        SFR_SET_BIT_ASM(ATIMx->PXUDCTL, ECCP_PXUDCTL_PXUDEN0_POS);
    }
    else
    {
        /* ֹ */
        SFR_CLR_BIT_ASM(ATIMx->PXUDCTL, ECCP_PXUDCTL_PXUDEN0_POS);
    }
}

/**
  *   Tzʹܡ
  *   ATIMx: ָʱڴṹָ룬ȡֵT6_SFR/T10_SFR
  *       NewState: ʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ATIM_Z_Updata_Enable (ATIM_SFRmap* ATIMx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCP_PXUDCTLĴPXUDEN1λ --------------------*/
    if (NewState != FALSE)
    {
        /* ʹܸ */
        SFR_SET_BIT_ASM(ATIMx->PXUDCTL, ECCP_PXUDCTL_PXUDEN1_POS);
    }
    else
    {
        /* ֹ */
        SFR_CLR_BIT_ASM(ATIMx->PXUDCTL, ECCP_PXUDCTL_PXUDEN1_POS);
    }
}

/**
  *   öʱTx¼
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *       UpdataCounter: ¼ֵȡֵ8λݡ
  *   
  */
void
ATIM_X_Set_Updata_Counter (ATIM_SFRmap* ATIMx, uint8_t UpdataCounter)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*---------------- TXUDTIMĴ ----------------*/
    ATIMx->TXUDTIM = UpdataCounter;
}

/**
  *   öʱTz¼
  *   ATIMx: ָʱڴṹָ룬ȡֵT6_SFR/T10_SFR
  *       UpdataCounter: ¼ֵȡֵ8λݡ
  *   
  */
void
ATIM_Z_Set_Updata_Counter (ATIM_SFRmap* ATIMx, uint8_t UpdataCounter)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*---------------- TZUDTIMĴ ----------------*/
    ATIMx->TZUDTIM = UpdataCounter;
}

/**
  *   Txģʽѡλ
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *       SlaveSelect: ģʽѡ
  *                    ȡֵΧΪ
  *                      ATIM_SLAVE_FORBIDDEN_MODE: ģʽֹ
  *                      ATIM_SLAVE_TRIGGER_MODE: ģʽ
  *                      ATIM_SLAVE_GATED_MODE: ſģʽ
  *                      ATIM_SLAVE_RESET_MODE: λģʽ
  *                      ATIM_SLAVE_COUNTER_MODE: ģʽ2
  *   
  */
void
ATIM_X_Slave_Mode_Config (ATIM_SFRmap* ATIMx, uint32_t SlaveMode)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_ATIM_SLAVE_MODE(SlaveMode));

    /*-------------------- ECCP_CTL2ĴTXSMSλ --------------------*/
    tmpreg = SlaveMode << ECCP_CTL2_TXSMS0_POS;
    ATIMx->ECCPXCTL2 = SFR_Config (ATIMx->ECCPXCTL2,
                          ~ECCP_CTL2_TXSMS,
                          tmpreg);
}

/**
  *   Tzģʽѡλ
  *   ATIMx: ָʱڴṹָ룬ȡֵT6_SFR/T10_SFR
  *       SlaveSelect: ģʽѡ
  *                    ȡֵΧΪ
  *                      ATIM_SLAVE_FORBIDDEN_MODE: ģʽֹ
  *                      ATIM_SLAVE_TRIGGER_MODE: ģʽ
  *                      ATIM_SLAVE_GATED_MODE: ſģʽ
  *                      ATIM_SLAVE_RESET_MODE: λģʽ
  *                      ATIM_SLAVE_COUNTER_MODE: ģʽ2
  *   
  */
void
ATIM_Z_Slave_Mode_Config (ATIM_SFRmap* ATIMx, uint32_t SlaveMode)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_ATIM_SLAVE_MODE(SlaveMode));

    /*-------------------- ECCP_CTL2ĴTZSMSλ --------------------*/
    tmpreg = SlaveMode << ECCP_CTL2_TZSMS0_POS;
    ATIMx->ECCPXCTL2 = SFR_Config (ATIMx->ECCPXCTL2,
                          ~ECCP_CTL2_TZSMS,
                          tmpreg);
}

/**
  *   Txģʽѡλ
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *       MasterMode: ģʽѡȡֵΧΪ
  *                     ATIM_MASTER_TXEN_SIGNAL: ʹźTXENΪTRGO
  *                     ATIM_MASTER_TXIF_SIGNAL: TXIFźΪTRGOʱʱжźţ
  *                     ATIM_MASTER_CCPXCH1IF_SIGNAL: ECCPxCC1IFΪTRGO
  *                     ATIM_MASTER_CCPXCH1_SIGNAL: ECCPxCH1ΪTRGO
  *                     ATIM_MASTER_CCPXCH2_SIGNAL: ECCPxCH2 ΪTRGO
  *                     ATIM_MASTER_CCPXCH3_SIGNAL: ECCPxCH3 ΪTRGO
  *                     ATIM_MASTER_CCPXCH4_SIGNAL: ECCPxCH4 ΪTRGO
  *   
  */
void
ATIM_Master_Mode_Config (ATIM_SFRmap* ATIMx, uint32_t MasterMode)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_ATIM_MASTER_MODE(MasterMode));

    /*-------------------- ECCP_CTL2ĴTXMMSλ --------------------*/
    ATIMx->ECCPXCTL2 = SFR_Config (ATIMx->ECCPXCTL2,
                          ~ECCP_CTL2_TXMMS,
                          MasterMode);
}

/**
  *   ģʽͬλ
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *       NewState: ģʽͬλ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ATIM_Master_Slave_Snyc_Enable (ATIM_SFRmap* ATIMx,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCP_CTL2ĴTXMSSYNCλ --------------------*/
    if (NewState != FALSE)
    {
        /* ʹģʽͬ */
        SFR_SET_BIT_ASM(ATIMx->ECCPXCTL2, ECCP_CTL2_TXMSSYNC_POS);
    }
    else
    {
        /* δʹ */
        SFR_CLR_BIT_ASM(ATIMx->ECCPXCTL2, ECCP_CTL2_TXMSSYNC_POS);
    }
}

/**
  *   ôѡλ
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *       TriggerSelect: ѡ
  *                      ȡֵΧΪ
  *                        ATIM_TRIGGER_T1
  *                        ATIM_TRIGGER_T20
  *                        ATIM_TRIGGER_T5
  *                        ATIM_TRIGGER_T9
  *                        ATIM_TRIGGER_ECCPXCH1
  *                        ATIM_TRIGGER_ECCPXCH2
  *                        ATIM_TRIGGER_ECCPXCH3
  *                        ATIM_TRIGGER_TXCK
  *   
  */
void
ATIM_Trigger_Select_Config (ATIM_SFRmap* ATIMx,
                    uint32_t TriggerSelect)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_ATIM_TRIGGER_MODE(TriggerSelect));

    /*-------------------- ECCP_CTL2ĴTXTSλ --------------------*/
    ATIMx->ECCPXCTL2 = SFR_Config (ATIMx->ECCPXCTL2,
                          ~ECCP_CTL2_TXTS,
                          TriggerSelect);
}

/**
  *   TxTzʹܡ
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *       NewState: TxTzʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ATIM_Timer_Unite_Enable (ATIM_SFRmap* ATIMx,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCP_CTL3ĴTUNITEλ --------------------*/
    if (NewState != FALSE)
    {
        /* TxTz */
        SFR_SET_BIT_ASM(ATIMx->ECCPXCTL3, ECCP_CTL3_TUNITE_POS);
    }
    else
    {
        /*  */
        SFR_CLR_BIT_ASM(ATIMx->ECCPXCTL3, ECCP_CTL3_TUNITE_POS);
    }
}

/**
  *   Txʱֵ
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *   Txֵ16λ
  */
uint16_t
ATIM_X_Get_Counter (ATIM_SFRmap* ATIMx)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /* ʱֵTxCNT */
    tmpreg = ATIMx->TXCNT;

    return tmpreg;
}

/**
  *   Tzʱֵ
  *   ATIMx: ָʱڴṹָ룬ȡֵT6_SFR/T10_SFR
  *   Tzֵ16λ
  */
uint16_t
ATIM_Z_Get_Counter (ATIM_SFRmap* ATIMx)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /* ʱֵTzCNT */
    tmpreg = ATIMx->TZCNT;

    return tmpreg;
}

/**
  *   Txʱֵ
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *   Txֵ16λ
  */
uint16_t
ATIM_X_Get_Period (ATIM_SFRmap* ATIMx)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /* ʱֵTxPPX */
    tmpreg = ATIMx->TXPPX;

    return tmpreg;
}

/**
  *   Tzʱֵ
  *   ATIMx: ָʱڴṹָ룬ȡֵT6_SFR/T10_SFR
  *   Tzֵ16λ
  */
uint16_t
ATIM_Z_Get_Period (ATIM_SFRmap* ATIMx)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /* ʱֵTZPPZ */
    tmpreg = ATIMx->TZPPZ;

    return tmpreg;
}

/**
  *   TxʱԤƵֵ
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *   TxԤƵֵ16λ
  */
uint16_t
ATIM_X_Get_Prescaler (ATIM_SFRmap* ATIMx)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /* ʱԤƵֵTxPPX */
    tmpreg = ATIMx->TXPRSC;

    return tmpreg;
}

/**
  *   TzʱԤƵֵ
  *   ATIMx: ָʱڴṹָ룬ȡֵT6_SFR/T10_SFR
  *   TzԤƵֵ16λ
  */
uint16_t
ATIM_Z_Get_Prescaler (ATIM_SFRmap* ATIMx)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /* ʱԤƵֵTxPPX */
    tmpreg = ATIMx->TZPRSC;

    return tmpreg;
}

/**
  *   ##### ߼ʱ(ATIM)ʼú #####
  */


/**
  *   ##### ߼ʱ(ATIM)жϼ־ #####
  */
/**
  *   Tx¼жʹܡ
  *   ATIMx: ָʱڴṹָ룬
  *              ȡֵT5_SFR/T9_SFR
  *       NewState: Tx¼жϣ
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ATIM_X_Updata_INT_Enable (ATIM_SFRmap* ATIMx,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCPX_IEĴTXUIEλ --------------------*/
    if (NewState != FALSE)
    {
        /* Txж */
        SFR_SET_BIT_ASM(ATIMx->ECCPXIE, ECCP_IE_TXUIE_POS);
    }
    else
    {
        /* ֹTxж */
        SFR_CLR_BIT_ASM(ATIMx->ECCPXIE, ECCP_IE_TXUIE_POS);
    }
}

/**
  *   Tz¼жʹܡ
  *   ATIMx: ָʱڴṹָ룬
  *              ȡֵT6_SFR/T10_SFR
  *       NewState: Tz¼жϣ
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ATIM_Z_Updata_INT_Enable (ATIM_SFRmap* ATIMx,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCPX_IEĴTZUIEλ --------------------*/
    if (NewState != FALSE)
    {
        /* Tzж */
        SFR_SET_BIT_ASM(ATIMx->ECCPXIE, ECCP_IE_TZUIE_POS);
    }
    else
    {
        /* ֹTzж */
        SFR_CLR_BIT_ASM(ATIMx->ECCPXIE, ECCP_IE_TZUIE_POS);
    }
}

/**
  *   Txжʹܡ
  *   ATIMx: ָʱڴṹָ룬
  *              ȡֵT5_SFR/T9_SFR
  *       NewState: Txжϣ
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ATIM_X_Overflow_INT_Enable (ATIM_SFRmap* ATIMx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCPX_IEĴTXIEλ --------------------*/
    if (NewState != FALSE)
    {
        /* Txж */
        SFR_SET_BIT_ASM(ATIMx->ECCPXIE, ECCP_IE_TXIE_POS);
    }
    else
    {
        /* ֹTxж */
        SFR_CLR_BIT_ASM(ATIMx->ECCPXIE, ECCP_IE_TXIE_POS);
    }
}

/**
  *   Tzжʹܡ
  *   ATIMx: ָʱڴṹָ룬
  *              ȡֵT6_SFR/T10_SFR
  *       NewState: Tzжϣ
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ATIM_Z_Overflow_INT_Enable (ATIM_SFRmap* ATIMx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCPX_IEĴTZIEλ --------------------*/
    if (NewState != FALSE)
    {
        /* Tzж */
        SFR_SET_BIT_ASM(ATIMx->ECCPXIE, ECCP_IE_TZIE_POS);
    }
    else
    {
        /* ֹTzж */
        SFR_CLR_BIT_ASM(ATIMx->ECCPXIE, ECCP_IE_TZIE_POS);
    }
}

/**
  *   Tx¼жʹܡ
  *   ATIMx: ָʱڴṹָ룬
  *              ȡֵT5_SFR/T9_SFR
  *       NewState: Tx¼жϣ
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ATIM_X_Trigger_INT_Enable (ATIM_SFRmap* ATIMx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCPX_IEĴTXTIEλ --------------------*/
    if (NewState != FALSE)
    {
        /* Tx¼ж */
        SFR_SET_BIT_ASM(ATIMx->ECCPXIE, ECCP_IE_TXTIE_POS);
    }
    else
    {
        /* ֹTx¼ж */
        SFR_CLR_BIT_ASM(ATIMx->ECCPXIE, ECCP_IE_TXTIE_POS);
    }
}

/**
  *   Tx¼DMAʹܡ
  *   ATIMx: ָʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       NewState: Tx¼DMA
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ATIM_X_Updata_DMA_Enable (ATIM_SFRmap* ATIMx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCPX_DEĴTXUDEλ --------------------*/
    if (NewState != FALSE)
    {
        /* ¼DMA */
        SFR_SET_BIT_ASM(ATIMx->ECCPXDE, ECCP_DE_TXUDE_POS);
    }
    else
    {
        /* ֹ¼DMA */
        SFR_CLR_BIT_ASM(ATIMx->ECCPXDE, ECCP_DE_TXUDE_POS);
    }
}

/**
  *   Tz¼DMAʹܡ
  *   ATIMx: ָʱڴṹָ룬
  *              ȡֵECCP6/ECCP10
  *       NewState: Tz¼DMA
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ATIM_Z_Updata_DMA_Enable (ATIM_SFRmap* ATIMx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCPX_DEĴTZUDEλ --------------------*/
    if (NewState != FALSE)
    {
        /* ¼DMA */
        SFR_SET_BIT_ASM(ATIMx->ECCPXDE, ECCP_DE_TZUDE_POS);
    }
    else
    {
        /* ֹ¼DMA */
        SFR_CLR_BIT_ASM(ATIMx->ECCPXDE, ECCP_DE_TZUDE_POS);
    }
}

/**
  *   Tx¼DMA
  *   ECCPx: ָCCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       NewState: Tx¼DMAʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ATIM_X_Trigger_DMA_Enable (ATIM_SFRmap* ATIMx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCPX_DEĴTXTDEλ --------------------*/
    if (NewState != FALSE)
    {
        /* ¼DMA */
        SFR_SET_BIT_ASM(ATIMx->ECCPXDE, ECCP_DE_TXTDE_POS);
    }
    else
    {
        /* ֹ¼DMA */
        SFR_CLR_BIT_ASM(ATIMx->ECCPXDE, ECCP_DE_TXTDE_POS);
    }
}

/**
  *   ȡTx¼жϱ־
  *   ATIMx: ָʱڴṹָ룬
  *              ȡֵT5_SFR/T9_SFR
  *   ж״̬0δжϣ1ж
  */
FlagStatus
ATIM_X_Get_Updata_INT_Flag (ATIM_SFRmap* ATIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*-------------------- ȡECCPXEGIFĴTXUIFλ --------------------*/
    if (ATIMx->ECCPXEGIF & ECCP_EGIF_TXUIF)
    {
        /* Tx¼ж */
        return SET;
    }
    else
    {
        /* δTx¼ж */
        return RESET;
    }
}

/**
  *   ȡTz¼жϱ־
  *   ATIMx: ָʱڴṹָ룬
  *              ȡֵT6_SFR/T10_SFR
  *   ж״̬0δжϣ1ж
  */
FlagStatus
ATIM_Z_Get_Updata_INT_Flag (ATIM_SFRmap* ATIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*-------------------- ȡECCPXEGIFĴTZUIFλ --------------------*/
    if (ATIMx->ECCPXEGIF & ECCP_EGIF_TZUIF)
    {
        /* Tz¼ж */
        return SET;
    }
    else
    {
        /* δTz¼ж */
        return RESET;
    }
}

/**
  *   ȡTxжϱ־
  *   ATIMx: ָʱڴṹָ룬
  *              ȡֵT5_SFR/T9_SFR
  *   ж״̬0δжϣ1ж
  */
FlagStatus
ATIM_X_Get_Overflow_INT_Flag (ATIM_SFRmap* ATIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*-------------------- ȡECCPXEGIFĴTXIFλ --------------------*/
    if (ATIMx->ECCPXEGIF & ECCP_EGIF_TXIF)
    {
        /* Txж */
        return SET;
    }
    else
    {
        /* δTxж */
        return RESET;
    }
}

/**
  *   ȡTzжϱ־
  *   ATIMx: ָʱڴṹָ룬
  *              ȡֵT6_SFR/T10_SFR
  *   ж״̬0δжϣ1ж
  */
FlagStatus
ATIM_Z_Get_Overflow_INT_Flag (ATIM_SFRmap* ATIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*-------------------- ȡECCPXEGIFĴTZIFλ --------------------*/
    if (ATIMx->ECCPXEGIF & ECCP_EGIF_TZIF)
    {
        /* Tzж */
        return SET;
    }
    else
    {
        /* δTzж */
        return RESET;
    }
}

/**
  *   ȡTx¼жϱ־
  *   ATIMx: ָʱڴṹָ룬ȡֵT5_SFR/T9_SFR
  *   ж״̬0δжϣ1ж
  */
FlagStatus
ATIM_X_Get_Trigger_INT_Flag (ATIM_SFRmap* ATIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*-------------------- ȡECCPXEGIFĴTXTIFλ --------------------*/
    if (ATIMx->ECCPXEGIF & ECCP_EGIF_TXTIF)
    {
        /* Tx¼ж */
        return SET;
    }
    else
    {
        /* δTx¼ж */
        return RESET;
    }
}

/**
  *   ¼λ
  *   ATIMx: ָʱڴṹָ룬
  *              ȡֵT5_SFR/T9_SFR
  *       NewState: ʱʹܿ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ATIM_X_Generate_Trigger_Config (ATIM_SFRmap* ATIMx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCPX_EGIFĴTXTRGλ --------------------*/
    if (NewState != FALSE)
    {
        /* Ӧ */
        SFR_SET_BIT_ASM(ATIMx->ECCPXEGIF, ECCP_EGIF_TXTRG_POS);
    }
    else
    {
        /* ޶ */
        SFR_CLR_BIT_ASM(ATIMx->ECCPXEGIF, ECCP_EGIF_TXTRG_POS);
    }
}

/**
  *   ȡTx¼DMAжϱ־
  *   ATIMx: ָʱڴṹָ룬
  *              ȡֵT5_SFR/T9_SFR
  *   ж״̬0δжϣ1ж
  */
FlagStatus
ATIM_X_Get_Updata_DMA_INT_Flag (ATIM_SFRmap* ATIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*-------------------- ECCPX_DFĴTXUDFλ --------------------*/
    if (ATIMx->ECCPXDF & ECCP_DF_TXUDF)
    {
        /* TxDMAж */
        return SET;
    }
    else
    {
        /* δTxDMAж */
        return RESET;
    }
}

/**
  *   ȡTz¼DMAжϱ־
  *   ATIMx: ָʱڴṹָ룬
  *              ȡֵT6_SFR/T10_SFR
  *   ж״̬0δжϣ1ж
  */
FlagStatus
ATIM_Z_Get_Updata_DMA_INT_Flag (ATIM_SFRmap* ATIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*-------------------- ECCPX_DFĴTZUDFλ --------------------*/
    if (ATIMx->ECCPXDF & ECCP_DF_TZUDF)
    {
        /* TzDMAж */
        return SET;
    }
    else
    {
        /* δTzDMAж */
        return RESET;
    }
}

/**
  *   ȡTx¼DMAжϱ־
  *   ATIMx: ָʱڴṹָ룬
  *              ȡֵT5_SFR/T9_SFR
  *   ж״̬0δжϣ1ж
  */
FlagStatus
ATIM_X_Get_Trigger_DMA_INT_Flag (ATIM_SFRmap* ATIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*-------------------- ECCPX_DFĴTRIGDFλ --------------------*/
    if (ATIMx->ECCPXDF & ECCP_DF_TRIGDF)
    {
        /* ¼DMAж */
        return SET;
    }
    else
    {
        /* δ¼DMAж */
        return RESET;
    }
}

/**
  *   Tx¼жϱ־
  *   ATIMx: ָʱڴṹָ룬
  *              ȡֵT5_SFR/T9_SFR
  *   
  * ˵ñ־λʹܶӦʱ½Уᵼʧܡ
  */
void
ATIM_X_Clear_Updata_INT_Flag (ATIM_SFRmap* ATIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*-------------------- ECCPX_SRICĴTXUICλ --------------------*/
    SFR_SET_BIT_ASM(ATIMx->ECCPXSRIC, ECCP_SRIC_TXUIC_POS);
    while((ATIMx->ECCPXEGIF & ECCP_EGIF_TXUIF)>>ECCP_EGIF_TXUIF_POS);
    SFR_CLR_BIT_ASM(ATIMx->ECCPXSRIC, ECCP_SRIC_TXUIC_POS);
}

/**
  *   Tz¼жϱ־
  *   ATIMx: ָʱڴṹָ룬
  *              ȡֵT6_SFR/T10_SFR
  *   
  * ˵ñ־λʹܶӦʱ½Уᵼʧܡ
  */
void
ATIM_Z_Clear_Updata_INT_Flag (ATIM_SFRmap* ATIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*-------------------- ECCPX_SRICĴTZUICλ --------------------*/
    SFR_SET_BIT_ASM(ATIMx->ECCPXSRIC, ECCP_SRIC_TZUIC_POS);
    while((ATIMx->ECCPXEGIF & ECCP_EGIF_TZUIF)>>ECCP_EGIF_TZUIF_POS);
    SFR_CLR_BIT_ASM(ATIMx->ECCPXSRIC, ECCP_SRIC_TZUIC_POS);
}

/**
  *   Txжϱ־
  *   ATIMx: ָʱڴṹָ룬
  *              ȡֵT5_SFR/T9_SFR
  *   
  */
void
ATIM_X_Clear_Overflow_INT_Flag (ATIM_SFRmap* ATIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*-------------------- ECCPX_SRICĴTXICλ --------------------*/
    SFR_SET_BIT_ASM(ATIMx->ECCPXSRIC, ECCP_SRIC_TXIC_POS);
    while((ATIMx->ECCPXEGIF & ECCP_EGIF_TXIF)>>ECCP_EGIF_TXIF_POS);
    SFR_CLR_BIT_ASM(ATIMx->ECCPXSRIC, ECCP_SRIC_TXIC_POS);
}

/**
  *   Tzжϱ־
  *   ATIMx: ָʱڴṹָ룬
  *              ȡֵT6_SFR/T10_SFR
  *   
  */
void
ATIM_Z_Clear_Overflow_INT_Flag (ATIM_SFRmap* ATIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*-------------------- ECCPX_SRICĴTZICλ --------------------*/
    SFR_SET_BIT_ASM(ATIMx->ECCPXSRIC, ECCP_SRIC_TZIC_POS);
    while((ATIMx->ECCPXEGIF & ECCP_EGIF_TZIF)>>ECCP_EGIF_TZIF_POS);
    SFR_CLR_BIT_ASM(ATIMx->ECCPXSRIC, ECCP_SRIC_TZIC_POS);
}

/**
  *   Tx¼жϱ־
  *   ATIMx: ָʱڴṹָ룬
  *              ȡֵT5_SFR/T9_SFR
  *   
  */
void
ATIM_X_Clear_Trigger_INT_Flag (ATIM_SFRmap* ATIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*-------------------- ECCPX_SRICĴTXTICλ --------------------*/
    SFR_SET_BIT_ASM(ATIMx->ECCPXSRIC, ECCP_SRIC_TXTIC_POS);
    while((ATIMx->ECCPXEGIF & ECCP_EGIF_TXTIF)>>ECCP_EGIF_TXTIF_POS);
    SFR_CLR_BIT_ASM(ATIMx->ECCPXSRIC, ECCP_SRIC_TXTIC_POS);
}

/**
  *   ##### ߼ʱ(ATIM)жϼ־ #####
  */


/**
  *   ##### ǿͲ׽/Ƚ/PWM(ECCP)׽ܺ #####
  */
/**
  *   ǿͱȽ(ECCP)á
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       Channel: ȽͨȡֵΪ:
  *                ECCP_CHANNEL_1: ͨ1
  *                ECCP_CHANNEL_2: ͨ2
  *                ECCP_CHANNEL_3: ͨ3
  *                ECCP_CHANNEL_4: ͨ4
  *       CompareMode: ȽģʽȡֵΪ:
  *                      ECCP_MODE_RST: رձȽϹ
  *                      ECCP_CMP_TOGGLE_LEVEL: Ƚƥʱת
  *                      ECCP_CMP_ACTIVE_LEVEL: Ƚƥʱߵƽ
  *                      ECCP_CMP_INACTIVE_LEVEL: Ƚƥʱ͵ƽ
  *                      ECCP_CMP_SOFT_INT: Ƚƥʱж
  *                      ECCP_CMP_SPECIAL_EVENT: Ƚƥʱ¼
  *       CompareValue: ȽϼĴֵȡֵΪ16λݡ
  *   
  */
void
ECCP_Compare_Configuration(ECCP_SFRmap* ECCPx, uint32_t Channel,
                    uint32_t CompareMode, uint16_t CompareValue)
{
    uint32_t tmpreg = 0;
    uint32_t tmpreg1 = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_ECCP_CMP_MODE(CompareMode));

    /*------------------ ECCPX_CTL1Ĵ -----------------*/
    /* ChannelCompareModeECCPxCHyMλ */
    tmpreg = 4 * Channel;
    ECCPx->ECCPXCTL1 = SFR_Config (ECCPx->ECCPXCTL1,
                          ~(ECCP_CTL1_CH1M << tmpreg),
                          CompareMode << tmpreg);

    /*------------------ ECCPXRyĴ -----------------*/
    /* ȡECCPXRYĴַ */
    tmpreg1 = (uint32_t)ECCPx;
    tmpreg1 = tmpreg1 + ECCP_RY_OFFSET + tmpreg;
    /* CompareValueECCPXRyλ */
    *(volatile uint32_t*)tmpreg1 = CompareValue;
}

/**
  *   ǿͲ׽ģ(ECCP)á
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       eccpInitStruct: ǿͲ׽ģ(ECCP)Ϣṹָ롣
  *   
  */
void
ECCP_Capture_Configuration (ECCP_SFRmap* ECCPx,
                    ECCP_CaptureInitTypeDef* eccpInitStruct)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL(eccpInitStruct->m_Channel));
    CHECK_RESTRICTION(CHECK_ECCP_CAP_MODE(eccpInitStruct->m_Mode));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(eccpInitStruct->m_PWMInput));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(eccpInitStruct->m_XORMode));

    /*------------------ ECCPX_CTL1Ĵ -----------------*/
    /* m_Channelm_ModeECCPXCHyMλ */
    tmpreg = 4 * eccpInitStruct->m_Channel;
    ECCPx->ECCPXCTL1 = SFR_Config (ECCPx->ECCPXCTL1,
                          ~(ECCP_CTL1_CH1M << tmpreg),
                          eccpInitStruct->m_Mode << tmpreg);

    /*------------------ ECCPX_CTL2Ĵ -----------------*/
    /* PWMInputPXPWMIλ */
    /* m_XORModePXXORMλ */
    tmpreg = (eccpInitStruct->m_PWMInput << ECCP_CTL2_PXPWMI_POS) \
           | (eccpInitStruct->m_PWMInput << ECCP_CTL2_PXXORM_POS);
    ECCPx->ECCPXCTL2 = SFR_Config (ECCPx->ECCPXCTL2,
                          ~ECCP_CTL2_INIT_MASK,
                          tmpreg);
}

/**
  *   ʼǿͲ׽ģ(ECCP)Ϣṹ塣
  *   eccpInitStruct: ָʼĽṹָ롣
  *   
  */
void
ECCP_Capture_Struct_Init (ECCP_CaptureInitTypeDef* eccpInitStruct)
{
    /* PWMͨ */
    eccpInitStruct->m_Channel = ECCP_CHANNEL_1;
    /* ͨģʽѡλ */
    eccpInitStruct->m_Mode = ECCP_MODE_RST;
    /* PWMģʽ */
    eccpInitStruct->m_PWMInput = FALSE;
    /* ģʽ */
    eccpInitStruct->m_XORMode = FALSE;
}

/**
  *   ǿPWMģ(ECCP)á
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       eccpInitStruct: ǿPWMģ(ECCP)Ϣṹָ롣
  *   
  */
void
ECCP_PWM_Configuration (ECCP_SFRmap* ECCPx,
                    ECCP_PWMInitTypeDef* eccpInitStruct)
{
    uint32_t tmpreg = 0;
    uint32_t tmpreg1 = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL(eccpInitStruct->m_Channel));
    CHECK_RESTRICTION(CHECK_ECCP_PWM_MODE(eccpInitStruct->m_Mode));
    CHECK_RESTRICTION(CHECK_ECCP_OUTPUT_MODE(eccpInitStruct->m_OutputMode));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL_OUTPUT(eccpInitStruct->m_HOutputCtl));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL_OUTPUT(eccpInitStruct->m_LOutputCtl));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(eccpInitStruct->m_PhaseMove));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(eccpInitStruct->m_SinglePWM));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(eccpInitStruct->m_CloseTimer));

    /*------------------ ECCPX_CTL1Ĵ -----------------*/
    /* ݽṹԱm_Channelm_ModeECCPXCHyMλ */
    tmpreg = 4 * eccpInitStruct->m_Channel;
    ECCPx->ECCPXCTL1 = SFR_Config (ECCPx->ECCPXCTL1,
                          ~(ECCP_CTL1_CH1M << tmpreg),
                          eccpInitStruct->m_Mode << tmpreg);

    /*------------------ ECCPX_RyĴ -----------------*/
    /* ݽṹԱm_ChannelȡCCPXRYĴַ */
    tmpreg1 = (uint32_t)ECCPx;
    tmpreg1 = tmpreg1 + ECCP_RY_OFFSET + tmpreg;
    /* ݽṹԱm_DutyRatioECCPXRyλ */
    *(volatile uint32_t*)tmpreg1
        = (uint32_t)eccpInitStruct->m_DutyRatio;

    /*------------------ PXUDCTLĴ -----------------*/
    /* ݽṹԱm_PhaseMovePXMPENλ */
    ECCPx->PXUDCTL = SFR_Config (ECCPx->PXUDCTL,
                        ~ECCP_PXUDCTL_PXMPEN,
                        eccpInitStruct->m_PhaseMove);

    /*------------------ PXDTCTLĴ -----------------*/
    /* ݽṹԱm_Channelm_DeadTimePZDCPZDCλ */
    if (ECCP_CHANNEL_4 == eccpInitStruct->m_Channel)
    {
        tmpreg = ((uint32_t)eccpInitStruct->m_DeadTime \
                    << ECCP_PXDTCTL_PZDC0_POS);
        ECCPx->PXDTCTL = SFR_Config (ECCPx->PXDTCTL,
                            ~ECCP_PXDTCTL_PZDC,
                            tmpreg);
    }
    else
    {
        tmpreg = ((uint32_t)eccpInitStruct->m_DeadTime \
                    << ECCP_PXDTCTL_PXDC0_POS);
        ECCPx->PXDTCTL = SFR_Config (ECCPx->PXDTCTL,
                            ~ECCP_PXDTCTL_PXDC,
                            tmpreg);
    }

    /*------------------ PXATRCTLĴ -----------------*/
    /* ݽṹԱm_Channelm_OutputModePxCHyMODλ */
    tmpreg = eccpInitStruct->m_Channel;
    ECCPx->PXATRCTL = SFR_Config (ECCPx->PXATRCTL,
                          ~(ECCP_PXATRCTL_PXCH1MOD << tmpreg),
                          (uint32_t)eccpInitStruct->m_OutputMode << tmpreg);

    /*------------------ PWMXOCĴ -----------------*/
    /* ݽṹԱm_Channelm_HOutputCtlm_LOutputCtl
       PxOCyHPxOCyLλ */
    tmpreg = 4 * eccpInitStruct->m_Channel;
    tmpreg1 = ((uint32_t)eccpInitStruct->m_HOutputCtl << ECCP_PWMXOC_PXOC1H0_POS) \
            | ((uint32_t)eccpInitStruct->m_LOutputCtl << ECCP_PWMXOC_PXOC1L0_POS);
    ECCPx->PWMXOC = SFR_Config (ECCPx->PWMXOC,
                          ~((ECCP_PWMXOC_PXOC1L | ECCP_PWMXOC_PXOC1H) \
                            << tmpreg),
                          tmpreg1 << tmpreg);

    /*------------------ ECCPX_CTL2Ĵ -----------------*/
    /* ݽṹԱm_SinglePWMPxSPMλ */
    tmpreg = (eccpInitStruct->m_SinglePWM << ECCP_CTL2_PXSPM_POS);
    ECCPx->ECCPXCTL2 = SFR_Config (ECCPx->ECCPXCTL2,
                          ~(ECCP_CTL2_PXSPM),
                          tmpreg);

    /*------------------ ECCPX_CTL3Ĵ -----------------*/
    /* ݽṹԱm_CloseTimerPxSPMSTλ */
    tmpreg = (eccpInitStruct->m_CloseTimer << ECCP_CTL3_PXSPMST_POS);
    ECCPx->ECCPXCTL3 = SFR_Config (ECCPx->ECCPXCTL3,
                          ~ECCP_CTL3_PXSPMST,
                          tmpreg);
}

/**
  *   ʼǿPWMģ(ECCP)Ϣṹ塣
  *   eccpInitStruct: ָʼĽṹָ롣
  *   
  */
void
ECCP_PWM_Struct_Init (ECCP_PWMInitTypeDef* eccpInitStruct)
{
    /* PWMͨ */
    eccpInitStruct->m_Channel = ECCP_CHANNEL_1;
    /* ͨģʽѡλ */
    eccpInitStruct->m_Mode = ECCP_MODE_RST;
    /* PWMռձ */
    eccpInitStruct->m_DutyRatio = 0x0000;
    /*  */
    eccpInitStruct->m_DeadTime = 0x00;
    /* ͨģʽ */
    eccpInitStruct->m_OutputMode = ECCP_OUTPUT_INDEPENDENT;
    /* ͨH */
    eccpInitStruct->m_HOutputCtl = ECCP_CHANNEL_OUTPUT_PWM_ACTIVE;
    /* ͨL */
    eccpInitStruct->m_LOutputCtl = ECCP_CHANNEL_OUTPUT_PWM_ACTIVE;
    /* λƶʹ */
    eccpInitStruct->m_PhaseMove = FALSE;
    /* õģʽ */
    eccpInitStruct->m_SinglePWM = FALSE;
    /* õģʽѡ */
    eccpInitStruct->m_CloseTimer = FALSE;
}

/**
  *   ECCP׽ܡ
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       Channel: ׽ͨѡȡֵΧΪ:
  *                  ECCP_CHANNEL_1: ͨ1
  *                  ECCP_CHANNEL_2: ͨ2
  *                  ECCP_CHANNEL_3: ͨ3
  *                  ECCP_CHANNEL_4: ͨ4
  *       EdgeConfig: ƥأȡֵΧΪ:
  *                     ECCP_MODE_RST: رղ׽
  *                     ECCP_CAP_RISING_EDGE: ÿ½ط׽
  *                     ECCP_CAP_FALLING_EDGE: ÿط׽
  *                     ECCP_CAP_4TH_RISING_EDGE: ÿ4ط׽
  *                     ECCP_CAP_16TH_RISING_EDGE: ÿ16ط׽
  *   
  */
void
ECCP_Capture_Mode_Config (ECCP_SFRmap* ECCPx,
                    uint32_t Channel, uint32_t EdgeConfig)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_ECCP_CAP_MODE(EdgeConfig));

    /*-------------------- ECCPX_CTL1Ĵ --------------------*/
    tmpreg = EdgeConfig << (4 * Channel);
    ECCPx->ECCPXCTL1 = SFR_Config (ECCPx->ECCPXCTL1,
                          ~(ECCP_CTL1_CH1M << (4 * Channel)),
                          tmpreg);
}

/**
  *   ECCPȽϹܡ
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       Channel: ȽͨѡȡֵΧΪ:
  *                  ECCP_CHANNEL_1: ͨ1
  *                  ECCP_CHANNEL_2: ͨ2
  *                  ECCP_CHANNEL_3: ͨ3
  *                  ECCP_CHANNEL_4: ͨ4
  *       CmpConfig: ȽƥģʽȡֵΧΪ:
  *                    ECCP_MODE_RST: رձȽϹ
  *                    ECCP_CMP_TOGGLE_LEVEL: ƥʱƽת
  *                    ECCP_CMP_ACTIVE_LEVEL: Ƚƥʱߵƽ
  *                    ECCP_CMP_INACTIVE_LEVEL: Ƚƥʱ͵ƽ
  *                    ECCP_CMP_SOFT_INT: Ƚƥʱж
  *                    ECCP_CMP_SPECIAL_EVENT: ¼
  *   
  */
void
ECCP_Compare_Mode_Config (ECCP_SFRmap* ECCPx,
                    uint32_t Channel, uint32_t CmpConfig)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_ECCP_CMP_MODE(CmpConfig));

    /*-------------------- ECCPX_CTL1Ĵ --------------------*/
    tmpreg = CmpConfig << (4 * Channel);
    ECCPx->ECCPXCTL1 = SFR_Config (ECCPx->ECCPXCTL1,
                          ~(ECCP_CTL1_CH1M << (4 * Channel)),
                          tmpreg);
}

/**
  *   ECCP PWM,ģʽѡɣЭͬʱģʽ
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       PWMConfig: PWMƥģʽȡֵΧΪ:
  *                    ECCP_MODE_RST: رձȽϹ
  *                    ECCP_PWM_FREE: PWMģʽ
  *                    ECCP_PWM_COORDINATION: PWMЭͬģʽ
  *                    ECCP_PWM_SINGLE: PWMʱģʽ
  *   
  */
void
ECCP_PWM_Mode_Config (ECCP_SFRmap* ECCPx, uint32_t PWMConfig)
{
	uint32_t tmpreg = 0;
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_PWM_MODE(PWMConfig));

    /*-------------------- ECCPX_CTL1Ĵ --------------------*/
    tmpreg = PWMConfig << ECCP_CTL1_CH1M0_POS;
    ECCPx->ECCPXCTL1 = SFR_Config (ECCPx->ECCPXCTL1,
                          ~ECCP_CTL1_CH1M,
                          tmpreg);
}

/**
  *   ȡECCP׽Ĵ
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       Channel: ׽ͨѡȡֵΧΪ:
  *                  ECCP_CHANNEL_1: ͨ1
  *                  ECCP_CHANNEL_2: ͨ2
  *                  ECCP_CHANNEL_3: ͨ3
  *                  ECCP_CHANNEL_4: ͨ4
  *   ׽Ĵ16λֵ
  */
uint16_t
ECCP_Get_Capture_Result (ECCP_SFRmap* ECCPx, uint32_t Channel)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL(Channel));

    /* ȡĴʵַ */
    tmpreg = (uint32_t)ECCPx;
    tmpreg = tmpreg + ECCP_CY_OFFSET + (4 * Channel);

    /* ͨ16λָȡĴ16λֵ */
    return (*(volatile const uint16_t*)  tmpreg);
}

/**
  *   ȡECCPȽ/EPWMռձȼĴ
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *               ȡֵT5_SFR/T9_SFR
  *               ECCP5_SFR/ECCP9_SFR
  *       Channel: ׽ͨѡȡֵΧΪ:
  *                  ECCP_CHANNEL_1: ͨ1
  *                  ECCP_CHANNEL_2: ͨ2
  *                  ECCP_CHANNEL_3: ͨ3
  *                  ECCP_CHANNEL_4: ͨ4
  *   Ƚ/PWMռձȼĴֵ
  */
uint16_t
ECCP_Get_Compare_Result (ECCP_SFRmap* ECCPx, uint32_t Channel)
{
    uint32_t tmpreg = 0;

    /* У */
      CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
      CHECK_RESTRICTION(CHECK_ECCP_CHANNEL(Channel));


    /* ȡĴʵַ */
    tmpreg = (uint32_t)ECCPx;
    tmpreg = tmpreg + ECCP_RY_OFFSET + (4 * Channel);

    /* ͨ16λָȡĴ16λֵ */
    return (*(volatile const uint16_t*)  tmpreg);
}

/**
  *   ECCPȽ/PWMռձȼĴ
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       Channel: ׽ͨѡȡֵΧΪ:
  *                  ECCP_CHANNEL_1: ͨ1
  *                  ECCP_CHANNEL_2: ͨ2
  *                  ECCP_CHANNEL_3: ͨ3
  *                  ECCP_CHANNEL_4: ͨ4
  *   ޡ
  */
void
ECCP_Set_Compare_Result (ECCP_SFRmap* ECCPx, uint32_t Channel, uint16_t Value)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL(Channel));

    /* ȡCCPXRYĴַ */
    tmpreg = (uint32_t)ECCPx;
    tmpreg = tmpreg + ECCP_RY_OFFSET + (4 * Channel);

    /*-------------------- ECCPX_RYĴ --------------------*/
    *(volatile uint32_t*)tmpreg = (uint16_t)Value;
}

/**
  *   ׽/Ƚ¼λ
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       Channel: ͨѡȡֵΧΪ:
  *                  ECCP_CHANNEL_1: ͨ1
  *                  ECCP_CHANNEL_2: ͨ2
  *                  ECCP_CHANNEL_3: ͨ3
  *                  ECCP_CHANNEL_4: ͨ4
  *       NewState: ׽/Ƚ¼״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ECCP_Generate_Trigger_Config (ECCP_SFRmap* ECCPx, uint32_t Channel,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*------------------ ECCPX_EGIFĴCCyGλ ------------------*/
    if (NewState != FALSE)
    {
        /* ͨChannelϲһ׽/Ƚ¼ */
        ECCPx->ECCPXEGIF |= ECCP_EGIF_CC1G << Channel;
    }
    else
    {
        /* ޶ */
        ECCPx->ECCPXEGIF &= ~(ECCP_EGIF_CC1G << Channel);
    }
}

/**
  *   PWMģʽʹ
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       NewState: PWMģʽʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ECCP_PWM_Input_Enable (ECCP_SFRmap* ECCPx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCP_CTL2ĴPXPWMIλ --------------------*/
    if (NewState != FALSE)
    {
        /* ʹPWMģʽ */
        SFR_SET_BIT_ASM(ECCPx->ECCPXCTL2, ECCP_CTL2_PXPWMI_POS);
    }
    else
    {
        /* δʹPWMģʽ */
        SFR_CLR_BIT_ASM(ECCPx->ECCPXCTL2, ECCP_CTL2_PXPWMI_POS);
    }
}

/**
  *   ʹλ
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       NewState: ʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ECCP_Input_XOR_Enable (ECCP_SFRmap* ECCPx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCP_CTL2ĴPXXORMλ --------------------*/
    if (NewState != FALSE)
    {
        /* ʹPWMģʽ */
        SFR_SET_BIT_ASM(ECCPx->ECCPXCTL2, ECCP_CTL2_PXXORM_POS);
    }
    else
    {
        /* δʹPWMģʽ */
        SFR_CLR_BIT_ASM(ECCPx->ECCPXCTL2, ECCP_CTL2_PXXORM_POS);
    }
}

/**
  *   õģʽ
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       NewState: ģʽʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ECCP_Single_Pulse_Enable (ECCP_SFRmap* ECCPx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCPX_CTL2ĴPXSPMλ --------------------*/
    if (NewState != FALSE)
    {
        /* ģʽʹ */
        SFR_SET_BIT_ASM(ECCPx->ECCPXCTL2, ECCP_CTL2_PXSPM_POS);
    }
    else
    {
        /* ģʽδʹ */
        SFR_CLR_BIT_ASM(ECCPx->ECCPXCTL2, ECCP_CTL2_PXSPM_POS);
    }
}

/**
  *   õģʽѡ
  *   ECCPx: ָʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       NewState: ģʽѡ
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ECCP_Single_Pulse_Shut_Enable (ECCP_SFRmap* ECCPx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCPX_CTL3ĴPXSPMSTλ --------------------*/
    if (NewState != FALSE)
    {
        /* رնʱʹλ */
        SFR_SET_BIT_ASM(ECCPx->ECCPXCTL3, ECCP_CTL3_PXSPMST_POS);
    }
    else
    {
        /* 󲻹رնʱʹλ */
        SFR_CLR_BIT_ASM(ECCPx->ECCPXCTL3, ECCP_CTL3_PXSPMST_POS);
    }
}

/**
  *   PWMͨ1/2/3/4ʹλ
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       NewState: PWMͨ1/2/3/4ʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ECCP_PWM_Restart_Enable (ECCP_SFRmap* ECCPx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCPX_CTL3ĴPXRSENλ --------------------*/
    if (NewState != FALSE)
    {
        /* Զرʱһر¼ʧPxASEλԶ㣬PWMԶ */
        SFR_SET_BIT_ASM(ECCPx->ECCPXCTL3, ECCP_CTL3_PXRSEN_POS);
    }
    else
    {
        /* ԶرʱPxASE㣬PWM */
        SFR_CLR_BIT_ASM(ECCPx->ECCPXCTL3, ECCP_CTL3_PXRSEN_POS);
    }
}

/**
  *   PWMͨʱʱ䡣
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       Channel: ͨѡȡֵΧΪ:
  *                  ECCP_CHANNEL_1: ͨ1
  *                  ECCP_CHANNEL_2: ͨ2
  *                  ECCP_CHANNEL_3: ͨ3
  *                  ECCP_CHANNEL_4: ͨ4
  *       DeadTimeʱʱ䣬ȡֵΪ8λݡ
  *   
  */
void
ECCP_Dead_Time_Config (ECCP_SFRmap* ECCPx, uint32_t Channel,
                    uint8_t DeadTime)
{
    uint32_t tmpreg = 0;
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL(Channel));

    /*-------------------- ECCPX_PxDTCTLĴ --------------------*/
    if (ECCP_CHANNEL_4 == Channel)
    {
        /* ͨ4ʱʱ */
        tmpreg = (uint32_t)DeadTime << ECCP_PXDTCTL_PZDC0_POS;
        ECCPx->PXDTCTL = SFR_Config (ECCPx->PXDTCTL,
                             ~ECCP_PXDTCTL_PZDC,
                             tmpreg);
    }
    else
    {
        /* ͨ1/2/3ʱʱ */
        tmpreg = (uint32_t)DeadTime << ECCP_PXDTCTL_PXDC0_POS;
        ECCPx->PXDTCTL = SFR_Config (ECCPx->PXDTCTL,
                             ~ECCP_PXDTCTL_PXDC,
                             tmpreg);
    }
}

/**
  *   ECCPͨơ
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       Channel: ׽ͨѡȡֵΧΪ:
  *                  ECCP_CHANNEL_1: ͨ1
  *                  ECCP_CHANNEL_2: ͨ2
  *                  ECCP_CHANNEL_3: ͨ3
  *                  ECCP_CHANNEL_4: ͨ4
  *       Port: ˿ѡȡֵΧΪ:
  *               ECCP_PORT_LOW: CHxL˿
  *               ECCP_PORT_HIGH: CHxH˿
  *       ChannelOutputCtl: ͨ˿ƣȡֵΧΪ:
  *                           ECCP_CHANNEL_OUTPUT_PWM_ACTIVE: PWMЧ
  *                           ECCP_CHANNEL_OUTPUT_PWM_INACTIVE: PWMЧ
  *                           ECCP_CHANNEL_OUTPUT_INACTIVE: ǿƵ͵ƽ
  *                           ECCP_CHANNEL_OUTPUT_ACTIVE: ǿƸߵƽ
  *   ޡ
  */
void
ECCP_Channel_Output_Control (ECCP_SFRmap* ECCPx, uint32_t Channel,
                    uint32_t Port, uint32_t ChannelOutputCtl)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_ECCP_PORT(Port));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL_OUTPUT(ChannelOutputCtl));

    /*--------------- ECCPX_PWMXOCĴPXOCyH/PXOCyLλ ---------------*/
    tmpreg = ChannelOutputCtl << (Port + Channel * 4);
    ECCPx->PWMXOC = SFR_Config (ECCPx->PWMXOC,
                          ~(ECCP_PWMXOC_PXOC1L << (Port + Channel * 4)),
                          tmpreg);
}

/**
  *   ECCPͨģʽ
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       Channel: ׽ͨѡȡֵΧΪ:
  *                  ECCP_CHANNEL_1: ͨ1
  *                  ECCP_CHANNEL_2: ͨ2
  *                  ECCP_CHANNEL_3: ͨ3
  *                  ECCP_CHANNEL_4: ͨ4
  *       ChannelOutputMode: PWMͨģʽȡֵΧΪ:
  *                            ECCP_OUTPUT_INDEPENDENT: ģʽ
  *                            ECCP_OUTPUT_COMPLEMENTARY: ģʽ
  *   ޡ
  */
void
ECCP_Channel_Output_Mode (ECCP_SFRmap* ECCPx, uint32_t Channel,
                    uint32_t ChannelOutputMode)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_ECCP_OUTPUT_MODE(ChannelOutputMode));

    /*----------------- ECCPX_PXATRCTLĴPXCHyMODλ -----------------*/
    tmpreg = ChannelOutputMode << (ECCP_PXATRCTL_PXCH1MOD_POS + Channel);
    ECCPx->PXATRCTL = SFR_Config (ECCPx->PXATRCTL,
                          ~(ECCP_PXATRCTL_PXCH1MOD << Channel),
                          tmpreg);
}

/**
  *   ͨԶر¼״̬λ
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       Channel: ׽ͨѡȡֵΧΪ:
  *                  ECCP_CHANNEL_1: ͨ1
  *                  ECCP_CHANNEL_2: ͨ2
  *                  ECCP_CHANNEL_3: ͨ3
  *                  ECCP_CHANNEL_4: ͨ4
  *       WorkingState: ͨԶر¼״̬ȡֵΧΪ:
  *                       ECCP_CHANNEL_WORKING_STATE: ͨ
  *                       ECCP_CHANNEL_SHUTDOWN_STATE: ͨر
  *   ޡ
  */
void
ECCP_Channel_Work_State_Config (ECCP_SFRmap* ECCPx, uint32_t Channel,
                    uint32_t WorkingState)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL_STATE(WorkingState));

    /*-------------------- ECCPX_PXASCTL0ĴPXASEyλ --------------------*/
    tmpreg = WorkingState << (ECCP_PXASCTL0_PXASE1_POS + Channel);
    ECCPx->PXASCTL0 = SFR_Config (ECCPx->PXASCTL0,
                          ~(ECCP_PXASCTL0_PXASE1 << Channel),
                          tmpreg);
}

/**
  *   ȡͨԶر¼״̬λ
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       Channel: ׽ͨѡȡֵΧΪ:
  *                  ECCP_CHANNEL_1: ͨ1
  *                  ECCP_CHANNEL_2: ͨ2
  *                  ECCP_CHANNEL_3: ͨ3
  *                  ECCP_CHANNEL_4: ͨ4
  *   ͨԶر¼״̬ر¼10
  */
FlagStatus
ECCP_Get_Channel_Work_State (ECCP_SFRmap* ECCPx, uint32_t Channel)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL(Channel));

    /*--------------- ȡECCPX_PXASCTL0ĴPXASEyλ ---------------*/
    tmpreg = ECCP_PXASCTL0_PXASE1 << Channel;
    if (ECCPx->PXASCTL0 & tmpreg)
    {
        /* ˹ر¼,ͨΪر״̬ */
        return SET;
    }
    else
    {
        /* ͨ */
        return RESET;
    }
}

/**
  *   ͨԶرԴѡλ
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       Channel: ׽ͨѡȡֵΧΪ:
  *                  ECCP_CHANNEL_1: ͨ1
  *                  ECCP_CHANNEL_2: ͨ2
  *                  ECCP_CHANNEL_3: ͨ3
  *                  ECCP_CHANNEL_4: ͨ4
  *       ShutDownSignal: ͨԶرԴȡֵΧΪ:
  *                         ECCP_CHANNEL_SHUTDOWN_FORBID: ֹԶض
  *                         ECCP_CHANNEL_CMP2CMP3_ACTIVE: Ƚ2/3ߵƽ
  *                         ECCP_CHANNEL_BKIN_INACTIVE: ECCP_BKINϵĵ͵ƽ
  *       ע⣺Ƚ3Ϊ ECCP5/9 ͨ 1/2/3 ԶضϵĴź(ߵƽض)
  *       		Ƚ 2/3 Ϊ ECCP5/9 ͨ4 ԶضϵĴź(ߵƽض)
  *   ޡ
  */
void
ECCP_CHANNEL4_Shutdown_SEL (ECCP_SFRmap* ECCPx,
                    uint32_t ShutDownSignal)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_CHANNEL4_SHUTDOWN_SIGNAL(ShutDownSignal));


    if (ShutDownSignal != CMP3_OUTPUT_SHUNT)
    {
        /* Զرʱһر¼ʧPxASEλԶ㣬PWMԶ */
        SFR_SET_BIT_ASM(ECCPx->PXASCTL, ECCP_PXASCTL_PXASS_POS);
    }
    else
    {
        /* ԶرʱPxASE㣬PWM */
        SFR_CLR_BIT_ASM(ECCPx->PXASCTL, ECCP_PXASCTL_PXASS_POS);
    }
}
/**
  *   ͨԶرԴѡλ
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       Channel: ׽ͨѡȡֵΧΪ:
  *                  ECCP_CHANNEL_1: ͨ1
  *                  ECCP_CHANNEL_2: ͨ2
  *                  ECCP_CHANNEL_3: ͨ3
  *                  ECCP_CHANNEL_4: ͨ4
  *       ShutDownSignal: ͨԶرԴȡֵΧΪ:
  *                         ECCP_CHANNEL_SHUTDOWN_FORBID: ֹԶض
  *                         ECCP_CHANNEL_CMP2CMP3_ACTIVE: Ƚ2/3ߵƽ
  *                         ECCP_CHANNEL_BKIN_INACTIVE: ECCP_BKINϵĵ͵ƽ
  *       ע⣺Ƚ3Ϊ ECCP5/9 ͨ 1/2/3 ԶضϵĴź(ߵƽض)
  *       		Ƚ 2/3 Ϊ ECCP5/9 ͨ4 ԶضϵĴź(ߵƽض)
  *   ޡ
  */
void
ECCP_Channel_Shutdown_Signal (ECCP_SFRmap* ECCPx, uint32_t Channel,
                    uint32_t ShutDownSignal)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_ECCP_SHUTDOWN_SIGNAL(ShutDownSignal));

    /*-------------------- ECCPX_PXASCTL0ĴPXASSyλ --------------------*/
    tmpreg = ShutDownSignal << (Channel * 2);
    ECCPx->PXASCTL0 = SFR_Config (ECCPx->PXASCTL0,
                          ~(ECCP_PXASCTL0_PXASS1 << (Channel * 2)),
                          tmpreg);
}

/**
  *   ECCPxCHyH/ECCPxCHyLر״̬λ
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       Channel: ׽ͨѡȡֵΧΪ:
  *                  ECCP_CHANNEL_1: ͨ1
  *                  ECCP_CHANNEL_2: ͨ2
  *                  ECCP_CHANNEL_3: ͨ3
  *                  ECCP_CHANNEL_4: ͨ4
  *       Port: ˿ѡȡֵΧΪ:
  *               ECCP_PORT_LOW: CHxL˿
  *               ECCP_PORT_HIGH: CHxH˿
  *       ChannelPinCtl: ״̬ȡֵΧΪ:
  *                        PIN_INACTIVE: Ϊ͵ƽ
  *                        PIN_ACTIVE: Ϊߵƽ
  *                        PIN_TRISTATE: Ϊ̬
  *   ޡ
  */
void
ECCP_Channel_Pin_Ctl (ECCP_SFRmap* ECCPx, uint32_t Channel,
                    uint32_t Port, uint32_t ChannelPinCtl)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_ECCP_PORT(Port));
    CHECK_RESTRICTION(CHECK_PIN_STATE(ChannelPinCtl));

    /*--------------- ECCPX_PXASCTL1ĴPxSSyH/PxSSyLλ ---------------*/
    tmpreg = ChannelPinCtl << (Port + Channel * 4);
    ECCPx->PXASCTL1 = SFR_Config (ECCPx->PXASCTL1,
                          ~(ECCP_PXASCTL1_PXSS1L << (Port + Channel * 2)),
                          tmpreg);
}

/**
  *   ʱӡ
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       ZeroClock: ʱӣȡֵΧΪ:
  *                    ECCP_ZERO_CLOCK_DIV_1: ԤƵʱ
  *                    ECCP_ZERO_CLOCK_DIV_2: ԤƵʱ / 2
  *                    ECCP_ZERO_CLOCK_DIV_4: ԤƵʱ / 4
  *                    ECCP_ZERO_CLOCK_DIV_8: ԤƵʱ / 8
  *                    ECCP_ZERO_CLOCK_DIV_16: ԤƵʱ / 16
  *                    ECCP_ZERO_CLOCK_DIV_32: ԤƵʱ / 32
  *                    ECCP_ZERO_CLOCK_DIV_64: ԤƵʱ / 64
  *                    ECCP_ZERO_CLOCK_DIV_128: ԤƵʱ / 128
  *                    ECCP_ZERO_CLOCK_DIV_256: ԤƵʱ / 256
  *                    ECCP_ZERO_CLOCK_DIV_512: ԤƵʱ / 512
  *   ޡ
  */
void
ECCP_Zero_Clock_Config (ECCP_SFRmap* ECCPx,
                    uint32_t ZeroClock)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_ZERO_CLOCK(ZeroClock));

    /*-------------------- ECCPX_ZPDCTL0ĴZCLKλ --------------------*/
    ECCPx->ZPDCTL0 = SFR_Config (ECCPx->ZPDCTL0,
                          ~(ECCP_ZPDCTL0_ZCLK),
                          ZeroClock);
}

/**
  *   ECCPxCHyH/ECCPxCHyL̬λ
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       Channel: ׽ͨѡȡֵΧΪ:
  *                  ECCP_CHANNEL_1: ͨ1
  *                  ECCP_CHANNEL_2: ͨ2
  *                  ECCP_CHANNEL_3: ͨ3
  *                  ECCP_CHANNEL_4: ͨ4
  *       Port: ˿ѡȡֵΧΪ:
  *               ECCP_PORT_LOW: CHxL˿
  *               ECCP_PORT_HIGH: CHxH˿
  *       PinTristateCtl: ״̬ȡֵΧΪ:
  *                        PIN_INACTIVE: Ϊ͵ƽ
  *                        PIN_ACTIVE: Ϊߵƽ
  *                        PIN_TRISTATE: Ϊ̬
  *   ޡ
  */
void
ECCP_Channel_Pin_Tristate_Enable (ECCP_SFRmap* ECCPx, uint32_t Channel,
                    uint32_t Port, uint32_t PinTristateCtl)
{
    uint32_t tmpreg = 0;
    uint32_t tmpreg1 = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_ECCP_PORT(Port));
    CHECK_RESTRICTION(CHECK_PIN_STATE(PinTristateCtl));

    /*------------- ECCPX_ZPDPORTĴZPORTλ -------------*/
    tmpreg = (Port / 2) + (Channel * 2);
    tmpreg1 = PinTristateCtl << tmpreg;
    ECCPx->ZPDPORT = SFR_Config (ECCPx->ZPDPORT,
                          ~(ECCP_ZPDPORT_ZPORT << tmpreg),
                          tmpreg1);
}

/**
  *   ##### ǿͲ׽/Ƚ/PWM(ECCP)׽ܺ #####
  */

/**
  *   ##### ǿͲ׽/Ƚ/PWM(ECCP)жϼ־ #####
  */
/**
  *   ͨ/Ƚϵжʹá
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       Channel: ͨѡȡֵΧΪ:
  *                  ECCP_CHANNEL_1: ͨ1
  *                  ECCP_CHANNEL_2: ͨ2
  *                  ECCP_CHANNEL_3: ͨ3
  *                  ECCP_CHANNEL_4: ͨ4
  *       NewState: ͨ/Ƚϵжʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
ECCP_Channel_INT_Enable (ECCP_SFRmap* ECCPx, uint32_t Channel,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCPX_IEĴCCxIEλ --------------------*/
    if (NewState != FALSE)
    {
        /* CCPͨChannel׽/Ƚж */
        ECCPx->ECCPXIE |= ECCP_IE_CC1IE << Channel;
    }
    else
    {
        /* ֹCCPͨChannel׽/Ƚж */
        ECCPx->ECCPXIE &= ~(ECCP_IE_CC1IE << Channel);
    }
}

/**
  *   ض¼DMAʹλ
  *   ECCPx: ָCCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       NewState: ض¼DMAʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
ECCP_X_Turn_off_DMA_Enable (ECCP_SFRmap* ECCPx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCPX_DEĴCLSDEλ --------------------*/
    if (NewState != FALSE)
    {
        /* ض¼DMA */
        SFR_SET_BIT_ASM(ECCPx->ECCPXDE, ECCP_DE_CLSDE_POS);
    }
    else
    {
        /* ֹض¼DMA */
        SFR_CLR_BIT_ASM(ECCPx->ECCPXDE, ECCP_DE_CLSDE_POS);
    }
}

/**
  *   ͨ/ȽϵDMAʹλá
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       Channel: ͨѡȡֵΧΪ:
  *                  ECCP_CHANNEL_1: ͨ1
  *                  ECCP_CHANNEL_2: ͨ2
  *                  ECCP_CHANNEL_3: ͨ3
  *                  ECCP_CHANNEL_4: ͨ4
  *       NewState: ͨ/ȽϵDMAʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
ECCP_Channel_DMA_Enable (ECCP_SFRmap* ECCPx, uint32_t Channel,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCPX_DEĴCHxDEλ --------------------*/
    if (NewState != FALSE)
    {
        /* /ȽͨxDMA */
        ECCPx->ECCPXDE |= ECCP_DE_CH1DE << Channel;
    }
    else
    {
        /* ֹ/ȽͨxDMA */
        ECCPx->ECCPXDE &= ~(ECCP_DE_CH1DE << Channel);
    }
}

/**
  *   ȡECCPͨ׽/Ƚжϱ־
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       Channel: ͨѡȡֵΧΪ:
  *                  ECCP_CHANNEL_1: ͨ1
  *                  ECCP_CHANNEL_2: ͨ2
  *                  ECCP_CHANNEL_3: ͨ3
  *                  ECCP_CHANNEL_4: ͨ4
  *   ж״̬0δжϣ1ж
  */
FlagStatus
ECCP_Get_Channel_Trigger_INT_Flag (ECCP_SFRmap* ECCPx, uint32_t Channel)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));

    /*-------------------- ȡECCPXEGIFĴCCxIFλ --------------------*/
    tmpreg = ECCP_EGIF_CC1IF << Channel;
    if (ECCPx->ECCPXEGIF & tmpreg)
    {
        /* ж */
        return SET;
    }
    else
    {
        /* δж */
        return RESET;
    }
}

/**
  *   ȡض¼DMA־
  *   ATIMx: ָʱڴṹָ룬
  *              ȡֵT5_SFR/T9_SFR
  *   ж״̬0δжϣ1ж
  */
FlagStatus
ECCP_X_Get_Turn_off_DMA_Flag (ATIM_SFRmap* ATIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ATIMx));

    /*-------------------- ECCPX_DFĴCLSDFλ --------------------*/
    if (ATIMx->ECCPXDF & ECCP_DF_CLSDF)
    {
        /* ض¼DMA־ */
        return SET;
    }
    else
    {
        /* δض¼DMA־ */
        return RESET;
    }
}

/**
  *   ȡECCPͨ׽/ȽDMAжϱ־
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       Channel: ͨѡȡֵΧΪ:
  *                  ECCP_CHANNEL_1: ͨ1
  *                  ECCP_CHANNEL_2: ͨ2
  *                  ECCP_CHANNEL_3: ͨ3
  *                  ECCP_CHANNEL_4: ͨ4
  *   ж״̬0δжϣ1ж
  */
FlagStatus
ECCP_Get_Trigger_DMA_INT_Flag (ECCP_SFRmap* ECCPx, uint32_t Channel)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));

    /*-------------------- ȡECCPXEGIFĴCHxDFλ --------------------*/
    tmpreg = ECCP_DF_CH1DF << Channel;
    if (ECCPx->ECCPXDF & tmpreg)
    {
        /* ж */
        return SET;
    }
    else
    {
        /* δж */
        return RESET;
    }
}

/**
  *   ECCPxͨ׽/Ƚжϱ־
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       Channel: ͨѡȡֵΧΪ:
  *                  ECCP_CHANNEL_1: ͨ1
  *                  ECCP_CHANNEL_2: ͨ2
  *                  ECCP_CHANNEL_3: ͨ3
  *                  ECCP_CHANNEL_4: ͨ4
  *   ޡ
  */
void
ECCP_Clear_Channel_INT_Flag (ECCP_SFRmap* ECCPx, uint32_t Channel)
{
    uint32_t tmpreg = 0;
    uint32_t tmpreg1 = 0;
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL(Channel));

    /*-------------------- ECCPX_SRICĴCCxICλ --------------------*/
    tmpreg = ECCP_SRIC_CC1IC << Channel;
    tmpreg1 = ECCP_EGIF_CC1IF << Channel;
    ECCPx->ECCPXSRIC |= tmpreg;

    while((ECCPx->ECCPXEGIF & tmpreg1)>>(ECCP_EGIF_CC1IF_POS+Channel));

    ECCPx->ECCPXSRIC &= ~tmpreg;
}

/**
  *   PWMλƶʹλá
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       NewState: PWMλƶʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
ECCP_PWM_Move_Phase_Enable (ECCP_SFRmap* ECCPx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCPX_PxUDCTLĴPxMPENλ --------------------*/
    if (NewState != FALSE)
    {
        /* PWMԶƹ */
        SFR_SET_BIT_ASM(ECCPx->PXUDCTL, ECCP_PXUDCTL_PXMPEN_POS);
    }
    else
    {
        /* رPWMԶƹ */
        SFR_CLR_BIT_ASM(ECCPx->PXUDCTL, ECCP_PXUDCTL_PXMPEN_POS);
    }
}

/**
  *   ͨʱơ
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       Channel: ׽ͨѡȡֵΧΪ:
  *                  ECCP_CHANNEL_1: ͨ1
  *                  ECCP_CHANNEL_2: ͨ2
  *                  ECCP_CHANNEL_3: ͨ3
  *                  ECCP_CHANNEL_4: ͨ4
  *       NewState: ͨ/Ƚϵжʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
ECCP_Channel_Zero_Detect_Sequential_Ctl (ECCP_SFRmap* ECCPx, uint32_t Channel,
                    FunctionalState NewState)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCPX_ZPDCTL0ĴZPDyTWINλ --------------------*/
    tmpreg = NewState << (Channel + ECCP_ZPDCTL0_ZPD1TWIN_POS);
    ECCPx->ZPDCTL0 = SFR_Config (ECCPx->ZPDCTL0,
                          ~(ECCP_ZPDCTL0_ZPD1TWIN << Channel),
                          tmpreg);
}

/**
  *   ȡͨĸӦѹ״̬
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       Channel: ׽ͨѡȡֵΧΪ:
  *                  ECCP_CHANNEL_1: ͨ1
  *                  ECCP_CHANNEL_2: ͨ2
  *                  ECCP_CHANNEL_3: ͨ3
  *                  ECCP_CHANNEL_4: ͨ4
  *   ͨĸӦѹ״̬
  *       δ⵽Ӧѹ⵽0㣩1
  *       ⵽Ӧѹδ⵽0㣩0
  */
FlagStatus
ECCP_Get_Channel_Zero_Detection_State (ECCP_SFRmap* ECCPx,
                    uint32_t Channel)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL(Channel));

    /*--------------- ȡECCPX_ZPDCTL0ĴZPDyFLAGλ ---------------*/
    tmpreg = ECCP_ZPDCTL0_ZPD1FLAG << Channel;
    if (ECCPx->ZPDCTL0 & tmpreg)
    {
        /* δ⵽Ӧѹ⵽0㣩 */
        return SET;
    }
    else
    {
        /* ⵽Ӧѹδ⵽0㣩 */
        return RESET;
    }
}

/**
  *   ͨĸӦѹ״̬
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       Channel: ׽ͨѡȡֵΧΪ:
  *                  ECCP_CHANNEL_1: ͨ1
  *                  ECCP_CHANNEL_2: ͨ2
  *                  ECCP_CHANNEL_3: ͨ3
  *                  ECCP_CHANNEL_4: ͨ4
  *   ޡ
  */
void
ECCP_Clear_Channel_Zero_Detection_State (ECCP_SFRmap* ECCPx,
                    uint32_t Channel)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL(Channel));

    /*--------------- ECCPX_ZPDCTL0ĴZPDyFLAGλ ---------------*/
    tmpreg = ECCP_ZPDCTL0_ZPD1FLAG << Channel;
    ECCPx->ZPDCTL0 &= ~tmpreg;
}

/**
  *   ͨȽʹλ
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       Channel: ׽ͨѡȡֵΧΪ:
  *                  ECCP_CHANNEL_1: ͨ1
  *                  ECCP_CHANNEL_2: ͨ2
  *                  ECCP_CHANNEL_3: ͨ3
  *                  ECCP_CHANNEL_4: ͨ4
  *       NewState: ͨ/Ƚϵжʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
ECCP_Channel_Zero_Detect_Enable (ECCP_SFRmap* ECCPx, uint32_t Channel,
                    FunctionalState NewState)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- ECCPX_ZPDCTL1ĴZPDyENλ --------------------*/
    tmpreg = NewState << (Channel + ECCP_ZPDCTL1_ZPD1EN_POS);
    ECCPx->ZPDCTL1 = SFR_Config (ECCPx->ZPDCTL1,
                          ~(ECCP_ZPDCTL1_ZPD1EN << Channel),
                          tmpreg);
}

/**
  *   ͨѹѡλ
  *   ECCPx: ָECCP߼ʱڴṹָ룬
  *              ȡֵECCP5_SFR/ECCP9_SFR
  *       Channel: ׽ͨѡȡֵΧΪ:
  *                  ECCP_CHANNEL_1: ͨ1
  *                  ECCP_CHANNEL_2: ͨ2
  *                  ECCP_CHANNEL_3: ͨ3
  *                  ECCP_CHANNEL_4: ͨ4
  *       ZeroDetectVoltage: ͨѹȡֵΧΪ
  *                            ECCP_ZERO_VOLTAGE_DECIMAL_15: 0.15V
  *                            ECCP_ZERO_VOLTAGE_DECIMAL_25: 0.25V
  *                            ECCP_ZERO_VOLTAGE_DECIMAL_35: 0.35V
  *                            ECCP_ZERO_VOLTAGE_DECIMAL_45: 0.45V
  *                            ECCP_ZERO_VOLTAGE_DECIMAL_55: 0.55V
  *   ޡ
  */
void
ECCP_Channel_Zero_Voltage_Config (ECCP_SFRmap* ECCPx, uint32_t Channel,
                    uint32_t ZeroDetectVoltage)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_ATIM_PERIPH(ECCPx));
    CHECK_RESTRICTION(CHECK_ECCP_CHANNEL(Channel));
    CHECK_RESTRICTION(CHECK_ECCP_ZERO_VOLTAGE(ZeroDetectVoltage));

    /*-------------------- ECCPX_ZPDCTL1ĴZPDyENλ --------------------*/
    tmpreg = ZeroDetectVoltage \
             << (Channel * 3 + ECCP_ZPDCTL1_ZPD1S0_POS);
    ECCPx->ZPDCTL1 = SFR_Config (ECCPx->ZPDCTL1,
                          ~(ECCP_ZPDCTL1_ZPD1S << (Channel * 3)),
                          tmpreg);
}

/**
  *   ##### ǿͲ׽/Ƚ/PWM(ECCP)жϼ־ #####
  */

