/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : User_ADC.c                                        	  *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-12                                            *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This fiel provides template for single mode ADC.      *
 *  					KF32A156 provides most 3 adc modules				  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-12 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/


#include "system_init.h"
#include "User_ADC.h"


/*******************************************************************************
**                      	Global Functions 		             	      	  **
*******************************************************************************/
/**
 *  @brief : configuration adc GPIO.
 *  @param in :	None
 *  @param out :None
 *  @retval :None
 */
void adc_GPIO_init(void)
{
	GPIO_Write_Mode_Bits(GPIOD_SFR,GPIO_PIN_MASK_5,GPIO_MODE_AN);
}
/**
 *  @brief : ADC0 conversion completed at least once flag.
 *  @param in :	None
 *  @param out :FlagStatus:SET or RESET
 *  @retval :None
 */
FlagStatus Get_ADC0_Conersion_flag(void)
{
	if(ADC0_STATE&0x800)
	{
		return SET;
	}
	else
	{
		return RESET;
	}
}
/**
 *  @brief : clear ADC0 conversion completed flag.
 *  @param in :	None
 *  @param out :None
 *  @retval :None
 */
void Clear_ADC0_Conersion_flag(void)
{
	/*clear EOCIF*/
	ADC0_STATE&=~(uint32_t)0x1000;
}

/**
 *  @brief : configuration adc0.
 *  @param in :	ADC_CH_Num:ADC sampling chanel number
 *  @param out :Corresponding adc channel Conversion Value
 *  @retval :None
 */
uint16_t Get_ADC0_value(uint32_t ADC_CH_Num)
{
	/*get adc conversion value*/
	return(ADC_Get_Conversion_Value(ADC0_SFR));
}
/**
 *  @brief :GPIO initialize.
 *  @param in :	GPIOx : IO grop
 			    GpioPin:IO Pin
 *  @param out :None
 *  @retval :None
 */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);
	GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_RESET);

}
