/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : User_ADC.c                                        	  *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-12                                            *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This fiel provides template for single mode ADC.      *
 *  					KF32A156 provides most 3 adc modules				  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-12 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/


#include "system_init.h"
#include "User_ADC.h"


/*******************************************************************************
**                      	Global Functions 		             	      	  **
*******************************************************************************/
/**
 *  @brief : configuration adc GPIO.
 *  @param in :	None
 *  @param out :None
 *  @retval :None
 */
void adc_GPIO_init(void)
{
	GPIO_Write_Mode_Bits(GPIOD_SFR,GPIO_PIN_MASK_5,GPIO_MODE_AN);
}

/**
 *  @brief : configuration adc0.
 *  @param in :	ADC_CH_Num:ADC sampling chanel number
 *  @param out :Corresponding adc channel Conversion Value
 *  @retval :None
 */
uint16_t Get_ADC0_value(uint32_t ADC_CH_Num)
{
	ADC_Regular_Channel_Config(ADC0_SFR,ADC_CH_Num,01);
	/*software triger adc Conversion*/
	ADC_Software_Start_Conv(ADC0_SFR);
	/*wait for the adc conversion to complete*/
	while(!ADC_Get_INT_Flag(ADC0_SFR,ADC_INT_EOC)); 
	/*get adc conversion value*/
	return(ADC_Get_Conversion_Value(ADC0_SFR));
}
