/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : User_T1.c                                        	  *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-12                                            *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This fiel provides template for T1 trig single mode   *
 *  					ADC.                                                  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-12 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "system_init.h"
#include "User_T1.h"
/**
 *  @brief : Initialize Timer 1 and configuration Timer 1 interrupt.
 *  @param in :	None
 *  @param out :None
 *  @retval :None
 */
void Init_T1(void)
{
	 //	T1ʹ
	TIM_Reset(T1_SFR);//ʱ踴λʹʱ
	GPTIM_Updata_Immediately_Config(T1_SFR,TRUE);//¿   TxUR, ǿƸЧ˿̵ļĴ
	GPTIM_Updata_Enable(T1_SFR,TRUE);//øʹ   TXUDEN
	GPTIM_Work_Mode_Config(T1_SFR,GPTIM_TIMER_MODE);//ʱģʽѡ  TxCS
	GPTIM_Master_Mode_Config(T1_SFR,GPTIM_MASTER_TXIF_SIGNAL);//ģʽѡTXIFΪ
	GPTIM_Set_Counter(T1_SFR,0);//ʱֵ
	GPTIM_Set_Period(T1_SFR,0X1000);//ʱֵ
	GPTIM_Set_Prescaler(T1_SFR,0xFF);//ʱԤƵֵ
	GPTIM_Counter_Mode_Config(T1_SFR,GPTIM_COUNT_UP_DOWN_OUF);//-¼,жϱ־
	GPTIM_Clock_Config(T1_SFR,GPTIM_HFCLK);//ѡHFCLKʱ
	GPTIM_Overflow_INT_Enable(T1_SFR,TRUE);//жʹ
	GPTIM_Cmd(T1_SFR,TRUE);//ʱʹ
}
/**
 *  @brief : Configuration Timer 1 interrupt Priority and enable INT_T1.
 *  @param in :	None
 *  @param out :None
 *  @retval :None
 */
void Config_T1_Interrupt(void)
{
	/*Preempt priority 4, sub-priority 0**************************************/
 	INT_Interrupt_Priority_Config(INT_T1,4,0);
	/*enable INT_T1 IRQ*******************************************************/
 	INT_Interrupt_Enable(INT_T1,TRUE);
 	/*clear INT_T1 interrupt flag*********************************************/
 	INT_Clear_Interrupt_Flag(INT_T1);
}
