/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : main.c                                         	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This is a template project used by adc through T1 treg*
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "system_init.h"
#include "Usart.h"
#include "User_ADC.h"
#include "User_T1.h"

/* Private variables *********************************************************/
ADC_InitTypeDef ADC_InitStructure;
volatile uint16_t adc_Pd12_value;
uint8_t adc_Pd12_buf[2];

/* public variables ***********************************************************/
volatile uint8_t adc_trig_flag=0;

/*******************************************************************************
**                     			main Functions 		             	     	  **
*******************************************************************************/
int main()
{
	/*initialize system clock,defaut SCLK is 120M,select INTHF as Clock source*/
	SystemInit(120);
	GPIO_Write_Mode_Bits(GPIOA_SFR,GPIO_PIN_MASK_13,GPIO_MODE_AN);
	GPIO_Write_Mode_Bits(GPIOD_SFR,GPIO_PIN_MASK_12,GPIO_MODE_OUT);
	/*Initialize Timer 1 and configuration Timer 1 interrupt******************/
	Init_T1();
	Config_T1_Interrupt();
	/*ADC0 module configuration***********************************************/
	adc_GPIO_init();
	/*reset ADC0 module,enable ADC0 clock source******************************/
	ADC_Reset (ADC0_SFR);
	ADC_Struct_Init(&ADC_InitStructure);
	/*select HFCLK as the ADC0 sampling clock source***************************
	**You can also select SCLK or LFCLK as the ADC0 sampling clock************/
	ADC_InitStructure.m_Clock=ADC_HFCLK;
	/*ADC sampling clock Divider configuration********************************/
	ADC_InitStructure.m_ClockDiv = ADC_CLK_DIV_32;
	/*disable adc scan mode***************************************************/
	ADC_InitStructure.m_ScanMode = FALSE;
	/*select single adc sampling mode ****************************************/
	ADC_InitStructure.m_ContinuousMode = ADC_SINGLE_MODE;
	/*Right-aligned sampling result data *************************************/
	ADC_InitStructure.m_DataAlign = ADC_DATAALIGN_RIGHT;
	/*disable External trigger************************************************/
	ADC_InitStructure.m_ExternalTrig_EN = TRUE;
	/*t1 is used as the external trigger condition of the ADC regular channel*/
	ADC_InitStructure.m_ExternalTrig = ADC_EXTERNALTRIG_T1TRGO;
	/*select Vdd as ADC refrence voltage**************************************/
	ADC_InitStructure.m_VoltageRef=ADC_REF_AVDD;
	ADC_Configuration (ADC0_SFR, &ADC_InitStructure);
	/*enable adc0 moduel******************************************************/
	ADC_Cmd (ADC0_SFR, TRUE);
	/*initialize usart IO*****************************************************/
	UsartGpioInit();
	/*configuration usart .Baud:115200****************************************/
	USART_Async_config(USART0_SFR);
	/*sampling adc of PA13****************************************************/
	ADC_Regular_Channel_Config (ADC0_SFR, ADC_CHANNEL_72, 0x01);
	/*enable all interrupt****************************************************/
	INT_All_Enable (TRUE);

	while(1)
	{
		/*When timer T1 triggers adc0 interrupt, read the sample value of 
		adc0,and output through the serial port 0*****************************/
		if(adc_trig_flag)
		{
			adc_trig_flag=0;
			adc_Pd12_value=Get_ADC0_value();
			adc_Pd12_buf[0]=adc_Pd12_value&0xff;
			adc_Pd12_buf[1]=adc_Pd12_value>>8;
			USART_Send(USART0_SFR,adc_Pd12_buf,2);
		}
	}		
}
/**
 *  @brief : Reports the name of the source file and the source line number
 *           where the assert_param error has occurred.
 *  @param in :	file pointer to the source file name
 * 	@param in :	line assert_param error line source number
 *  @param out :None
 *  @retval :None
 */
void check_failed(uint8_t* File, uint32_t Line)
{
	/* User can add his own implementation to report the file name and line number,
		ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	/* Infinite loop */
	while(1)
	{
		;
	}
};
