/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : main.c                                         	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $Description$     : This is a KF32A156 device StdPeriph Template		  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
*                        		Include Files                                 *
******************************************************************************/
#include "system_init.h"
#include "Canfd.h"
static void Led_Gpio_Init(void);
static void Led_Flip(void);


static void Led_Gpio_Init(void)
{
/* 
CCP0CH1    PD12
CCP21CH3   PH3
ECCP5CH3H  PA4
EPWM13A    PF7
 */
	GPIO_Write_Mode_Bits(GPIOA_SFR, GPIO_PIN_MASK_4 , GPIO_MODE_OUT);
	GPIO_Write_Mode_Bits(GPIOD_SFR, GPIO_PIN_MASK_12 , GPIO_MODE_OUT);
	GPIO_Write_Mode_Bits(GPIOF_SFR, GPIO_PIN_MASK_7 , GPIO_MODE_OUT);
	GPIO_Write_Mode_Bits(GPIOH_SFR, GPIO_PIN_MASK_3 , GPIO_MODE_OUT);
}


/**
 *  @brief :
 *  @param in :None
 *  @param out :None
 *  @retval :None
 */
static void Led_Flip(void)
{
	GPIO_Toggle_Output_Data_Config(GPIOA_SFR, GPIO_PIN_MASK_4);
	GPIO_Toggle_Output_Data_Config(GPIOD_SFR, GPIO_PIN_MASK_12);
	GPIO_Toggle_Output_Data_Config(GPIOF_SFR, GPIO_PIN_MASK_7);
	GPIO_Toggle_Output_Data_Config(GPIOH_SFR, GPIO_PIN_MASK_3);
}


/*
 * 500K  BAUDRATE
 * */
int main()
{
	/* Initialize the system clock */
	SystemInit(120);
	/* Setup SysTick Timer as delay function */
	systick_delay_init(120);
	Canfd_Gpio_Init();
	Led_Gpio_Init();
	Can_m_FdControllerDeInit(CANfd6);
	Can_m_FdControllerInit(CANfd6, Canfd_Controller_AllConfig,Initindex_0);
	/*
	 * MAILBOX10 RECEIVE_MAILBOX ID:STD  0X100
	 *
	 * */
	Canfd_Sdu.Can_MailboxHeader[0].Id = 0x100;
	Canfd_Sdu.Can_MailboxHeader[0].Can_id = CAN_ID_STANDARD;
	Can_m_FdMailBox_Write(CANfd6, Mailbox_10,&Canfd_Sdu.Can_MailboxHeader[0]);
	/*
	 * MAILBOX11 RECEIVE_MAILBOX ID:STD  0X200
	 *
	 * */
	Canfd_Sdu.Can_MailboxHeader[0].Id = 0x200;
	Canfd_Sdu.Can_MailboxHeader[0].Can_id = CAN_ID_STANDARD;
	Can_m_FdMailBox_Write(CANfd6, Mailbox_11,&Canfd_Sdu.Can_MailboxHeader[0]);
	/*
	 * MAILBOX12 RECEIVE_MAILBOX ID:EXD  0x3860000
	 *
	 * */
	Canfd_Sdu.Can_MailboxHeader[0].Id = 0x3860000;
	Canfd_Sdu.Can_MailboxHeader[0].Can_id = CAN_ID_EXTENDED;
	Can_m_FdMailBox_Write(CANfd6, Mailbox_12,&Canfd_Sdu.Can_MailboxHeader[0]);
	/*
	 * MAILBOX13 RECEIVE_MAILBOX ID:EXD  0X3860100
	 *
	 * */
	Canfd_Sdu.Can_MailboxHeader[0].Id = 0x3860100;
	Canfd_Sdu.Can_MailboxHeader[0].Can_id = CAN_ID_EXTENDED;
	Can_m_FdMailBox_Write(CANfd6, Mailbox_13,&Canfd_Sdu.Can_MailboxHeader[0]);

	while (1)
	{
		/*
		 * MAILBOX14 TRANSMIT_MAILBOX
		 *
		 * */
		Canfd_Sdu.Can_MailboxHeader[0].Id = 0x555;
		Canfd_Sdu.Can_MailboxHeader[0].Can_id = CAN_ID_STANDARD;
		Canfd_Sdu.Can_MailboxHeader[0].TransceiveType = MAIL_TRANSMIT;

		if(Can_m_FdMailBox_Write(CANfd6,Mailbox_14,&Canfd_Sdu.Can_MailboxHeader[0]) == CAN_OK)
		{
			if(Can_m_FdTransmitonce(CANfd6) != CAN_OK)
			{
				Can_m_FdTransmiterrorHandler();
			}
			systick_delay_ms(200);
			Led_Flip();
		}
	}
}








