/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : system_init.h                                         *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file contains the Header file configuration 	  *
 * 						for KF32A156 device                                  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/
#ifndef _CAN_H_
#define _CAN_H_
/******************************************************************************
**                       	Include Files                                     *
******************************************************************************/
#include <stdint.h>
#include "kf32a156_can.h"

/******************************************************************************
*                        Configuration definition                             *
******************************************************************************/
#define BAUDRATE100K    (0U)
#define BAUDRATE250K    (1U)
#define BAUDRATE500K    (2U)

#define BAUDRATE    BAUDRATE500K

/******************************************************************************
*                        Type  definitions                                    *
******************************************************************************/
#define INTERRUPT_ENABLE   1
#define INTERRUPT_DISABLE  0


typedef struct
{
	CAN_MessageTypeDef CAN_Message[64];
	uint8_t Frame_length;
}Can_Pdu_TypeDef;

typedef enum
{
    Can_OK,
    Can_NOK,
} Can_Return_Type;

typedef struct
{
	uint32_t CAN_TRANSMIT_INTERRUPT;
	uint32_t CAN_RECEIVE_INTERRUPT;
	uint32_t CAN_OVERFLOW_INTERRUPT;
	uint32_t CAN_BUSERROR_INTERRUPT;
	uint32_t CAN_BUSOFF_INTERRUPT;
	uint32_t CAN_ERRORNEGATIVE_INTERRUPT;
}Can_Interrupt_Type;

/******************************************************************************
*                      Functional definition                                 *
******************************************************************************/
void CAN_Gpio_Init(void);
void CAN_Init(CAN_SFRmap* CANx, CAN_InitTypeDef* canInitStruct);
Can_Return_Type CAN_Transmit_Message_Once(volatile CAN_MessageTypeDef *CAN_Message);
Can_Return_Type CAN_Transmit_Message_Repeat(volatile CAN_MessageTypeDef *CAN_Message);
Can_Return_Type CAN_Receive_Message(volatile Can_Pdu_TypeDef* Pdu);
Can_Return_Type CAN_Int_Config(Can_Interrupt_Type *Can_Interrupt);
#endif

