#include "LoopFifo.h"

extern CAN_MessageTypeDef  CAN_MessageR[100];
/*********************************************************************************************************
   Init FIFO
*********************************************************************************************************/
void Fifo_Init(LPFifo_TypeDef *pFifo,uint32_t VarLen)
{
//	pFifo -> Ptr	= (VarType *)malloc(VarLen * sizeof(VarType));
	pFifo -> Ptr	=  &CAN_MessageR[0];
	pFifo -> Size	= VarLen;
    pFifo -> Head	= 0;
    pFifo -> Tail	= 0;	
	pFifo -> Len	= 0;
}


/*********************************************************************************************************
	Deinit FIFO
*********************************************************************************************************/
tBool Fifo_DeInit(LPFifo_TypeDef *pFifo)
{
	if(pFifo -> Len == 0)
	{
		return True;
	}
	else 
		return False;
}



/*********************************************************************************************************
	Check FIFO  Message Number
*********************************************************************************************************/
uint32_t Check_FifoMessageNumber(LPFifo_TypeDef *pFifo)
{
	return pFifo->Len;
}


/*********************************************************************************************************
    Check FIFO State
*********************************************************************************************************/
tBool Fifo_IsFull(LPFifo_TypeDef *pFifo)
{
	tBool ret = Undifined;
    if(pFifo -> Len == pFifo ->Size)
    {
    	ret = True;
    }else
    {
    	ret = False;
    }
    return ret;
}


/*********************************************************************************************************
    Check FIFO State
*********************************************************************************************************/
tBool Fifo_IsEmpty(LPFifo_TypeDef *pFifo)
{
	tBool ret = Undifined;
    if(pFifo -> Len == 0)
    {
    	ret = True;
    }else
    {
    	ret = False;
    }
    return ret;
}


/*********************************************************************************************************
	Write Infor to FIFO
*********************************************************************************************************/
void Fifo_Write(LPFifo_TypeDef *pFifo,VarType Var)
{
	asm("DSI");
    *(pFifo -> Ptr + pFifo -> Head) = Var;
    pFifo -> Head = (pFifo -> Head + 1) % pFifo -> Size;
    pFifo -> Len ++;
    asm("ENI");
}


/*********************************************************************************************************
	Read Infor From FiFO
*********************************************************************************************************/
VarType Fifo_Read(LPFifo_TypeDef *pFifo)
{
	VarType ReceiveData;
	asm("DSI");
    ReceiveData = *(pFifo -> Ptr + pFifo -> Tail);
	pFifo -> Tail = (pFifo -> Tail + 1) % (pFifo -> Size);
	pFifo -> Len --;
    asm("ENI");
    return ReceiveData;
}



