/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : main.c                                         	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file provides a routine for CCP compare mode     *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "system_init.h"

/*******************************************************************************
**                      	Global Functions 		             	      	  **
*******************************************************************************/
/**
 *  @brief: GPIOx output initialization configuration
 *  @param in: GPIOx
 * 			   GpioPin
 *  @param out : None
 *  @retval : None
 */
void GPIOInit_Output_Config(GPIO_SFRmap *GPIOx, uint16_t GpioPin)
{
	/* Configure Pxy as output mode parameter */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	/* Initialize GPIO output speed */
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;
	/* Initialize GPIO direction as output */
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;
	/* Initialize whether the GPIO is pulled up */
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;
	/* Initialize whether the GPIO is pulled down */
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;

	GPIO_Configuration(GPIOx, &GPIO_InitStructure);

	/* Initialized to high level */
	GPIO_Set_Output_Data_Bits(GPIOx, GpioPin, Bit_SET);
}

/**
 *  @brief: The CCPx capture function configures the initialization parameters.
 *  @param in: CCPx Pointer to CCP or general timer memory structure
 *  @param out : None
 *  @retval : None
 */
void CCPx_Compare_Mode_init(CCP_SFRmap *CCPx)
{
	/* Set the prescaler value of the timer and the mode of the capture channel */
	/* Timer peripheral reset, enable peripheral clock */
	TIM_Reset(CCPx);

	/* Configure CCPx to compare mode, the output level is inverted during comparison match*/
	CCP_Compare_Mode_Config(CCPx, CCP_CHANNEL_1, CCP_CMP_TOGGLE_LEVEL);
	/* Configure CCPx compare register */
	CCP_Set_Compare_Result(CCPx, CCP_CHANNEL_1, 0x8000);

	/* Update control now */
	GPTIM_Updata_Immediately_Config(CCPx, TRUE);
	/* Configuration update enable */
	GPTIM_Updata_Enable(CCPx, TRUE);
	/* Timing mode selection */
	GPTIM_Work_Mode_Config(CCPx, GPTIM_TIMER_MODE);
	/* Timer count value */
	GPTIM_Set_Counter(CCPx, 0);
	/* Timer period value */
	GPTIM_Set_Period(CCPx, 0XF000);
	/* Timer prescaler value */
	GPTIM_Set_Prescaler(CCPx, 15);
	/* Up-down counting, overflow and underflow generate interrupt flags */
	GPTIM_Counter_Mode_Config(CCPx, GPTIM_COUNT_UP_OF);
	/* Configure working clock  */
	GPTIM_Clock_Config(CCPx, GPTIM_SCLK);

	/* Timer start control enable */
	GPTIM_Cmd(CCPx, TRUE);
}
/*******************************************************************************
**                     			main Functions 		             	     	  **
*******************************************************************************/
int main()
{
	/* System clock configuration */
	SystemInit(120);

	/* Initialize led lights */
	GPIOInit_Output_Config(GPIOD_SFR, GPIO_PIN_MASK_12);

	/* PG8 remap tp capture mode */
	GPIO_Write_Mode_Bits(GPIOG_SFR, GPIO_PIN_MASK_8, GPIO_MODE_RMP);
	GPIO_Pin_RMP_Config(GPIOG_SFR, GPIO_Pin_Num_8, GPIO_RMP_AF2);

	/* CCP18 channel 1 and channel 2 Capture mode initialization, Configure 
	   channel 1 trigger source*/
	CCPx_Compare_Mode_init(CCP18_SFR);

	/* Wait match successfully  */
	while (CCP_Get_Channel_Trigger_INT_Flag(CCP18_SFR, CCP_CHANNEL_1))
	{
		/* Clear interrupt flag */
		CCP_Clear_Channel_INT_Flag(CCP18_SFR, CCP_CHANNEL_1);
		/* Update timer period value */
		GPTIM_Set_Period(T18_SFR, 0xF000);
	}

	while (1)
	{
	}
}

/**
 *  @brief : Reports the name of the source file and the source line number
 *           where the assert_param error has occurred.
 *  @param in :	file pointer to the source file name
 * 	@param in :	line assert_param error line source number
 *  @param out :None
 *  @retval :None
 */
void check_failed(uint8_t *File, uint32_t Line)
{
	/* User can add his own implementation to report the file name and line number,
		ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	/* Infinite loop */
	while (1)
	{
		;
	}
};
