/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : main.c                                         	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file provides a routine for CCP PWM mode         *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "system_init.h"

/*******************************************************************************
**                      	Private Macro Definitions                         **
*******************************************************************************/
/* Edge aligned PWM signal */
#define PWM_Edge_Out (0U)
/* Center aligned PWM signal */
#define PWM_Center_Out (1U)

/* PWM signal mode control */
#define CCP_PWM_WORK (PWM_Edge_Out)
/*******************************************************************************
**                     			Global Functions 		             	      **
*******************************************************************************/
/**
 *  @brief: PWM output function initialization parameters.
 *  @param in: CCPx
 * 			   Channel
 * 			   Period
 * 			   Duty
 *  @param out : None
 *  @retval : None
 */
void CCPx_PWM_PPX_Duty(CCP_SFRmap *CCPx, uint32_t Channel, uint16_t Period, uint16_t Duty)
{
	/* Timer peripheral reset, enable peripheral clock */
	TIM_Reset(CCPx);
	/* PWM function channel mode */
	CCP_PWM_Mode_Config(CCPx, Channel, CCP_PWM_MODE);
	/* Configure CCP channel output to control PWM output, high effective */
	CCP_Channel_Output_Control(CCPx, Channel, CCP_CHANNEL_OUTPUT_PWM_ACTIVE);
	/* PWM duty cycle */
	CCP_Set_Compare_Result(CCPx, Channel, Duty);

	/* Update control now */
	GPTIM_Updata_Immediately_Config(CCPx, TRUE);
	/* Configuration update enable */
	GPTIM_Updata_Enable(CCPx, TRUE);
	/* Timing mode selection */
	GPTIM_Work_Mode_Config(CCPx, GPTIM_TIMER_MODE);
	/* Timer count value */
	GPTIM_Set_Counter(CCPx, 0);
	/* Timer period value */
	GPTIM_Set_Period(CCPx, Period);
	/* Timer prescaler value */
	GPTIM_Set_Prescaler(CCPx, 118);

#if CCP_PWM_WORK == PWM_Edge_Out
	/* Up-counting mode, that is, edge-aligned PWM signal */
	GPTIM_Counter_Mode_Config(CCPx, GPTIM_COUNT_UP_OF);
#else
	/* Up and down counting mode, that is, center-aligned PWM signal */
	GPTIM_Counter_Mode_Config(CCPx, GPTIM_COUNT_UP_DOWN_OF);
#endif
    /* Configure working clock */
	GPTIM_Clock_Config(CCPx, GPTIM_SCLK); 
    /* Enable timer */
	GPTIM_Cmd(CCPx, TRUE);				  
}
/*******************************************************************************
**                     			main Functions 		             	     	  **
*******************************************************************************/
int main()
{
	/* System clock configuration */
	SystemInit(120);

	/* Configure PWM output IO port */
	GPIO_Write_Mode_Bits(GPIOG_SFR, GPIO_PIN_MASK_8, GPIO_MODE_RMP);
	GPIO_Pin_RMP_Config(GPIOG_SFR, GPIO_Pin_Num_8, GPIO_RMP_AF2);

    /* PWM mode related configuration */
	CCPx_PWM_PPX_Duty(CCP18_SFR, CCP_CHANNEL_1, 1000, 500); 
	while (1)
		;
}

/**
 *  @brief : Reports the name of the source file and the source line number
 *           where the assert_param error has occurred.
 *  @param in :	file pointer to the source file name
 * 	@param in :	line assert_param error line source number
 *  @param out :None
 *  @retval :None
 */
void check_failed(uint8_t *File, uint32_t Line)
{
	/* User can add his own implementation to report the file name and line number,
		ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	/* Infinite loop */
	while (1)
	{
		;
	}
};
