/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : main.c                                         	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file provides a routine for ECCPx capture mode   *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "system_init.h"

/* Capture the PWM duty cycle variable */
volatile uint16_t UP_PLUSE_WIDTH = 0;
/*******************************************************************************
**                      	Global Functions 		             	      	  **
*******************************************************************************/
/**
 *  @brief: Delay time
 *  @param in: nms
 *  @param out : None
 *  @retval : None
 */
void delay_ms(volatile uint32_t nms)
{
	volatile uint32_t i, j;
	for (i = 0; i < nms; i++)
	{
		j = 5000;
		while (j--)
			;
	}
}

/**
 *  @brief: GPIOx output initialization configuration
 *  @param in: GPIOx
 * 			   GpioPin
 *  @param out : None
 *  @retval : None
 */
void GPIOInit_Output_Config(GPIO_SFRmap *GPIOx, uint16_t GpioPin)
{
	/* Configure Pxy as output mode parameter */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	/* Initialize GPIO output speed */
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;
	/* Initialize GPIO direction as output */
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;
	/* Initialize whether the GPIO is pulled up */
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;
	/* Initialize whether the GPIO is pulled down */
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;

	GPIO_Configuration(GPIOx, &GPIO_InitStructure);

	/* Initialized to high level */
	GPIO_Set_Output_Data_Bits(GPIOx, GpioPin, Bit_SET);
}

/**
 *  @brief: The ECCPx capture function configures the initialization parameters.
 *  @param in: ECCPx Pointer to ECCP or general timer memory structure
 *  @param out : None
 *  @retval : None
 */
void ECCPx_Capture_Mode_init(ECCP_SFRmap *ECCPx)
{
	/* Set the prescaler value of the timer and the mode of the capture channel */
	/* Timer peripheral reset, enable peripheral clock */
	TIM_Reset(ECCPx);
	/* Set slave mode: reset mode */
	ATIM_X_Slave_Mode_Config(ECCPx, ATIM_SLAVE_RESET_MODE);
	/* Select the trigger source : CH1 */
	ATIM_Trigger_Select_Config(ECCPx, ATIM_TRIGGER_ECCPXCH1);
	/* Set the capture channel mode: capture every rising edge */
	ECCP_Capture_Mode_Config(ECCPx, ECCP_CHANNEL_1, ECCP_CAP_RISING_EDGE);

	/* Immediately update the output control register with Tx as the time base */
	ATIM_X_Updata_Output_Ctl(ECCPx, TRUE);
	/* Update control immediately */
	ATIM_X_Updata_Immediately_Config(ECCPx, TRUE);
	/* Configuration update enable */
	ATIM_X_Updata_Enable(ECCPx, TRUE);
	/* Timing mode selection */
	ATIM_X_Work_Mode_Config(ECCPx, ATIM_TIMER_MODE);
	/* Timer count value */
	ATIM_X_Set_Counter(ECCPx, 0);

	/* Timer prescaler value The prescaler is 119+1=120, the main clock is 120M, 
	   1us counts once */
	ATIM_X_Set_Prescaler(ECCPx, 119);
	/* Up, overflow generates an interrupt flag */
	ATIM_X_Counter_Mode_Config(ECCPx, ATIM_COUNT_UP_OF);
	/* Select SCLK as the timer clock source */
	ATIM_X_Clock_Config(ECCPx, ATIM_SCLK);
	/* Enable general timer */
	ATIM_X_Cmd(ECCPx, TRUE);
}
/*******************************************************************************
**                     			main Functions 		             	     	  **
*******************************************************************************/
int main()
{
	/* System clock configuration */
	SystemInit(120);

	/* Initialize led lights */
	GPIOInit_Output_Config(GPIOD_SFR, GPIO_PIN_MASK_12);

	/* PB0 remap tp capture mode */
	GPIO_Write_Mode_Bits(GPIOB_SFR, GPIO_PIN_MASK_0, GPIO_MODE_RMP);
	GPIO_Pin_RMP_Config(GPIOB_SFR, GPIO_Pin_Num_0, GPIO_RMP_AF8);

	/* ECCP5 channel 1H Capture mode initialization, Configure 
	   channel 1H trigger source*/
	ECCPx_Capture_Mode_init(ECCP5_SFR);

	while (1)
	{
		delay_ms(200);
		delay_ms(200);

		/* Capture duty cycle */
		UP_PLUSE_WIDTH = ECCP_Get_Capture_Result(ECCP5_SFR, ECCP_CHANNEL_1);
		/* 1KHZ PWM signal, duty cycle is 50% */
		if ((UP_PLUSE_WIDTH > 980) && (UP_PLUSE_WIDTH < 1020))
		{
			GPIO_Toggle_Output_Data_Config(GPIOD_SFR, GPIO_PIN_MASK_12);
		}
	}
}

/**
 *  @brief : Reports the name of the source file and the source line number
 *           where the assert_param error has occurred.
 *  @param in :	file pointer to the source file name
 * 	@param in :	line assert_param error line source number
 *  @param out :None
 *  @retval :None
 */
void check_failed(uint8_t *File, uint32_t Line)
{
	/* User can add his own implementation to report the file name and line number,
		ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	/* Infinite loop */
	while (1)
	{
		;
	}
};
