/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : main.c                                         	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : Provide the operation interface of data area flash,   *
 * 						including reading, erasing, page writing, byte 		  *
 * 						writing, comparison and other functions		  		  *	
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "system_init.h"
#include "Usart.h"
#include "stdio.h"
#include "Flash.h"
#include "ChipMessageApi.h"

/*******************************************************************************
**                      	Private Macro Definitions                         **
*******************************************************************************/
#define FlashDataSize 				512
#define FlashInformationDataSize	257
/******************************************************************************
**                   	Private variables  Definitions                       **
******************************************************************************/
/* Flash Data buffer */
uint32_t FlashDataBuffer[FlashDataSize];
uint32_t FlashInformationDataBuffer[FlashInformationDataSize];
uint8_t FlashEEDataBuffer[] = {
	0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0};
	/*******************************************************************************
**                     		   Global Functions 		             	      **
*******************************************************************************/
	/**
 *  @brief :Initializes the GPIO of the Usart
 *  @param in :None
 *  @param out :None
 *  @retval :PA3 -- USART0_TX0
 *           PE7 -- USART0_RX
 */
	void
	Usart_Gpio_Init(void)
{
	GPIO_InitTypeDef GPIO_InitStructure;
	/*
   *  Configure PA3 remap mode
   *  as TX pin
   */
	GPIO_InitStructure.m_Mode = GPIO_MODE_RMP;
	GPIO_InitStructure.m_OpenDrain = GPIO_POD_PP;
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;
	GPIO_InitStructure.m_Pin = GPIO_PIN_MASK_3;
	GPIO_Configuration(GPIOA_SFR, &GPIO_InitStructure);
	/*
   * Configure PE7 remap mode
   * as RX pin
   * Configured in pull-up mode
   */
	GPIO_InitStructure.m_PullUp = GPIO_PULLUP;
	GPIO_InitStructure.m_Pin = GPIO_PIN_MASK_7;
	GPIO_Configuration(GPIOE_SFR, &GPIO_InitStructure);
	/* Configure PA3 remap function to AF3 */
	GPIO_Pin_RMP_Config(GPIOA_SFR, GPIO_Pin_Num_3, GPIO_RMP_AF3);
	/* Configure PE17 remap function to AF3 */
	GPIO_Pin_RMP_Config(GPIOE_SFR, GPIO_Pin_Num_7, GPIO_RMP_AF3);
}

/*******************************************************************************
**                     			main Functions 		             	     	  **
*******************************************************************************/
int main()
{
	uint32_t i, FlashRetVal;
	/* Initialize the system clock is 120M */
	SystemInit(120);
	/* Setup SysTick Timer as delay function, and input frequency is 120M */
	systick_delay_init(120);
	/* Initialize the USART IOs */
	Usart_Gpio_Init();
	/* USARTx configured as follow:
		- BaudRate = 115200 baud
		- Word Length = 8 Bits
		- One Stop Bit
		- No parity
		- Hardware flow control disabled (RTS and CTS signals)
		- Receive and transmit enabled
	 */
	USART_Async_config(USART0_SFR);
	/* Get the MCU Unique ID */
	printf("START Flash Read And WRite Example\r\n");
	if (__getChipUniqueSerialNumber(FlashDataBuffer) == CMD_SUCCESS)
	{
		for (i = 0; i < 4; i++)
		{
			printf("MCU UniqueID[%d] is 0x%x \r\n", i, FlashDataBuffer[i]);
		}
	}
	/* Read from 0x20000 address to 'FlashDataSize' data */
	FlashReadNByte(0x20000, FlashDataSize * sizeof(FlashDataBuffer[0]), (uint8_t *)FlashDataBuffer);
	printf("Read address 0x20000\r\n");
	for (i = 0; i < FlashDataSize; i++)
	{
		printf("%d 0x%x\t", i, FlashDataBuffer[i]);
	}
	printf("\r\n\r\n");
	/* Prepare data */
	for (i = 0; i < FlashDataSize; i++)
	{
		FlashDataBuffer[i] = i;
	}
	/* First erase and then write. The interrupt is closed inside the function, and then recover */
	/* Write 'FlashDataBuffer' to address 0x20000 about 2K data */
	FlashRetVal = FlashWriteNKBytes(0x20000, 2048, (uint8_t *)FlashDataBuffer);
	if (FlashRetVal == CMD_SUCCESS)
	{
		printf("Write 2 Kbytes success\r\n\r\n");
	}
	/* Write 'FlashDataBuffer' to address 0x30005 about 10 byte */
	FlashRetVal = FlashEEWriteNBytes(0x30005, 10, FlashEEDataBuffer);
	if (FlashRetVal == CMD_SUCCESS)
	{
		printf("Write Byte success\r\n\r\n");
	}

	/* Prepare data */
	for (i = 0; i < FlashInformationDataSize; i++)
	{
		FlashInformationDataBuffer[i] = i;
	}
	/* Write 'FlashDataBuffer' to Flash date area (address 0x1C00) about 1K data */
	printf("Write Flash date area ,address 0x1C00\r\n");
	FlashRetVal = FlashCFGUserWrite(0x1C00, 1024, FlashInformationDataBuffer);
	if (FlashRetVal == CMD_SUCCESS)
	{
		printf("Write 1Kbytes success\r\n\r\n");
	}
	/* Read from Flash date area (address 0x1C00)  to 'FlashDataBuffer' data */
	printf("Read Flash date area ,address 0x1C00\r\n");
	FlashRetVal = FlashCFGUserRead(0x1C00, 1024, FlashInformationDataBuffer);
	for (i = 0; i < 257; i++)
	{
		printf("%d 0x%x\t", i, FlashInformationDataBuffer[i]);
	}
	printf("\r\n\r\n");

	while (1)
	{

	}
}

/**
 *  @brief : Reports the name of the source file and the source line number
 *           where the assert_param error has occurred.
 *  @param in :	file pointer to the source file name
 * 	@param in :	line assert_param error line source number
 *  @param out :None
 *  @retval :None
 */
void check_failed(uint8_t *File, uint32_t Line)
{
	/* User can add his own implementation to report the file name and line number,
		ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	/* Infinite loop */
	while (1)
	{
		;
	}
};
