/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : main.c                                         	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file provides a routine for use I2C as Master in *
 *                      interrupt mode                                        * 
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "main.h"

/*******************************************************************************
**                      	Private Macro Definitions                         **
*******************************************************************************/

/*******************************************************************************
**                     			Global Functions 		             	      **
*******************************************************************************/
/**
 *  @brief: Delay time 
 *  @param in: 
 *  @param out : None
 *  @retval : None
 */
void delay_ms(volatile uint32_t nms)
{
	volatile uint32_t i, j;
	for (i = 0; i < nms; i++)
	{
		j = 2000;
		while (j--)
			;
	}
}

/**
 *  @brief: GPIOx output initialization configuration
 *  @param in: GPIOx
 * 			   GpioPin
 *  @param out : None
 *  @retval : None
 */
void GPIOInit_Output_Config(GPIO_SFRmap *GPIOx, uint16_t GpioPin)
{
	/* Configure Pxy as output mode parameter */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	/* Initialize GPIO output speed */
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;
	/* Initialize GPIO direction as output */
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;
	/* Initialize whether the GPIO is pulled up */
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;
	/* Initialize whether the GPIO is pulled down */
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;

	GPIO_Configuration(GPIOx, &GPIO_InitStructure);

	/* Initialized to high level */
	GPIO_Set_Output_Data_Bits(GPIOx, GpioPin, Bit_SET);
}

/*******************************************************************************
**                     			main Functions 		             	     	  **
*******************************************************************************/
int main()
{
	/* System clock configuration */
	SystemInit(120);

	/* LED control */
	GPIOInit_Output_Config(GPIOD_SFR, GPIO_PIN_MASK_12);
	/* Configure IO */
	I2c_IO_Init();

	/* I2C initialization */
	I2c_Init(I2C0_SFR);

	/* I2C interrupt initialization */
	I2c_Interrupt_Init();

	while (1)
	{
		/* Delay time */
		delay_ms(200);

		/* Send data */
		/* Enable I2C HW module*/
		I2C_Cmd(I2C0_SFR, TRUE);
		/* Clear interrupt flag ISIF */
		I2C_Clear_INTERRUPT_Flag(I2C0_SFR);

		/* Start bit */
		I2C_Generate_START(I2C0_SFR, TRUE);

		/* Wait stop */
		while(!I2C_Get_Stop_Flag(I2C0_SFR));
		/* Clear interrupt flag */
		I2C_Clear_INTERRUPT_Flag(I2C0_SFR);
        I2C_Clear_Stop_Flag(I2C0_SFR);
		
        /* Stop I2C module */
        I2C_Cmd(I2C0_SFR, FALSE);
        delay_ms(200);
		GPIO_Toggle_Output_Data_Config(GPIOD_SFR, GPIO_PIN_MASK_12);
	}
}

/**
 *  @brief : Reports the name of the source file and the source line number
 *           where the assert_param error has occurred.
 *  @param in :	file pointer to the source file name
 * 	@param in :	line assert_param error line source number
 *  @param out :None
 *  @retval :None
 */
void check_failed(uint8_t *File, uint32_t Line)
{
	/* User can add his own implementation to report the file name and line number,
		ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	/* Infinite loop */
	while (1)
	{

	};
};
