/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : main.c                                         	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file provides a routine for use I2C as Master    *
 *                      polling mode                                          * 
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "main.h"

/*******************************************************************************
**                      	Private Macro Definitions                         **
*******************************************************************************/

/*******************************************************************************
**                      	Private Variables Definitions                  	  **
*******************************************************************************/
uint8_t i2c_buffer_write[] = {
	0X5A, 0X22, 0X33, 0X44, 0X66, 0X77, 0X88, 0X99, 0XAA, 0XBB,
	0X01, 0X02, 0X03, 0X04, 0X05, 0X06, 0X07, 0X08, 0X09, 0X10,
	0X11, 0X12, 0X13, 0X14, 0X15, 0X16, 0X17, 0X18, 0X19, 0X20,
	0X21, 0X22, 0X23, 0X24, 0X25, 0X26, 0X27, 0X28, 0X29, 0X30,
	0X31, 0X32, 0X33, 0X34, 0X35, 0X36, 0X37, 0X38, 0X39, 0X40,
	0X41, 0X42, 0X43, 0X44, 0X45, 0X46, 0X47, 0X48, 0X49, 0X50,
	0X51, 0X52, 0X53, 0XA5};
uint8_t i2c_Read_buffer[64];
/* Wait Ack time out flag */
extern volatile uint8_t AckTimeoutFlag;
/*******************************************************************************
**                     			Global Functions 		             	      **
*******************************************************************************/
/**
 *  @brief: Delay time 
 *  @param in: 
 *  @param out : None
 *  @retval : None
 */
void delay_ms(volatile uint32_t nms)
{
	volatile uint32_t i, j;
	for (i = 0; i < nms; i++)
	{
		j = 2000;
		while (j--)
			;
	}
}

/**
 *  @brief: GPIOx output initialization configuration
 *  @param in: GPIOx
 * 			   GpioPin
 *  @param out : None
 *  @retval : None
 */
void GPIOInit_Output_Config(GPIO_SFRmap *GPIOx, uint16_t GpioPin)
{
	/* Configure Pxy as output mode parameter */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	/* Initialize GPIO output speed */
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;
	/* Initialize GPIO direction as output */
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;
	/* Initialize whether the GPIO is pulled up */
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;
	/* Initialize whether the GPIO is pulled down */
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;

	GPIO_Configuration(GPIOx, &GPIO_InitStructure);

	/* Initialized to high level */
	GPIO_Set_Output_Data_Bits(GPIOx, GpioPin, Bit_SET);
}

/*******************************************************************************
**                     			main Functions 		             	     	  **
*******************************************************************************/
int main()
{
	/* System clock configuration */
	SystemInit(120);

	/* LED1 control */
	GPIOInit_Output_Config(GPIOD_SFR, GPIO_PIN_MASK_12);
	GPIOInit_Output_Config(GPIOA_SFR, GPIO_PIN_MASK_4);
	GPIO_Set_Output_Data_Bits(GPIOA_SFR, GPIO_PIN_MASK_4, Bit_RESET);

	/* Configure IO */
	I2c_IO_Init();

	/* I2C initialization */
	I2c_Init(I2C0_SFR);

	while (1)
	{
		/* Delay time */
		delay_ms(200);

#if (I2C_ADDRESS_WIDTH == I2C_10BIT)
		/* Ten-digit address sending */
		I2C_Buffer_write(I2C_SLAVE_ADDR10B, i2c_buffer_write, sizeof(i2c_buffer_write));
#else
		/* Seven-digit address transmission  */
		I2C_Buffer_write(I2C_SLAVE_ADDR, i2c_buffer_write, sizeof(i2c_buffer_write));

#endif
		GPIO_Toggle_Output_Data_Config(GPIOD_SFR, GPIO_PIN_MASK_12);

		/* Determine whether to wait for a timeout */
		if (AckTimeoutFlag == 1)
		{
			GPIO_Set_Output_Data_Bits(GPIOA_SFR, GPIO_PIN_MASK_4, Bit_SET);
			AckTimeoutFlag = 0;
		}
		else
		{
			GPIO_Set_Output_Data_Bits(GPIOA_SFR, GPIO_PIN_MASK_4, Bit_RESET);
		}
	}
}

/**
 *  @brief : Reports the name of the source file and the source line number
 *           where the assert_param error has occurred.
 *  @param in :	file pointer to the source file name
 * 	@param in :	line assert_param error line source number
 *  @param out :None
 *  @retval :None
 */
void check_failed(uint8_t *File, uint32_t Line)
{
	/* User can add his own implementation to report the file name and line number,
		ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	/* Infinite loop */
	while (1)
	{
		;
	}
};
