/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : kf32a156_crc.c                                	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-08                                            *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file provides the Cyclic Redundancy Check (CRC)  *
 *  				    peripherals function                                  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "kf32a156_crc.h"
#include "kf32a156_rst.h"
#include "kf32a156_pclk.h"


/*******************************************************************************
**                         (CRC) module private definition       		      **
*******************************************************************************/

/* CRC_CTLĴ */
#define CRC_CTL_INIT_MASK               (CRC_CTL_RSLTREV \
                                       | CRC_CTL_DATAREV \
                                       | CRC_CTL_DATASIZE \
                                       | CRC_CTL_RSET)

/**
  *   ##### ʼú #####
  */
/**
  *  CRC踴λʹʱӡ
  *   : 
  *   ޡ
  */
void
CRC_Reset ()
{
	RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_CRCRST, TRUE);
	RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_CRCRST, FALSE);
	PCLK_CTL3_Peripheral_Clock_Enable(PCLK_CTL3_CRCCLKEN, TRUE);
}

/**
  *   CRCá
  *   CRCx: CRCInitStruct: CRCϢ
  *   ޡ
  */
void
CRC_Configuration (CRC_InitTypeDef* CRCInitStruct)
{
    uint32_t tmpreg = 0;

	CHECK_RESTRICTION(CHECK_CRC_CAL_RSET(CRCInitStruct->m_CalUnitReset));
	CHECK_RESTRICTION(CHECK_CRC_INPUT_SEZE(CRCInitStruct->m_InputSize));
	CHECK_RESTRICTION(CHECK_CRC_INPUT_REVERSE(CRCInitStruct->m_InputReverse));
	CHECK_RESTRICTION(CHECK_CRC_RSLTREV_SEL(CRCInitStruct->m_ResultReverse));

	/*---------------------------- CRC_CTLĴ  -----------------*/
	/* ݽṹԱm_CalUnitResetRSETλ */
	/* ݽṹԱm_InputSizeDATASIZEλ */
	/* ݽṹԱm_InputReverseDATAREVλ */
	/* ݽṹԱm_ResultReverseRSLTREVλ */

   tmpreg = ((CRCInitStruct->m_CalUnitReset ) | \
			  (CRCInitStruct->m_InputSize) | \
			  (CRCInitStruct->m_InputReverse) | \
			  (CRCInitStruct->m_ResultReverse));
   CRC_SFR->CTL = SFR_Config (CRC_SFR->CTL,
			   ~CRC_CTL_INIT_MASK,
			   tmpreg);
}

/**
  *   ʼCRCϢṹ塣
  *   CRCInitStruct: ָʼĽṹָ롣
  *   ޡ
  */
void
CRC_Struct_Init (CRC_InitTypeDef* CRCInitStruct)
{
    /* ʼCRC㵥Ԫλλ */
    CRCInitStruct->m_CalUnitReset = CRC_CAL_RSET_DISABLE;
    /* ʼ CRCݸʽλ */
    CRCInitStruct->m_InputSize = CRC_INPUT_SEZE_8;
    /* ʼ CRCλλ */
    CRCInitStruct->m_InputReverse = CRC_INPUT_REVERSE_DISABLE;
    /* ʼ CRCλ */
    CRCInitStruct->m_ResultReverse = CRC_RESULT_REVERSE_DISABLE;
}

/**
  *   ȡCRCӦĴֵ
  *   CRC_Register:  CRC_DATA_REGISTER CRCݼĴ
  * 					CRC_RSLT_REGISTER CRCĴ
  * 					CRC_INIT_REGISTER CRCʼֵĴ
  * 					CRC_PLN_REGISTER CRCʽĴ
  * 					CRC_RXOR_REGISTER CRCֵĴ
  * 					CRC_IDATA_REGISTER CRCݼĴ
  * 					CRC_TEMP_REGISTER CRCĴ
  *   32λݡ
  */
uint32_t
CRC_Get_Register_Value(uint32_t CRC_Register)
{
	/* У */
	CHECK_RESTRICTION(CHECK_CRC_REGISTER1_SEL(CRC_Register));

	return (*((uint32_t *)(CRC_ADDR+4*CRC_Register)));
}

/**
  *   CRCӦĴֵ
  *   CRC_Register:  CRC_DATA_REGISTER CRCݼĴ
  * 					CRC_INIT_REGISTER CRCʼֵĴ
  * 					CRC_PLN_REGISTER CRCʽĴ
  * 					CRC_RXOR_REGISTER CRCֵĴ
  * 					CRC_IDATA_REGISTER CRCݼĴ
  *   ޡ
  */
void
CRC_Register_Value_Config(uint32_t CRC_Register ,uint32_t Value)
{
	/* У */
	CHECK_RESTRICTION(CHECK_CRC_REGISTER2_SEL(CRC_Register));

	*((uint32_t *)(CRC_ADDR+4*CRC_Register)) = Value;
}

/**
  *   CRCʹܡ
  *   NewState: TRUECRCλ
  * 	 		 FALSEӰ
  *   ޡ
  */
void
CRC_Result_Reverse_Enable(FunctionalState NewState)
{
	/* У */
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	CRC_CTL = SFR_Config(CRC_CTL, ~CRC_CTL_RSLTREV, NewState<<CRC_CTL_RSLTREV_POS);
}

/**
  *   CRCλơ
  *   NewState: TRUEֽΪλλ
  * 	 		   FALSEλ
  *   ޡ
  */
void
CRC_Input_Data_Reverse_Enable(FunctionalState NewState)
{
	/* У */
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	CRC_CTL = SFR_Config(CRC_CTL, ~CRC_CTL_DATAREV, NewState<<CRC_CTL_DATAREV_POS);
}

/**
  *   CRCݸʽơ
  *   Select:    CRC_INPUT_SEZE_8: 8λ
  * 				CRC_INPUT_SEZE_16: 16λ
  * 				CRC_INPUT_SEZE_24: 24λ
  * 				CRC_INPUT_SEZE_32: 32λ
  *   ޡ
  */
void
CRC_Input_Data_Format_Config(uint32_t Select)
{
	/* У */
	CHECK_RESTRICTION(CHECK_CRC_INPUT_SEZE(Select));

	CRC_CTL = SFR_Config(CRC_CTL, ~CRC_CTL_DATASIZE, Select);
}

/**
  *   CRC㵥Ԫƿơ
  *   NewState: TRUEλ״̬
  * 	 		   FALSE
  *   ޡ
  */
void
CRC_Calculation_Unit_Reset_Enable(FunctionalState NewState)
{
	/* У */
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	CRC_CTL = SFR_Config(CRC_CTL, ~CRC_CTL_RSET, NewState<<CRC_CTL_RSET_POS);
}





/**
  *   CRCݼĴ
  *   DATA: ֵ
  *   ޡ
  */
void
CRC_INPUT_DATA (uint32_t DATA)
{
    /* CRCݼĴ */
	CRC_SFR->DATA = DATA;
}
/**
  *   ȡCRC
  *   : 
  *   uint32_tλֵ
  */
uint32_t
CRC_GET_RESULT ()
{
    /* ȡCRCĴ */
	uint32_t DATA;
	DATA=CRC_SFR->RSLT;
	return DATA;
}
/**
  *   CRCĳʼֵ
  *   : 
  *   uint32_tλֵ
  */
void
CRC_SET_INITVALUE (uint32_t DATA)
{
    /* CRCĳʼֵĴ */
	CRC_SFR->INIT = DATA;
}
/**
  *   CRCʽ
  *   : 
  *   uint32_tλֵ
  */
void
CRC_SET_PLN (uint32_t DATA)
{
    /* CRCʽĴ */
	CRC_SFR->PLN = DATA;
}
/**
  *   CRCֵ
  *   : 
  *   uint32_tλֵ
  */
void
CRC_SET_RXOR (uint32_t DATA)
{
    /* ýֵĴ */
	CRC_SFR->RXOR = DATA;
}
/**
  *   CRC
  *   : 
  *   uint32_tλֵ
  */
void
CRC_SET_IDATA (uint32_t DATA)
{
    /* öݼĴ */
	CRC_SFR->IDATA = DATA;
}
/**
  *   CRC
  *   : 
  *   uint32_tλֵ
  */
uint32_t
CRC_GET_TEMP ()
{
    /* ûĴ */
	uint32_t DATA;
	DATA=CRC_SFR->TEMP;
	return DATA;
}
/**
  *   CRC 㵥Ԫλ
  *   : 
  * 
  */
void
CRC_SET_RSET ()
{
    /* ûĴ */
	CRC_SFR->CTL|=CRC_CTL_RSET;
}
