/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : kf32a156_dac.c                                 	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-08                                            *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file provides the DAC peripherals function, 	  *
 *  					including:											  *
 *          			+ Initialization and configuration functions          *
 *          			+ Data read-write function                            *
 *          			+ DAC checksum register configuration function		  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/

#include "kf32a156_dac.h"
#include "kf32a156_rst.h"
#include "kf32a156_pclk.h"


/*******************************************************************************
**                   (DAC) module Private Macro Definitions                   **
*******************************************************************************/

/* DAC˽ж ----------------------------------------------------*/
/* DACx_CTLĴ */
#define DAC_CTL_INIT_MASK               (DAC_CTL_TRIGEN \
                                       | DAC_CTL_TREVT \
                                       | DAC_CTL_DE \
                                       | DAC_CTL_WAVE \
                                       | DAC_CTL_MAS)

/* DACx_CTLĴ */
#define DAC_CTL1_INIT_MASK              (DAC_CTL1_CLK \
                                       | DAC_CTL1_RFS \
                                       | DAC_CTL1_BUFEN \
                                       | DAC_CTL1_SEL)


/**
  *   ##### ʼú #####
  */
/**
  *   DAC踴λʹʱӡ
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFRDAC2_SFRDAC3_SFR
  *   ޡ
  */
void
DAC_Reset (DAC_SFRmap* DACx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));

    if (DACx == DAC0_SFR)
    {
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_DAC0RST, TRUE);
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_DAC0RST, FALSE);
        PCLK_CTL1_Peripheral_Clock_Enable(PCLK_CTL1_DAC0CLKEN, TRUE);
    }
    else if (DACx == DAC1_SFR)
    {
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_DAC1RST, TRUE);
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_DAC1RST, FALSE);
        PCLK_CTL1_Peripheral_Clock_Enable(PCLK_CTL1_DAC1CLKEN, TRUE);
    }
    else if (DACx == DAC2_SFR)
    {
        RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_DAC2RST, TRUE);
        RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_DAC2RST, FALSE);
        PCLK_CTL2_Peripheral_Clock_Enable(PCLK_CTL2_DAC2CLKEN, TRUE);
    }
    else if (DACx == DAC3_SFR)
    {
        RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_DAC3RST, TRUE);
        RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_DAC3RST, FALSE);
        PCLK_CTL2_Peripheral_Clock_Enable(PCLK_CTL2_DAC3CLKEN, TRUE);
    }
    else
    {
    	;
    }
}

/**
  *   DACá
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFRDAC2_SFRDAC3_SFR
  *       dacInitStruct: DACϢ
  *   ޡ
  */
void
DAC_Configuration (DAC_SFRmap* DACx, DAC_InitTypeDef* dacInitStruct)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(dacInitStruct->m_TriggerEnable));
    CHECK_RESTRICTION(CHECK_DAC_TRIGGER_EVENT(dacInitStruct->m_TriggerEvent));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(dacInitStruct->m_TriggerDMAEnable));
    CHECK_RESTRICTION(CHECK_DAC_WAVE(dacInitStruct->m_Wave));
    CHECK_RESTRICTION(CHECK_DAC_MAS(dacInitStruct->m_Mas));
    CHECK_RESTRICTION(CHECK_DAC_CLK(dacInitStruct->m_Clock));
    CHECK_RESTRICTION(CHECK_DAC_CLK_DIV(dacInitStruct->m_ClockDiv));
    CHECK_RESTRICTION(CHECK_DAC_RFS(dacInitStruct->m_ReferenceVoltage));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(dacInitStruct->m_OutputBuffer));
    CHECK_RESTRICTION(CHECK_DAC_OUTPUT_PIN(dacInitStruct->m_OutputPin));
    CHECK_RESTRICTION(CHECK_DAC_OUTPUT(dacInitStruct->m_Output));

    /*---------------------------- DACx_CTLĴ  -----------------*/
    /* ݽṹԱm_TriggerEnableTRIGENλ */
    /* ݽṹԱm_TriggerEventTREVTλ */
    /* ݽṹԱm_TriggerDMAEnableDEλ */
    /* ݽṹԱm_WaveWAVEλ */
    /* ݽṹԱm_MasMASλ */
    tmpreg = ((dacInitStruct->m_TriggerEnable << DAC_CTL_TRIGEN_POS) | \
              (dacInitStruct->m_TriggerEvent) | \
              (dacInitStruct->m_TriggerDMAEnable << DAC_CTL_DE_POS) | \
              (dacInitStruct->m_Wave) | \
              (dacInitStruct->m_Mas));
    DACx->CTL = SFR_Config (DACx->CTL, ~DAC_CTL_INIT_MASK, tmpreg);

    /*---------------------------- DACx_CTL1Ĵ -----------------*/
    /* ݽṹԱm_ClockDivCLKDIVλ */
    /* ݽṹԱm_ClockCLKλ */
    /* ݽṹԱm_ReferenceVoltageRFSλ */
    /* ݽṹԱm_OutputBufferBUFENλ */
    /* ݽṹԱm_OutputPinSELλ */
    tmpreg = (dacInitStruct->m_ClockDiv)\
    	   | (dacInitStruct->m_Clock) \
           | (dacInitStruct->m_ReferenceVoltage) \
           | (dacInitStruct->m_OutputBuffer << DAC_CTL1_BUFEN_POS) \
           | (dacInitStruct->m_OutputPin);
    DACx->CTL1 = SFR_Config (DACx->CTL1, ~DAC_CTL1_INIT_MASK, tmpreg);

    /*---------------------------- DACx_DAHDĴ -----------------*/
    /* ݽṹԱm_OutputDAHDλ */
    tmpreg = dacInitStruct->m_Output;
    DACx->DAHD = SFR_Config (DACx->DAHD, ~DAC_DAHD_DAHD, tmpreg);
}

/**
  *   ʼDACϢṹ塣
  *   dacInitStruct: ָʼĽṹָ롣
  *   ޡ
  */
void
DAC_Struct_Init (DAC_InitTypeDef* dacInitStruct)
{
    /* ʼ DACͨʹ */
    dacInitStruct->m_TriggerEnable = FALSE;
    /* ʼ DACͨ¼ */
    dacInitStruct->m_TriggerEvent = DAC_TRIGGER_T1_TRGO;
    /* ʼ DACDMAʹ */
    dacInitStruct->m_TriggerDMAEnable = FALSE;
    /* ʼ DACηʹ */
    dacInitStruct->m_Wave = DAC_WAVE_NONE;
    /* ʼ DAC/ֵѡ */
    dacInitStruct->m_Mas = DAC_LFSR_UNMASK_BITS0_0;
    /* ʼ DACʱ */
    dacInitStruct->m_Clock = DAC_CLK_SCLK;
    /* ʼ DACʱӷƵ */
    dacInitStruct->m_ClockDiv = DAC_CLK_DIV_1;
    /* ʼ DACοѹѡ */
    dacInitStruct->m_ReferenceVoltage = DAC_RFS_AVDD;
    /* ʼ DACʹ */
    dacInitStruct->m_OutputBuffer = FALSE;
    /* ʼ DAC */
    dacInitStruct->m_OutputPin = DAC_OUTPUT_PIN_0;
    /* ʼ DAC */
    dacInitStruct->m_Output = 0;
}

/**
  *   DACʹλ
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFRDAC2_SFRDAC3_SFR
  *       NewState: DACʹλϢ
  *                 ȡֵΪ TRUE  FALSE
  *   ޡ
  */
void
DAC_Cmd (DAC_SFRmap* DACx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (NewState != FALSE)
    {
        /* ʹDAC */
        SFR_SET_BIT_ASM(DACx->CTL, DAC_CTL_EN_POS);
    }
    else
    {
        /* ֹDAC */
        SFR_CLR_BIT_ASM(DACx->CTL, DAC_CTL_EN_POS);
    }
}

/**
  *   DACʹλ
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFRDAC2_SFRDAC3_SFR
  *       NewState: DACʹλϢ
  *                 ȡֵΪ TRUE  FALSE
  *   ޡ
  */
void
DAC_Software_Trigger_Cmd (DAC_SFRmap* DACx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (NewState != FALSE)
    {
        /* ʹDAC */
        SFR_SET_BIT_ASM(DACx->CTL, DAC_CTL_SWTRIG_POS);
    }
    else
    {
        /* ֹDAC */
        SFR_CLR_BIT_ASM(DACx->CTL, DAC_CTL_SWTRIG_POS);
    }
}

/**
  *   DACͨDMAģʽʹܡ
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFRDAC2_SFRDAC3_SFR
  *       NewState: DACʹλϢ
  *                 ȡֵΪ TRUE  FALSE
  *   ޡ
  */
void
DAC_DMA_Cmd (DAC_SFRmap* DACx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (NewState != FALSE)
    {
        /* ʹDACͨDMAģʽ */
        SFR_SET_BIT_ASM(DACx->CTL, DAC_CTL_DE_POS);
    }
    else
    {
        /* ֹDACͨDMAģʽ */
        SFR_CLR_BIT_ASM(DACx->CTL, DAC_CTL_DE_POS);
    }
}

/**
  *   DACʹܡ
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFRDAC2_SFRDAC3_SFR
  *       NewState: DACʹλϢ
  *                 ȡֵΪ TRUE  FALSEֱʾ򲻴塣
  *   ޡ
  */
void
DAC_Output_Buffer_Config (DAC_SFRmap* DACx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (NewState != FALSE)
    {
        /* ʹDAC */
        SFR_SET_BIT_ASM(DACx->CTL1, DAC_CTL1_BUFEN_POS);
    }
    else
    {
        /* ֹDAC */
        SFR_CLR_BIT_ASM(DACx->CTL1, DAC_CTL1_BUFEN_POS);
    }
}

/**
  *   DACIOѡ
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFRDAC2_SFRDAC3_SFR
  *       NewState: DACʹλϢ
  *                 ȡֵΪ TRUE  FALSEֱʾIO1IO0
  *   ޡ
  */
void
DAC_Output_Port_Config (DAC_SFRmap* DACx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (NewState != FALSE)
    {
        /* DACIO1 */
        SFR_SET_BIT_ASM(DACx->CTL1, DAC_CTL1_SEL_POS);
    }
    else
    {
        /* DACIO0 */
        SFR_CLR_BIT_ASM(DACx->CTL1, DAC_CTL1_SEL_POS);
    }
}

/**
  *   ##### ʼú #####
  */



/**
  *   ##### ݶд #####
  */
/**
  *   дDACݣֻдDACx_DAHDĴ
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFRDAC2_SFRDAC3_SFR
  *       Value: дݼĴֵ
  *              ȡֵΪ12λݡ
  *   ޡ
  */
void
DAC_Write_Output_Data (DAC_SFRmap* DACx, uint32_t Value)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));
    CHECK_RESTRICTION(CHECK_DAC_OUTPUT(Value));

    DACx->DAHD = Value;
}

/**
  *   DACݡ
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFRDAC2_SFRDAC3_SFR
  *   32λݵ12λݡ
  */
uint32_t
DAC_Read_Output_Data (DAC_SFRmap* DACx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));

    return (DAC_DAHD_DAHD & DACx->DATA);
}

/**
  *   ##### ݶд #####
  */



/**
  *   ##### DACУĴú #####
  */

/**
  *   PУ׼
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFRDAC2_SFRDAC3_SFR
  *       Direction: DAC_Positive	DACУ׼
  *       			 DAC_Negetive	DACУ׼
  *   ޡ
  */
void
DAC_PCalibration_Direction_Config (DAC_SFRmap* DACx, uint32_t Direction)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));
    CHECK_RESTRICTION(CHECK_DAC_CAL_DIRECTION(Direction));

    tmpreg = Direction << DAC_CAL_TRIMPPOL_POS;
    DACx->CAL = SFR_Config (DACx->CAL, ~DAC_CAL_TRIMPPOL, tmpreg);
}

/**
  *   PУ׼λá
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFRDAC2_SFRDAC3_SFR
  *       Value:  Value <= 0x3F
  *   ޡ
  */
void
DAC_PCalibration_Value_Config (DAC_SFRmap* DACx, uint32_t Value)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));
    CHECK_RESTRICTION(CHECK_DAC_TRIMP(Value));

    tmpreg = Value << DAC_CAL_TRIMP0_POS;
    DACx->CAL = SFR_Config (DACx->CAL, ~DAC_CAL_TRIMP, tmpreg);
}

/**
  *   PУ׼λȡ
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFRDAC2_SFRDAC3_SFR
  *   PУ׼λǰֵ
  */
uint16_t
DAC_PCalibration_Value_Read (DAC_SFRmap* DACx)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));

    return((DACx->CAL && DAC_CAL_TRIMP) >> DAC_CAL_TRIMP0_POS);
}

/**
  *   NУ׼
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFRDAC2_SFRDAC3_SFR
  *       Direction: DAC_Positive	DACУ׼
  *       			 DAC_Negetive	DACУ׼
  *   ޡ
  */
void
DAC_NCalibration_Direction_Config (DAC_SFRmap* DACx, uint32_t Direction)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));
    CHECK_RESTRICTION(CHECK_DAC_CAL_DIRECTION(Direction));

    tmpreg = Direction << DAC_CAL_TRIMNPOL_POS;
    DACx->CAL = SFR_Config (DACx->CAL, ~DAC_CAL_TRIMNPOL, tmpreg);
}

/**
  *   NУ׼λá
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFRDAC2_SFRDAC3_SFR
  *       Value:  Value <= 0x3F
  *   ޡ
  */
void
DAC_NCalibration_Value_Config (DAC_SFRmap* DACx, uint32_t Value)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));
    CHECK_RESTRICTION(CHECK_DAC_TRIMP(Value));

    tmpreg = Value << DAC_CAL_TRIMN0_POS;
    DACx->CAL = SFR_Config (DACx->CAL, ~DAC_CAL_TRIMN, tmpreg);
}

/**
  *   NУ׼λȡ
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFRDAC2_SFRDAC3_SFR
  *   PУ׼λǰֵ
  */
uint16_t
DAC_NCalibration_Value_Read (DAC_SFRmap* DACx)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));

    return((DACx->CAL && DAC_CAL_TRIMN) >> DAC_CAL_TRIMN0_POS);
}

/**
  *   У׼״̬λȡ
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFRDAC2_SFRDAC3_SFR
  *   У׼״̬λǰֵ
  */
uint8_t
DAC_TRIM_STATE_Value_Read (DAC_SFRmap* DACx)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));

    return((DACx->CAL && DAC_CAL_TRIMSTATE) >> DAC_CAL_TRIMSTATE_POS);
}

/**
  *   У׼߹ģʹܡ
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFRDAC2_SFRDAC3_SFR
  * 	 NewState: TRUE ʹ
  * 	 		   FALSE ֹ
  *   ޡ
  */
void
DAC_TRIMHI_Enable(DAC_SFRmap* DACx, FunctionalState NewState)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    tmpreg = NewState << DAC_CAL_TRIMHI_POS;
    DACx->CAL = SFR_Config(DACx->CAL, ~DAC_CAL_TRIMHI, tmpreg);
}

/**
  *   У׼͹ģʹܡ
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFRDAC2_SFRDAC3_SFR
  * 	 NewState: TRUE ʹ
  * 	 		   FALSE ֹ
  *   ޡ
  */
void
DAC_TRIMLO_Enable(DAC_SFRmap* DACx, FunctionalState NewState)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    tmpreg = NewState << DAC_CAL_TRIMLO_POS;
    DACx->CAL = SFR_Config(DACx->CAL, ~DAC_CAL_TRIMLO, tmpreg);
}

/**
  *   ơ
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFRDAC2_SFRDAC3_SFR
  * 	 TestGroup: DAC_TEST_GROUP1 һ
  * 	 			DAC_TEST_GROUP2 ڶ
  * 	 			DAC_TEST_GROUP3 
  * 	 			DAC_TEST_GROUP4 
  *   ޡ
  */
void
DAC_Test_Group_Config(DAC_SFRmap* DACx, uint32_t TestGroup)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));
    CHECK_RESTRICTION(CHECK_DAC_TEST_GROUP(TestGroup));

    tmpreg = TestGroup << DAC_CAL_TP0_POS;
    DACx->CAL = SFR_Config(DACx->CAL, ~DAC_CAL_TP, tmpreg);
}

/**
  *   ʹܡ
  *   DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFRDAC2_SFRDAC3_SFR
  * 	 NewStateTRUE ʹܲ
  * 	 		   FALSE ֹ
  *   ޡ
  */
void
DAC_Test_Group_Enable(DAC_SFRmap* DACx, FunctionalState NewState)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_DAC_ALL_PERIPH(DACx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    tmpreg = NewState << DAC_CAL_TPEN_POS;
    DACx->CAL = SFR_Config(DACx->CAL, ~DAC_CAL_TPEN, tmpreg);
}


/**
  *   ##### DACУĴú #####
  */



