/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : kf32a156_epwm.c                                	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-08                                            *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file provides the enhanced pulse width modulation*
 *						(EPWM) peripherals function              		  	  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/


#include "kf32a156_epwm.h"
#include "kf32a156_rst.h"
#include "kf32a156_pclk.h"


/**
  *   ##### ʼú #####
  */

/**
  *   EPWM踴λʹʱӡ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  *   ޡ
  */
void
EPWM_Reset (EPWM_SFRmap* EPWMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));

    if (EPWMx == EPWM11_SFR)
    {
    	RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_EPWM11TRST, TRUE);
    	RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_EPWM11TRST, FALSE);
    	PCLK_CTL2_Peripheral_Clock_Enable(PCLK_CTL2_EPWM11CLKEN, TRUE);
    }
    else if (EPWMx == EPWM12_SFR)
    {
    	RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_EPWM12TRST, TRUE);
    	RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_EPWM12TRST, FALSE);
    	PCLK_CTL2_Peripheral_Clock_Enable(PCLK_CTL2_EPWM12CLKEN, TRUE);
    }
    else if (EPWMx == EPWM13_SFR)
    {
    	RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_EPWM13TRST, TRUE);
    	RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_EPWM13TRST, FALSE);
    	PCLK_CTL2_Peripheral_Clock_Enable(PCLK_CTL2_EPWM13CLKEN, TRUE);
    }
    else if (EPWMx == EPWM16_SFR)
    {
    	RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_EPWM16TRST, TRUE);
    	RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_EPWM16TRST, FALSE);
    	PCLK_CTL2_Peripheral_Clock_Enable(PCLK_CTL2_EPWM16CLKEN, TRUE);
    }
    else
    {
    	;
    }
}
/**
  *   32λTxʱֵ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  * 	 Value  Value <= 0xFFFFFFFF;
  *   ޡ
  */
void
EPWM_TxCNT_Value_Config(EPWM_SFRmap* EPWMx, uint32_t Value)
{
    /* У */
    CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
    CHECK_RESTRICTION(CHECK_EPWM_32BIT_LIMIT(Value));

    EPWMx->CNT = Value;
}
/**
  *   ȡ32λTxʱֵ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  *   32λֵ
  */
uint32_t
EPWM_Get_TxCNT_Value(EPWM_SFRmap* EPWMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));

    return EPWMx->CNT;
}
/**
  *   32λTxʱλĴֵ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  * 	 Value  Value <= 0xFFFFFFFF;
  *   ޡ
  */
void
EPWM_TxPHS_Value_Config(EPWM_SFRmap* EPWMx, uint32_t Value)
{
    /* У */
    CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
    CHECK_RESTRICTION(CHECK_EPWM_32BIT_LIMIT(Value));

    EPWMx->PHS = Value;
}
/**
  *   ȡ32λTxʱλĴֵ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  *   32λֵ
  */
uint32_t
EPWM_Get_TxPHS_Value(EPWM_SFRmap* EPWMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));

    return EPWMx->PHS;
}
/**
  *   32λTxʱڼĴֵ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  * 	 Value  Value <= 0xFFFFFFFF;
  *   ޡ
  */
void
EPWM_TxPPX_Value_Config(EPWM_SFRmap* EPWMx, uint32_t Value)
{
    /* У */
    CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
    CHECK_RESTRICTION(CHECK_EPWM_32BIT_LIMIT(Value));

    EPWMx->PPX = Value;
}
/**
  *   ȡ32λTxʱڼĴֵ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  *   32λֵ
  */
uint32_t
EPWM_Get_TxPPX_Value(EPWM_SFRmap* EPWMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));

    return EPWMx->PPX;
}
/**
  *   32λTxʱԤƵֵ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  * 	 Value  Value <= 0xFFFFFFFF;
  *   ޡ
  * עƵֵ = Value + 1;
  */
void
EPWM_TxPRSC_Value_Config(EPWM_SFRmap* EPWMx, uint32_t Value)
{
    /* У */
    CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
    CHECK_RESTRICTION(CHECK_EPWM_32BIT_LIMIT(Value));

    EPWMx->PRSC = Value;
}
/**
  *   ȡ32λTxʱԤƵֵ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  *   32λֵ
  */
uint32_t
EPWM_Get_TxPRSC_Value(EPWM_SFRmap* EPWMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));

    return EPWMx->PRSC;
}


/**
  *   ӦһEPWM͵ĵLINKʹܡ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  * 	 NewState : TRUE : ĴʹLINK
  * 	 			FALSE : ֹĴʹLINK
  *   ޡ
  */
void
EPWM_Response_UpperLevel_LINK_Enable(EPWM_SFRmap* EPWMx, FunctionalState NewState)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	tmpreg = NewState << EPWM_CTL_BLINKEN_POS;
	EPWMx->CTL = SFR_Config(EPWMx->CTL, ~EPWM_CTL_BLINKEN, tmpreg);
}
/**
  *   һPEWMLINKʹܡ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  * 	 NewState : TRUE : LINK
  * 	 			FALSE : LINK
  *   ޡ
  */
void
EPWM_NextLevel_LINK_Ask_Enable(EPWM_SFRmap* EPWMx, FunctionalState NewState)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	tmpreg = NewState << EPWM_CTL_LINKEN_POS;
	EPWMx->CTL = SFR_Config(EPWMx->CTL, ~EPWM_CTL_LINKEN, tmpreg);
}
/**
  *   ͬźŴʹܡ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  * 	 NewState : TRUE : ͬźŴ
  * 	 			FALSE : ֹͬźŴ
  *   ޡ
  */
void
EPWM_SYNC_Single_Trigger_Enable(EPWM_SFRmap* EPWMx, FunctionalState NewState)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	tmpreg = NewState << EPWM_CTL_UDSYNEN_POS;
	EPWMx->CTL = SFR_Config(EPWMx->CTL, ~EPWM_CTL_UDSYNEN, tmpreg);
}
/**
  *   ģĴá
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  * 	 Select : 	EPWM_SUBMODULE_HRPWM_LOCK 		: HRPWMģĴ
  * 	 			EPWM_SUBMODULE_ET_LOCK 			: ETģĴ
  * 	 			EPWM_SUBMODULE_PC_LOCK 			: PCģĴ
  * 	 			EPWM_SUBMODULE_DB_LOCK 			: DBģĴ
  * 	 			EPWM_SUBMODULE_CHANNELB_AQ_LOCK : ͨBAQģĴ
  * 	 			EPWM_SUBMODULE_CHANNELA_AQ_LOCK : ͨAAQģĴ
  * 	 NewState : TRUE : ֹxxģĴд
  * 	 			FALSE : xxģĴд
  *   ޡ
  */
void
EPWM_Submodule_Register_Lock_Config(EPWM_SFRmap* EPWMx,
			uint32_t Select, FunctionalState NewState)
{
	uint32_t tmpreg = 0;
	uint32_t tmask = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_SUBMODULE_LOCK(Select));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	tmpreg = NewState << (EPWM_CTL_AQLOCKA_POS + Select);
	tmask = 1 << (EPWM_CTL_AQLOCKA_POS + Select);
	EPWMx->CTL = SFR_Config(EPWMx->CTL, ~tmask, tmpreg);
}
/**
  *   ׽ʹܡ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  * 	 NewState : TRUE : ʹܲ׽ʹ
  * 	 			FALSE : ֹ׽ʹ
  *   ޡ
  */
void
EPWM_Cap_Function_Enable(EPWM_SFRmap* EPWMx, FunctionalState NewState)
{
	uint32_t tmpreg = 0;
	uint32_t tmask = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	tmpreg = NewState << EPWM_CTL_CAPEN_POS;
	tmask = EPWM_CTL_CAPEN;
	EPWMx->CTL = SFR_Config(EPWMx->CTL, ~tmask, tmpreg);
}
/**
  *   ò׽¼ѡ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  * 	 Select : 	EPWM_CAP_TRIGGER_EVENT_TZ1 : TZ1׽¼
  * 	 			EPWM_CAP_TRIGGER_EVENT_TZ2 : TZ2׽¼
  * 	 			EPWM_CAP_TRIGGER_EVENT_TZ3 : TZ3׽¼
  * 	 			EPWM_CAP_TRIGGER_EVENT_TZ4 : TZ4׽¼
  *   ޡ
  */
void
EPWM_Cap_Trigger_Event_Select(EPWM_SFRmap* EPWMx, uint32_t Select)
{
	uint32_t tmpreg = 0;
	uint32_t tmask = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_CAP_TRIGGER_EVENT(Select));

	tmpreg = Select << EPWM_CTL_CAPSEL0_POS;
	tmask = EPWM_CTL_CAPSEL;
	EPWMx->CTL = SFR_Config(EPWMx->CTL, ~tmask, tmpreg);
}
/**
  *   ȡﵽֵ״̬
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  *   0  ֵûдﵽֵ0xFFFF_FFFF
  *      1  ֵﵽֵ0xFFFF_FFFF
  */
FlagStatus
EPWM_Get_CountValue_MAX_Status(EPWM_SFRmap* EPWMx)
{
	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));

	return ((EPWMx->CTL & EPWM_CTL_TXMAX) >> EPWM_CTL_TXMAX_POS);
}
/**
  *   ﵽֵ״̬־
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  *   ޡ
  */
void
EPWM_Clear_CountValue_MAX_Status(EPWM_SFRmap* EPWMx)
{
	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));

	EPWMx->CTL = SFR_Config(EPWMx->CTL, ~EPWM_CTL_TXMAX, EPWM_CTL_TXMAX);
	while(!(EPWMx->CTL & EPWM_CTL_TXMAX));
}
/**
  *   λơ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  * 	 Direction : 	EPWM_SYNC_TRIGGER_DOWM : ͬ¼¼
  * 	 				EPWM_SYNC_TRIGGER_UP : ͬ¼ϼ
  *   ޡ
  */
void
EPWM_Phase_Direction_Config(EPWM_SFRmap* EPWMx, uint32_t Direction)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_SYNC_TRIGGER_DIRECTION(Direction));

	tmpreg = Direction << EPWM_CTL_PHSDIR_POS;
	EPWMx->CTL = SFR_Config(EPWMx->CTL, ~EPWM_CTL_PHSDIR, tmpreg);
}
/**
  *   ͬ¼(һͬ¼)
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  *   ޡ
  */
void
EPWM_Software_SYNC_Event(EPWM_SFRmap* EPWMx)
{
	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));

	EPWMx->CTL = SFR_Config(EPWMx->CTL, ~EPWM_CTL_SWFSYNC, EPWM_CTL_SWFSYNC);
}
/**
  *   ͬ¼ѡ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  * 	 Select : 	EPWM_SYNC_EVENT_OUT_EPWM_SWF : EPWMxSYNCIԼSWFSYNC
  * 	 			EPWM_SYNC_EVENT_OUT_COUNT0	 : ֵ0
  * 	 			EPWM_SYNC_EVENT_OUT_EPWMRB 	 : ֵEPWMx_RB
  * 	 			EPWM_SYNC_EVENT_OUT_DISABLE  : ֹEPWMxSYNCO
  *   ޡ
  */
void
EPWM_SYNC_Event_Out_Select(EPWM_SFRmap* EPWMx, uint32_t Select)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_SYNC_EVENT_OUT(Select));

	tmpreg = Select << EPWM_CTL_SYNCOSEL0_POS;
	EPWMx->CTL = SFR_Config(EPWMx->CTL, ~EPWM_CTL_SYNCOSEL, tmpreg);
}
/**
  *   λĴʹܡ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  * 	 NewState : 	TRUE : ⲿͬ¼ǿͬʱλĴTXPHS붨ʱ
  * 	 				FALSE : λĴTXPHS붨ʱ
  *   ޡ
  */
void
EPWM_Phase_Register_Loading_Enable(EPWM_SFRmap* EPWMx, FunctionalState NewState)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	tmpreg = NewState << EPWM_CTL_PHSEN_POS;
	EPWMx->CTL = SFR_Config(EPWMx->CTL, ~EPWM_CTL_PHSEN, tmpreg);
}
/**
  *   ȡⲿͬ¼״̬
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  *   ޡ
  */
FlagStatus
EPWM_Get_External_SYNC_Event_Status(EPWM_SFRmap* EPWMx)
{
	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));

	return ((EPWMx->CTL & EPWM_CTL_SYNCI) >> EPWM_CTL_SYNCI_POS);
}
/**
  *   ⲿͬ¼״̬λ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  *   ޡ
  */
void
EPWM_Clear_External_SYNC_Event_Status(EPWM_SFRmap* EPWMx)
{
	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));

	EPWMx->CTL = SFR_Config(EPWMx->CTL, ~EPWM_CTL_SYNCI, EPWM_CTL_SYNCI);
	while(!(EPWMx->CTL & EPWM_CTL_SYNCI));
}
/**
  *   ¼ʹܡ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  * 	 NewState : TRUE  ʼʱTxļڡռձȡԤƵƼĴ
  * 	 			FALSE  δʹ
  *   ޡ
  */
void
EPWM_Updata_Event_Generate_Enable(EPWM_SFRmap* EPWMx, FunctionalState NewState)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	tmpreg = NewState << EPWM_CTL_TXUR_POS;
	EPWMx->CTL = SFR_Config(EPWMx->CTL, ~EPWM_CTL_TXUR, tmpreg);
}
/**
  *   ¼ơ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  * 	 NewState : TRUE  ¼TxΪʱռձȡڡơԤƵĴ
								УʱλֻڸλЧڶʱ
  * 	 			FALSE  ʱTxΪ0ʱ¼ΪPPֵʱTxΪʱռձȡ
  * 	 						ڡơԤƵĴ
  *   ޡ
  */
void
EPWM_Updata_Event_Config(EPWM_SFRmap* EPWMx, FunctionalState NewState)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	tmpreg = NewState << EPWM_CTL_TXEUDEVT_POS;
	EPWMx->CTL = SFR_Config(EPWMx->CTL, ~EPWM_CTL_TXEUDEVT, tmpreg);
}
/**
  *   ʹܡ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  * 	 NewState : TRUE  TxΪʱռձȡڡơԤƵĴ
  * 	 			FALSE  ֹTxΪʱռձȡڡơԤƵĴ
  *   ޡ
  */
void
EPWM_Updata_Event_Enable(EPWM_SFRmap* EPWMx, FunctionalState NewState)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	tmpreg = NewState << EPWM_CTL_TXUDEN_POS;
	EPWMx->CTL = SFR_Config(EPWMx->CTL, ~EPWM_CTL_TXUDEN, tmpreg);
}
/**
  *   Txģʽѡ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  * 	 Select : 	EPWM_COUNT_DOWM_UF  ¼ʱжϱ־
  * 	 			EPWM_COUNT_UP_OF  ϼʱжϱ־
  * 	 			EPWM_COUNT_UP_DOWM_OF  -¼ʱжϱ־
  * 	 			EPWM_COUNT_UP_DOWM_UF  -¼ʱжϱ־
  * 	 			EPWM_COUNT_UP_DOWM_OUF  -¼ʱжϱ־
  *   ޡ
  */
void
EPWM_Counter_Mode_Select(EPWM_SFRmap* EPWMx, uint32_t Select)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_COUNT_MODE(Select));

	tmpreg = Select << EPWM_CTL_TXCMS0_POS;
	EPWMx->CTL = SFR_Config(EPWMx->CTL, ~EPWM_CTL_TXCMS, tmpreg);
}
/**
  *   ȡTx
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  *  	0  ǰΪ¼
  * 		1  ǰΪϼ
  */
FlagStatus
EPWM_Get_Tx_Count_Direction(EPWM_SFRmap* EPWMx)
{
	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));

	return ((EPWMx->CTL & EPWM_CTL_TTXDIR) >> EPWM_CTL_TTXDIR_POS);
}
/**
  *   Txʱѡ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  * 	 CLK : 	EPWM_CLK_SCLK : ѡSCLKʱΪTxʱ
  * 	 		EPWM_CLK_HFCLK : ѡHFCLKʱΪTxʱ
  * 	 		EPWM_CLK_LFCLK : ѡLFCLKʱΪTxʱ
  *   ޡ
  */
void
EPWM_Work_Clock_Select(EPWM_SFRmap* EPWMx, uint32_t CLK)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_CLK(CLK));

	tmpreg = CLK << EPWM_CTL_TXCLK0_POS;
	EPWMx->CTL = SFR_Config(EPWMx->CTL, ~EPWM_CTL_TXCLK, tmpreg);
}
/**
  *   Txģʽⲿͬ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  * 	 NewState : TRUE : ⲿͬ
  * 	 			FALSE : ⲿͬ
  *   ޡ
  * עTXCS=1ʱλЧ
  */
void
EPWM_External_Pulse_Sync_Config(EPWM_SFRmap* EPWMx, FunctionalState NewState)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	tmpreg = NewState << EPWM_CTL_TXSY_POS;
	EPWMx->CTL = SFR_Config(EPWMx->CTL, ~EPWM_CTL_TXSY, tmpreg);
}
/**
  *   Txſʹ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  * 	 NewState : TRUE : ʹTxſأſźΪTxCK
  * 	 			FALSE : ֹTxſ
  *   ޡ
  */
void
EPWM_Gated_Enable(EPWM_SFRmap* EPWMx, FunctionalState NewState)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	tmpreg = NewState << EPWM_CTL_TXGATE_POS;
	EPWMx->CTL = SFR_Config(EPWMx->CTL, ~EPWM_CTL_TXGATE, tmpreg);
}
/**
  *   Txʱ/ģʽѡ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  *      Mode : µĶʱ/ģʽ
  *                EPWM_TIMER_MODE: ʱģʽ
  *                EPWM_COUNTER_MODE: ģʽ
  *   ޡ
  */
void
EPWM_Work_Mode_Config(EPWM_SFRmap* EPWMx, uint32_t Mode)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_MODE(Mode));

	tmpreg = Mode << EPWM_CTL_TXCS_POS;
	EPWMx->CTL = SFR_Config(EPWMx->CTL, ~EPWM_CTL_TXCS, tmpreg);
}
/**
  *   Txʹλ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  *      NewState : TRUE : ʹTx
  *      			FALSE : ֹTx
  *   ޡ
  */
void
EPWM_Enable(EPWM_SFRmap* EPWMx, FunctionalState NewState)
{
	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	EPWMx->CTL = SFR_Config(EPWMx->CTL, ~EPWM_CTL_TXEN, NewState);
}


/**
  *   ռձA/B/C/DĴ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  *      Register : EPWM_REGISTER_A : ĴA
  *      			EPWM_REGISTER_B  ĴB
  *      			EPWM_REGISTER_C  ĴC
  *      			EPWM_REGISTER_D  ĴD
  *      Value : Value <= 0xFFFFFFFF
  *   ޡ
  */
void
EPWM_Duty_Cycle_RegisterABCD_Config(EPWM_SFRmap* EPWMx, uint32_t Register,uint32_t Value)
{
	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_REGISTER_AB(Register));
	CHECK_RESTRICTION(CHECK_EPWM_32BIT_LIMIT(Value));

	if(Register == EPWM_REGISTER_A)
	{
		EPWMx->RA = Value;
	}
	else if(Register == EPWM_REGISTER_B)
	{
		EPWMx->RB = Value;
	}
	else if(Register == EPWM_REGISTER_C)
	{
		EPWMx->RC = Value;
	}
	else if(Register == EPWM_REGISTER_D)
	{
		EPWMx->RD = Value;
	}
}
/**
  *  ȡռձA/B/C/DĴֵ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  *      Register : EPWM_REGISTER_A : ĴA
  *      			EPWM_REGISTER_B  ĴB
  *      			EPWM_REGISTER_C  ĴC
  *      			EPWM_REGISTER_D  ĴD
  *   32λֵ
  */
uint32_t
EPWM_Get_Duty_Cycle_RegisterABCD_Value(EPWM_SFRmap* EPWMx, uint32_t Register)
{
	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_REGISTER_AB(Register));

	if(Register == EPWM_REGISTER_A)
	{
		return EPWMx->RA;
	}
	else if(Register == EPWM_REGISTER_B)
	{
		return EPWMx->RB;
	}
	else if(Register == EPWM_REGISTER_C)
	{
		return EPWMx->RC;
	}
	else if(Register == EPWM_REGISTER_D)
	{
		return EPWMx->RD;
	}
}


/**
  *   EPWMxA/EPWMxBǿʹ
  *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
  *      Register : EPWM_REGISTER_A : ĴA
  *      			EPWM_REGISTER_B  ĴB
  *      NewState : TRUE : ʹEPWMxAǿ
  *      			FALSE : ֹEPWMxAǿ
  *   ޡ
  */
void
EPWM_Single_Mandatory_Output_Enable(EPWM_SFRmap* EPWMx,
			uint32_t Register, FunctionalState NewState)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_REGISTER_AB(Register));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	tmpreg = NewState << EPWM_CTLA_OTSFA_POS;
	if(Register == EPWM_REGISTER_A)
	{
		EPWMx->CTLA = SFR_Config(EPWMx->CTLA, ~EPWM_CTLA_OTSFA, tmpreg);
	}
	else if(Register == EPWM_REGISTER_B)
	{
		EPWMx->CTLB = SFR_Config(EPWMx->CTLB, ~EPWM_CTLA_OTSFA, tmpreg);
	}
}
/**
 *   EPWMxAǿ
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 *      Register : 	EPWM_REGISTER_A : ĴA
 *      			EPWM_REGISTER_B  ĴB
 *      Select : 	EPWM_OUT_NONE : ޶ֵƽ䣩
 *      			EPWM_OUT_LOW : ͵ƽ
 *      			EPWM_OUT_HIGH : ߵƽ
 *      			EPWM_OUT_TOGGLE : ת
 *   ޡ
 */
void
EPWM_Single_Mandatory_Output_Config(EPWM_SFRmap* EPWMx, uint32_t Register, uint32_t Select)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_REGISTER_AB(Register));
	CHECK_RESTRICTION(CHECK_EPWM_MANDATORY_OUT(Select));

	tmpreg = Select << EPWM_CTLA_ACTSFA0_POS;
	if(Register == EPWM_REGISTER_A)
	{
		EPWMx->CTLA = SFR_Config(EPWMx->CTLA, ~EPWM_CTLA_ACTSFA, tmpreg);
	}
	else if(Register == EPWM_REGISTER_B)
	{
		EPWMx->CTLB = SFR_Config(EPWMx->CTLB, ~EPWM_CTLA_ACTSFA, tmpreg);
	}
}
/**
 *   EPWMxAǿ
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 *      Register : 	EPWM_REGISTER_A : ĴA
 *      			EPWM_REGISTER_B  ĴB
 *      Select : 	EPWM_OUT_NONE : ޶ֵƽ䣩
 *      			EPWM_OUT_LOW : ͵ƽ
 *      			EPWM_OUT_HIGH : ߵƽ
 *      			EPWM_OUT_PROHIBIT : ֹ
 *   ޡ
 */
void
EPWM_Continuous_Mandatory_Output_Config(EPWM_SFRmap* EPWMx, uint32_t Register, uint32_t Select)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_REGISTER_AB(Register));
	CHECK_RESTRICTION(CHECK_EPWM_MANDATORY_OUT(Select));

	tmpreg = Select << EPWM_CTLA_CSFA0_POS;
	if(Register == EPWM_REGISTER_A)
	{
		EPWMx->CTLA = SFR_Config(EPWMx->CTLA, ~EPWM_CTLA_CSFA, tmpreg);
	}
	else if(Register == EPWM_REGISTER_B)
	{
		EPWMx->CTLB = SFR_Config(EPWMx->CTLB, ~EPWM_CTLA_CSFA, tmpreg);
	}
}
/**
 *   TxֵEPWMx_RBĴҼʱEPWMxA
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 *      Register : 	EPWM_REGISTER_A : ĴA
 *      			EPWM_REGISTER_B  ĴB
 *     	Event : 	EPWM_CERB_DD_EPWMAB_OUT : TxֵEPWMx_RBĴҼʱEPWMxA/B
 *     				EPWM_CERB_DU_EPWMAB_OUT : TxֵEPWMx_RBĴҼʱEPWMxA/B
 *     				EPWM_CERA_DD_EPWMAB_OUT : TxֵEPWMx_RAĴҼʱEPWMxA/B
 *     				EPWM_CERA_DU_EPWMAB_OUT : TxֵEPWMx_RAĴҼʱEPWMxA/B
 *     				EPWM_CEPPX_EPWMAB_OUT : TxֵڼĴPPXʱEPWMxA/B
 *     				EPWM_CE0_EPWMAB_OUT : TxֵʱEPWMxA/B
 *      Select : 	EPWM_OUT_NONE : ¼
 *      			EPWM_OUT_LOW : ͵ƽ
 *      			EPWM_OUT_HIGH : ߵƽ
 *      			EPWM_OUT_TOGGLE : ת
 *   ޡ
 */
void
EPWM_EPWMxAB_OUTPUT_Select(EPWM_SFRmap* EPWMx,
			uint32_t Register, uint32_t Event, uint32_t Select)
{
	uint32_t tmpreg = 0;
	uint32_t tmask = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_REGISTER_AB(Register));
	CHECK_RESTRICTION(CHECK_EPWM_TXCOUNT_EQUAL_XX_EPWMAB_OUT(Event));
	CHECK_RESTRICTION(CHECK_EPWM_MANDATORY_OUT(Select));

	tmpreg = Select << (Event*2);
	tmask = 0x03 << (Event*2);
	if(Register == EPWM_REGISTER_A)
	{
		EPWMx->CTLA = SFR_Config(EPWMx->CTLA, ~tmask, tmpreg);
	}
	else if(Register == EPWM_REGISTER_B)
	{
		EPWMx->CTLB = SFR_Config(EPWMx->CTLB, ~tmask, tmpreg);
	}
}


/**
 *   ѡ
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 *      Select : 	EPWM_EPWMA_UP_EPWMA_DOWM : 	EPWMxAԲηģ飩Ϊ/½ģ
 *      			EPWM_EPWMB_UP_EPWMA_DOWM : 	EPWMxBԲηģ飩Ϊģ
												EPWMxAԲηģ飩Ϊ½ģ
 *      			EPWM_EPWMA_UP_EPWMB_DOWM : 	EPWMxAԲηģ飩Ϊģ
				 	 	 	 	 	 	 	 	EPWMxBԲηģ飩Ϊ½ģ
 *      			EPWM_EPWMB_UP_EPWMB_DOWM : 	Բηģ飩Ϊ/½ģ
 *   ޡ
 */
void
EPWM_Dead_Zone_Input_Select(EPWM_SFRmap* EPWMx, uint32_t Select)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_DEAD_ZONE(Select));

	tmpreg = Select << EPWM_DBCTL_INMODE0_POS;
	EPWMx->DBCTL = SFR_Config(EPWMx->DBCTL, ~EPWM_DBCTL_INMODE, tmpreg);
}
/**
 *   ѡ
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 *      Select : 	EPWM_EPWMA_NTOGGLE_EPWMB_NTOGGLE : 	EPWMxAEPWMxB/½ģ飩ת
 *      			EPWM_EPWMA_TOGGLE_EPWMB_NTOGGLE : 	EPWMxAתEPWMxBת/½ģ飩
 *      			EPWM_EPWMA_NTOGGLE_EPWMB_TOGGLE : 	EPWMxBתEPWMxAת/½ģ飩
 *      			EPWM_EPWMA_TOGGLE_EPWMB_TOGGLE : 	EPWMxAEPWMxB/½ģ飩ת
 *   ޡ
 */
void
EPWM_Dead_Zone_Output_Polarity_Select(EPWM_SFRmap* EPWMx, uint32_t Select)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_DEAD_ZONE_OUT_POLARITY(Select));

	tmpreg = Select << EPWM_DBCTL_POLSEL0_POS;
	EPWMx->DBCTL = SFR_Config(EPWMx->DBCTL, ~EPWM_DBCTL_POLSEL, tmpreg);
}
/**
 *   ѡ
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 *      Select : 	EPWM_UP_BYPASS_DOWN_BYPASS : 	/½ģ鶼·
 *      			EPWM_UP_BYPASS_DOWN_ENABLE : 	ģ鱻·½ģʹ
 *      			EPWM_UP_ENABLE_DOWN_BYPASS : 	ģ鱻ʹܣ½ģ·
 *      			EPWM_UP_ENABLE_DOWN_ENABLE : 	/½ģ鶼ʹ
 *   ޡ
 */
void
EPWM_Dead_Zone_Output_Select(EPWM_SFRmap* EPWMx, uint32_t Select)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_DEAD_ZONE_OUT(Select));

	tmpreg = Select << EPWM_DBCTL_OUTMODE0_POS;
	EPWMx->DBCTL = SFR_Config(EPWMx->DBCTL, ~EPWM_DBCTL_OUTMODE, tmpreg);
}
/**
 *   ʱ
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 *      Select : 	EPWM_UP_EDGE_DEAD_ZONE : ʱ
 *      			EPWM_DOWM_EDGE_DEAD_ZONE : ½ʱ
 *      Value : ʱ Value <= 0xFFFF
 *   ޡ
 */
void
EPWM_Dead_Zone_Time_Config(EPWM_SFRmap* EPWMx, uint32_t Select, uint32_t Value)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_UP_DOWN_EDGE_DEAD_ZONE(Select));
	CHECK_RESTRICTION(CHECK_EPWM_16BIT_LIMIT(Value));

	if(Select == EPWM_UP_EDGE_DEAD_ZONE)
	{
		EPWMx->DBT = SFR_Config(EPWMx->DBT, ~EPWM_DBT_RDBT, Value << EPWM_DBT_RDBT0_POS);
	}
	else if(Select == EPWM_DOWM_EDGE_DEAD_ZONE)
	{
		EPWMx->DBT = SFR_Config(EPWMx->DBT, ~EPWM_DBT_FDBT, Value);
	}
}


/**
 *   PCLKƵ
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 *      Select : 	EPWM_PCLK_DIV1 : 1Ƶ
 *      			EPWM_PCLK_DIV2 : 2Ƶ
 *      			EPWM_PCLK_DIV3 : 3Ƶ
 *      			EPWM_PCLK_DIV4 : 4Ƶ
 *      			EPWM_PCLK_DIV5 : 5Ƶ
 *      			EPWM_PCLK_DIV6 : 6Ƶ
 *      			EPWM_PCLK_DIV7 : 7Ƶ
 *      			EPWM_PCLK_DIV8 : 8Ƶ
 *   ޡ
 */
void
EPWM_PCLK_Frequency_Config(EPWM_SFRmap* EPWMx, uint32_t Select)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_PCLK_DIV(Select));

	tmpreg = Select << EPWM_PCCTL_CHPFREQ0_POS;
	EPWMx->PCCTL = SFR_Config(EPWMx->PCCTL, ~EPWM_PCCTL_CHPFREQ, tmpreg);
}
/**
 *   PCLKռձ
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 *      Select : 	EPWM_PCLK_DUTY_CYCLE78 : 7/8ռձ
 *      			EPWM_PCLK_DUTY_CYCLE68 : 6/8ռձ
 *      			EPWM_PCLK_DUTY_CYCLE58 : 5/8ռձ
 *      			EPWM_PCLK_DUTY_CYCLE48 : 4/8ռձ
 *      			EPWM_PCLK_DUTY_CYCLE38 : 3/8ռձ
 *      			EPWM_PCLK_DUTY_CYCLE28 : 2/8ռձ
 *      			EPWM_PCLK_DUTY_CYCLE18 : 1/8ռձ
 *   ޡ
 */
void
EPWM_PCLK_Duty_Cycle_Config(EPWM_SFRmap* EPWMx, uint32_t Select)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_PCLK_DUTY_CYCLE(Select));

	tmpreg = Select << EPWM_PCCTL_CHPDUTY0_POS;
	EPWMx->PCCTL = SFR_Config(EPWMx->PCCTL, ~EPWM_PCCTL_CHPDUTY, tmpreg);
}
/**
 *   նһѡ
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 *      Select : 	EPWM_CHOPPING_PULSE_WIDTH1 : 1նʱڣնʱӵ1/8ʱӣ
 *      			EPWM_CHOPPING_PULSE_WIDTH2 : 2նʱ
 *      			EPWM_CHOPPING_PULSE_WIDTH3 : 3նʱ
 *      			EPWM_CHOPPING_PULSE_WIDTH4 : 4նʱ
 *      			EPWM_CHOPPING_PULSE_WIDTH5 : 5նʱ
 *      			EPWM_CHOPPING_PULSE_WIDTH6 : 6նʱ
 *      			EPWM_CHOPPING_PULSE_WIDTH7 : 7նʱ
 *      			EPWM_CHOPPING_PULSE_WIDTH8 : 8նʱ
 *      			EPWM_CHOPPING_PULSE_WIDTH9 : 9նʱ
 *      			EPWM_CHOPPING_PULSE_WIDTH10 : 10նʱ
 *      			EPWM_CHOPPING_PULSE_WIDTH11 : 11նʱ
 *      			EPWM_CHOPPING_PULSE_WIDTH12 : 12նʱ
 *      			EPWM_CHOPPING_PULSE_WIDTH13 : 13նʱ
 *      			EPWM_CHOPPING_PULSE_WIDTH14 : 14նʱ
 *      			EPWM_CHOPPING_PULSE_WIDTH15 : 15նʱ
 *      			EPWM_CHOPPING_PULSE_WIDTH16 : 16նʱ
 *   ޡ
 */
void
EPWM_Chopping_Pulse_Width_Config(EPWM_SFRmap* EPWMx, uint32_t Select)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_CHOPPING_PULSE_WIDTH(Select));

	tmpreg = Select << EPWM_PCCTL_OSHTWTH0_POS;
	EPWMx->PCCTL = SFR_Config(EPWMx->PCCTL, ~EPWM_PCCTL_OSHTWTH, tmpreg);
}
/**
 *   նģʹ
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 *      NewState : 	TRUE : ʹն
 *      			FALSE : ֹն
 *   ޡ
 */
void
EPWM_Chopping_Pulse_Mode_Enable(EPWM_SFRmap* EPWMx, FunctionalState NewState)
{
	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	EPWMx->PCCTL = SFR_Config(EPWMx->PCCTL, ~EPWM_PCCTL_CHPEN, NewState);
}


/**
 *   EPWMxԶʹ
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 *      NewState : 	EPWM_PXASE_SOFTWARE_CLEAR_RESET : ԶرʱPXASE㣬EPWM
 *      			EPWM_PXASE_AUTO_CLEAR_RESET : Զرʱر¼ʧPXASEλԶ㣬EPWMԶ
 *   ޡ
 */
void
EPWM_Auto_Reset_Enable(EPWM_SFRmap* EPWMx, uint32_t NewState)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_PXASE_CLEAR_RESET(NewState));

	tmpreg = NewState << EPWM_PXASCTL_PXRSEN_POS;
	EPWMx->PXASCTL = SFR_Config(EPWMx->PXASCTL, ~EPWM_PXASCTL_PXRSEN, tmpreg);
}
/**
 *   EPWMxAر״̬
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 *      Status  	EPWM_DRIVER_PIN_EPWMAB_LOW : EPWMxA/BΪ͵ƽ
 *      			EPWM_DRIVER_PIN_EPWMAB_HIGH : EPWMxA/BΪߵƽ
 *      			EPWM_DRIVER_PIN_EPWMAB_3STATUS   :	EPWMxA/BΪ̬
 *   ޡ
 */
void
EPWM_Pin_EPWMA_ShouDown_Status_Config(EPWM_SFRmap* EPWMx, uint32_t Status)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_DRIVER_PIN_EPWMAB(Status));

	tmpreg = Status << EPWM_PXASCTL_PXSSA0_POS;
	EPWMx->PXASCTL = SFR_Config(EPWMx->PXASCTL, ~EPWM_PXASCTL_PXSSA, tmpreg);
}
/**
 *   EPWMxBر״̬
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 *      Status  	EPWM_DRIVER_PIN_EPWMAB_LOW : EPWMxA/BΪ͵ƽ
 *      			EPWM_DRIVER_PIN_EPWMAB_HIGH : EPWMxA/BΪߵƽ
 *      			EPWM_DRIVER_PIN_EPWMAB_3STATUS   :	EPWMxA/BΪ̬
 *   ޡ
 */
void
EPWM_Pin_EPWMB_ShouDown_Status_Config(EPWM_SFRmap* EPWMx, uint32_t Status)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_DRIVER_PIN_EPWMAB(Status));

	tmpreg = Status << EPWM_PXASCTL_PXSSB0_POS;
	EPWMx->PXASCTL = SFR_Config(EPWMx->PXASCTL, ~EPWM_PXASCTL_PXSSB, tmpreg);
}
/**
 *   ȡEPWMxԶر¼״̬
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 *   0   EPWMx
 * 		1   ˹ر¼EPWMxΪر״̬
 */
FlagStatus
EPWM_Get_Auto_ShowDown_Event_Status(EPWM_SFRmap* EPWMx)
{
	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));

	return ((EPWMx->PXASCTL & EPWM_PXASCTL_PXASE) >> EPWM_PXASCTL_PXASE_POS);
}
/**
 *   EPWMxԶر¼״̬
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 *  
 */
void
EPWM_Claer_Auto_ShowDown_Event_Status(EPWM_SFRmap* EPWMx)
{
	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));

	EPWMx->PXASCTL &= ~EPWM_PXASCTL_PXASE;
}
/**
 *   EPWMxԶرԴѡ
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 * 		Select :  EPWM_AUTO_SHOWDOWN_SOURCE_NO : ֹԶض
 * 				  EPWM_AUTO_SHOWDOWN_SOURCE_TZ1_HIGH :  TZ1ߵƽ
 * 				  EPWM_AUTO_SHOWDOWN_SOURCE_TZ2_HIGH :  TZ2ߵƽ
 * 				  EPWM_AUTO_SHOWDOWN_SOURCE_TZ3_HIGH :  TZ3ߵƽ
 * 				  EPWM_AUTO_SHOWDOWN_SOURCE_TZ4_HIGH :  TZ4ߵƽ
 * 				  EPWM_AUTO_SHOWDOWN_SOURCE_CLKIF :  ģж
 * 				  EPWM_AUTO_SHOWDOWN_SOURCE_QEIIF :  QEIж
 *   ޡ
 */
void
EPWM_Auto_ShowDown_Source_Select(EPWM_SFRmap* EPWMx, uint32_t Select)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_AUTO_SHOWDOWN_SOURCE(Select));

	tmpreg = Select << EPWM_PXASCTL_PXASS0_POS;
	EPWMx->PXASCTL = SFR_Config(EPWMx->PXASCTL, ~EPWM_PXASCTL_PXASS, tmpreg);
}


/**
 *   AD¼ģʽѡ
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 * 		Event :   EPWM_TRIGGER_AD_EVENT0 : AD¼0
 * 				  EPWM_TRIGGER_AD_EVENT1 : AD¼1
 * 		Select :  EPWM_TRIGGER_AD_UP : 		ѡϼʽ´AD
 * 				  EPWM_TRIGGER_AD_DOWM :  	ѡ¼ʽ´AD
 * 				  EPWM_TRIGGER_AD_UD :  	ѡ¼ʽ´AD
 *   ޡ
 */
void
EPWM_Trigger_AD_Event_Mode_Select(EPWM_SFRmap* EPWMx, uint32_t Event, uint32_t Select)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_TRIGGER_AD_EVENT(Event));
	CHECK_RESTRICTION(CHECK_EPWM_TRIGGER_AD_UD(Select));

	if(Event == EPWM_TRIGGER_AD_EVENT1)
	{
		tmpreg = Select << EPWM_ETCTL_BTSEL0_POS;
		EPWMx->ETCTL = SFR_Config(EPWMx->ETCTL, ~EPWM_ETCTL_BTSEL, tmpreg);
	}
	else if(Event == EPWM_TRIGGER_AD_EVENT0)
	{
		tmpreg = Select << EPWM_ETCTL_ATSEL0_POS;
		EPWMx->ETCTL = SFR_Config(EPWMx->ETCTL, ~EPWM_ETCTL_ATSEL, tmpreg);
	}
}
/**
 *   AD¼źż
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 * 		Event :   EPWM_TRIGGER_AD_EVENT0 : AD¼0
 * 				  EPWM_TRIGGER_AD_EVENT1 : AD¼1
 *   AD
 */
uint8_t
EPWM_Get_Trigger_AD_Event_Single(EPWM_SFRmap* EPWMx, uint32_t Event)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_TRIGGER_AD_EVENT(Event));

	if(Event == EPWM_TRIGGER_AD_EVENT1)
	{
		return ((EPWMx->ETCTL & EPWM_ETCTL_BT) >> EPWM_ETCTL_BT0_POS);
	}
	else if(Event == EPWM_TRIGGER_AD_EVENT0)
	{
		return ((EPWMx->ETCTL & EPWM_ETCTL_AT) >> EPWM_ETCTL_AT0_POS);
	}
}
/**
 *   AD¼ѡ
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 * 		Event :   EPWM_TRIGGER_AD_EVENT0 : AD¼0
 * 				  EPWM_TRIGGER_AD_EVENT1 : AD¼1
 * 		Select :  EPWM_1_TRIGGER_EVENT_TRIGGER_AD : ÿһδźŶܲAD¼а
 * 				  EPWM_2_TRIGGER_EVENT_TRIGGER_AD : ÿδźŲAD¼
 * 				  EPWM_3_TRIGGER_EVENT_TRIGGER_AD : ÿδźŲAD¼
 * 				  EPWM_4_TRIGGER_EVENT_TRIGGER_AD : ÿĴδźŲAD¼
 *   ޡ
 */
void
EPWM_Trigger_Event_Cycle_Select(EPWM_SFRmap* EPWMx, uint32_t Event, uint32_t Select)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_TRIGGER_AD_EVENT(Event));
	CHECK_RESTRICTION(CHECK_EPWM_TRIGGER_EVENT_TRIGGER_AD(Select));

	if(Event == EPWM_TRIGGER_AD_EVENT1)
	{
		tmpreg = Select << EPWM_ETCTL_BPP0_POS;
		EPWMx->ETCTL = SFR_Config(EPWMx->ETCTL, ~EPWM_ETCTL_BPP, tmpreg);
	}
	else if(Event == EPWM_TRIGGER_AD_EVENT0)
	{
		tmpreg = Select << EPWM_ETCTL_APP0_POS;
		EPWMx->ETCTL = SFR_Config(EPWMx->ETCTL, ~EPWM_ETCTL_APP, tmpreg);
	}
}
/**
 *   AD¼
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 * 		Event :   EPWM_TRIGGER_AD_EVENT0 : AD¼0
 * 				  EPWM_TRIGGER_AD_EVENT1 : AD¼1
 * 		NewState :  TRUE : һδAD¼
 * 					FALSE : ʹAD¼
 *   ޡ
 */
void
EPWM_Software_Trigger_AD_Event_Enable(EPWM_SFRmap* EPWMx, uint32_t Event, FunctionalState NewState)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_TRIGGER_AD_EVENT(Event));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	if(Event == EPWM_TRIGGER_AD_EVENT1)
	{
		tmpreg = NewState << EPWM_ETCTL_BPP0_POS;
		EPWMx->ETCTL = SFR_Config(EPWMx->ETCTL, ~EPWM_ETCTL_FRCB, tmpreg);
	}
	else if(Event == EPWM_TRIGGER_AD_EVENT0)
	{
		tmpreg = NewState << EPWM_ETCTL_FRCB_POS;
		EPWMx->ETCTL = SFR_Config(EPWMx->ETCTL, ~EPWM_ETCTL_FRCA, tmpreg);
	}
}
/**
 *   AD¼ѡ
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 * 		Event :   EPWM_TRIGGER_AD_EVENT0 : AD¼0
 * 				  EPWM_TRIGGER_AD_EVENT1 : AD¼1
 * 		Select :  EPWM_TIMER_EQUAL_0PULSE : ʱֵ
 * 				  EPWM_TIMER_EQUAL_PPPULSE : ʱֵPP
 * 				  EPWM_TIMER_EQUAL_DUTYA : ʱֵռձAĴ
 * 				  EPWM_TIMER_EQUAL_DUTYB : ʱֵռձBĴ
 *   ޡ
 */
void
EPWM_Trigger_AD_Event_Select(EPWM_SFRmap* EPWMx, uint32_t Event, uint32_t Select)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_TRIGGER_AD_EVENT(Event));
	CHECK_RESTRICTION(CEHCK_EPWM_TRIGGER_AD_EVENT(Select));

	if(Event == EPWM_TRIGGER_AD_EVENT1)
	{
		tmpreg = Select << EPWM_ETCTL_SELB0_POS;
		EPWMx->ETCTL = SFR_Config(EPWMx->ETCTL, ~EPWM_ETCTL_SELB, tmpreg);
	}
	else if(Event == EPWM_TRIGGER_AD_EVENT0)
	{
		tmpreg = Select << EPWM_ETCTL_SELA0_POS;
		EPWMx->ETCTL = SFR_Config(EPWMx->ETCTL, ~EPWM_ETCTL_SELA, tmpreg);
	}
}
/**
 *   AD¼ʹ
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 * 		Event :   EPWM_TRIGGER_AD_EVENT0 : AD¼0
 * 				  EPWM_TRIGGER_AD_EVENT1 : AD¼1
 * 		NewState :  TRUE : ʹܴAD¼
 * 					FALSE : ֹAD¼
 *   ޡ
 */
void
EPWM_Trigger_AD_Event_Enable(EPWM_SFRmap* EPWMx, uint32_t Event, FunctionalState NewState)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_TRIGGER_AD_EVENT(Event));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	if(Event == EPWM_TRIGGER_AD_EVENT1)
	{
		tmpreg = NewState << EPWM_ETCTL_TOADENB_POS;
		EPWMx->ETCTL = SFR_Config(EPWMx->ETCTL, ~EPWM_ETCTL_TOADENB, tmpreg);
	}
	else if(Event == EPWM_TRIGGER_AD_EVENT0)
	{
		tmpreg = NewState << EPWM_ETCTL_TOADENA_POS;
		EPWMx->ETCTL = SFR_Config(EPWMx->ETCTL, ~EPWM_ETCTL_TOADENA, tmpreg);
	}
}



/**
 *   жʹ
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 * 		Select :   EPWM_COUNT_EQUAL_EPWMRD : TxֵEPWMx_RDж
 * 				   EPWM_COUNT_EQUAL_EPWMRC : TxֵEPWMx_RCж
 * 				   EPWM_COUNT_EQUAL_EPWMRA : TxֵEPWMx_RAж
 * 				   EPWM_COUNT_EQUAL_EPWMRB : TxֵEPWMx_RBж
 * 				   EPWM_COUNT_OVERFLOW : Txж
 * 				   EPWM_UPDATA_EVENT : Tx¼ж
 * 				   EPWM_SHOTDOWN_EVENT : Txض¼ж
 * 				   EPWM_TRIGGER_AD_EVENT1 : TxAD¼1ж
 * 				   EPWM_TRIGGER_AD_EVENT0 : TxAD¼0ж
 * 		NewState :  TRUE : ʹܸ¼ж
 * 					FALSE : ֹ¼ж
 *   ޡ
 */
void
EPWM_INT_Enable(EPWM_SFRmap* EPWMx, uint32_t Select, FunctionalState NewState)
{
	uint32_t tmpreg = 0;
	uint32_t tmask = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_FALG(Select));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	tmpreg = NewState << Select;
	tmask = 1 << Select;
	EPWMx->IE = SFR_Config(EPWMx->IE, ~tmask, tmpreg);
}
/**
 *   ȡжϱ־
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 * 		Select :   EPWM_COUNT_EQUAL_EPWMRD : TxֵEPWMx_RDж
 * 				   EPWM_COUNT_EQUAL_EPWMRC : TxֵEPWMx_RCж
 * 				   EPWM_COUNT_EQUAL_EPWMRA : TxֵEPWMx_RAж
 * 				   EPWM_COUNT_EQUAL_EPWMRB : TxֵEPWMx_RBж
 * 				   EPWM_COUNT_OVERFLOW : Txж
 * 				   EPWM_UPDATA_EVENT : Tx¼ж
 * 				   EPWM_SHOTDOWN_EVENT : Txض¼ж
 * 				   EPWM_TRIGGER_AD_EVENT1 : TxAD¼1ж
 * 				   EPWM_TRIGGER_AD_EVENT0 : TxAD¼0ж
 *   0  δ¼жϡ
 *      1  ¼ж
 */
FlagStatus
EPWM_Get_INT_Flag(EPWM_SFRmap* EPWMx, uint32_t Select)
{
	uint32_t tmask = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_FALG(Select));

	tmask = 1 << Select;
	return ((EPWMx->IF & tmask) >> Select);
}
/**
 *   жϱ־
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 * 		Select :   EPWM_COUNT_EQUAL_EPWMRD : TxֵEPWMx_RDж
 * 				   EPWM_COUNT_EQUAL_EPWMRC : TxֵEPWMx_RCж
 * 				   EPWM_COUNT_EQUAL_EPWMRA : TxֵEPWMx_RAж
 * 				   EPWM_COUNT_EQUAL_EPWMRB : TxֵEPWMx_RBж
 * 				   EPWM_COUNT_OVERFLOW : Txж
 * 				   EPWM_UPDATA_EVENT : Tx¼ж
 * 				   EPWM_SHOTDOWN_EVENT : Txض¼ж
 * 				   EPWM_TRIGGER_AD_EVENT1 : TxAD¼1ж
 * 				   EPWM_TRIGGER_AD_EVENT0 : TxAD¼0ж
 *   ޡ
 */
void
EPWM_Clear_INT_Flag(EPWM_SFRmap* EPWMx, uint32_t Select)
{
	uint32_t tmask = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_FALG(Select));

	tmask = 1 << Select;
	EPWMx->IC = SFR_Config(EPWMx->IC, ~tmask, tmask);
	while(EPWMx->IF & tmask);
	EPWMx->IC = SFR_Config(EPWMx->IC, ~tmask, 0);
}
/**
 *   DMA
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 * 		Select :   EPWM_COUNT_EQUAL_EPWMRD : TxֵEPWMx_RDж
 * 				   EPWM_COUNT_EQUAL_EPWMRC : TxֵEPWMx_RCж
 * 				   EPWM_COUNT_EQUAL_EPWMRA : TxֵEPWMx_RAж
 * 				   EPWM_COUNT_EQUAL_EPWMRB : TxֵEPWMx_RBж
 * 				   EPWM_COUNT_OVERFLOW : Txж
 * 				   EPWM_UPDATA_EVENT : Tx¼ж
 * 				   EPWM_SHOTDOWN_EVENT : Txض¼ж
 * 				   EPWM_TRIGGER_AD_EVENT1 : TxAD¼1ж
 * 				   EPWM_TRIGGER_AD_EVENT0 : TxAD¼0ж
 * 		NewState :  TRUE : ʹܸ¼DMA
 * 					FALSE : ֹ¼DMA
 *   ޡ
 */
void
EPWM_Trigger_DMA_Enable(EPWM_SFRmap* EPWMx, uint32_t Select, FunctionalState NewState)
{
	uint32_t tmpreg = 0;
	uint32_t tmask = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_FALG(Select));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	tmpreg = NewState << Select;
	tmask = 1 << Select;
	EPWMx->DE = SFR_Config(EPWMx->DE, ~tmask, tmpreg);
}
/**
 *   ȡDMA־
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 * 		Select :   EPWM_COUNT_EQUAL_EPWMRD : TxֵEPWMx_RDж
 * 				   EPWM_COUNT_EQUAL_EPWMRC : TxֵEPWMx_RCж
 * 				   EPWM_COUNT_EQUAL_EPWMRA : TxֵEPWMx_RAж
 * 				   EPWM_COUNT_EQUAL_EPWMRB : TxֵEPWMx_RBж
 * 				   EPWM_COUNT_OVERFLOW : Txж
 * 				   EPWM_UPDATA_EVENT : Tx¼ж
 * 				   EPWM_SHOTDOWN_EVENT : Txض¼ж
 * 				   EPWM_TRIGGER_AD_EVENT1 : TxAD¼1ж
 * 				   EPWM_TRIGGER_AD_EVENT0 : TxAD¼0ж
 *   0  δ¼DMA
 *      1  ¼DMA
 */
FlagStatus
EPWM_Get_Trigger_DMA_Flag(EPWM_SFRmap* EPWMx, uint32_t Select)
{
	uint32_t tmask = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_FALG(Select));

	tmask = 1 << Select;
	return ((EPWMx->DF & tmask) >> Select);
}
/**
 *   HRPWMB˿
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 * 		Select :   EPWM_EPWMB_NORMAL_OUTPUT : EPWMxB˿
 * 				   EPWM_EPWMB_REVERSE_OUTPUT_EPWMA : EPWMxB˿ڷEPWMxA
 *   
 */
void
EPWM_HRPWM_OUTPUTB_CONTRAL_Select(EPWM_SFRmap* EPWMx, uint32_t Select)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_EPWMB_OUTPUT(Select));

	tmpreg = Select << EPWM_HRPWMCTL_HRPOUTB_POS;
	EPWMx->HRPWMCTL = SFR_Config(EPWMx->HRPWMCTL, ~EPWM_HRPWMCTL_HRPOUTB, tmpreg);
}
/**
 *   ߾PWMʹ
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 * 		NewState :   TRUE : ʹHRPWM
 * 				     FALSE : ֹHRPWM
 *   
 */
void
EPWM_HRPWM_Enable(EPWM_SFRmap* EPWMx, FunctionalState NewState)
{
	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	EPWMx->HRPWMCTL = SFR_Config(EPWMx->HRPWMCTL, ~EPWM_HRPWMCTL_HRPEN, NewState);
}
/**
 *   8λ߾PWMռձ
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 * 		Value : Value <= 0xFF
 *   
 */
void
EPWM_8Bit_HRPWM_Duty_Cycle(EPWM_SFRmap* EPWMx, uint8_t Value)
{
	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_8BIT_LIMIT(Value));

	EPWMx->HRCMP = Value;
}
/**
 *   ȡ׽ĵǰֵ
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 *   32λ׽ĵǰֵ
 */
uint32_t
EPWM_Get_Cap_Register_Current_Value(EPWM_SFRmap* EPWMx)
{
	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));

	return EPWMx->CAP;
}
/**
 *   EPWMx_UDCTL¼
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 * 		Mode : 	EPWM_UDCTL_PPUD : Tx_PPXڼĴ
 * 				EPWM_UDCTL_PRUD : Tx_PRSCĴ
 * 				EPWM_UDCTL_CMAUD : EPWMx_RAĴ
 * 				EPWM_UDCTL_CMBUD : EPWMx_RBĴ
 * 				EPWM_UDCTL_CMCUD : EPWMx_RCĴ
 * 				EPWM_UDCTL_CMDUD : EPWMx_RDĴ
 * 				EPWM_UDCTL_EAUD : EPWMx_CTLAĴ
 * 				EPWM_UDCTL_EBUD : EPWMx_CTLBĴ
 * 				EPWM_UDCTL_HRPUD :  EPWMx_HRCMPĴ
 * 		NewState : 	TRUE : ʹ
 * 					FALSE : ֹ
 *   
 */
void
EPWM_UDCTL_Updata_Enable(EPWM_SFRmap* EPWMx, uint32_t Mode, FunctionalState NewState)
{
	uint32_t tmpreg = 0;
	uint32_t tmask = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_UDCTL_UD(Mode));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	tmpreg = NewState << (Mode*3);
	tmask = 1 << (Mode*3);
	EPWMx->UDCTL = SFR_Config(EPWMx->UDCTL, ~tmask, tmpreg);
}
/**
 *   EPWMx_UDCTL¼ѡ
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 * 		Mode : 	EPWM_UDCTL_PPUD : Tx_PPXڼĴ
 * 				EPWM_UDCTL_PRUD : Tx_PRSCĴ
 * 				EPWM_UDCTL_CMAUD : EPWMx_RAĴ
 * 				EPWM_UDCTL_CMBUD : EPWMx_RBĴ
 * 				EPWM_UDCTL_CMCUD : EPWMx_RCĴ
 * 				EPWM_UDCTL_CMDUD : EPWMx_RDĴ
 * 				EPWM_UDCTL_EAUD : EPWMx_CTLAĴ
 * 				EPWM_UDCTL_EBUD : EPWMx_CTLBĴ
 * 				EPWM_UDCTL_HRPUD :  EPWMx_HRCMPĴ
 * 		Select : 	EPWM_COUNT_VALUE_EQUAL_0 : ֵ0ʱ
 * 					EPWM_COUNT_VALUE_EQUAL_TxPPX : ֵTx_PPXֵʱ
 * 					EPWM_COUNT_VALUE_EQUAL_0_TxPPX : ֵ0ߵTx_PPXֵʱ
 * 					EPWM_INPUT_SYCN_SINGLE : ͬźʱ
 *   
 */
void
EPWM_UDCTL_Register_Updata_Event_Select(EPWM_SFRmap* EPWMx, uint32_t Mode, uint32_t Select)
{
	uint32_t tmpreg = 0;
	uint32_t tmask = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_EPWM_UDCTL_UD(Mode));
	CHECK_RESTRICTION(CEHCK_EPWM_TXPPX_CYCLE_UPDATA_EVENT(Select));

	tmpreg = Select << (EPWM_UDCTL_PPUDSEL0_POS + Mode*3);
	tmask = 0x03 << (EPWM_UDCTL_PPUDSEL0_POS + Mode*3);
	EPWMx->UDCTL = SFR_Config(EPWMx->UDCTL, ~tmask, tmpreg);
}
/**
 *   ȫּʹ
 *   EPWMx: ָEPWMڴṹָ룬ȡֵΪEPWM11_SFREPWM12_SFREPWM13_SFREPWM16_SFR
 * 		NewState : 	TRUE :	ѡȫּ
 * 					FALSE : ѡȫּ
 *   
 */
void
EPWM_Global_Loading_Enable(EPWM_SFRmap* EPWMx, FunctionalState NewState)
{
	uint32_t tmpreg = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_EPWM_ALL_PERIPH(EPWMx));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	tmpreg = NewState << EPWM_UDCTL_GBUDEN_POS;
	EPWMx->UDCTL = SFR_Config(EPWMx->UDCTL, ~EPWM_UDCTL_GBUDEN, tmpreg);
}




