/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : KF32A156_iwdt.c                             	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-08                                            *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : The file provides functions related to the independent*
 *                  	watchdog (IWDT) , including:                          *
 *          			+ Independent Watchdog (IWDT) control function	      *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/

#include "kf32a156_iwdt.h"

/*******************************************************************************
**         		    (IDWT) Moudle private macro definition 		              **
*******************************************************************************/

/* IWDT_FDĴιֵ */
#define FEED_THE_DOG                    ((uint32_t)0x55AA55AA)

/**
  *   ##### Ź(IWDT)ƹܺ #####
  */
/**
  *   öŹԤƵŹʱӽзƵ
  *   Prescaler: ŹʱӵԤƵֵȡֵΪ
  *                    IWDT_PRESCALER_32: 32Ƶ
  *                    IWDT_PRESCALER_64: 64Ƶ
  *                    IWDT_PRESCALER_128: 128Ƶ
  *                    IWDT_PRESCALER_256: 256Ƶ
  *                    IWDT_PRESCALER_512: 512Ƶ
  *                    IWDT_PRESCALER_1024: 1024Ƶ
  *                    IWDT_PRESCALER_2048: 2048Ƶ
  *                    IWDT_PRESCALER_4096: 4096Ƶ
  *                    IWDT_PRESCALER_8192: 8192Ƶ
  *                    IWDT_PRESCALER_16384: 16384Ƶ
  *                    IWDT_PRESCALER_32768: 32768Ƶ
  *                    IWDT_PRESCALER_65536: 65536Ƶ
  *   ޡ
  */
void
IWDT_Prescaler_Config (uint32_t Prescaler)
{
    /* У */
    CHECK_RESTRICTION(CHECK_IWDT_PRESCALER(Prescaler));

    /*---------------- IWDT_CTLĴIWDTPSλ ----------------*/
    IWDT_CTL = SFR_Config (IWDT_CTL, ~IWDT_CTL_IWDTPS, Prescaler);
}

/**
  *   öŹĹʱӡ
  *   Source: ŹʱӣȡֵΪ
  * 			IWDT_SCK_INTLF
  * 			IWDT_SCK_EXTLF
  *   ޡ
  */
void
IWDT_SCK_Source_Select(uint32_t Source)
{
	/* У */
	CHECK_RESTRICTION(CHECK_IWDT_SCK(Source));

	IWDT_CTL = SFR_Config(IWDT_CTL, ~IWDT_CTL_CLKS, Source << IWDT_CTL_CLKS_POS);
}

/**
  *   öŹֵʱλ
  *   Overflow: ŹֵȡֵΪ0~0xFFF
  *   ޡ
  */
void
IWDT_Overflow_Config (uint32_t Overflow)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_IWDTPS_OVERFLOW(Overflow));

    /*---------------- IWDT_CTLĴIWDTOVFλ ----------------*/
    tmpreg = Overflow << IWDT_CTL_IWDTOVF0_POS;
    IWDT_CTL = SFR_Config (IWDT_CTL, ~IWDT_CTL_IWDTOVF, tmpreg);
}

/**
  *   öŹʹܡ
  *   NewState: Źʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
IWDT_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- IWDT_CTLĴIWDTENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹܶŹʱ */
        SFR_SET_BIT_ASM(IWDT_CTL, IWDT_CTL_IWDTEN_POS);
    }
    else
    {
        /* δʹܶŹ */
        SFR_CLR_BIT_ASM(IWDT_CTL, IWDT_CTL_IWDTEN_POS);
    }
}

/**
  *   Źι
  *   ޡ
  *   ޡ
  */
void
IWDT_Feed_The_Dog (void)
{
    IWDT_FD = FEED_THE_DOG;
}
/**
  *   ##### Ź(IWDT)ƹܺ #####
  */
