/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : kf32a156_rng.c                               	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-08                                            *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file provides the Random number generator(RNG)   *
 *  				    peripherals function                              	  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/

#include "kf32a156_rng.h"
#include "kf32a156_rst.h"
#include "kf32a156_pclk.h"

/**
  * : λRNG裬ʹʱӡ
  * : ޡ
  * : ޡ
  */
void
RNG_Reset(void)
{
	RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_RNGRST, TRUE);
	RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_RNGRST, FALSE);
	PCLK_CTL3_Peripheral_Clock_Enable(PCLK_CTL3_RNGCLKEN, TRUE);
}
/**
  * : ģʽʹܡ
  * : 	NewState:
  * 				TRUE : ģ鹤ģʽ
  * 				FALSE  ģ鹤αģʽ
  * : ޡ
  */
void
RNG_Real_RNG_Mode_Enable(FunctionalState NewState)
{
	/* У */
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	RNG_CTL = SFR_Config(RNG_CTL, ~RNG_CTL_TRNGMS, NewState << RNG_CTL_TRNGMS_POS);
}
/**
  * : ӽʹܡ
  * : 	NewState:
  * 				TRUE : ʹӽ
  * 				FALSE  ֹӽ
  * : ޡ
  */
void
RNG_Real_RNG_Seed_Correct_Enable(FunctionalState NewState)
{
	/* У */
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	RNG_CTL = SFR_Config(RNG_CTL, ~RNG_CTL_RECEN, NewState << RNG_CTL_RECEN_POS);
}
/**
  * : ӷ߹ʹܡ
  * : 	NewState:
  * 				TRUE : ʹܸ߹ģʽ
  * 				FALSE ֹ߹ģʽ
  * : ޡ
  */
void
RNG_Real_RNG_Seed_High_Pow_Enable(FunctionalState NewState)
{
	/* У */
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	RNG_CTL = SFR_Config(RNG_CTL, ~RNG_CTL_HIPOW, NewState << RNG_CTL_HIPOW_POS);
}
/**
  * : ӷƵУ׼
  * : 	Select:
  * 				RNG_FREQUENCY_CALI_GEAR0 : λ0
  * 				RNG_FREQUENCY_CALI_GEAR1 : λ1
  * 				RNG_FREQUENCY_CALI_GEAR2 : λ2
  * 				RNG_FREQUENCY_CALI_GEAR3 : λ3
  * : ޡ
  */
void
RNG_Real_RNG_Seed_Frequency_Cail_Select(uint32_t Select)
{
	/* У */
	CHECK_RESTRICTION(CHECK_RNG_FREQUENCY_CALI_GEAR(Select));

	RNG_CTL = SFR_Config(RNG_CTL, ~RNG_CTL_ADD, Select << RNG_CTL_ADD0_POS);
}
/**
  * : ʹܡ
  * : 	NewState:
  * 				TRUE : ʹ
  * 				FALSE ֹ
  * : ޡ
  */
void
RNG_Real_RNG_Seed_Output_Enable(FunctionalState NewState)
{
	/* У */
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	RNG_CTL = SFR_Config(RNG_CTL, ~RNG_CTL_TSEEDGO, NewState << RNG_CTL_TSEEDGO_POS);
}
/**
  * : ӷʹܡ
  * : 	NewState:
  * 				TRUE : ʹӷ
  * 				FALSE ֹӷ
  * : ޡ
  */
void
RNG_Real_RNG_Seed_Generator_Enable(FunctionalState NewState)
{
	/* У */
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	RNG_CTL = SFR_Config(RNG_CTL, ~RNG_CTL_TSEEDEN, NewState << RNG_CTL_TSEEDEN_POS);
}
/**
  * : RNG ʱӷƵơ
  * : 	DIV:
  * 				RNG_CLK_DIV1 : 1Ƶ
  * 				RNG_CLK_DIV2 : 2Ƶ
  * 				RNG_CLK_DIV4 : 4Ƶ
  * 				RNG_CLK_DIV8 : 8Ƶ
  * 				RNG_CLK_DIV16 : 16Ƶ
  * 				RNG_CLK_DIV32 : 32Ƶ
  * 				RNG_CLK_DIV64 : 64Ƶ
  * 				RNG_CLK_DIV128 : 128Ƶ
  * 				RNG_CLK_DIV256 : 256Ƶ
  * 				RNG_CLK_DIV512 : 512Ƶ
  * 				RNG_CLK_DIV1024 : 1024Ƶ
  * 				RNG_CLK_DIV2048 : 2048Ƶ
  * 				RNG_CLK_DIV4096 : 4096Ƶ
  * 				RNG_CLK_DIV8192 : 8192Ƶ
  * 				RNG_CLK_DIV16384 : 16384Ƶ
  * 				RNG_CLK_DIV32768 : 32768Ƶ
  * : ޡ
  */
void
RNG_CLK_DIV_Select(uint32_t DIV)
{
	/* У */
	CHECK_RESTRICTION(CHECK_RNG_CLK_DIV(DIV));

	RNG_CTL = SFR_Config(RNG_CTL, ~RNG_CTL_CLKDIV, DIV << RNG_CTL_CLKDIV0_POS);
}
/**
  * : RNGʱԴѡ
  * : 	CLK:
  * 				RNG_CLK_SCLK : ѡSCLKΪRNGģ鹤ʱ
  * 				RNG_CLK_HFCLK : ѡHFCLKΪRNGģ鹤ʱ
  * 				RNG_CLK_LFCLK : ѡLFCLKΪRNGģ鹤ʱ
  * 				RNG_CLK_INTLF : ѡINTLFΪRNGģ鹤ʱ
  * : ޡ
  */
void
RNG_Work_CLK_Select(uint32_t CLK)
{
	/* У */
	CHECK_RESTRICTION(CHECK_RNG_CLK(CLK));

	RNG_CTL = SFR_Config(RNG_CTL, ~RNG_CTL_CLKS, CLK << RNG_CTL_CLKS0_POS);
}
/**
  * : ѡ
  * : 	Seed:
  * 				RNG_SEED_CPU : CPUд
  * 				RNG_SEED_REAL : ӷ
  * : ޡ
  */
void
RNG_Seed_Select(uint32_t Seed)
{
	/* У */
	CHECK_RESTRICTION(CHECK_RNG_SEED(Seed));

	RNG_CTL = SFR_Config(RNG_CTL, ~RNG_CTL_RNGSEL, Seed << RNG_CTL_RNGSEL_POS);
}
/**
  * : RNGʹܡ
  * : 	NewState:
  * 				TRUE : ʹRNG
  * 				FALSE : ʹ
  * : ޡ
  */
void
RNG_Enable(FunctionalState NewState)
{
	/* У */
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	RNG_CTL = SFR_Config(RNG_CTL, ~RNG_CTL_RNGEN, NewState);
}


/**
  * : ĵǰ״̬
  * : 
  * : 	032λͬλ01
  * 		132λ010101010...
  */
FlagStatus
RNG_Get_Current_Error_Status(void)
{
	return ((RNG_STATE & RNG_STATE_DEIS) >> RNG_STATE_DEIS_POS);
}
/**
  * : жϱ־ʹܡ
  * : Select : 	RNG_INT_TSR  Ӿжϱ־
  * 				RNG_INT_DR  ݾжϱ־
  * 				RNG_INT_DE  жϱ־
  * 	  NewStateTRUE : ʹ
  * 	  			FALSE : 
  * : 
  */
void
RNG_INT_Enable(uint32_t Select, FunctionalState NewState)
{
	uint32_t tmpreg = 0;
	uint32_t tmask = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_RNG_INT(Select));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	tmpreg = NewState << (RNG_STATE_DEIE_POS + Select);
	tmask = (uint32_t)1 << (RNG_STATE_DEIE_POS + Select);
	RNG_STATE = SFR_Config(RNG_STATE, ~tmask, tmpreg);
}
/**
  * : жϱ־㡣
  * : Select : 	RNG_INT_TSR  Ӿжϱ־
  * 				RNG_INT_DR  ݾжϱ־
  * 				RNG_INT_DE  жϱ־
  * : 
  */
void
RNG_Clear_INT_Flag(uint32_t Select)
{
	uint32_t tmpreg = 0;
	uint32_t tmask = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_RNG_INT(Select));

	tmpreg = (uint32_t)1 << (RNG_STATE_DEIC_POS + Select);
	tmask = (uint32_t)1 << (RNG_STATE_DEIC_POS + Select);
	RNG_STATE = SFR_Config(RNG_STATE, ~tmask, tmpreg);
	while(RNG_STATE & ((uint32_t)1<<Select));
	RNG_STATE = SFR_Config(RNG_STATE, ~tmask, FALSE);
}
/**
  * : ȡжϱ־
  * : Select : 	RNG_INT_TSR  Ӿжϱ־
  * 				RNG_INT_DR  ݾжϱ־
  * 				RNG_INT_DE  жϱ־
  * : 0 δûд
  * 	  1 : ()
  */
FlagStatus
RNG_Get_INT_Flag(uint32_t Select)
{
	uint32_t tmpreg = 0;
	uint32_t tmask = 0;

	/* У */
	CHECK_RESTRICTION(CHECK_RNG_INT(Select));

	tmask = (uint32_t)1 << Select;
	return ((RNG_STATE & tmask) >> Select);
}
/**
  * : ȡӡ
  * 룺
  * : 16λ
  */
uint16_t
RNG_Seed_Value(void)
{
	return (RNG_SEED & 0xFFFF);
}
/**
  * : ȡӡ
  * 룺
  * : 16λ
  */
uint32_t
RNG_Data_Value(void)
{
	return RNG_DR;
}



