/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : main.c                                         	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : Show how to use external or internal clock and output *
 *  					clock through special pin							  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "system_init.h"

/*******************************************************************************
**                      	Private Macro Definitions                         **
*******************************************************************************/
/**
 * @brief Select the type of clock output from the OSC_OUT pins.In the following
 * line choose the out type
 * 	CLKOUT_SCLK		----  select main system clock
 * 	CLKOUT_EXTLF	----  select External low frequency crystal oscillator
 * 	CLKOUT_EXTHF	----  select External high frequency crystal oscillator
 * 	CLKOUT_INTLF	----  select Internal low frequency crystal oscillator
 * 	CLKOUT_INTHF	----  select Internal high frequency crystal oscillator
 * 	CLKOUT_PLL		----  select PLL
 * */
#if !defined  (CLK_OUT_TYPE)
  #define CLK_OUT_TYPE    	(CLKOUT_SCLK)
#endif /* HSI_STARTUP_TIMEOUT */

/*******************************************************************************
**                     			main Functions 		             	     	  **
*******************************************************************************/
int main()
{
	/* Initialize the system clock is 120M, and enable the INTHF,INTLF,EXTHF,PLL */
	SystemInit(120);
	/* Setup SysTick Timer as delay function, and input frequency is 120M */
	systick_delay_init(120);
	/* Enale EXTLF */
	OSC_EXTLF_Software_Enable(TRUE);
	OSC_EXTLF_Start_Delay_Config(EXT_START_DELAY_1024);
	while(OSC_Get_EXTLF_INT_Flag() != SET);
	/* Enale LP4M */
	OSC_LP4M_Software_Enable(TRUE);
	while(OSC_Get_LP4MIF_INT_Flag() != SET);
	/* Configure PE13 remap to SCLKOUT */
	GPIO_Write_Mode_Bits(GPIOE_SFR, GPIO_PIN_MASK_13, GPIO_MODE_RMP);
	GPIO_Pin_RMP_Config(GPIOE_SFR, GPIO_Pin_Num_13, GPIO_RMP_AF0);
	/* Select the type of clock output from the OSC_OUT pins !!! */
	OSC_SCLK_Output_Select(CLK_OUT_TYPE);
	/* Enable SCLKOUT, and frequency division is <1:16> */
	OSC_SCLK_Output_Division_Config(CLKOUT_DIVISION_16);
	OSC_SCLK_Output_Enable(TRUE);
	while(1)
	{

	}		
}

/**
 *  @brief : Reports the name of the source file and the source line number
 *           where the assert_param error has occurred.
 *  @param in :	file pointer to the source file name
 * 	@param in :	line assert_param error line source number
 *  @param out :None
 *  @retval :None
 */
void check_failed(uint8_t* File, uint32_t Line)
{
	/* User can add his own implementation to report the file name and line number,
		ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	/* Infinite loop */
	while(1)
	{
		;
	}
};
