/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : main.c                                         	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This example demonstrates how go to STOP1 sleep mode, *
 * 						and wakeup source									  *
 * 						-Timer0 in STOP1 mode 								  *
 * 						-RTC beat Interrupt in STOP1 mode					  *
 * 						-WKUP pins in STOP1 mode							  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "system_init.h"

/******************************************************************************
**                      	Private variables                                **
******************************************************************************/
static volatile uint32_t TimingDelay;

/*******************************************************************************
**                     		   Global Functions 		             	      **
*******************************************************************************/
/**
 *  @brief :Initialize the LED GPIO ports
 * 			PD7	------------- UserKey
 * 			PD12 ------------ LED1
 * 			PH3 ------------- LED2
 *  @param in :None
 *  @param out :None 
 *  @retval :None
 */
void BoardGpioInit(void)
{
	GPIO_InitTypeDef GPIO_InitStructure;
	
	/* Configure PD12 LED1 output */
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;
	GPIO_InitStructure.m_OpenDrain = GPIO_POD_PP;
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;
	GPIO_InitStructure.m_Pin = GPIO_PIN_MASK_12;
	GPIO_Configuration(GPIOD_SFR , &GPIO_InitStructure);
	/* Configure PH3 LED2 output */
	GPIO_InitStructure.m_Pin = GPIO_PIN_MASK_3;
	GPIO_Configuration(GPIOH_SFR , &GPIO_InitStructure);
	/* Configure PA4 LED3 output */
	GPIO_InitStructure.m_Pin = GPIO_PIN_MASK_4;
	GPIO_Configuration(GPIOA_SFR , &GPIO_InitStructure);
	/* Configure PD7 user key input */
	GPIO_InitStructure.m_Mode = GPIO_MODE_IN;
	GPIO_InitStructure.m_Pin = GPIO_PIN_MASK_7;
	GPIO_Configuration(GPIOD_SFR , &GPIO_InitStructure);
}

/**
 *  @brief :Config the BKP area is enable, BKP register and data can be write and read
 *  @param in :None
 *  @param out :None
 *  @retval :None
 */
void BKP_WriteReadEnable(void)
{
	/* The backup domain register allows reading and writing */
	SFR_SET_BIT_ASM(OSC_CTL0, OSC_CTL0_PMWREN_POS);
	/* Backup domain exits reset mode */
	SFR_SET_BIT_ASM(PM_CTL0, PM_CTL0_BKPREGCLR_POS);
	/* The backup area allows reading and writing */
	SFR_SET_BIT_ASM(PM_CTL0, PM_CTL0_BKPWR_POS);
}

/**
 *  @brief : Initialize the WKUP2 Pin in PC2, WKUP1~5 in this way
 * 			'BKP_WriteReadEnable' function called must be first!!!
 *  @param in :None
 *  @param out :None
 *  @retval :None
 */
void WakeupPinInit(void)
{
	if (PM_Get_Reset_Flag(PM_WAKEUP_EXTERNAL_PIN_WKP2))
	{
		PM_Clear_External_Wakeup_Pin_Flag(PM_WAKEUP_EXTERNAL_PIN_WKP2);
	}
	PM_External_Wakeup_Pin_Enable(PM_PIN_WKP2, TRUE);
	PM_External_Wakeup_Edge_Config(PM_PIN_WKP2, PM_TRIGGER_RISE_EDGE);
}

/**
 *  @brief :Set the stop1 sleep mode, and go to sleep
 *  @param in :None
 *  @param out :None
 *  @retval :None
 */
void SystemGotoStandbyMode(void)
{
	/* Set stop1 sleep mode */
	PM_Low_Power_Mode_Config(PM_LOW_POWER_MODE_STANDBY);
	/* Go to sleep */
	asm("SLEEP");
}

/*******************************************************************************
**                     			Main Functions 		             	     	  **
*******************************************************************************/
/**
 *  @brief :Main program
 *  @param in :None
 *  @param out :None
 *  @retval :None
 */
int main()
{
	EINT_InitTypeDef EINT_17to19;
	volatile uint32_t i;
	/* Initialize the system clock is 120M */
	SystemInit(120);
	/* Setup SysTick Timer as delay function, and input frequency is 120M */
	systick_delay_init(120);
	/* Initialize the LED IOs */
	BoardGpioInit();
	/* Set the BKP area is enable */
	BKP_WriteReadEnable();
	/* Query whether it is WKUP2 pin wakeup, clear WKUP2 flag, and light the LED2 */
	if (PM_Get_Reset_Flag(PM_WAKEUP_EXTERNAL_PIN_WKP2))
	{
		PM_Clear_External_Wakeup_Pin_Flag(PM_WAKEUP_EXTERNAL_PIN_WKP2);
		/* Turn on LED3 to represent wake-up from RTC  */
		GPIO_Toggle_Output_Data_Config(GPIOH_SFR, GPIO_PIN_MASK_3);
	}
	/* Turn ON/OFF the LED1 every 200ms for 10 times, it showing power on state */
	do
	{
		GPIO_Toggle_Output_Data_Config(GPIOD_SFR, GPIO_PIN_MASK_12);
		systick_delay_ms(200);
	} while ((TimingDelay++ < 10));
	while(1)
	{
		/* Scan the user key */
		if (GPIO_Read_Input_Data_Bit(GPIOD_SFR, GPIO_PIN_MASK_7) == Bit_RESET)
		{
			/* Initialize the WKUP2 Pin in PC2 */
			WakeupPinInit();
			/* Go to Sleep */
			SystemGotoStandbyMode();
		}
	}		
}

/**
 *  @brief : Reports the name of the source file and the source line number
 *           where the assert_param error has occurred.
 *  @param in :	file pointer to the source file name
 * 	@param in :	line assert_param error line source number
 *  @param out :None
 *  @retval :None
 */
void check_failed(uint8_t* File, uint32_t Line)
{
	/* User can add his own implementation to report the file name and line number,
		ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	/* Infinite loop */
	while(1)
	{
		;
	}
};
