/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : kf_ic.c                                               *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : Main Interrupt Service Routines.                      *      
 *                      This file provides template for all exceptions        *
 *                      handler and peripherals interrupt service routine.    *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                          Include Files                                    **
******************************************************************************/
#include "system_init.h"
#include "User_SysTick.h"

/*******************************************************************************
**                   KF32A1x6 Processor Exceptions Handlers  		         **
*******************************************************************************/

//*****************************************************************************************
//                                 NMI Interrupt Course
//*****************************************************************************************	
void __attribute__((interrupt)) _NMI_exception (void)
{	

}

//*****************************************************************************************
//                               HardFault Interrupt Course
//*****************************************************************************************	
void __attribute__((interrupt)) _HardFault_exception (void)
{

}

//*****************************************************************************************
//                               StackFault Interrupt Course
//*****************************************************************************************	
void __attribute__((interrupt)) _StackFault_exception (void)
{

}

//*****************************************************************************************
//                               SVC Interrupt Course
//*****************************************************************************************	
void __attribute__((interrupt)) _SVC_exception (void)
{

}

//*****************************************************************************************
//                              SoftSV Interrupt Course
//*****************************************************************************************	
void __attribute__((interrupt)) _SoftSV_exception (void)
{

}
//*****************************************************************************************
//                              INT_EINTF17_19 Interrupt Course
//*****************************************************************************************
void __attribute__((interrupt)) _EINT19TO17_exception (void)
{
	//ⲿж17ж
	if(INT_Get_External_Flag(INT_EXTERNAL_INTERRUPT_17)) //RTCжʹõⲿж17
	{
		INT_External_Clear_Flag(INT_EXTERNAL_INTERRUPT_17);//ñ־λſ˳ж
		if(RTC_Get_Time_Tick_INT_Flag())//ж
		{
			RTC_Clear_Time_Tick_INT_Flag(); //жϱ־λ
			GPIO_Toggle_Output_Data_Config(GPIOB_SFR ,GPIO_PIN_MASK_13 ); //ָʾ˸һ
		}

		if(RTC_Get_Seconds_INT_Flag()) //ӽж
		{
			RTC_Clear_Seconds_INT_Flag(); //жϱ־λ
		}

		if(RTC_Get_Alarm_A_INT_Flag()) //Aж
		{
			RTC_Clear_Alarm_A_INT_Flag(); //Aı־λ
		}
	}
}



//*****************************************************************************************
//                              SysTick Interrupt Course
//*****************************************************************************************	
void __attribute__((interrupt)) _SysTick_exception (void)
{
	/*write ST_CV any valer,clear ST_CV*/
	SYSTICK_Counter_Updata();
	/*system tick count-dowm counter*/
	TimingDelay_Decrement();
}

