#ifndef FREERTOS_CONFIG_H
#define FREERTOS_CONFIG_H

/*-----------------------------------------------------------
 * Application specific definitions.
 * ʹʱӦȷ
 * These definitions should be adjusted for your particular hardware and
 * application requirements.
 * ӲƺӦ
 * THESE PARAMETERS ARE DESCRIBED WITHIN THE 'CONFIGURATION' SECTION OF THE
 * FreeRTOS API DOCUMENTATION AVAILABLE ON THE FreeRTOS.org WEB SITE.
 * ²FreeRTOSӦóӿ(API)ļӦãûԽãFreeRTOS.orgվȡ
 * See http://www.freertos.org/a00110.html.
 *----------------------------------------------------------*/

/* Ensure stdint is only used by the compiler, and not the assembler. */
/* ȷ׼ڱ򣬶ûл*/
#ifndef Message_RTOS_DEBUG
#define Message_RTOS_DEBUG
#endif

#ifndef Message_RTOS_DEBUG
	#define RTOS_DEBUG_MSG(...)           	(void)0
	#warning(warning:UART should be initialized already)

#else
	#include <stdio.h>
	#define RTOS_DEBUG_MSG(...)           	printf(__VA_ARGS__)
#endif


extern uint32_t RTOSSYSTEM_ERROR;

#define configUSE_PREEMPTION			1								//ʹռʽΪ0ʹЭʽ
#define configUSE_IDLE_HOOK				0								//ҹ
#define configUSE_TICK_HOOK				0								//Ĺҹ
#define configCPU_CLOCK_HZ				( 72000000 )					//CPUʱƵ,λHz
#define configTICK_RATE_HZ				( ( TickType_t ) 1000 )			//ʱƵʣλHz
#define configMAX_PRIORITIES			( 5 )							//ȼ
#define configMINIMAL_STACK_SIZE		( ( unsigned short ) 128 )		//СջռС,Ϊλ
#define configTOTAL_HEAP_SIZE			( ( size_t ) ( 20  * 1024 ) )	//ܶջ(ֽΪλ)
#define configMAX_TASK_NAME_LEN			( 10 )							//󳤶
#define configUSE_TRACE_FACILITY		1								//ѯܿأʹvTaskGetInfoxTaskGetApplicationTaskTag
#define configUSE_16_BIT_TICKS			0								//ʹ16bitorʹ32bit
#define configIDLE_SHOULD_YIELD			1								//лÿ
#define configUSE_MUTEXES				1								//ʹûź
#define configQUEUE_REGISTRY_SIZE		20								//м¼
#define configCHECK_FOR_STACK_OVERFLOW	2								//ջ(2-0)
#define configUSE_RECURSIVE_MUTEXES		1								//ʹõݹ黥ź
#define configUSE_MALLOC_FAILED_HOOK	1								//ڴҹ
#define configUSE_APPLICATION_TASK_TAG	0								//ʹӦǩãxTaskGetApplicationTaskTagvTaskSetApplicationTaskTag
#define configUSE_COUNTING_SEMAPHORES	1								//ʹüźſ
#define configGENERATE_RUN_TIME_STATS	0								//ͳʱ俪

//========================================
#define INCLUDE_uxTaskGetStackHighWaterMark		1						//ѯʣջС
#define INCLUDE_xSemaphoreGetMutexHolder		1
#ifdef Message_RTOS_DEBUG
	#if (!INCLUDE_uxTaskGetStackHighWaterMark || !INCLUDE_xSemaphoreGetMutexHolder)
		#error(use uxTaskGetStackHighWaterMark function must be set INCLUDE_uxTaskGetStackHighWaterMark and
		INCLUDE_xSemaphoreGetMutexHolder before)
	#endif
#endif
//========================================
/* Co-routine definitions. */
/* Ͻ̶*/
#define configUSE_CO_ROUTINES 		    0								//ʹϳ
#define configMAX_CO_ROUTINE_PRIORITIES ( 2 )							//ϳȼ

/* Software timer definitions. */
/* ʱ*/
#define configUSE_TIMERS				01								//ʱ
#define configTIMER_TASK_PRIORITY		( configMAX_PRIORITIES-1 )		//ʱȼ
#define configTIMER_QUEUE_LENGTH		10								//ʱг
#define configTIMER_TASK_STACK_DEPTH	( configMINIMAL_STACK_SIZE * 3 )//ʱջ

/* Set the following definitions to 1 to include the API function, or zero
to exclude the API function. */
/* ͨ궨Ϊ1ӦӦóӿڣAPIΪ0رӦ*/
#define INCLUDE_vTaskPrioritySet		1				//ȼú
#define INCLUDE_uxTaskPriorityGet		1				//ȼȡ
#define INCLUDE_vTaskDelete				1				//ɾ
#define INCLUDE_vTaskCleanUpResources	1				//Դ
#define INCLUDE_vTaskSuspend			1				//
#define INCLUDE_vTaskDelayUntil			1				//ȷʱ
#define INCLUDE_vTaskDelay				1				//ʱ

/*ȼλ*/
#define configPRIO_BITS       			4        		/* 15 priority levels */

/* The lowest interrupt priority that can be used in a call to a "set priority"
function. */
/* ͵жȼȼĺ*/
#define configLIBRARY_LOWEST_INTERRUPT_PRIORITY			15//жȼ

/* The highest interrupt priority that can be used by any interrupt service
routine that makes calls to interrupt safe FreeRTOS API functions.  DO NOT CALL
INTERRUPT SAFE FREERTOS API FUNCTIONS FROM ANY INTERRUPT THAT HAS A HIGHER
PRIORITY THAN THIS! (higher priorities are lower numeric values. */
/* ȼһЩFreeRTOSжϰȫAPIĳжϷ
 * Ҫȼȼֵͣ*/

#define configLIBRARY_MAX_SYSCALL_INTERRUPT_PRIORITY	1	//ϵͳжȼ

/* Interrupt priorities used by the kernel port layer itself.  These are generic
to all Cortex-M ports, and do not rely on any particular library functions. */
/* ĽӿڲжȼCortex-Mӿͬһ࣬κп⺯*/
/*ںжȼ*/
#define configKERNEL_INTERRUPT_PRIORITY 		( configLIBRARY_LOWEST_INTERRUPT_PRIORITY << (8 - configPRIO_BITS) )
/* !!!! configMAX_SYSCALL_INTERRUPT_PRIORITY must not be set to zero !!!!
See http://www.FreeRTOS.org/RTOS-Cortex-M3-M4.html. */
/*configMAX_SYSCALL_INTERRUPT_PRIORITY벻Ϊ0!!!Ϊ0÷/
/*жϰȫ汾FreeRTOS API ежȼ*/
#define configMAX_SYSCALL_INTERRUPT_PRIORITY 	( configLIBRARY_MAX_SYSCALL_INTERRUPT_PRIORITY << (8 - configPRIO_BITS) )
	
/*У*/
// #define configASSERT( x ) if( ( x ) == 0 ) { taskDISABLE_INTERRUPTS();for( ;; ); }	
#define configASSERT(x) if((x) == 0)                        \
{                                                           \
    asm("MOV R0,R13");                                      \
    asm("MOV R1,#RTOSSYSTEM_ERROR");                        \
    asm("ST.W [R1],R0");                                    \
    RTOS_DEBUG_MSG(",ַ0x%08X\r\n",RTOSSYSTEM_ERROR);   \
    RTOS_DEBUG_MSG("Wrong parameters value: file %s on line %d\r\n",__FILE__,__LINE__);\
    RTOS_DEBUG_MSG("releasedebuglstļвҳ\r\n");    \
    RTOS_DEBUG_MSG("ֹ\r\n");   \
    while(1);                       \
}   


/* Definitions that map the FreeRTOS port interrupt handlers to their CMSIS
standard names. */
/*FreeRTOSжϺӿCMSIS׼ƶ*/
//#define vPortSVCHandler 	_SVCAll_exception			//SVCallжϺ
//#define xPortPendSVHandler 	_PendSV_exception			//PendSVжϺ
//#define xPortSysTickHandler _SysTick_exception			//SysTickжϺ

#endif /* FREERTOS_CONFIG_H */

