/*****************************************************************************
*                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
******************************************************************************
*  @File Name        : SPI.c                                                 *
*  @Author           : ChipON AE/FAE Group                                   *
*  @Data$            : 2021-07-14                                            *
*  @Version          : V1.0                                                  *
*  @Description      : This file contains the spi configuration for KF32A156 *
*  devices                                                                   *
******************************************************************************
*  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
*  All rights reserved.                                                      *
*                                                                            *
*  This software is copyrght protected and proprietary to                    *
*  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
******************************************************************************
*  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
*                          REVISON HISTORY                                   *
*  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
*  Data       Version  Author        Description                             *
*  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
*  2021-07-14 00.01.00  AE Group     new creat                               *
*                                                                            *
*                                                                            *
*****************************************************************************/

/******************************************************************************
**                             Include Files                                **
******************************************************************************/
#include "SPI.h"

/*****************************************************************************
**                         Private Macro Definitions                        **
*****************************************************************************/

/*****************************************************************************
**                         Private Variables Definitions                    **
*****************************************************************************/
uint8_t Tx_Master[SPI_TRANSMISSION_DATA_SIZE] = "KF32A156-KungFu32 SPI Example master";
uint8_t Spi_ReadData[SPI_TRANSMISSION_DATA_SIZE];
/*****************************************************************************
**                             Private Functions                            **
*****************************************************************************/

/*****************************************************************************
**                             Global Functions                            **
*****************************************************************************/
/**
 *  @brief: Initialize the spi module
 *  @param in: SPIx
 *  @param out : None
 *  @retval : None
 */
void Spi_Init(SPI_SFRmap *SPIx)
{
    SPI_InitTypeDef Spi_ConfigPtr;

    /* SPI mode */
    Spi_ConfigPtr.m_Mode = SPI_MODE_MASTER_CLKDIV4;
    /* SPI clock */
    Spi_ConfigPtr.m_Clock = SPI_CLK_SCLK;
    /* Data transfer start control */
    Spi_ConfigPtr.m_FirstBit = SPI_FIRSTBIT_MSB;
    /* Spi idle state */
    Spi_ConfigPtr.m_CKP = SPI_CKP_LOW;
    /* Spi clock phase(Data shift edge) */
    Spi_ConfigPtr.m_CKE = SPI_CKE_1EDGE;
    /* Data width */
    Spi_ConfigPtr.m_DataSize = SPI_DATASIZE_8BITS;
    /* Baud rate :Fck_spi=Fck/2(m_BaudRate+1)*/
    Spi_ConfigPtr.m_BaudRate = 0x59;

    /* Spi reset */
    SPI_Reset(SPIx);
    /* Configure SPI module */
    SPI_Configuration(SPIx, &Spi_ConfigPtr);
    /* Enable SPI module */
    SPI_Cmd(SPIx, TRUE);
}

/**
 *  @brief: Initialize the SPI IO
 *  @param in: None
 *  @param out : None
 *  @retval : None
 */
void Spi_IO_Init()
{
    /* Configure SPI2 IO */
    /* 
     * SPI2_SCK = PD3
     * SPI2_SDI = PD2
     * SPI2_SDO = PG15
     * SPI2_SS0 = PG14
     */
    GPIO_Write_Mode_Bits(GPIOD_SFR, GPIO_PIN_MASK_2 | GPIO_PIN_MASK_3, GPIO_MODE_RMP);
    GPIO_Write_Mode_Bits(GPIOG_SFR, GPIO_PIN_MASK_14 | GPIO_PIN_MASK_15, GPIO_MODE_RMP);

    GPIO_Pin_RMP_Config(GPIOD_SFR, GPIO_Pin_Num_2, GPIO_RMP_AF4);
    GPIO_Pin_RMP_Config(GPIOD_SFR, GPIO_Pin_Num_3, GPIO_RMP_AF4);
    GPIO_Pin_RMP_Config(GPIOG_SFR, GPIO_Pin_Num_15, GPIO_RMP_AF4);
    GPIO_Pin_RMP_Config(GPIOG_SFR, GPIO_Pin_Num_14, GPIO_RMP_AF4);
}

/**
 *  @brief: Initialize the SPI interrupt
 *  @param in: SPIx
 *  @param out : None
 *  @retval : None
 */
void Spi_Interrupt_Init(SPI_SFRmap *SPIx)
{
    /* Send empty interrupt enable */
    SPI_TNEIE_INT_Enable(SPI2_SFR, TRUE);
    /* Total interrupt enable */
    INT_Interrupt_Enable(INT_SPI2, TRUE);
}
