/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : kf_ic.c                                               *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : Main Interrupt Service Routines.                      *      
 *                      This file provides template for all exceptions        *
 *                      handler and peripherals interrupt service routine.    *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                          Include Files                                    **
******************************************************************************/
#include "system_init.h"
#include "SPI.h"
#include <stdio.h>
/*******************************************************************************
**                   KF32A156 Processor Exceptions Handlers  		         **
*******************************************************************************/
extern uint8_t Spi_Length;
//*****************************************************************************************
//                                 NMI Interrupt Course
//*****************************************************************************************
void __attribute__((interrupt)) _NMI_exception(void)
{
}

//*****************************************************************************************
//                               HardFault Interrupt Course
//*****************************************************************************************
void __attribute__((interrupt)) _HardFault_exception(void)
{
}

//*****************************************************************************************
//                               StackFault Interrupt Course
//*****************************************************************************************
void __attribute__((interrupt)) _StackFault_exception(void)
{
}

//*****************************************************************************************
//                               SVC Interrupt Course
//*****************************************************************************************
void __attribute__((interrupt)) _SVC_exception(void)
{
}

//*****************************************************************************************
//                              SoftSV Interrupt Course
//*****************************************************************************************
void __attribute__((interrupt)) _SoftSV_exception(void)
{
}

//*****************************************************************************************
//                              SysTick Interrupt Course
//*****************************************************************************************
void __attribute__((interrupt)) _SysTick_exception(void)
{
}

//*****************************************************************************************
//                             SPI2 Interrupt Course
//*****************************************************************************************
void __attribute__((interrupt)) _SPI2_exception(void)
{
	/* Waiting for the sending buffer to be empty */
	if(SPI_Get_Transmit_Buf_Flag(SPI2_SFR)==RESET)
	{
		/* Polling to send string  */
		if(Spi_Length < SPI_TRANSMISSION_DATA_SIZE)
		{
			/* Send data */
			SPI_I2S_SendData8(SPI2_SFR,Tx_Master[Spi_Length]);
			/* Waiting to accept that the buffer is not empty */
			while(!SPI_Get_Receive_Buf_Flag(SPI2_SFR));
			/* Read the received data */
			Spi_ReadData[Spi_Length] = SPI_I2S_ReceiveData(SPI2_SFR);
			Spi_Length++;
			/* If it is full, use the serial port to print out the received data */
			if(Spi_Length == SPI_TRANSMISSION_DATA_SIZE)
			{
				/* Disable the send buffer is empty interrupt */
				SPI_TNEIE_INT_Enable(SPI2_SFR,FALSE);
				/* Waiting for spi to send no data */
				while(SPI_Get_BUSY_Flag(SPI2_SFR)==SET);
				Spi_Length = 0;
				printf("%s\r\n",Spi_ReadData);
				/* LED1 flashing */
				GPIO_Toggle_Output_Data_Config(GPIOD_SFR, GPIO_PIN_MASK_12);
				/* Enable the send buffer is empty interrupt */
				SPI_TNEIE_INT_Enable(SPI2_SFR,TRUE);
			}

		}
	}
}
