/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : User_SysTick.h                                        *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-9                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file contains the Header file configuration 	  *
 * 						for User_systick 						     		  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-09 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/


#ifndef USER_SYSTICK_H_
#define USER_SYSTICK_H_
/******************************************************************************
*                      system delay time defineition   (MS)                   *
******************************************************************************/
#define			SYSTEM_DELAY_1MS											(1UL)
#define			SYSTEM_DELAY_2MS											(2UL)
#define			SYSTEM_DELAY_5MS											(5UL)
#define			SYSTEM_DELAY_10MS											(10UL)
#define			SYSTEM_DELAY_20MS											(20UL)
#define			SYSTEM_DELAY_50MS											(50UL)
#define			SYSTEM_DELAY_100MS											(100UL)
#define			SYSTEM_DELAY_200MS											(200UL)
#define			SYSTEM_DELAY_500MS											(500UL)
#define			SYSTEM_DELAY_1000MS											(1000UL)

/******************************************************************************
*                      Functional defineition                                 *
******************************************************************************/
/*LED1 Debug*/
#define LED1_On()			GPIOD_SFR->POR |= (uint32_t)GPIO_PIN_MASK_5
#define LED1_Off()			GPIOD_SFR->POR &= ~(uint32_t)GPIO_PIN_MASK_5

void TimingDelay_Decrement(void);
void Systick_Delay(uint32_t delayTime);
void SysTick_Configuration(uint32_t Reload);
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin);


#endif /* USER_SYSTICK_H_ */
