/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : main.c                                         	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This is a template project used by system tick.		  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "system_init.h"
#include "User_SysTick.h"


/*******************************************************************************
**                     			main Functions 		             	     	  **
*******************************************************************************/
int main()
{
	/*initialize system clock ,defaut SCLK is  120M,select INTHF as Clock source */
	SystemInit(120);
	GPIOInit_Output_Config(GPIOD_SFR,GPIO_PIN_MASK_5);
	/******************************************************************
	SCLK out of PF3,for INTHF test
	*******************************************************************/
	GPIO_Write_Mode_Bits(GPIOF_SFR,GPIO_PIN_MASK_3,GPIO_MODE_RMP);
	GPIO_Pin_RMP_Config(GPIOF_SFR, GPIO_PIN_MASK_3, GPIO_RMP_AF0);
	GPIOF_SFR->OMOD|=((uint32_t)GPIO_PIN_MASK_3<<3);
	OSC_CTL1=0xF0000000;
	/******************************************************************/
	/*T=1/120M*120000=1ms,120M:SCLK*/
	SysTick_Configuration(120000);
	while(1)
	{
		LED1_On();
		Systick_Delay(SYSTEM_DELAY_100MS);
		LED1_Off();
		Systick_Delay(SYSTEM_DELAY_100MS);
	}		
}
/**
 *  @brief : Reports the name of the source file and the source line number
 *           where the assert_param error has occurred.
 *  @param in :	file pointer to the source file name
 * 	@param in :	line assert_param error line source number
 *  @param out :None
 *  @retval :None
 */
void check_failed(uint8_t* File, uint32_t Line)
{
	/* User can add his own implementation to report the file name and line number,
		ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	/* Infinite loop */
	while(1)
	{
		;
	}
};
