/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : User_T14.c                                        	  *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-12                                            *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This fiel provides template for T14.                  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-12 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "system_init.h"
#include "User_T14.h"
volatile uint16_t time_10ms=0;

/**
 *  @brief : Initialize Timer 14 and configuration Timer 14.
 *  @param in :	CNT_T:Counting period
 				Prescaler
 *  @param out :None
 *  @retval :None
 */
void BASIC_TIMER14_Config(uint16_t CNT_T,uint16_t Prescaler)
{
	
	TIM_Reset(T14_SFR);												
	BTIM_Updata_Immediately_Config(T14_SFR,TRUE);			
	BTIM_Updata_Enable(T14_SFR,TRUE);						
	BTIM_Work_Mode_Config(T14_SFR,BTIM_TIMER_MODE);			
	BTIM_Set_Counter(T14_SFR,0);							
	BTIM_Set_Period(T14_SFR,CNT_T);							
	BTIM_Set_Prescaler(T14_SFR,Prescaler);					
	BTIM_Counter_Mode_Config(T14_SFR,BTIM_COUNT_UP_OF);
	/*Select internal high frequency as clock source*/
	BTIM_Clock_Config(T14_SFR,BTIM_HFCLK);					
	INT_Interrupt_Priority_Config(INT_T14,4,0);				
	BTIM_Overflow_INT_Enable(T14_SFR,TRUE);					
	INT_Interrupt_Enable(INT_T14,TRUE);						 
	INT_Clear_Interrupt_Flag(INT_T14);						
	BTIM_Cmd(T14_SFR,TRUE);									
	INT_Stack_Align_Config(INT_STACK_SINGLE_ALIGN);			
	INT_All_Enable (TRUE);									
}


