/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : kf_it.c                                        	      *
 *  $Project Name$	  : KF32A156_USART										  *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-20- 18:04:36                                  *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file provides a reference for interrupt usart    *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/
#include"system_init.h"
#include "Usart.h"

//*****************************************************************************************
//                                 NMI Interrupt Course
//*****************************************************************************************	
void __attribute__((interrupt)) _NMI_exception (void)
{	

}

//*****************************************************************************************
//                               HardFault Interrupt Course
//*****************************************************************************************	

void __attribute__((interrupt)) _HardFault_exception (void)
{

}

//*****************************************************************************************
//                               StackFault Interrupt Course
//*****************************************************************************************	
void __attribute__((interrupt)) _StackFault_exception (void)
{

}

//*****************************************************************************************
//                               SVC Interrupt Course
//*****************************************************************************************	
void __attribute__((interrupt)) _SVC_exception (void)
{

}

//*****************************************************************************************
//                              SoftSV Interrupt Course
//*****************************************************************************************	
void __attribute__((interrupt)) _SoftSV_exception (void)
{

}

//*****************************************************************************************
//                              SysTick Interrupt Course
//*****************************************************************************************	
void __attribute__((interrupt)) _SysTick_exception (void)
{
	
}

//*****************************************************************************************
//                               USART0 Interrupt Course
//*****************************************************************************************
/* Usart0 receive data count */
volatile uint32_t TransmitCount = 0;
extern uint8_t UsartTxBuffer[];
extern uint8_t UsartRxBuffer[];
void __attribute__((interrupt)) _USART0_exception (void)
{
	static uint32_t ReceiveCount = 0;
	/*	If gets the status of the USART data ready interrupt flag */
	if(USART_Get_Receive_BUFR_Ready_Flag(USART0_SFR))
	{
		UsartRxBuffer[ReceiveCount++] = USART_ReceiveData(USART0_SFR);
	}
	/* If gets the USART interrupt flag for receiving idle frames */
	if (USART_Get_Receive_Frame_Idel_Flag(USART0_SFR))
	{
		/* Clear idle interrupt flag */
		USART_Clear_Idle_INT_Flag(USART0_SFR);
		/* Gets the length of the data received */
		TransmitCount = ReceiveCount;
		ReceiveCount = 0;
	}
}


