/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : main.c                                         	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file provides a reference for interrupt usart    *
 *                    asynchronous transceiver application routines		      *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
*                        		Include Files                                 *
******************************************************************************/
#include "system_init.h"
#include "Usart.h"
#include "Usart_Config.h"

/******************************************************************************
*                 	      Static function declaration                         *
******************************************************************************/
static void Led_Gpio_Init(void);
static void Led_Flip(void);

/******************************************************************************
*                           Array Definition                                  *
******************************************************************************/
uint8_t  Usart_Send_Sdu[] = {"ChipON\r\n"};
/* Usart send data array and receive data array */
uint8_t UsartTxBuffer[100];
uint8_t UsartRxBuffer[100];

extern volatile uint32_t TransmitCount ;
/******************************************************************************
*                        	Initialization function                           *
******************************************************************************/
/**
 *  @brief :Initializes the GPIO of the LED
 *  @param in :None
 *  @param out :None
 *  @retval :PD12--LED1
 *  		 PH3 --LED2
 *  		 PA4 --LED3
 *  		 PF7 --LED4
 */
static void Led_Gpio_Init(void)
{
	/*Configure the GPIO PA4/PD12/PF7/PH3 as IO port output mode */
	GPIO_Write_Mode_Bits(GPIOA_SFR, GPIO_PIN_MASK_4 , GPIO_MODE_OUT);
	GPIO_Write_Mode_Bits(GPIOD_SFR, GPIO_PIN_MASK_12 , GPIO_MODE_OUT);
	GPIO_Write_Mode_Bits(GPIOF_SFR, GPIO_PIN_MASK_7 , GPIO_MODE_OUT);
	GPIO_Write_Mode_Bits(GPIOH_SFR, GPIO_PIN_MASK_3 , GPIO_MODE_OUT);
}

/**
 *  @brief :Led flip
 *  @param in :None
 *  @param out :None
 *  @retval :PD12--LED1
 *  		 PH3 --LED2
 *  		 PA4 --LED3
 *  		 PF7 --LED4
 */
static void Led_Flip(void)
{
	/*Configure the GPIO port PA4/PD12/PF7/PH3 to specify the output data of the pins to be inverted*/
	GPIO_Toggle_Output_Data_Config(GPIOA_SFR, GPIO_PIN_MASK_4);
	GPIO_Toggle_Output_Data_Config(GPIOD_SFR, GPIO_PIN_MASK_12);
	GPIO_Toggle_Output_Data_Config(GPIOF_SFR, GPIO_PIN_MASK_7);
	GPIO_Toggle_Output_Data_Config(GPIOH_SFR, GPIO_PIN_MASK_3);
}

/*****************************************************************************
*                              	main function                                *
******************************************************************************/
int main()
{
	/* Initialize the system clock */
	SystemInit(120);
	/* Setup SysTick Timer as delay function */
	systick_delay_init(120);
	/*
	 * Initialize led IOs
	 * Configure the GPIO PA4/PD12/PF7/PH3 as IO port output mode
	 */
	Led_Gpio_Init();
	/*
	 *  Set Usart Tx and Rx PINS
	 *  PA3 -- USART0_TX0
	 *      - Configure PA3 remap mode
     *      - PushCpull output
	 *  PE7 -- USART0_RX
	 *      - Configure PE7 remap mode
	 *      - Configured in pull-up mode
	 */
	Usart_Gpio_Init();
	/*
	 * Set Usart0 working mode :
	 *    - Set Usart0 to async mode
	 *    - Set baudrate to 115200
	 *    - Set Usart to send enable
	 */
	USART_Mode_Config(USART0_SFR);
	/* Set Usart intterrupt
	 *   - Resetting USARTx sends the BUF interrupt bit
	 *   - SET USARTx RDR interrupt enable
	 *   - SET USARTx TFE interrupt enable
	 *   - Interrupt enables a peripheral or kernel interrupt vector
	 *   - Global shielded interrupt enable bit
	 */
	USART_Int_Config(USART0_SFR,INT_USART0);
	/* Configure interrupt priority group, default is 3VS1 */
	INT_Priority_Group_Config(INT_PRIORITY_GROUP_3VS1);
	/* Global shielded interrupt enable bit */
	INT_All_Enable(TRUE);

	/* Sends a string of characters and light up the led */
	USART_Send(USART0_SFR, Usart_Send_Sdu, sizeof(Usart_Send_Sdu));
	Led_Flip();

	while(1)
	{
		/* If data is received */
		if (TransmitCount)
		{
			/* Copy data from UsartRxBuffer to TransmitCount */
			memcpy(UsartTxBuffer, UsartRxBuffer, TransmitCount);
			USART_Send(USART0_SFR, UsartTxBuffer, TransmitCount);
			USART_Send(USART0_SFR, Usart_Send_Sdu, sizeof(Usart_Send_Sdu));
			/* Clear TransmitCount */
			TransmitCount = 0;
			Led_Flip();
		}

	}		
}
