/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : system_init.h                                         *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file contains the Header file configuration 	  *
 * 						for KF32A156 device                                  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/
#ifndef _USART_H_
#define _USART_H_
/******************************************************************************
**                       	Include Files                                     *
******************************************************************************/
#include <stdint.h>
/******************************************************************************
*                        Type  definitions                                    *
******************************************************************************/
typedef struct
{
	uint8_t Data[10];
	uint8_t Length;
}Usart_Sdu_Type;


/******************************************************************************
*                      Functional definition                                 *
******************************************************************************/
void Usart_Gpio_Init(void);
void USART_Send(USART_SFRmap *USARTx, Usart_Sdu_Type  *Usart_Sdu);
void USART_Receive(USART_SFRmap *USARTx, Usart_Sdu_Type *Usart_Sdu);
void USART_Mode_Config(USART_SFRmap *USARTx);
void USART_Int_Config(USART_SFRmap *USARTx, InterruptIndex Peripheral);
#endif

