#include "system_init.h"
#include "Usart.h"
#include "Usart_Config.h"
/*******************************************************************************
**                     		   Global Functions 		             	      **
*******************************************************************************/
/**
 *  @brief :
 *  @param in :None
 *  @param out :None
 *  @retval :None
 */
void Usart_Gpio_Init(void)
{
  GPIO_InitTypeDef GPIO_InitStructure;

  /* Configure PA3 remap mode */
  GPIO_InitStructure.m_Mode = GPIO_MODE_RMP;
  GPIO_InitStructure.m_OpenDrain = GPIO_POD_PP;
  GPIO_InitStructure.m_PullDown = GPIO_NOPULL;
  GPIO_InitStructure.m_PullUp = GPIO_NOPULL;
  GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;
  GPIO_InitStructure.m_Pin = GPIO_PIN_MASK_6;
  GPIO_Configuration(GPIOH_SFR, &GPIO_InitStructure);
  /* Configure PE7 remap mode, as RX pin, it should be pullup */
  GPIO_InitStructure.m_PullUp = GPIO_PULLUP;
  GPIO_InitStructure.m_Pin = GPIO_PIN_MASK_14;
  GPIO_Configuration(GPIOH_SFR, &GPIO_InitStructure);
  /* Configure PA3 remap function to AF3 */
  GPIO_Pin_RMP_Config(GPIOH_SFR, GPIO_Pin_Num_6, GPIO_RMP_AF3);
  /* Configure PE17 remap function to AF3 */
  GPIO_Pin_RMP_Config(GPIOH_SFR, GPIO_Pin_Num_14, GPIO_RMP_AF3);
}

void Usart0_Gpio_Init(void)
{
	GPIO_InitTypeDef GPIO_InitStructure;
	/*
	*  Configure PA3 remap mode
	*  as TX pin
	*/
	GPIO_InitStructure.m_Mode = GPIO_MODE_RMP;
	GPIO_InitStructure.m_OpenDrain = GPIO_POD_PP;
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;
	GPIO_InitStructure.m_Pin = GPIO_PIN_MASK_3;
	GPIO_Configuration(GPIOA_SFR, &GPIO_InitStructure);
	/*
	* Configure PE7 remap mode
	* as RX pin
	* Configured in pull-up mode
	*/
	GPIO_InitStructure.m_PullUp = GPIO_PULLUP;
	GPIO_InitStructure.m_Pin = GPIO_PIN_MASK_7;
	GPIO_Configuration(GPIOE_SFR, &GPIO_InitStructure);
	/* Configure PA3 remap function to AF3 */
	GPIO_Pin_RMP_Config(GPIOA_SFR, GPIO_Pin_Num_3, GPIO_RMP_AF3);
	/* Configure PE17 remap function to AF3 */
	GPIO_Pin_RMP_Config(GPIOE_SFR, GPIO_Pin_Num_7, GPIO_RMP_AF3);
}

/**
 *  @brief :Usart to send data
 *  @param in :
 *              USARTx :A pointer to the USART memory structure
 *                      with a value of USART0_SFR
 *                                      USART1_SFR
 *                                      USART2_SFR
 *                                      USART5_SFR
 *  			Usart_Sdu: Data   : A pointer to the sending data
 *  			           Length : Length of transmission
 *  @param out :None
 *  @retval :None
 */

void USART_Send(USART_SFRmap *USARTx, uint8_t *Databuf, uint32_t length)
{
	for (uint32_t i = 0; i < length; i++)
	{
		/* Serial transmission */
		systick_delay_us(20);
		USART_SendData(USARTx, Databuf[i]);
	}
}

/**
 *  @brief :
 *  @param in :None
 *  @param out :None
 *  @retval :None
 */
char getche(void)
{
	char temp;
	while(USART_Get_Receive_BUFR_Ready_Flag(USART0_SFR));
	temp = fgetchar(USART0_STREAM);
	return temp;
}


/**
 *  @brief :
 *  @param in :None
 *  @param out :None
 *  @retval :None
 */
void USART_Mode_Config(USART_SFRmap *USARTx)
{
  USART_InitTypeDef USART_InitStructure;
  USART_Struct_Init(&USART_InitStructure);
  /* Set Usart To Async Mode */
  USART_InitStructure.m_Mode = USART_MODE_HALFDUPLEXSYN;
  USART_InitStructure.m_HalfDuplexClkSource = USART_MASTER_CLOCKSOURCE_INTER;
  USART_InitStructure.m_TransferDir = USART_DIRECTION_TRANSMIT;
  USART_InitStructure.m_WordLength = USART_WORDLENGTH_9B;
  USART_InitStructure.m_Parity = USART_PARITY_ODD;

  /*  Set baudrate to 115200 */
  USART_InitStructure.m_BaudRateBRCKS = USART_CLK_HFCLK;
  USART_InitStructure.m_BaudRateInteger = 8;
  USART_InitStructure.m_BaudRateNumerator = 1;
  USART_InitStructure.m_BaudRateDenominator = 13;

  USART_Reset(USARTx);
  USART_Configuration(USARTx, &USART_InitStructure);
  USART_Passageway_Select_Config(USARTx, USART_U7816R_PASSAGEWAY_TX0);
  USART_HalfDuplex_ClockPolarity_Config(USARTx, USART_CPOL_LOW);
  USART_Clear_Transmit_BUFR_INT_Flag(USARTx);
  USART_RESHD_Enable(USARTx, TRUE);
  USART_Transmit_Data_Enable(USARTx, TRUE);
  USART_Cmd(USARTx, TRUE);
}

/**
 *  @brief :Configure USART mode
 *  @param in :
 *             USARTx :A pointer to the USART memory structure
 *                     with a value of USART0_SFR
 *                                     USART1_SFR
 *                                     USART2_SFR
 *                                     USART5_SFR
 *  @param out :None
 *  @retval :None
 */
void USART0_Mode_Config(USART_SFRmap *USARTx)
{
	USART_InitTypeDef USART_InitStructure;
	USART_Struct_Init(&USART_InitStructure);
	/* Set Usart To Async Mode */
	USART_InitStructure.m_Mode = USART_MODE_FULLDUPLEXASY;
	USART_InitStructure.m_TransferDir = USART_DIRECTION_FULL_DUPLEX;
	USART_InitStructure.m_WordLength = USART_WORDLENGTH_8B;
	USART_InitStructure.m_StopBits = USART_STOPBITS_1;

	/*  Set baudrate to 115200 */
	USART_InitStructure.m_BaudRateBRCKS = USART_CLK_HFCLK;
	USART_InitStructure.m_BaudRateInteger = 8;
	USART_InitStructure.m_BaudRateNumerator = 1;
	USART_InitStructure.m_BaudRateDenominator = 13;
	/* Set Usart to send enable */
	USART_Reset(USARTx);
	USART_Configuration(USARTx, &USART_InitStructure);
	USART_Passageway_Select_Config(USARTx, USART_U7816R_PASSAGEWAY_TX0);
	USART_RESHD_Enable(USARTx, TRUE);
	USART_Transmit_Data_Enable(USARTx, TRUE);
	USART_Cmd(USARTx, TRUE);
}

/**
 *  @brief :
 *  @param in :None
 *  @param out :None
 *  @retval :None
 */
void USART_Int_Config(USART_SFRmap *USARTx, InterruptIndex Peripheral)
{
  USART_Clear_Transmit_BUFR_INT_Flag(USARTx);
  USART_RDR_INT_Enable(USARTx, TRUE);
  USART_TFE_INT_Enable(USARTx, TRUE);
  INT_Interrupt_Enable(Peripheral, TRUE);
}
