/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : User_SysTick.c                                        *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This fiel provides provides template for 			  *
 *                      system tick 							     		  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/
#include "system_init.h"
#include "User_SysTick.h"


/*******************************************************************************
**                      	Private Variables Definitions                  	  **
*******************************************************************************/
volatile static uint32_t TimingDelay;


/*******************************************************************************
**                      	Global Functions 		             	      	  **
*******************************************************************************/
/**
  * @brief  Decrements the TimingDelay variable.
  *  @param in : None
  *  @param out :None
  * @retval None
  */
void TimingDelay_Decrement(void)
{
	if (TimingDelay != 0x00)
	{
		TimingDelay--;
	}
}


/**
 *  @brief :Inserts a delay time.
 *  @param in :	delayTime: specifies the delay time length, in milliseconds.
 *  @param out :None
 *  @retval :None
 */
void Systick_Delay(uint32_t delayTime)
{ 
	TimingDelay = delayTime;
	while(TimingDelay != 0);
}

/**
 *  @brief :initialize system tick timer,T=1/SCLK*Reload.
 *  @param in :	Reload : the count value of Systick timer enter IRQ
 *  @param out :None
 *  @retval :None
 */
void SysTick_Configuration(uint32_t Reload)
{
	/*before initializtion,disable systick timer*/
	SYSTICK_Cmd (FALSE);
	SYSTICK_Reload_Config(Reload);
	/*write ST_CV any valer,clear ST_CV*/
	SYSTICK_Counter_Updata();
	/*select SCLK as the clock source of the system tick timer */
	SYSTICK_Clock_Config(SYSTICK_SYS_CLOCK_DIV_1);
	/*enable system timer IRQ&interrupt flag*/
	SYSTICK_Systick_INT_Enable(TRUE);
	/*Configuration system timer Interrupt Priority*/
	INT_Interrupt_Priority_Config(INT_SysTick,2,0);
	/*enable systick timer*/
	SYSTICK_Cmd(TRUE);
	/*enable system timer Interrupt*/
    INT_Interrupt_Enable(INT_SysTick,TRUE);				
	INT_All_Enable (TRUE);
}


/**
 *  @brief :GPIO output initialize.
 *  @param in :	GPIOx : IO grop
 			    GpioPin:IO Pin
 *  @param out :None
 *  @retval :None
 */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);
	GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_RESET);

}
/**
 *  @brief :GPIO input initialize.
 *  @param in :	GPIOx : IO grop
 			    GpioPin:IO Pin
 *  @param out :None
 *  @retval :None
 */
void GPIOInit_Input_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;                   
	GPIO_InitStructure.m_Mode = GPIO_MODE_IN;                     
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;                     
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;                  
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);
}


