/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : User_iwdg.c                                           *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This fiel provides provides template for 			  *
 *                      User_iwdg 							     		      *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-12 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/
#include "system_init.h"
#include "User_SysTick.h"
#include "User_iwdg.h"



/*******************************************************************************
**                      	Global Functions 		             	      	  **
*******************************************************************************/

/**
  * @brief  initialize IWDG.
  *  @param in : Overflow:IWDG interrupt overflow value
  *  			 Prescaler:Prescaler of IWDG clock source
  *  @param out :None
  * @retval None
  */
void IWDG_Config(uint32_t Overflow,uint32_t Prescaler)
{

	/*enable BKP write and read*************************************************/
	BKP_Write_And_Read_Enable(TRUE);                                
	/*Exit reset state**********************************************************/
	PM_Independent_Watchdog_Reset_Config(PERIPHERAL_OUTRST_STATUS); 
	/*select INTLF as the IWDG clock source*************************************/
	PM_Internal_Low_Frequency_Enable(TRUE);
	/*T = 1/32K*Prescaler*Overflow=1s*******************************************/
	IWDT_Overflow_Config (Overflow);                               
	IWDT_Prescaler_Config(Prescaler);
	/*enable IWDG*/
	IWDT_Enable(TRUE);
}
/**
  * @brief  get user key state.
  *  @param in : None
  *  @param out :FlagStatus
  * @retval None
  */
FlagStatus User_Key_Down(void)
{
	if(GPIO_Read_Input_Data_Bit(GPIOD_SFR,GPIO_PIN_MASK_7))
	{
		return RESET;
	}
	else
	{
		return SET;
	}
}

