/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : main.c                                         	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This is a template project used by WWDG.			  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "system_init.h"
#include "User_SysTick.h"
#include "User_wwdg.h"


/*******************************************************************************
**                     			main Functions 		             	     	  **
*******************************************************************************/
int main()
{
	/*initialize system clock,defaut SCLK is 120M,select INTHF as Clock source*/
	SystemInit(120);
	/*Low frequency working frequency selection:1/1****************************/
	OSC_LFCK_Division_Config(LFCK_DIVISION_1);
	/*Select INTLF as LFCLK clock source***************************************/
	OSC_LFCK_Source_Config (LFCK_INPUT_INTLF);
	/*enable LFCLK*************************************************************/
	OSC_LFCK_Enable (TRUE);
	OSC_INTLF_Software_Enable(TRUE);
	
	GPIOInit_Output_Config(GPIOD_SFR,GPIO_PIN_MASK_12);
	/*user key input*/
	GPIOInit_Input_Config(GPIOD_SFR,GPIO_PIN_MASK_7);
	LED1_On();
	/*T=1/120M*120000=1ms,SCLK:120M*/
	SysTick_Configuration(120000);
	WWDT_Config_TH(WWDT_Threshold);
	while(1)
	{
		#if WWDT_Enable_INT
		Systick_Delay(SYSTEM_DELAY_200MS);
		#else
		Systick_Delay(SYSTEM_DELAY_10MS);
		if(User_Key_Down()==SET)
		{
			WWDT_Clear();
		}
		#endif



	}		
}
/**
 *  @brief : Reports the name of the source file and the source line number
 *           where the assert_param error has occurred.
 *  @param in :	file pointer to the source file name
 * 	@param in :	line assert_param error line source number
 *  @param out :None
 *  @retval :None
 */
void check_failed(uint8_t* File, uint32_t Line)
{
	/* User can add his own implementation to report the file name and line number,
		ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	/* Infinite loop */
	while(1)
	{
		;
	}
};
