/*
 * PowerMan.c
 *
 *  Created on: 2021-4-24
 *      Author: о
 */

#include "PowerMan.h"

unsigned char CTCTL0_Reg, VRECTL_Reg;

void LowPower_GPIO_Config(void)
{
	//Ϊ룬I2C
	TR0 = 0b00011000;
	TR1 = 0b00000011;
	TR2 = 0b00000001;



	P0LR2=0;//danger
	P0LR = 0;
	P1LR = 0;
	P0LR0 = 0;
	P0LR1 = 0;
}

void Touch_GPIO_Config(void)
{
	/* ˿ڳʼôͨΪ */
	TR0 = 0b00000000;
	TR1 = 0b11111100;
	TR2 = 0b00001111;

	P0LR4 = 0; // P04ͣCxݷŵ磩
	P0LR5 = 0; // P05ͣCxݽӵضˣ

	/* ¿ָΪCxݷŵʱ */
__asm
	NOPZ
	NOPZ
	NOPZ
	NOPZ
	NOPZ
	NOPZ
	NOPZ
	NOPZ
	NOPZ
	NOPZ
__endasm;

	TR04 = 1; // P04루Cxݳŵ磩
}

void System_Goto_Sleep(void)
{
	CTCTL0_Reg = CTCTL0;
	VRECTL_Reg = VRECTL;

	VRECTL = 0; //Disable Reference
	CTCTL0 = 0; //Disable CTouch
	SLVREN = 0; //Disable Low Voltage Detect

	AIEH = 0; //Disable Interrupt
	AIEL = 0;

	WDTPS = 0x05; //Sleep for about 32ms
	_CWDT();
	LowPower_GPIO_Config();
	_IDLE();      //Sleep
	_NOP();       //Wakeup from here


//	WDTPS = 0x06; //Sleep for about 64ms
//	_CWDT();
//	_IDLE();      //Sleep
//	_NOP();       //Wakeup from here

	WDTPS = 0x07; //Set usual time out
	Touch_GPIO_Config();
	SLVREN = 1;   //Enable Low Voltage Detect
	AIEH = 1;
	AIEL = 1;
	_NOP();
	_CWDT();
	CTCTL0 = CTCTL0_Reg;
	VRECTL = VRECTL_Reg;
}

