/****************************************************************************************
 * ļ: init_mcu.c
 *  :   2014-6-28
 *  :   Ϻо΢Ӽ޹˾
 * ˵       ʼоƬĴ
 ****************************************************************************************/
#include "init_mcu.h"

//;************************************************************************************
//;*   :  delay_ms
//;* : ʱ
//;* ڲ: 
//;*     :   
//;************************************************************************************
void delay_ms(unsigned int ms_data)
{
	unsigned int j;
	while(ms_data--)
	{
		j=200;
		_CWDT();
		while(j--)
		{
			_CWDT();
		}
	}
}

/******************************************************************************
*   : init_mcu()
* : óʼοĴ˵
* ڲ: 
*     : 
******************************************************************************/
void Init_Touch(void)
{
#if 0
	//VDDΪѹԴ
	CTCTL1 = 0x81;
	VDAC=0x80;
#else
	//ڲοѹΪѹԴ
	CTCTL1 	= 0x01;
	VRECTL	=0x92;
	__asm
	;;VDACS=0x40;
		MOVB #0x00
		MOV R0,#0x40
		ORL 0x1A,R0
	__endasm;
	VDAC=0xC0;
#endif
	PT3 = 1;   //T3ĴжȼΪ
}

/******************************************************************************
*   : Init_Touch_GPIO()
* : ʼ
* ڲ: 
*     : 
******************************************************************************/
void Init_Touch_GPIO(void)
{
	/* ˿ڳʼôͨΪ */
	TR0 = 0b00010111;
	TR1 = 0b11111111;
	TR2 = 0b00001111;

	P0LR5 = 0; //P05ͣCxݽӵضˣ
}

/******************************************************************************
*   : init_mcu()
* : ʼ
* ڲ: 
*     : 
******************************************************************************/
void Init_MCU()
{
	/* Ƶѡ 16MHz */
	OSCCTL = 0x70;

	Init_Touch_GPIO();

    IPEN = 1;  //ʹжȼ
#if (I2C_SLAVE_ENABLE == 1)
    Init_I2C_S();
#endif
#if (USART_DEBUG_EN == 1)
    Init_Usart();
#endif

    Init_Touch();

	AIEH = 1; //ʹܸȼж--ж--ӦInterrupt 0
	AIEL = 1; //ʹܵȼж--I2Cж --ӦInterrupt  1
    delay_ms(300);
}


/******************************************************************************
*   : Init_I2C_S()
* : ģʽʼжӦ
* ڲ: 
*     : 
******************************************************************************/
void Init_I2C_S()
{
	SSCIPIN = 0;			//SDA = P00, SCL =P01
	TR00 = 1;				//P00 SDA,Ϊ̬
	TR01 = 1;				//P01 SCL,Ϊ̬

	/* I2Cʼ */
	SSCICTL0 = 0x36;		//ʹIIC˿ڣʹʱӣIICӶģʽ7λַ
	SSCICTL1 = 0x00;		//ֹ㲥еַƥж
	SSCIADD = I2C_SLAVE_ADDR;//оƬַ趨
	SSCISTA = 0x00;
	SSCIIF  =0;
	PSSCI = 0;	            // ȼ
	SSCIIF = 0;	            // ־λ
	SSCIIE = 1;             // ʹI2Cж
}

/******************************************************************************
*   : Init_Usart()
* : ڳʼ115200, SPLCK --- TX
*                                    SPDAT --- RX
* ڲ: 
*     : 
******************************************************************************/
void Init_Usart()
{
	/***UsartؼĴʼ****/
	BRCTL = 0x44;	// 	տ  ʹ8λǻʹܺԶʼ

	EUBRGH = 0x00;	// ʹʽ=SCLK/(m*y+1),SCLKϵͳʱӣ8MmΪƵֲᣬyΪ8λ16λʼֵ
	EUBRGL = 0x08; 	// SYNC=0(ȫ˫첽ģʽ),BRG16=0(ʹ8λʷ),HBRG=1()
	TSCTL = 0x26;  	// 8λ ͣʹܷͣȫ˫첽ģʽSYNC=0ģʽHBRG=1λ,ͬ
	RSCTL = 0x90;  	// ʹܣΪпţ8λգʹܣ֡󣬲ǵַʶ͵9λ
}

/****************************************************************************************
 *      UART_SendBuf
 * ܣڷͺȴͱ־λ
 * ڲ
 *           
****************************************************************************************/
void UART_SendBuf(unsigned char SendTemp)
{
	TXSDR = SendTemp;
	while(TXSRS == 0);
}
